/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.validator.TreeBaseDataAssignPreValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.form.FormMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;

public class BaseDataAssignValidator {
    static final String SYSTEM_TYPE = "bos-bd-business";
    final String entityId;
    final Long assignOrgId;
    private final String appId;
    final Set<Long> dataIds;
    final Set<Long> orgIds;
    private static final String CTLSTRATEGY = "ctrlStrategy";
    private static final String ORG_ENTITY = "bos_org";
    final String masterIdProName;
    private String numberField = "number";
    boolean isIgnoreStatus;
    String billStatusKey;
    static final String CREATEORGID = "createOrg.id";

    public BaseDataAssignValidator(String entityId, Long assignOrgId, String appId, Set<Long> dataIds, Set<Long> orgIds) {
        this.entityId = entityId;
        this.assignOrgId = assignOrgId;
        this.appId = null != appId ? appId : this.getAppId(entityId);
        this.dataIds = dataIds;
        this.orgIds = orgIds;
        this.masterIdProName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
            String billStatusKey = dt.getBillStatus();
            this.isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
            this.billStatusKey = dt.getBillStatus();
            if (BaseDataCommonService.isOtherMasterIdType(entityId)) {
                this.numberField = "masterid.number";
            }
        }
    }

    public BaseDataResponse assignValidate() {
        BaseDataResponse response = this.paramIsNotNull();
        if (!response.isSuccess()) {
            return response;
        }
        this.assignPermValidate(response);
        if (!response.isSuccess()) {
            return response;
        }
        this.isCtrlType(response);
        if (!response.isSuccess()) {
            return response;
        }
        String selectProperties = this.businessTreeTypeValidate(response);
        if (!response.isSuccess()) {
            return response;
        }
        DynamicObjectCollection doc = this.dataExistValidate(selectProperties, response);
        if (!response.isSuccess()) {
            return response;
        }
        this.batchForeachValidate(doc, response);
        if (!response.isSuccess()) {
            return response;
        }
        this.validateOrgOfAssigned(response);
        if (!response.isSuccess()) {
            return response;
        }
        if (BaseDataCommonService.isTreeType(this.entityId)) {
            TreeBaseDataAssignPreValidator treeValidator = new TreeBaseDataAssignPreValidator(this.entityId, this.assignOrgId);
            return treeValidator.treeValidate(new ArrayList<Long>(this.dataIds));
        }
        return response;
    }

    DynamicObjectCollection dataExistValidate(String selectProperties, BaseDataResponse response) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.entityId, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", this.dataIds)});
        if (null == doc || doc.isEmpty() || doc.size() != this.dataIds.size()) {
            response.setSuccess(false);
            response.setErrorMsg(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BaseDataAssignValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return doc;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", this.dataIds), BaseDataServiceHelper.getBaseDataFilter((String)this.entityId, (Long)this.assignOrgId)};
        doc = QueryServiceHelper.query((String)this.entityId, (String)selectProperties, (QFilter[])filters);
        if (null == doc || doc.isEmpty() || doc.size() != this.dataIds.size()) {
            response.setSuccess(false);
            response.setErrorMsg(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u6ca1\u6709\u6570\u636e\u7684\u4f7f\u7528\u6743\u9650\u3002", (String)"BaseDataAssignValidator_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return doc;
    }

    private BaseDataResponse paramIsNotNull() {
        BaseDataResponse response = new BaseDataResponse(false, "");
        if (null == this.entityId) {
            response.setErrorMsg("entityId is empty");
        } else if (null == this.assignOrgId) {
            response.setErrorMsg("assignOrgId is empty");
        } else if (null == this.appId) {
            response.setErrorMsg("appId is empty");
        } else if (CollectionUtils.isEmpty(this.dataIds)) {
            response.setErrorMsg("dataIds is empty");
        } else if (CollectionUtils.isEmpty(this.orgIds)) {
            response.setErrorMsg("orgIds is empty");
        } else {
            response.setSuccess(true);
        }
        return response;
    }

    private String getAppId(String entityId) {
        if (null != entityId) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            return null != mainEntityType ? mainEntityType.getAppId() : null;
        }
        return null;
    }

    private void isAssignedOrgBelowAssignOrg(String ctrlStrategy, BaseDataResponse response) {
        if (!"1".equals(ctrlStrategy)) {
            return;
        }
        DynamicObject orgView = BaseDataServiceHelper.getCtrlview((String)this.entityId);
        Long orgIdViewId = (Long)orgView.getPkValue();
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)orgIdViewId, Collections.singletonList(this.assignOrgId), (boolean)true, (boolean)true);
        ArrayList<Long> orgParam = new ArrayList<Long>(this.orgIds);
        orgParam.add(this.assignOrgId);
        QFilter[] orgFilters = new QFilter[]{new QFilter("id", "in", (Object)orgParam.toArray())};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)ORG_ENTITY, (String)"id,name,number", (QFilter[])orgFilters);
        Map<Long, DynamicObject> orgMap = orgCol.stream().collect(Collectors.toMap(org -> org.getLong("id"), org -> org));
        orgParam.removeAll(subOrgIds);
        if (!orgParam.isEmpty()) {
            String orgNumber = Optional.ofNullable(orgMap.get(orgParam.get(0))).orElseGet(() -> BusinessDataServiceHelper.newDynamicObject((String)ORG_ENTITY)).getString("number");
            response.setSuccess(false);
            response.setErrorMsg(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u5206\u914d\u7ec4\u7ec7\u7684\u4e0b\u7ea7\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u3002", (String)"BaseDataAssignValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), orgNumber));
        }
    }

    private void validateOrgOfAssigned(BaseDataResponse response) {
        StringBuilder errorMsg;
        DynamicObject orgView = BaseDataServiceHelper.getCtrlview((String)this.entityId);
        Long orgIdViewId = (Long)orgView.getPkValue();
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("select forgid,fviewid,fisctrlunit,fparentid from t_org_structure where ", new Object[0]);
        sbd.append("fViewId = ", new Object[0]).append(orgIdViewId.toString(), new Object[0]).append(" and ", new Object[0]);
        sbd.appendIn("fOrgId", this.orgIds.toArray());
        HashMap orgCtrlUnitSet = new HashMap(this.orgIds.size());
        DB.query((DBRoute)DBRoute.base, (SqlBuilder)sbd, rs -> {
            HashMap map = new HashMap(this.orgIds.size());
            while (rs.next()) {
                Long orgId = rs.getLong("forgid");
                String isCtrlUnit = rs.getString("fisctrlunit");
                orgCtrlUnitSet.put(orgId, isCtrlUnit);
            }
            rs.close();
            return map;
        });
        ArrayList<Long> orgIsNotExist = new ArrayList<Long>(16);
        ArrayList<Long> orgIsNotCtrlUnit = new ArrayList<Long>(this.orgIds.size());
        for (Long orgId2 : this.orgIds) {
            if (null == orgCtrlUnitSet.get(orgId2)) {
                orgIsNotExist.add(orgId2);
                continue;
            }
            if ("1".equals(orgCtrlUnitSet.get(orgId2))) continue;
            orgIsNotCtrlUnit.add(orgId2);
        }
        if (CollectionUtils.isNotEmpty(orgIsNotExist)) {
            errorMsg = new StringBuilder();
            errorMsg.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a", (String)"BaseDataAssignValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            orgIsNotExist.forEach(orgId -> errorMsg.append(orgId).append(','));
            errorMsg.append(ResManager.loadKDString((String)"\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"BaseDataAssignValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            response.setSuccess(false);
            response.setErrorMsg(errorMsg.toString());
            return;
        }
        if (CollectionUtils.isNotEmpty(orgIsNotCtrlUnit)) {
            errorMsg = new StringBuilder();
            errorMsg.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a", (String)"BaseDataAssignValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            orgIsNotExist.forEach(orgId -> errorMsg.append(orgId).append(','));
            errorMsg.append(ResManager.loadKDString((String)"\u4e0d\u662f\u7ba1\u63a7\u5355\u5143\uff0c\u4e0d\u80fd\u5206\u914d\u3002", (String)"BaseDataAssignValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            response.setSuccess(false);
            response.setErrorMsg(errorMsg.toString());
        }
    }

    void batchForeachValidate(DynamicObjectCollection doc, BaseDataResponse response) {
        String firstCtrlStrategy = ((DynamicObject)doc.get(0)).getString(CTLSTRATEGY);
        for (DynamicObject obj : doc) {
            Long id = obj.getLong("id");
            long masterId = obj.getLong(this.masterIdProName);
            String ctrlStrategy = obj.getString(CTLSTRATEGY);
            String number = obj.getString(this.numberField);
            Long createOrgId = obj.getLong(CREATEORGID);
            if (masterId == 0L) {
                response.setSuccess(false);
                response.setErrorMsg(ResManager.loadKDString((String)"\u5b58\u5728masterId\u4e3a0\u7684\u5f02\u5e38\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u590d\u6570\u636e\u3002", (String)"BaseDataAssignValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            if (!"1".equals(ctrlStrategy) && !"2".equals(ctrlStrategy)) {
                response.setSuccess(false);
                response.setErrorMsg(ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u4e3a\u201c\u5206\u914d\u201d\u7c7b\u578b\u7684\u6570\u636e\u624d\u80fd\u5206\u914d\u3002", (String)"BaseDataAssignValidator_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            if (!this.isIgnoreStatus && !"C".equals(obj.getString(this.billStatusKey))) {
                response.setSuccess(false);
                response.setErrorMsg(String.format(ResManager.loadKDString((String)"%s\uff1a\u672a\u5ba1\u6838\u7684\u6570\u636e\u4e0d\u80fd\u5206\u914d\u3002", (String)"BaseDataAssignValidator_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
                return;
            }
            if (!firstCtrlStrategy.equals(ctrlStrategy)) {
                response.setSuccess(false);
                response.setErrorMsg(ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u6279\u91cf\u5206\u914d\u3002", (String)"BaseDataAssignValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            if ("2".equals(ctrlStrategy) && !this.assignOrgId.equals(createOrgId)) {
                response.setSuccess(false);
                response.setErrorMsg(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u6570\u636e(%s)\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5206\u914d\u3002", (String)"BaseDataAssignValidator_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
                return;
            }
            if (!id.equals(masterId) && "2".equals(ctrlStrategy)) {
                response.setSuccess(false);
                response.setErrorMsg(String.format(ResManager.loadKDString((String)"%s\uff1a\u4e2a\u6027\u5316\u7684\u201c\u81ea\u7531\u5206\u914d\u201d\u7c7b\u578b\u6570\u636e\u4e0d\u80fd\u5206\u914d\u3002", (String)"BaseDataAssignValidator_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
                return;
            }
            if (this.orgIds.size() != 1 || !this.assignOrgId.equals(this.orgIds.toArray()[0])) continue;
            response.setSuccess(false);
            response.setErrorMsg(String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u80fd\u5c06\u81ea\u5df1\u521b\u5efa\u7684\u6570\u636e\u5206\u914d\u7ed9\u81ea\u5df1\u3002", (String)"BaseDataAssignValidator_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
            return;
        }
        this.isAssignedOrgBelowAssignOrg(firstCtrlStrategy, response);
    }

    protected void assignPermValidate(BaseDataResponse response) {
        boolean hasAssignPerm;
        RequestContext context = RequestContext.get();
        long userId = context.getCurrUserId();
        boolean bl = hasAssignPerm = 1 == PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)this.assignOrgId, (String)this.appId, (String)this.entityId, (String)"80513208000000ac");
        if (!hasAssignPerm) {
            String caption = FormMetadataCache.getFormConfig((String)this.entityId).getCaption().getLocaleValue();
            String errorMsg = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c\u5206\u914d\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BaseDataAssignValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), caption);
            response.setSuccess(false);
            response.setErrorMsg(errorMsg);
        }
    }

    private void isCtrlType(BaseDataResponse response) {
        if (Boolean.FALSE.equals(BaseDataServiceHelper.checkBaseDataCtrl((String)this.entityId))) {
            response.setSuccess(false);
            response.setErrorMsg(ResManager.loadKDString((String)"\u53ea\u6709\u53d7\u63a7\u57fa\u7840\u8d44\u6599\u624d\u652f\u6301\u5206\u914d\u3002", (String)"BaseDataAssignValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    String businessTreeTypeValidate(BaseDataResponse response) {
        ArrayList<String> selectFields = new ArrayList<String>(Arrays.asList("id", this.numberField, CREATEORGID, CTLSTRATEGY, this.masterIdProName));
        if (!this.isIgnoreStatus) {
            selectFields.add(this.billStatusKey);
        }
        if (BaseDataCommonService.isTreeType(this.entityId)) {
            selectFields.add("isLeaf");
            selectFields.add("longNumber");
        }
        return String.join((CharSequence)",", selectFields);
    }
}

