/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.CancelAssignResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.roaringbitmap.RoaringBitmap;

public class BaseDataCancelAssignAPIValidator {
    private static final Log LOGGER = LogFactory.getLog(BaseDataCancelAssignAPIValidator.class);
    static final String SYSTEM_TYPE = "bos-bd-business";
    private String numberField;
    private String masterIdPropName;
    private String entityId;
    private static final String KEY_PARENT_ID = "parent.id";
    private static final String KEY_ORG_NAME = "createorg.name";
    private Map<Long, Set<Long>> dataIdToUseOrgMap = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Set<Long>> customData = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Set<Long>> assignData = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Set<Long>> unableCancelAssignMap = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Long> dataId2PidMap = new HashMap<Long, Long>(16);
    private Map<Long, Set<String>> unableCancelDataOrgNameMap = new HashMap<Long, Set<String>>(16);
    private Map<Long, Long> child2ParentOrgMap = new HashMap<Long, Long>(16);
    private List<Long[]> businessCheckResult = new ArrayList<Long[]>(10);
    private List<Object[]> businessCheckResultWitchDetail = new ArrayList<Object[]>(16);
    private Set<Long> freeDataIds = new HashSet<Long>(16);
    private Map<Long, String> dataNumberMap = new HashMap<Long, String>(16);
    private Map<Long, String> orgNameMap = new HashMap<Long, String>(16);
    private Map<Long, String> dataStrategyMap = new HashMap<Long, String>(16);
    private boolean isTreeTypeBaseData = false;
    private List<CancelAssignResult> result = new ArrayList<CancelAssignResult>(16);
    private Set<String> unableCancelDataIdOrgSet = new HashSet<String>(16);

    public List<CancelAssignResult> getResult() {
        return this.result;
    }

    public void setResult(List<CancelAssignResult> result) {
        this.result = result;
    }

    private void init(Set<Long> dataIds, Set<Long> orgIds) {
        this.dataIdToUseOrgMap = new HashMap<Long, Set<Long>>(dataIds.size());
        dataIds.forEach(dataId -> this.dataIdToUseOrgMap.computeIfAbsent((Long)dataId, k -> new HashSet()).addAll(orgIds));
        boolean isOtherMasterIdType = BaseDataCommonService.isOtherMasterIdType(this.entityId);
        this.numberField = isOtherMasterIdType ? "masterid.number" : "number";
        this.masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)this.entityId);
        QFilter[] datafilters = new QFilter[]{new QFilter("id", "in", dataIds)};
        Map dataObjs = BusinessDataServiceHelper.loadFromCache((String)this.entityId, (String)("id," + this.numberField + ",ctrlstrategy"), (QFilter[])datafilters);
        for (Long dataId2 : dataIds) {
            if (null == dataObjs.get(dataId2)) continue;
            this.dataNumberMap.put(dataId2, ((DynamicObject)dataObjs.get(dataId2)).getString(this.numberField));
            this.dataStrategyMap.put(dataId2, ((DynamicObject)dataObjs.get(dataId2)).getString("ctrlstrategy"));
        }
        QFilter[] orgfilters = new QFilter[]{new QFilter("id", "in", orgIds)};
        Map orgObjs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])orgfilters);
        orgIds.forEach(orgId -> this.orgNameMap.put((Long)orgId, ((DynamicObject)orgObjs.get(orgId)).getString("name")));
    }

    Long getCreateOrgId(DynamicObject data) {
        Object createOrg = data.get("createorg");
        if (createOrg instanceof DynamicObject) {
            return (Long)((DynamicObject)createOrg).getPkValue();
        }
        if (createOrg instanceof Long) {
            return (Long)createOrg;
        }
        return 0L;
    }

    String getCreateOrgName() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.entityId);
        IDataEntityProperty createOrgPro = (IDataEntityProperty)entityType.getProperties().get((Object)"createorg");
        if (null != createOrgPro) {
            return createOrgPro.getDisplayName().getLocaleValue();
        }
        return ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"BaseDataCancelAssignAPIValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    String getEntityNumber() {
        return FormMetadataCache.getFormConfig((String)this.entityId).getEntityTypeId();
    }

    String getAppId() {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)this.getEntityNumber());
        return met.getAppId();
    }

    Set<Long> getAssignDataIds(String entity, Long orgId, String ctrlStrategy, Set<Long> dataIds) throws Exception {
        Set<Long> alreadyAssignDataIds = Collections.emptySet();
        if ("1".equals(ctrlStrategy)) {
            alreadyAssignDataIds = new BaseDataAssignService(entity).getAssignToDirectSubChildData(dataIds, orgId);
        } else if ("2".equals(ctrlStrategy)) {
            alreadyAssignDataIds = new BaseDataAssignService(entity).getAllAssignTypeData(dataIds, orgId);
        }
        return alreadyAssignDataIds;
    }

    Set<Long> getAssignDataIdsOnOriginalModel(Set<Long> dataIds) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entityId);
        SqlBuilder builder = new SqlBuilder();
        builder.append(String.format("SELECT top 1 fdataid from %sUseReg where FisAssign = '1' and ", dt.getAlias()), new Object[0]);
        builder.appendIn("fdataid", dataIds.toArray());
        return (Set)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
            if (rs.next()) {
                return Collections.singleton(rs.getLong("fdataid"));
            }
            return Collections.emptySet();
        });
    }

    public BaseDataCancelAssignAPIValidator(String entityId) {
        this.isTreeTypeBaseData = BaseDataCommonService.isTreeType(entityId);
        this.entityId = entityId;
    }

    public boolean validate(Set<Long> dataIds, Set<Long> orgIds) {
        this.init(dataIds, orgIds);
        if (this.isTreeTypeBaseData) {
            return this.executeValidate(this.entityId);
        }
        this.businessValidate(dataIds);
        Long currentOrgId = RequestContext.get().getOrgId();
        return this.executeValidate(dataIds, orgIds, currentOrgId);
    }

    private void businessValidate(Set<Long> dataIds) {
        IBaseDataCtrlPlugin plugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)this.entityId);
        List<Long[]> cancelAssignDataList = this.getBusinessCancelAssignCheckData(dataIds);
        if (plugin != null && !this.isTreeTypeBaseData) {
            List checkResult = plugin.unAssignCheck(cancelAssignDataList);
            if (!CollectionUtils.isEmpty((Collection)checkResult)) {
                checkResult.forEach(tempResult -> this.businessCheckResultWitchDetail.add(new Object[]{tempResult[0], tempResult[1], ""}));
            } else {
                this.businessCheckResultWitchDetail = plugin.unAssignCheckWitchDetail(cancelAssignDataList);
            }
            for (Object[] check : this.businessCheckResultWitchDetail) {
                this.unableCancelAssignMap.computeIfAbsent(Long.valueOf(check[0].toString()), k -> new HashSet(16)).add(Long.valueOf(check[1].toString()));
            }
        }
    }

    private List<Long[]> getBusinessCancelAssignCheckData(Set<Long> dataIds) {
        ArrayList<Long[]> unAssignDataList = new ArrayList<Long[]>(10);
        for (Map.Entry<Long, Set<Long>> entry : this.dataIdToUseOrgMap.entrySet()) {
            Long dataId = entry.getKey();
            dataIds.add(dataId);
            for (Long orgId : entry.getValue()) {
                Long[] unAssignData = new Long[]{dataId, orgId};
                unAssignDataList.add(unAssignData);
            }
        }
        return unAssignDataList;
    }

    private boolean executeValidate(Set<Long> dataIds, Set<Long> orgIds, Long currentOrgId) {
        try {
            this.basicsValidate(this.entityId);
            this.dataIdToUseOrgMap.forEach((dataId, selectOrgIds) -> {
                Set<Long> unableCancelOrgIds = this.unableCancelAssignMap.get(dataId);
                if (CollectionUtils.isEmpty(unableCancelOrgIds)) {
                    return;
                }
                selectOrgIds.removeAll(unableCancelOrgIds);
            });
            this.addResult(this.dataIdToUseOrgMap, "", true);
            this.cancelErrorResponse();
            return !this.dataIdToUseOrgMap.isEmpty();
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u6821\u9a8c\u5931\u8d25", (String)"BaseDataCancelAssignAPIValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), (Throwable)e);
            return false;
        }
    }

    private boolean executeValidate(String entity) {
        try {
            this.validateOnTreeType(entity);
            this.businessValidate(entity);
            this.basicsValidate(entity);
            if (this.isTreeTypeBaseData) {
                this.excludeUnableCancelData(this.unableCancelAssignMap);
            }
            for (Map.Entry<Long, Set<Long>> entry : this.dataIdToUseOrgMap.entrySet()) {
                Long dataId = entry.getKey();
                Set<Long> unableCancelOrgIds = this.unableCancelAssignMap.get(dataId);
                if (CollectionUtils.isEmpty(unableCancelOrgIds)) continue;
                Set<Long> selectOrgIds = entry.getValue();
                selectOrgIds.removeAll(unableCancelOrgIds);
            }
            this.addResult(this.dataIdToUseOrgMap, "", true);
            this.cancelErrorResponse();
            return !this.dataIdToUseOrgMap.isEmpty();
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u6821\u9a8c\u5931\u8d25", (String)"BaseDataCancelAssignAPIValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), (Throwable)e);
            return false;
        }
    }

    private void validateOnTreeType(String entity) throws Exception {
        if (!this.isTreeTypeBaseData) {
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        this.dataIdToUseOrgMap.forEach((key, value) -> orgIds.addAll((Collection<Long>)value));
        this.initChild2ParentOrgMap(entity, orgIds);
        Map<Long, RoaringBitmap> orgBitMap = BaseDataUseRelQueryEngine.getOrgUseRelBitMapByOrgIds(orgIds, entity);
        Set<Long> selectDataIds = this.dataIdToUseOrgMap.keySet();
        HashMap<Long, Set<Long>> unableCancelData2OrgMap = new HashMap<Long, Set<Long>>(16);
        String selectFields = "id,createorg.name,parent.id,bitindex";
        QFilter[] filters = new QFilter[]{new QFilter(KEY_PARENT_ID, "in", selectDataIds)};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entity, (String)selectFields, (QFilter[])filters);
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            DynamicObject data = (DynamicObject)entry.getValue();
            Long dataId = data.getLong("id");
            Long pId = data.getLong(KEY_PARENT_ID);
            this.dataId2PidMap.put(dataId, pId);
            if (selectDataIds.contains(dataId) || this.eachValidateOrgOnTreeType(orgBitMap, pId, data.getInt("bitindex"), unableCancelData2OrgMap)) continue;
            this.unableCancelDataOrgNameMap.computeIfAbsent(pId, k -> new HashSet(16)).add(data.getString(KEY_ORG_NAME));
            this.unableCancelAssignMap.putAll(unableCancelData2OrgMap);
        }
        this.excludeUnableCancelData(unableCancelData2OrgMap);
    }

    private boolean eachValidateOrgOnTreeType(Map<Long, RoaringBitmap> orgBitMap, Long selectDataId, int bitIndex, Map<Long, Set<Long>> unableCancelData2OrgMap) {
        Set<Long> useOrgIds = this.dataIdToUseOrgMap.get(selectDataId);
        if (CollectionUtils.isEmpty(useOrgIds) || 0 == bitIndex) {
            return true;
        }
        boolean ableCancel = true;
        for (Long orgId : useOrgIds) {
            RoaringBitmap bit = orgBitMap.get(orgId);
            if (null == bit || !bit.contains(bitIndex)) continue;
            unableCancelData2OrgMap.computeIfAbsent(selectDataId, k -> new HashSet(16)).add(orgId);
            ableCancel = false;
        }
        return ableCancel;
    }

    private void excludeUnableCancelData(Map<Long, Set<Long>> unableCancelData2OrgMap) {
        for (Map.Entry<Long, Set<Long>> entry : unableCancelData2OrgMap.entrySet()) {
            Long dataId = entry.getKey();
            String strategy = this.dataStrategyMap.get(dataId);
            if (!"1".equals(strategy) && !"2".equals(strategy)) continue;
            Set<Long> unableCancelOrgIds = entry.getValue();
            Set<Long> selectOrgId = this.dataIdToUseOrgMap.get(dataId);
            if (!CollectionUtils.isEmpty(selectOrgId)) {
                selectOrgId.removeAll(unableCancelOrgIds);
            }
            for (Long unableCancelOrgId : unableCancelOrgIds) {
                if ("1".equals(strategy)) {
                    Long parentOrgId = this.child2ParentOrgMap.get(unableCancelOrgId);
                    this.eachExcludeUnableCancelOrg(parentOrgId, this.dataIdToUseOrgMap.get(dataId));
                    this.eachExcludeUnableCancelData(unableCancelOrgId, dataId);
                    continue;
                }
                this.eachExcludeUnableCancelDataOnFreeType(dataId, unableCancelOrgId);
            }
            Set<Map.Entry<Long, Set<Long>>> entrySet = this.dataIdToUseOrgMap.entrySet();
            entrySet.removeIf(en -> CollectionUtils.isEmpty((Collection)((Collection)en.getValue())));
        }
    }

    private void eachExcludeUnableCancelDataOnFreeType(Long dataId, Long currentOrgId) {
        if (null == dataId) {
            return;
        }
        Set<Long> selectOrgIds = this.dataIdToUseOrgMap.get(dataId);
        if (!CollectionUtils.isEmpty(selectOrgIds)) {
            selectOrgIds.remove(currentOrgId);
        }
        dataId = this.dataId2PidMap.get(dataId);
        this.eachExcludeUnableCancelDataOnFreeType(dataId, currentOrgId);
    }

    private void eachExcludeUnableCancelData(Long currentOrgId, Long currentDataId) {
        Long parentDataId = this.dataId2PidMap.get(currentDataId);
        if (null == parentDataId) {
            return;
        }
        Set<Long> selectOrgIds = this.dataIdToUseOrgMap.get(parentDataId);
        if (!CollectionUtils.isEmpty(selectOrgIds)) {
            this.eachExcludeUnableCancelOrg(currentOrgId, selectOrgIds);
        }
        this.eachExcludeUnableCancelData(currentOrgId, parentDataId);
    }

    private void eachExcludeUnableCancelOrg(Long parentOrgId, Set<Long> selectOrgIds) {
        if (CollectionUtils.isEmpty(selectOrgIds) || null == parentOrgId) {
            return;
        }
        selectOrgIds.remove(parentOrgId);
        parentOrgId = this.child2ParentOrgMap.get(parentOrgId);
        this.eachExcludeUnableCancelOrg(parentOrgId, selectOrgIds);
    }

    private void initChild2ParentOrgMap(String entity, Set<Long> orgIds) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        OrgTreeParam orgTreeParam = new OrgTreeParam();
        orgTreeParam.setOrgRangeList(new ArrayList<Long>(orgIds));
        orgTreeParam.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        orgTreeParam.setOrgViewId(((Long)ctrlView.getPkValue()).longValue());
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)orgTreeParam);
        Long topOrgId = Long.valueOf(rootNode.getId());
        this.child2ParentOrgMap.putAll(new BaseDataCommonService().getChild2ParentOrgMap(orgIds, topOrgId, entity));
    }

    private void businessValidate(String entity) {
        if (this.dataIdToUseOrgMap.isEmpty()) {
            return;
        }
        ArrayList cancelAssignDataList = new ArrayList(10);
        for (Map.Entry<Long, Set<Long>> entry : this.dataIdToUseOrgMap.entrySet()) {
            Long dataId = entry.getKey();
            Set<Long> useOrgIds = entry.getValue();
            useOrgIds.forEach(orgId -> cancelAssignDataList.add(new Long[]{dataId, orgId}));
        }
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entity);
        if (baseDataCtrlPlugin == null) {
            return;
        }
        List checkResult = baseDataCtrlPlugin.unAssignCheck(cancelAssignDataList);
        if (!CollectionUtils.isEmpty((Collection)checkResult)) {
            checkResult.forEach(tempResult -> this.businessCheckResultWitchDetail.add(new Object[]{tempResult[0], tempResult[1], ""}));
        } else {
            this.businessCheckResultWitchDetail = baseDataCtrlPlugin.unAssignCheckWitchDetail(cancelAssignDataList);
        }
        for (Object[] check : this.businessCheckResultWitchDetail) {
            Long dataId = Long.valueOf(check[0].toString());
            Set<Long> useOrgIds = this.dataIdToUseOrgMap.get(dataId);
            if (null == useOrgIds) continue;
            Long orgId2 = Long.valueOf(check[1].toString());
            useOrgIds.remove(orgId2);
            this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(orgId2);
        }
    }

    private void basicsValidate(String entity) throws Exception {
        HashSet<Long> orgIds = new HashSet<Long>(this.dataIdToUseOrgMap.size());
        this.dataIdToUseOrgMap.values().forEach(orgIds::addAll);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        Long viewId = (Long)ctrlView.getPkValue();
        Map<Long, List<Long>> subCuOrgMap = new BaseDataCommonService().getDirectSubCuOrgMapping(viewId, orgIds);
        this.setCustomData(entity, subCuOrgMap);
        for (Map.Entry<Long, Set<Long>> entry : this.dataIdToUseOrgMap.entrySet()) {
            this.unableCancelAssignByCustom(entry.getKey(), entry.getValue(), subCuOrgMap);
        }
        HashSet<Long> allOrgIds = new HashSet<Long>(orgIds);
        subCuOrgMap.values().forEach(allOrgIds::addAll);
        Map<Long, Set<Long>> assignInfo = new BaseDataAssignService(entity).getDataAssignInfo(this.dataIdToUseOrgMap.keySet(), allOrgIds);
        for (Map.Entry<Long, Set<Long>> entry : this.dataIdToUseOrgMap.entrySet()) {
            Long dataId = entry.getKey();
            Set<Long> selectOrgIds = entry.getValue();
            if (CollectionUtils.isEmpty(selectOrgIds) || "2".equals(this.dataStrategyMap.get(dataId))) continue;
            this.unableCancelAssignByAssigned(dataId, selectOrgIds, subCuOrgMap, assignInfo);
        }
    }

    private void unableCancelAssignByAssigned(Long dataId, Set<Long> selectOrgIds, Map<Long, List<Long>> subCuOrgMap, Map<Long, Set<Long>> assignInfo) {
        Set<Long> assignOrgIds = assignInfo.get(dataId);
        if (CollectionUtils.isEmpty(assignOrgIds)) {
            return;
        }
        Set<Long> unableCancelOrgIds = this.unableCancelAssignMap.get(dataId);
        for (Long selectOrgId : selectOrgIds) {
            if (!CollectionUtils.isEmpty(unableCancelOrgIds) && unableCancelOrgIds.contains(selectOrgId)) continue;
            List<Long> subOrgIds = subCuOrgMap.get(selectOrgId);
            subOrgIds = CollectionUtils.isEmpty(subOrgIds) ? Collections.emptyList() : subOrgIds;
            HashSet<Long> ids = new HashSet<Long>(subOrgIds);
            ids.retainAll(assignOrgIds);
            if (ids.isEmpty()) continue;
            int assignCount = ids.size();
            ids.retainAll(selectOrgIds);
            if (ids.size() < assignCount) {
                this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
                this.assignData.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
                continue;
            }
            boolean unableCancel = this.unableCancelAssignByAssigned(dataId, ids, subCuOrgMap, assignInfo, selectOrgIds);
            if (!unableCancel) continue;
            this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
            this.assignData.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
        }
    }

    private boolean unableCancelAssignByAssigned(Long dataId, Set<Long> selectSubOrgIds, Map<Long, List<Long>> subCuOrgMap, Map<Long, Set<Long>> assignInfo, Set<Long> allOrgIds) {
        Set<Long> assignOrgIds = assignInfo.get(dataId);
        if (CollectionUtils.isEmpty(assignOrgIds)) {
            return false;
        }
        for (Long selectSubOrgId : selectSubOrgIds) {
            List<Long> subOrgIds = subCuOrgMap.get(selectSubOrgId);
            subOrgIds = CollectionUtils.isEmpty(subOrgIds) ? Collections.emptyList() : subOrgIds;
            HashSet<Long> ids = new HashSet<Long>(subOrgIds);
            ids.retainAll(assignOrgIds);
            if (ids.isEmpty()) continue;
            int assignCount = ids.size();
            ids.retainAll(allOrgIds);
            if (ids.size() < assignCount) {
                this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectSubOrgId);
                this.assignData.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectSubOrgId);
                return true;
            }
            boolean unableCancel = this.unableCancelAssignByAssigned(dataId, ids, subCuOrgMap, assignInfo, allOrgIds);
            if (!unableCancel) continue;
            this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectSubOrgId);
            this.assignData.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectSubOrgId);
            return true;
        }
        return false;
    }

    private void unableCancelAssignByCustom(Long dataId, Set<Long> selectOrgIds, Map<Long, List<Long>> subCuOrgMap) {
        HashMap<Long, Set<Long>> customValidateMap = new HashMap<Long, Set<Long>>(this.customData.size());
        for (Map.Entry<Long, Set<Long>> entry : this.customData.entrySet()) {
            customValidateMap.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        Set customOrgIds = (Set)customValidateMap.get(dataId);
        if (CollectionUtils.isEmpty((Collection)customOrgIds)) {
            return;
        }
        for (Long selectOrgId : selectOrgIds) {
            boolean unableCancel;
            List<Long> subOrgIds;
            if (customOrgIds.contains(selectOrgId)) {
                this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
                continue;
            }
            if (this.freeDataIds.contains(dataId) || CollectionUtils.isEmpty(subOrgIds = subCuOrgMap.get(selectOrgId)) || !(unableCancel = this.unableCancelAssignByCustom(dataId, subOrgIds, subCuOrgMap, selectOrgIds, customValidateMap))) continue;
            customOrgIds.add(selectOrgId);
            this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
        }
    }

    private boolean unableCancelAssignByCustom(Long dataId, List<Long> subOrgIds, Map<Long, List<Long>> subCuOrgMap, Set<Long> allSelectOrgIds, Map<Long, Set<Long>> customValidateMap) {
        Set<Long> customOrgIds = customValidateMap.get(dataId);
        for (Long orgId : subOrgIds) {
            if (!customOrgIds.contains(orgId)) continue;
            return true;
        }
        ArrayList<Long> copySubOrgIds = new ArrayList<Long>(subOrgIds);
        copySubOrgIds.retainAll(allSelectOrgIds);
        if (CollectionUtils.isEmpty(copySubOrgIds)) {
            return false;
        }
        for (Long subOrgId : copySubOrgIds) {
            List<Long> orgIds = subCuOrgMap.get(subOrgId);
            if (CollectionUtils.isEmpty(orgIds) || !this.unableCancelAssignByCustom(dataId, orgIds, subCuOrgMap, allSelectOrgIds, customValidateMap)) continue;
            customOrgIds.add(subOrgId);
            this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(subOrgId);
            return true;
        }
        return false;
    }

    private void setCustomData(String entity, Map<Long, List<Long>> subCuOrgMap) {
        if (BaseDataBusinessServiceUtils.isEnableVersion(this.entityId)) {
            return;
        }
        String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entity);
        HashMap<Long, Set> customDataOrgMap = new HashMap<Long, Set>(16);
        QFilter[] filters = new QFilter[]{new QFilter("sourcedata", "in", this.dataIdToUseOrgMap.keySet()), QFilter.sqlExpress((String)"id", (String)"!=", (String)masterIdFieldName)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entity, (String)"id, createorg, sourcedata, ctrlstrategy", (QFilter[])filters);
        for (DynamicObject baseData : collection) {
            Long source = baseData.getLong("sourcedata");
            if ("2".equals(baseData.getString("ctrlstrategy"))) {
                this.freeDataIds.add(source);
            }
            Long creator = baseData.getLong("createorg");
            customDataOrgMap.computeIfAbsent(source, k -> new HashSet(16)).add(creator);
        }
        for (Map.Entry<Long, Set<Long>> entry : this.dataIdToUseOrgMap.entrySet()) {
            Long dataId = entry.getKey();
            Set customOrgIds = (Set)customDataOrgMap.get(dataId);
            if (CollectionUtils.isEmpty((Collection)customOrgIds)) continue;
            Set<Long> orgIds = entry.getValue();
            block2: for (Long orgId : orgIds) {
                List<Long> subCuOrgIds;
                if (customOrgIds.contains(orgId)) {
                    this.customData.computeIfAbsent(dataId, k -> new HashSet(16)).add(orgId);
                    if (!this.isTreeTypeBaseData) continue;
                    HashSet<Long> dataParentIds = new HashSet<Long>(16);
                    this.getDataParentId(dataId, dataParentIds);
                    dataParentIds.forEach(dataParentId -> this.assignData.computeIfAbsent((Long)dataParentId, k -> new HashSet(16)).add(orgId));
                    continue;
                }
                if (this.freeDataIds.contains(dataId) || CollectionUtils.isEmpty(subCuOrgIds = subCuOrgMap.get(orgId))) continue;
                for (Long subCuOrgId : subCuOrgIds) {
                    if (!customOrgIds.contains(subCuOrgId) || orgIds.contains(subCuOrgId)) continue;
                    this.customData.computeIfAbsent(dataId, k -> new HashSet(16)).add(orgId);
                    if (!this.isTreeTypeBaseData) continue block2;
                    HashSet<Long> dataParentIds = new HashSet<Long>();
                    this.getDataParentId(dataId, dataParentIds);
                    dataParentIds.forEach(dataParentId -> this.assignData.computeIfAbsent((Long)dataParentId, k -> new HashSet(16)).add(orgId));
                    continue block2;
                }
            }
        }
    }

    private void getDataParentId(Long dataId, Set<Long> dataParentIds) {
        Long parentId = this.dataId2PidMap.get(dataId);
        if (null != parentId) {
            if (dataParentIds.contains(parentId)) {
                return;
            }
            dataParentIds.add(parentId);
        }
    }

    public Map<Long, Set<Long>> getCustomData() {
        return this.customData;
    }

    public Map<Long, Set<Long>> getAssignData() {
        return this.assignData;
    }

    public List<Long[]> getBusinessCheckResult() {
        return this.businessCheckResult;
    }

    public Map<Long, String> getDataNumberMap() {
        return this.dataNumberMap;
    }

    public Map<Long, String> getOrgNameMap() {
        return this.orgNameMap;
    }

    public Map<Long, Set<Long>> getCancelData() {
        this.release();
        if (this.dataIdToUseOrgMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> cancelData = new HashMap<Long, Set<Long>>(16);
        Iterator<Map.Entry<Long, Set<Long>>> iterator = this.dataIdToUseOrgMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Set<Long>> entry = iterator.next();
            Long dataId = entry.getKey();
            Iterator<Long> it = entry.getValue().iterator();
            while (it.hasNext()) {
                cancelData.computeIfAbsent(it.next(), k -> new HashSet(16)).add(dataId);
                it.remove();
            }
            iterator.remove();
        }
        this.dataIdToUseOrgMap = null;
        return cancelData;
    }

    private void release() {
        this.unableCancelAssignMap = null;
        this.dataId2PidMap = null;
        this.child2ParentOrgMap = null;
        this.freeDataIds = null;
        this.dataStrategyMap = null;
    }

    private void cancelErrorResponse() {
        if (!CollectionUtils.isEmpty(this.customData)) {
            this.showCustomTipNotification();
        }
        if (!this.unableCancelDataOrgNameMap.isEmpty()) {
            this.showTreeDataValidateTipNotification();
        }
        if (CollectionUtils.isEmpty(this.assignData) && !CollectionUtils.isEmpty(this.businessCheckResultWitchDetail)) {
            this.addBusinessValidateErrorTip(this.businessCheckResultWitchDetail);
        }
        HashSet orgIds = new HashSet();
        this.assignData.values().forEach(orgIds::addAll);
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)});
        HashMap orgNameMap = new HashMap(orgCol.size());
        orgCol.forEach(org -> orgNameMap.put(org.getLong("id"), org.getString("name")));
        for (Map.Entry<Long, Set<Long>> entry : this.assignData.entrySet()) {
            Long dataId = entry.getKey();
            String dataNumber = this.dataNumberMap.get(dataId);
            for (Long orgId : entry.getValue()) {
                String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5728\u3010%2$s\u3011\u53d6\u6d88\u5206\u914d\u5931\u8d25\uff0c\u8be5\u8bb0\u5f55\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u5206\u914d\u8bb0\u5f55\uff0c\u8bf7\u5148\u5728\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u53d6\u6d88\u5206\u914d\u3002", (String)"BaseDataCancelAssignAPIValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                HashMap<Long, Set<Long>> tempErrorMap = new HashMap<Long, Set<Long>>(1);
                HashSet<Long> tempOrgSet = new HashSet<Long>(1);
                tempOrgSet.add(orgId);
                tempErrorMap.put(dataId, tempOrgSet);
                if (this.unableCancelDataIdOrgSet.contains(dataId + "-" + orgId)) continue;
                this.unableCancelDataIdOrgSet.add(dataId + "-" + orgId);
                this.addResult(tempErrorMap, String.format(msg, dataNumber, orgNameMap.get(orgId)), false);
            }
        }
    }

    private void addBusinessValidateErrorTip(List<Object[]> checkResult) {
        if (checkResult.isEmpty()) {
            return;
        }
        for (Object[] checkResultTemp : checkResult) {
            Long dataId = Long.valueOf(checkResultTemp[0].toString());
            Long orgId = Long.valueOf(checkResultTemp[1].toString());
            String errorMsg = null == checkResultTemp[2] ? "" : checkResultTemp[2].toString();
            HashMap<Long, Set<Long>> errorMap = new HashMap<Long, Set<Long>>(1);
            HashSet<Long> errorSet = new HashSet<Long>(1);
            errorSet.add(orgId);
            errorMap.put(dataId, errorSet);
            String number = this.dataNumberMap.get(dataId);
            String orgName = this.orgNameMap.get(orgId);
            String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5728\u7ec4\u7ec7\u3010%2$s\u3011\u53d6\u6d88\u5206\u914d\u5931\u8d25\uff0c%3$s", (String)"BaseDataCancelAssignAPIValidator_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            if (this.unableCancelDataIdOrgSet.contains(dataId + "-" + orgId)) continue;
            this.unableCancelDataIdOrgSet.add(dataId + "-" + orgId);
            this.addResult(errorMap, String.format(msg, number, orgName, errorMsg), false);
        }
    }

    private void showTreeDataValidateTipNotification() {
        String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5728\u7ec4\u7ec7\u3010%2$s\u3011\u4e2d\u5b58\u5728\u4e0b\u7ea7\u8d44\u6599\uff0c\u8bf7\u5148\u53d6\u6d88\u8be5\u4e0b\u7ea7\u8d44\u6599\u7684\u5206\u914d\u6216\u8005\u5220\u9664\u8be5\u4e0b\u7ea7\u8d44\u6599\u3002", (String)"BaseDataCancelAssignAPIValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        for (Map.Entry<Long, Set<Long>> entry : this.unableCancelAssignMap.entrySet()) {
            Long dataId = entry.getKey();
            String number = this.dataNumberMap.get(dataId);
            HashMap<Long, Set<Long>> errorTempMap = new HashMap<Long, Set<Long>>(1);
            Set<Long> orgIds = entry.getValue();
            for (Long orgId : orgIds) {
                HashSet<Long> errorTempSet = new HashSet<Long>(1);
                errorTempSet.add(orgId);
                errorTempMap.put(dataId, errorTempSet);
                String orgName = this.orgNameMap.get(orgId);
                if (this.unableCancelDataIdOrgSet.contains(dataId + "-" + orgId)) continue;
                this.unableCancelDataIdOrgSet.add(dataId + "-" + orgId);
                this.addResult(errorTempMap, String.format(msg, number, orgName), false);
            }
        }
    }

    private void showCustomTipNotification() {
        for (Map.Entry<Long, Set<Long>> entry : this.customData.entrySet()) {
            String personalDataNum = this.dataNumberMap.get(entry.getKey());
            Set<Long> values = entry.getValue();
            for (Long value : values) {
                String personalDataOrg = this.orgNameMap.get(value);
                String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5728\u7ec4\u7ec7\u3010%2$s\u3011\u6216\u8005\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u4e2d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u8bf7\u5148\u5220\u9664\u4e2a\u6027\u5316\u6570\u636e\u518d\u53d6\u6d88\u5206\u914d\u3002", (String)"BaseDataCancelAssignAPIValidator_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), personalDataNum, personalDataOrg);
                HashMap<Long, Set<Long>> tempErrorMap = new HashMap<Long, Set<Long>>(1);
                HashSet<Long> tempOrgSet = new HashSet<Long>(1);
                tempOrgSet.add(value);
                tempErrorMap.put(entry.getKey(), tempOrgSet);
                this.unableCancelDataIdOrgSet.add(entry.getKey() + "-" + value);
                this.addResult(tempErrorMap, msg, false);
            }
        }
    }

    private void addResult(Map<Long, Set<Long>> unableCancelData, String errorMsg, boolean isSuccess) {
        Set<Map.Entry<Long, Set<Long>>> entrySet = unableCancelData.entrySet();
        Iterator<Map.Entry<Long, Set<Long>>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            CancelAssignResult cancelAssignResult = new CancelAssignResult();
            Map.Entry<Long, Set<Long>> entry = iterator.next();
            cancelAssignResult.setDataId(entry.getKey());
            cancelAssignResult.setOrgIds(new ArrayList(entry.getValue()));
            cancelAssignResult.setSuccess(isSuccess);
            cancelAssignResult.setErrorMsg(errorMsg);
            this.result.add(cancelAssignResult);
        }
    }
}

