/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.validator.AbstractBaseDataValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.roaringbitmap.RoaringBitmap;

public class BaseDataCancelAssignValidator
extends AbstractBaseDataValidator {
    private static final Log LOGGER = LogFactory.getLog(BaseDataCancelAssignValidator.class);
    private static final String UN_ASSIGN_PERM = "80513209000000ac";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String KEY_DATA_ID = "dataid";
    private static final String KEY_USE_ORG_ID = "useorgid";
    private static final String KEY_USE_ORG_NAME = "useorg";
    private static final String KEY_PARENT_ID = "parent.id";
    private static final String KEY_ORG_NAME = "createorg.name";
    private Map<Long, Set<Long>> dataIdToUseOrgMap = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Set<Long>> customData = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Set<Long>> assignData = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Set<Long>> unableCancelAssignMap = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Long> dataId2PidMap = new HashMap<Long, Long>(16);
    private Map<Long, Set<String>> unableCancelDataOrgNameMap = new HashMap<Long, Set<String>>(16);
    private Map<Long, Long> child2ParentOrgMap = new HashMap<Long, Long>(16);
    private List<Long[]> businessCheckResult = new ArrayList<Long[]>(10);
    private List<Object[]> businessCheckResultWitchDetail = new ArrayList<Object[]>(16);
    private Set<Long> freeDataIds = new HashSet<Long>(16);
    private Map<Long, String> dataNumberMap = new HashMap<Long, String>(16);
    private Map<Long, String> orgNameMap = new HashMap<Long, String>(16);
    private Map<Long, String> dataStrategyMap = new HashMap<Long, String>(16);
    private boolean isTreeTypeBaseData = false;

    public BaseDataCancelAssignValidator(IFormView view) {
        this.view = view;
    }

    public BaseDataCancelAssignValidator(IFormView view, String entity) {
        this(view);
        this.isTreeTypeBaseData = BaseDataCommonService.isTreeType(entity);
        this.entity = entity;
        this.init();
    }

    public boolean validate(Map<String, String> dataMap, ListSelectedRowCollection orgCollection, String entity, String ctrlStrategy) {
        if (!this.hasCancelPermission(entity)) {
            return false;
        }
        FormShowParameter showParameter = this.view.getFormShowParameter();
        Long currentOrgId = Long.valueOf(showParameter.getCustomParam("useOrgId").toString());
        this.businessValidate(dataMap, orgCollection, entity, ctrlStrategy, currentOrgId);
        if (this.isTreeTypeBaseData) {
            return this.executeValidate(entity);
        }
        return this.executeValidate(dataMap, orgCollection, entity, currentOrgId);
    }

    private void businessValidate(Map<String, String> dataMap, ListSelectedRowCollection orgCollection, String entity, String ctrlStrategy, Long currentOrgId) {
        IBaseDataCtrlPlugin plugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entity);
        ArrayList<Long[]> cancelAssignDataList = new ArrayList<Long[]>(10);
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            Long dataId = Long.valueOf(entry.getKey());
            this.dataNumberMap.put(dataId, entry.getValue());
            this.dataStrategyMap.put(dataId, ctrlStrategy);
            for (ListSelectedRow org : orgCollection) {
                Long orgId = (Long)org.getPrimaryKeyValue();
                if (orgId.equals(currentOrgId)) continue;
                this.orgNameMap.put(orgId, org.getName());
                if (this.isTreeTypeBaseData) {
                    this.dataIdToUseOrgMap.computeIfAbsent(dataId, k -> new HashSet(orgCollection.size())).add(orgId);
                    continue;
                }
                if (plugin == null) continue;
                cancelAssignDataList.add(new Long[]{dataId, orgId});
            }
        }
        if (plugin != null && !this.isTreeTypeBaseData) {
            List checkResult = plugin.unAssignCheck(cancelAssignDataList);
            if (!CollectionUtils.isEmpty((Collection)checkResult)) {
                checkResult.forEach(result -> this.businessCheckResultWitchDetail.add(new Object[]{result[0], result[1], ""}));
            } else {
                this.businessCheckResultWitchDetail = plugin.unAssignCheckWitchDetail(cancelAssignDataList);
            }
            for (Object[] check : this.businessCheckResultWitchDetail) {
                this.unableCancelAssignMap.computeIfAbsent(Long.valueOf(check[0].toString()), k -> new HashSet(16)).add(Long.valueOf(check[1].toString()));
            }
        }
    }

    private boolean executeValidate(Map<String, String> dataMap, ListSelectedRowCollection orgCollection, String entity, Long currentOrgId) {
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            Long dataId2 = Long.valueOf(entry.getKey());
            Set<Long> unableCancelAssignOrgIds = this.unableCancelAssignMap.get(dataId2);
            for (ListSelectedRow org : orgCollection) {
                Long orgId = (Long)org.getPrimaryKeyValue();
                boolean needCheck = !orgId.equals(currentOrgId) && (null == unableCancelAssignOrgIds || !unableCancelAssignOrgIds.contains(orgId));
                if (!needCheck) continue;
                this.dataIdToUseOrgMap.computeIfAbsent(dataId2, k -> new HashSet(orgCollection.size())).add(orgId);
            }
        }
        try {
            this.basicsValidate(entity);
            this.dataIdToUseOrgMap.forEach((dataId, selectOrgIds) -> {
                Set<Long> unableCancelOrgIds = this.unableCancelAssignMap.get(dataId);
                if (CollectionUtils.isEmpty(unableCancelOrgIds)) {
                    return;
                }
                selectOrgIds.removeAll(unableCancelOrgIds);
            });
            return true;
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u6821\u9a8c\u5931\u8d25", (String)"BaseDataCancelAssignValidator_13", (String)"bos-bd-business", (Object[])new Object[0]), (Throwable)e);
            this.view.showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u76f8\u5173\u6821\u9a8c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataCancelAssignValidator_2", (String)"bos-bd-business", (Object[])new Object[0]));
            return false;
        }
    }

    public boolean validate(String entity, BillList billList, DynamicObject baseData) {
        if (!this.hasCancelPermission(entity)) {
            return false;
        }
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53d6\u6d88\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"BaseDataCancelAssignValidator_3", (String)"bos-bd-business", (Object[])new Object[0]));
            return false;
        }
        this.initCancelAssignData(billList, baseData);
        return this.executeValidate(entity);
    }

    public boolean validate(String entity) {
        if (!this.hasCancelPermission(entity)) {
            return false;
        }
        EntryGrid billList = (EntryGrid)this.view.getControl(ENTRY_ENTITY);
        int[] selectRows = billList.getSelectRows();
        if (selectRows.length == 0) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53d6\u6d88\u5206\u914d\u7684\u6570\u636e\u3002", (String)"BaseDataCancelAssignValidator_1", (String)"bos-bd-business", (Object[])new Object[0]));
            return false;
        }
        this.initCancelAssignData(billList, entity);
        return this.executeValidate(entity);
    }

    private boolean executeValidate(String entity) {
        try {
            this.validateOnTreeType(entity);
            this.businessValidate(entity);
            this.basicsValidate(entity);
            if (this.isTreeTypeBaseData) {
                this.excludeUnableCancelData(this.unableCancelAssignMap);
                return true;
            }
            for (Map.Entry<Long, Set<Long>> entry : this.dataIdToUseOrgMap.entrySet()) {
                Long dataId = entry.getKey();
                Set<Long> unableCancelOrgIds = this.unableCancelAssignMap.get(dataId);
                if (CollectionUtils.isEmpty(unableCancelOrgIds)) continue;
                Set<Long> selectOrgIds = entry.getValue();
                selectOrgIds.removeAll(unableCancelOrgIds);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u6821\u9a8c\u5931\u8d25", (String)"BaseDataCancelAssignValidator_13", (String)"bos-bd-business", (Object[])new Object[0]), (Throwable)e);
            this.view.showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u76f8\u5173\u6821\u9a8c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataCancelAssignValidator_2", (String)"bos-bd-business", (Object[])new Object[0]));
            return false;
        }
    }

    private boolean hasCancelPermission(String entity) {
        String useOrgId = this.view.getFormShowParameter().getCustomParam("useOrgId").toString();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (PermissionServiceHelper.checkFunctionPermission((long)userId, (long)Long.parseLong(useOrgId), (String)entity, (String)UN_ASSIGN_PERM) == 0) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u53d6\u6d88\u5206\u914d\u6743\u9650\u3002", (String)"BaseDataCancelAssignValidator_0", (String)"bos-bd-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateOnTreeType(String entity) throws Exception {
        if (!this.isTreeTypeBaseData) {
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        this.dataIdToUseOrgMap.forEach((key, value) -> orgIds.addAll((Collection<Long>)value));
        this.initChild2ParentOrgMap(entity, orgIds);
        Map<Long, RoaringBitmap> orgBitMap = BaseDataUseRelQueryEngine.getOrgUseRelBitMapByOrgIds(orgIds, entity);
        Set<Long> selectDataIds = this.dataIdToUseOrgMap.keySet();
        HashMap<Long, Set<Long>> unableCancelData2OrgMap = new HashMap<Long, Set<Long>>(16);
        String selectFields = "id,createorg.name,parent.id,bitindex";
        QFilter[] filters = new QFilter[]{new QFilter(KEY_PARENT_ID, "in", selectDataIds)};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entity, (String)selectFields, (QFilter[])filters);
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            DynamicObject data = (DynamicObject)entry.getValue();
            Long dataId = data.getLong("id");
            Long pId = data.getLong(KEY_PARENT_ID);
            this.dataId2PidMap.put(dataId, pId);
            if (selectDataIds.contains(dataId) || this.eachValidateOrgOnTreeType(orgBitMap, pId, data.getInt("bitindex"), unableCancelData2OrgMap)) continue;
            this.unableCancelDataOrgNameMap.computeIfAbsent(pId, k -> new HashSet(16)).add(data.getString(KEY_ORG_NAME));
        }
        this.excludeUnableCancelData(unableCancelData2OrgMap);
    }

    private boolean eachValidateOrgOnTreeType(Map<Long, RoaringBitmap> orgBitMap, Long selectDataId, int bitIndex, Map<Long, Set<Long>> unableCancelData2OrgMap) {
        Set<Long> useOrgIds = this.dataIdToUseOrgMap.get(selectDataId);
        if (CollectionUtils.isEmpty(useOrgIds) || 0 == bitIndex) {
            return true;
        }
        boolean ableCancel = true;
        for (Long orgId : useOrgIds) {
            RoaringBitmap bit = orgBitMap.get(orgId);
            if (null == bit || !bit.contains(bitIndex)) continue;
            unableCancelData2OrgMap.computeIfAbsent(selectDataId, k -> new HashSet(16)).add(orgId);
            ableCancel = false;
        }
        return ableCancel;
    }

    private void excludeUnableCancelData(Map<Long, Set<Long>> unableCancelData2OrgMap) {
        for (Map.Entry<Long, Set<Long>> entry : unableCancelData2OrgMap.entrySet()) {
            Long dataId = entry.getKey();
            String strategy = this.dataStrategyMap.get(dataId);
            if (!"1".equals(strategy) && !"2".equals(strategy)) continue;
            Set<Long> unableCancelOrgIds = entry.getValue();
            Set<Long> selectOrgId = this.dataIdToUseOrgMap.get(dataId);
            if (!CollectionUtils.isEmpty(selectOrgId)) {
                selectOrgId.removeAll(unableCancelOrgIds);
            }
            for (Long unableCancelOrgId : unableCancelOrgIds) {
                if ("1".equals(strategy)) {
                    Long parentOrgId = this.child2ParentOrgMap.get(unableCancelOrgId);
                    this.eachExcludeUnableCancelOrg(parentOrgId, this.dataIdToUseOrgMap.get(dataId));
                    this.eachExcludeUnableCancelData(unableCancelOrgId, dataId);
                    continue;
                }
                this.eachExcludeUnableCancelDataOnFreeType(dataId, unableCancelOrgId);
            }
        }
    }

    private void eachExcludeUnableCancelDataOnFreeType(Long dataId, Long currentOrgId) {
        if (null == dataId) {
            return;
        }
        Set<Long> selectOrgIds = this.dataIdToUseOrgMap.get(dataId);
        if (!CollectionUtils.isEmpty(selectOrgIds)) {
            selectOrgIds.remove(currentOrgId);
        }
        dataId = this.dataId2PidMap.get(dataId);
        this.eachExcludeUnableCancelDataOnFreeType(dataId, currentOrgId);
    }

    private void eachExcludeUnableCancelData(Long currentOrgId, Long currentDataId) {
        Long parentDataId = this.dataId2PidMap.get(currentDataId);
        if (null == parentDataId) {
            return;
        }
        Set<Long> selectOrgIds = this.dataIdToUseOrgMap.get(parentDataId);
        if (!CollectionUtils.isEmpty(selectOrgIds)) {
            this.eachExcludeUnableCancelOrg(currentOrgId, selectOrgIds);
        }
        this.eachExcludeUnableCancelData(currentOrgId, parentDataId);
    }

    private void eachExcludeUnableCancelOrg(Long parentOrgId, Set<Long> selectOrgIds) {
        if (CollectionUtils.isEmpty(selectOrgIds) || null == parentOrgId) {
            return;
        }
        selectOrgIds.remove(parentOrgId);
        parentOrgId = this.child2ParentOrgMap.get(parentOrgId);
        this.eachExcludeUnableCancelOrg(parentOrgId, selectOrgIds);
    }

    private void initChild2ParentOrgMap(String entity, Set<Long> orgIds) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        OrgTreeParam orgTreeParam = new OrgTreeParam();
        orgTreeParam.setOrgRangeList(new ArrayList<Long>(orgIds));
        orgTreeParam.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        orgTreeParam.setOrgViewId(((Long)ctrlView.getPkValue()).longValue());
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)orgTreeParam);
        Long topOrgId = Long.valueOf(rootNode.getId());
        this.child2ParentOrgMap.putAll(new BaseDataCommonService().getChild2ParentOrgMap(orgIds, topOrgId, entity));
    }

    private void businessValidate(String entity) {
        if (this.dataIdToUseOrgMap.isEmpty()) {
            return;
        }
        ArrayList cancelAssignDataList = new ArrayList(10);
        for (Map.Entry<Long, Set<Long>> entry : this.dataIdToUseOrgMap.entrySet()) {
            Long dataId = entry.getKey();
            Set<Long> useOrgIds = entry.getValue();
            useOrgIds.forEach(orgId -> cancelAssignDataList.add(new Long[]{dataId, orgId}));
        }
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entity);
        if (baseDataCtrlPlugin == null) {
            return;
        }
        List checkResult = baseDataCtrlPlugin.unAssignCheck(cancelAssignDataList);
        if (!CollectionUtils.isEmpty((Collection)checkResult)) {
            checkResult.forEach(result -> this.businessCheckResultWitchDetail.add(new Object[]{result[0], result[1], ""}));
        } else {
            this.businessCheckResultWitchDetail = baseDataCtrlPlugin.unAssignCheckWitchDetail(cancelAssignDataList);
        }
        for (Object[] check : this.businessCheckResultWitchDetail) {
            Long dataId = Long.valueOf(check[0].toString());
            Set<Long> useOrgIds = this.dataIdToUseOrgMap.get(dataId);
            if (null == useOrgIds) continue;
            Long orgId2 = Long.valueOf(check[1].toString());
            useOrgIds.remove(orgId2);
            this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(orgId2);
        }
    }

    private void initCancelAssignData(EntryGrid billList, String entity) {
        int[] selectRows;
        DynamicObject[] objs = billList.getEntryData().getDataEntitys();
        for (int i : selectRows = billList.getSelectRows()) {
            String number = objs[i].getString("number");
            String useOrgName = objs[i].getString(KEY_USE_ORG_NAME);
            Long dataId = objs[i].getLong(KEY_DATA_ID);
            Long useOrgId = objs[i].getLong(KEY_USE_ORG_ID);
            this.dataNumberMap.put(dataId, number);
            this.orgNameMap.put(useOrgId, useOrgName);
            this.dataIdToUseOrgMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(useOrgId);
        }
        this.mappingDataStrategy(entity);
    }

    private void initCancelAssignData(BillList billList, DynamicObject baseData) {
        Long dataId = baseData.getLong("id");
        this.dataNumberMap.put(dataId, baseData.getString(this.numberField));
        this.dataStrategyMap.put(dataId, baseData.getString("ctrlstrategy"));
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        for (ListSelectedRow row : selectedRows) {
            Long orgId = Long.valueOf(row.getPrimaryKeyValue().toString());
            this.orgNameMap.put(orgId, row.getName());
            this.dataIdToUseOrgMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(orgId);
        }
    }

    private void basicsValidate(String entity) throws Exception {
        HashSet<Long> orgIds = new HashSet<Long>(this.dataIdToUseOrgMap.size());
        this.dataIdToUseOrgMap.values().forEach(orgIds::addAll);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        Long viewId = (Long)ctrlView.getPkValue();
        Map<Long, List<Long>> subCuOrgMap = new BaseDataCommonService().getDirectSubCuOrgMapping(viewId, orgIds);
        this.setCustomData(entity, subCuOrgMap);
        for (Map.Entry<Long, Set<Long>> entry : this.dataIdToUseOrgMap.entrySet()) {
            this.unableCancelAssignByCustom(entry.getKey(), entry.getValue(), subCuOrgMap);
        }
        HashSet<Long> allOrgIds = new HashSet<Long>(orgIds);
        subCuOrgMap.values().forEach(allOrgIds::addAll);
        Map<Long, Set<Long>> assignInfo = new BaseDataAssignService(entity).getDataAssignInfo(this.dataIdToUseOrgMap.keySet(), allOrgIds);
        for (Map.Entry<Long, Set<Long>> entry : this.dataIdToUseOrgMap.entrySet()) {
            Long dataId = entry.getKey();
            Set<Long> selectOrgIds = entry.getValue();
            if (CollectionUtils.isEmpty(selectOrgIds) || "2".equals(this.dataStrategyMap.get(dataId))) continue;
            this.unableCancelAssignByAssigned(dataId, selectOrgIds, subCuOrgMap, assignInfo);
        }
    }

    private void unableCancelAssignByAssigned(Long dataId, Set<Long> selectOrgIds, Map<Long, List<Long>> subCuOrgMap, Map<Long, Set<Long>> assignInfo) {
        Set<Long> assignOrgIds = assignInfo.get(dataId);
        if (CollectionUtils.isEmpty(assignOrgIds)) {
            return;
        }
        Set<Long> unableCancelOrgIds = this.unableCancelAssignMap.get(dataId);
        for (Long selectOrgId : selectOrgIds) {
            if (!CollectionUtils.isEmpty(unableCancelOrgIds) && unableCancelOrgIds.contains(selectOrgId)) continue;
            List<Long> subOrgIds = subCuOrgMap.get(selectOrgId);
            subOrgIds = CollectionUtils.isEmpty(subOrgIds) ? Collections.emptyList() : subOrgIds;
            HashSet<Long> ids = new HashSet<Long>(subOrgIds);
            ids.retainAll(assignOrgIds);
            if (ids.isEmpty()) continue;
            int assignCount = ids.size();
            ids.retainAll(selectOrgIds);
            if (ids.size() < assignCount) {
                this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
                this.assignData.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
                continue;
            }
            boolean unableCancel = this.unableCancelAssignByAssigned(dataId, ids, subCuOrgMap, assignInfo, selectOrgIds);
            if (!unableCancel) continue;
            this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
            this.assignData.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
        }
    }

    private boolean unableCancelAssignByAssigned(Long dataId, Set<Long> selectSubOrgIds, Map<Long, List<Long>> subCuOrgMap, Map<Long, Set<Long>> assignInfo, Set<Long> allOrgIds) {
        Set<Long> assignOrgIds = assignInfo.get(dataId);
        if (CollectionUtils.isEmpty(assignOrgIds)) {
            return false;
        }
        for (Long selectSubOrgId : selectSubOrgIds) {
            List<Long> subOrgIds = subCuOrgMap.get(selectSubOrgId);
            subOrgIds = CollectionUtils.isEmpty(subOrgIds) ? Collections.emptyList() : subOrgIds;
            HashSet<Long> ids = new HashSet<Long>(subOrgIds);
            ids.retainAll(assignOrgIds);
            if (ids.isEmpty()) continue;
            int assignCount = ids.size();
            ids.retainAll(allOrgIds);
            if (ids.size() < assignCount) {
                this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectSubOrgId);
                this.assignData.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectSubOrgId);
                return true;
            }
            boolean unableCancel = this.unableCancelAssignByAssigned(dataId, ids, subCuOrgMap, assignInfo, allOrgIds);
            if (!unableCancel) continue;
            this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectSubOrgId);
            this.assignData.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectSubOrgId);
            return true;
        }
        return false;
    }

    private void unableCancelAssignByCustom(Long dataId, Set<Long> selectOrgIds, Map<Long, List<Long>> subCuOrgMap) {
        HashMap<Long, Set<Long>> customValidateMap = new HashMap<Long, Set<Long>>(this.customData.size());
        for (Map.Entry<Long, Set<Long>> entry : this.customData.entrySet()) {
            customValidateMap.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        Set customOrgIds = (Set)customValidateMap.get(dataId);
        if (CollectionUtils.isEmpty((Collection)customOrgIds)) {
            return;
        }
        for (Long selectOrgId : selectOrgIds) {
            boolean unableCancel;
            List<Long> subOrgIds;
            if (customOrgIds.contains(selectOrgId)) {
                this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
                continue;
            }
            if (this.freeDataIds.contains(dataId) || CollectionUtils.isEmpty(subOrgIds = subCuOrgMap.get(selectOrgId)) || !(unableCancel = this.unableCancelAssignByCustom(dataId, subOrgIds, subCuOrgMap, selectOrgIds, customValidateMap))) continue;
            customOrgIds.add(selectOrgId);
            this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(selectOrgId);
        }
    }

    private boolean unableCancelAssignByCustom(Long dataId, List<Long> subOrgIds, Map<Long, List<Long>> subCuOrgMap, Set<Long> allSelectOrgIds, Map<Long, Set<Long>> customValidateMap) {
        Set<Long> customOrgIds = customValidateMap.get(dataId);
        for (Long orgId : subOrgIds) {
            if (!customOrgIds.contains(orgId)) continue;
            return true;
        }
        ArrayList<Long> copySubOrgIds = new ArrayList<Long>(subOrgIds);
        copySubOrgIds.retainAll(allSelectOrgIds);
        if (CollectionUtils.isEmpty(copySubOrgIds)) {
            return false;
        }
        for (Long subOrgId : copySubOrgIds) {
            List<Long> orgIds = subCuOrgMap.get(subOrgId);
            if (CollectionUtils.isEmpty(orgIds) || !this.unableCancelAssignByCustom(dataId, orgIds, subCuOrgMap, allSelectOrgIds, customValidateMap)) continue;
            customOrgIds.add(subOrgId);
            this.unableCancelAssignMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(subOrgId);
            return true;
        }
        return false;
    }

    private void setCustomData(String entity, Map<Long, List<Long>> subCuOrgMap) {
        String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entity);
        HashMap<Long, Set> customDataOrgMap = new HashMap<Long, Set>(16);
        QFilter[] filters = new QFilter[]{new QFilter("sourcedata", "in", this.dataIdToUseOrgMap.keySet()), QFilter.sqlExpress((String)"id", (String)"!=", (String)masterIdFieldName)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entity, (String)"createorg, sourcedata, ctrlstrategy", (QFilter[])filters);
        for (DynamicObject baseData : collection) {
            Long source = baseData.getLong("sourcedata");
            if ("2".equals(baseData.getString("ctrlstrategy"))) {
                this.freeDataIds.add(source);
            }
            Long creator = baseData.getLong("createorg");
            customDataOrgMap.computeIfAbsent(source, k -> new HashSet(16)).add(creator);
        }
        for (Map.Entry<Long, Set<Long>> entry : this.dataIdToUseOrgMap.entrySet()) {
            Long dataId = entry.getKey();
            Set customOrgIds = (Set)customDataOrgMap.get(dataId);
            if (CollectionUtils.isEmpty((Collection)customOrgIds)) continue;
            Set<Long> orgIds = entry.getValue();
            block2: for (Long orgId : orgIds) {
                List<Long> subCuOrgIds;
                if (customOrgIds.contains(orgId)) {
                    this.customData.computeIfAbsent(dataId, k -> new HashSet(16)).add(orgId);
                    continue;
                }
                if (this.freeDataIds.contains(dataId) || CollectionUtils.isEmpty(subCuOrgIds = subCuOrgMap.get(orgId))) continue;
                for (Long subCuOrgId : subCuOrgIds) {
                    if (!customOrgIds.contains(subCuOrgId) || orgIds.contains(subCuOrgId)) continue;
                    this.customData.computeIfAbsent(dataId, k -> new HashSet(16)).add(orgId);
                    continue block2;
                }
            }
        }
    }

    private void mappingDataStrategy(String entity) {
        Set<Long> dataIds = this.dataNumberMap.keySet();
        if (CollectionUtils.isEmpty(dataIds)) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entity, (String)"id, ctrlstrategy", (QFilter[])filters);
        for (DynamicObject baseData : collection) {
            this.dataStrategyMap.put(baseData.getLong("id"), baseData.getString("ctrlstrategy"));
        }
    }

    public Map<Long, Set<Long>> getCustomData() {
        return this.customData;
    }

    public Map<Long, Set<Long>> getAssignData() {
        return this.assignData;
    }

    public List<Long[]> getBusinessCheckResult() {
        return this.businessCheckResult;
    }

    public Map<Long, String> getDataNumberMap() {
        return this.dataNumberMap;
    }

    public Map<Long, String> getOrgNameMap() {
        return this.orgNameMap;
    }

    public Map<Long, Set<Long>> getCancelData() {
        this.release();
        if (this.dataIdToUseOrgMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        Iterator<Map.Entry<Long, Set<Long>>> iterator = this.dataIdToUseOrgMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Set<Long>> entry = iterator.next();
            Long dataId = entry.getKey();
            Iterator<Long> it = entry.getValue().iterator();
            while (it.hasNext()) {
                result.computeIfAbsent(it.next(), k -> new HashSet(16)).add(dataId);
                it.remove();
            }
            iterator.remove();
        }
        this.dataIdToUseOrgMap = null;
        return result;
    }

    private void release() {
        this.unableCancelAssignMap = null;
        this.dataId2PidMap = null;
        this.child2ParentOrgMap = null;
        this.freeDataIds = null;
        this.dataStrategyMap = null;
    }

    public void showCancelTipNotification() {
        if (!this.unableCancelDataOrgNameMap.isEmpty()) {
            this.showTreeDataValidateTipNotification();
            return;
        }
        if (!CollectionUtils.isEmpty(this.customData)) {
            this.showCustomTipNotification();
            return;
        }
        if (CollectionUtils.isEmpty(this.assignData)) {
            if (CollectionUtils.isEmpty(this.businessCheckResultWitchDetail)) {
                this.view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"BaseDataCancelAssignValidator_4", (String)"bos-bd-business", (Object[])new Object[0]));
            } else {
                String msg = ResManager.loadKDString((String)"%1$s\u7b49%2$s\u6761\u6570\u636e\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002%3$s", (String)"BaseDataCancelAssignValidator_5", (String)"bos-bd-business", (Object[])new Object[0]);
                this.view.showTipNotification(String.format(msg, this.dataNumberMap.get(this.businessCheckResultWitchDetail.get(0)[0]), this.businessCheckResultWitchDetail.size(), this.businessCheckResultWitchDetail.get(0)[2]));
            }
            return;
        }
        if (!CollectionUtils.isEmpty(this.businessCheckResultWitchDetail)) {
            String msg = ResManager.loadKDString((String)"%1$s\u7b49%2$s\u6761\u6570\u636e\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002%3$s", (String)"BaseDataCancelAssignValidator_5", (String)"bos-bd-business", (Object[])new Object[0]);
            this.view.showTipNotification(String.format(msg, this.dataNumberMap.get(this.businessCheckResultWitchDetail.get(0)[0]), this.businessCheckResultWitchDetail.size(), this.businessCheckResultWitchDetail.get(0)[2]));
            return;
        }
        int failSize = 0;
        for (Set<Long> orgIds : this.assignData.values()) {
            failSize += orgIds.size();
        }
        HashSet orgIds = new HashSet();
        this.assignData.values().forEach(orgIds::addAll);
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)});
        HashMap orgNameMap = new HashMap(orgCol.size());
        orgCol.forEach(org -> orgNameMap.put(org.getLong("id"), org.getString("name")));
        ArrayList<String> alreadyAssignMsg = new ArrayList<String>(failSize);
        for (Map.Entry<Long, Set<Long>> entry : this.assignData.entrySet()) {
            Long dataId = entry.getKey();
            String dataNumber = this.dataNumberMap.get(dataId);
            for (Long orgId : entry.getValue()) {
                String msg;
                if (1 == failSize) {
                    msg = ResManager.loadKDString((String)"%1$s\uff1a\u5728\u3010%2$s\u3011\u53d6\u6d88\u5206\u914d\u5931\u8d25\uff0c\u8be5\u8bb0\u5f55\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u5206\u914d\u8bb0\u5f55\uff0c\u8bf7\u5148\u5728\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u53d6\u6d88\u5206\u914d\u3002", (String)"BaseDataCancelAssignValidator_10", (String)"bos-bd-business", (Object[])new Object[0]);
                    this.view.showTipNotification(String.format(msg, dataNumber, orgNameMap.get(orgId)));
                    return;
                }
                msg = ResManager.loadKDString((String)"%1$s\uff1a\u8bf7\u5148\u5728\u3010%2$s\u3011\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u53d6\u6d88\u5206\u914d\u3002", (String)"BaseDataCancelAssignValidator_6", (String)"bos-bd-business", (Object[])new Object[0]);
                alreadyAssignMsg.add(String.format(msg, dataNumber, orgNameMap.get(orgId)));
            }
        }
        String msg = ResManager.loadKDString((String)"\u5b58\u5728%1$s\u6761\u53d6\u6d88\u5206\u914d\u5931\u8d25\u6570\u636e\u3002", (String)"BaseDataCancelAssignValidator_7", (String)"bos-bd-business", (Object[])new Object[0]);
        this.view.showMessage(String.format(msg, failSize), String.join((CharSequence)"\r\n", alreadyAssignMsg), MessageTypes.Default);
    }

    private void showTreeDataValidateTipNotification() {
        String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5728\u7ec4\u7ec7\u3010%2$s\u3011\u4e2d\u5b58\u5728\u4e0b\u7ea7\u8d44\u6599\uff0c\u8bf7\u5148\u53d6\u6d88\u8be5\u4e0b\u7ea7\u8d44\u6599\u7684\u5206\u914d\u6216\u8005\u5220\u9664\u8be5\u4e0b\u7ea7\u8d44\u6599\u3002", (String)"BaseDataCancelAssignValidator_11", (String)"bos-bd-business", (Object[])new Object[0]);
        int size = 0;
        StringJoiner joiner = new StringJoiner("\r\n");
        for (Map.Entry<Long, Set<String>> entry : this.unableCancelDataOrgNameMap.entrySet()) {
            Set<String> orgNames = entry.getValue();
            String number = this.dataNumberMap.get(entry.getKey());
            for (String orgName : orgNames) {
                joiner.add(String.format(msg, number, orgName));
            }
            size += orgNames.size();
        }
        if (1 == size) {
            this.view.showTipNotification(joiner.toString());
            return;
        }
        String title = ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u65e0\u6cd5\u53d6\u6d88\u5206\u914d", (String)"BaseDataCancelAssignValidator_12", (String)"bos-bd-business", (Object[])new Object[0]);
        this.view.showMessage(title, joiner.toString(), MessageTypes.Default);
    }

    private void showCustomTipNotification() {
        ArrayList<String> messages = new ArrayList<String>(16);
        for (Map.Entry<Long, Set<Long>> entry : this.customData.entrySet()) {
            String personalDataNum = this.dataNumberMap.get(entry.getKey());
            Set<Long> values = entry.getValue();
            for (Long value : values) {
                String personalDataOrg = this.orgNameMap.get(value);
                String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5728\u7ec4\u7ec7\u3010%2$s\u3011\u6216\u8005\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u4e2d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u8bf7\u5148\u5220\u9664\u4e2a\u6027\u5316\u6570\u636e\u518d\u53d6\u6d88\u5206\u914d\u3002", (String)"BaseDataCancelAssignValidator_15", (String)"bos-bd-business", (Object[])new Object[0]), personalDataNum, personalDataOrg);
                messages.add(msg);
            }
        }
        if (messages.size() == 1) {
            this.view.showTipNotification((String)messages.get(0));
            return;
        }
        this.view.showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e", (String)"BaseDataCancelAssignValidator_9", (String)"bos-bd-business", (Object[])new Object[0]), String.join((CharSequence)"\r\n", messages), MessageTypes.Default);
    }
}

