/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.validator.AbstractBaseDataValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BaseDataChangeCtrlValidator
extends AbstractBaseDataValidator {
    private static final Log LOGGER = LogFactory.getLog(BaseDataChangeCtrlValidator.class);
    private static final String BD_CTRL_CHANGE = "/IN0GIK354+3";
    private BeforeItemClickEvent event;

    public BaseDataChangeCtrlValidator(BeforeItemClickEvent event, IFormView view) {
        this.event = event;
        this.view = view;
        this.entity = this.getEntityNumber();
        this.init();
    }

    public void validate(Long useOrgId, List<Long> dataIds) {
        QFilter[] filters;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appId = this.view.getFormShowParameter().getAppId();
        if (PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)useOrgId, (String)appId, (String)this.entity, (String)BD_CTRL_CHANGE) == 0) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u5728\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u201c\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BaseDataChangeCtrlValidator_1", (String)"bos-bd-business", (Object[])new Object[0]));
            this.event.setCancel(true);
            return;
        }
        String selectFields = this.selectFields(Arrays.asList("id", "ctrlstrategy", "createOrg"));
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)this.entity, (String)selectFields, (QFilter[])(filters = new QFilter[]{new QFilter("id", "in", dataIds)}));
        if (collection == null || collection.length == 0) {
            this.event.setCancel(true);
            return;
        }
        String ctrlStrategy = collection[0].getString("ctrlstrategy");
        Long createOrgId = this.getCreateOrgId(collection[0]);
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(collection.length);
        String createOrgName = this.getCreateOrgName();
        for (DynamicObject dynamicObject : collection) {
            Long orgId = this.getCreateOrgId(dynamicObject);
            String number = dynamicObject.getString(this.numberField);
            if (!orgId.equals(useOrgId)) {
                this.view.showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u4f7f\u7528\u7ec4\u7ec7\u201d\u4e0e\u201c%2$s\u201d\u76f8\u540c\u65f6\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataChangeCtrlValidator_3", (String)"bos-bd-business", (Object[])new Object[0]), number, createOrgName));
                this.event.setCancel(true);
                return;
            }
            if (!orgId.equals(createOrgId)) {
                this.view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataChangeCtrlValidator_5", (String)"bos-bd-business", (Object[])new Object[0]), createOrgName));
                this.event.setCancel(true);
                return;
            }
            String strategy = dynamicObject.getString("ctrlstrategy");
            if (!ctrlStrategy.equals(strategy)) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataChangeCtrlValidator_4", (String)"bos-bd-business", (Object[])new Object[0]));
                this.event.setCancel(true);
                return;
            }
            Long masterId = dynamicObject.getLong(this.masterIdPropName);
            Long dataId = dynamicObject.getLong("id");
            if ("2".equals(strategy) && !dataId.equals(masterId)) {
                this.view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u81ea\u7531\u5206\u914d\u7684\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataChangeCtrlValidator_8", (String)"bos-bd-business", (Object[])new Object[0]), number));
                this.event.setCancel(true);
                return;
            }
            idNumberMap.put((Long)dynamicObject.getPkValue(), number);
        }
        this.assignValidate(useOrgId, ctrlStrategy, idNumberMap);
    }

    public void assignValidate(Long orgId, String ctrlStrategy, Map<Long, String> idNumberMap) {
        Set<Long> alreadyAssignDataIds;
        try {
            alreadyAssignDataIds = this.getAssignDataIds(this.entity, orgId, ctrlStrategy, new HashSet<Long>(idNumberMap.keySet()));
        }
        catch (Exception e) {
            LOGGER.error("\u4ece\u4f4d\u56fe\u6570\u636e\u4e2d\u83b7\u53d6\u5df2\u5206\u914d\u60c5\u51b5\u5f02\u5e38", (Throwable)e);
            this.view.showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5df2\u5206\u914d\u60c5\u51b5\u5f02\u5e38\uff0c\u6682\u65f6\u65e0\u6cd5\u8fdb\u884c\u7ba1\u63a7\u7b56\u7565\u53d8\u66f4\u3002", (String)"BaseDataChangeCtrlValidator_7", (String)"bos-bd-business", (Object[])new Object[0]));
            this.event.setCancel(true);
            return;
        }
        if (CollectionUtils.isEmpty(alreadyAssignDataIds)) {
            return;
        }
        Long dataId = new ArrayList<Long>(alreadyAssignDataIds).get(0);
        String number = idNumberMap.get(dataId);
        String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6570\u636e\u672a\u5206\u914d\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"BaseDataChangeCtrlValidator_6", (String)"bos-bd-business", (Object[])new Object[0]), number);
        this.view.showTipNotification(msg);
        this.event.setCancel(true);
    }
}

