/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.validator.AbstractBaseDataValidator;
import kd.bos.bd.validator.ChangeManageRightValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BaseDataChangeOrgValidator
extends AbstractBaseDataValidator {
    private static final String ORG_PERM_CHANGE = "4730fc9f000000ac";
    private static final String ORG_ENTITY = "bos_org";

    public BaseDataChangeOrgValidator(IFormView view) {
        this.view = view;
        this.entity = this.getEntityNumber();
        this.init();
    }

    public boolean validate(List<Long> dataIds, long useOrgId) {
        QFilter[] filters;
        String selectFields;
        DynamicObjectCollection collection;
        long userId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)useOrgId, (String)this.getAppId(), (String)this.entity, (String)ORG_PERM_CHANGE) == 0) {
            String caption = FormMetadataCache.getFormConfig((String)this.entity).getCaption().getLocaleValue();
            this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u7ba1\u7406\u6743\u8f6c\u8ba9\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BaseDataChangeOrgValidator_5", (String)"bos-bd-business", (Object[])new Object[0]), caption));
            return false;
        }
        boolean isTreeType = BaseDataCommonService.isTreeType(this.entity);
        if (BaseDataCommonService.isTreeType(this.entity) && !this.isAllGlobalShare(dataIds)) {
            ChangeManageRightValidator validator = new ChangeManageRightValidator(this.entity);
            List<DynamicObject> allNodes = validator.getAllNodes(new HashSet<Long>(dataIds), useOrgId);
            allNodes.forEach(node -> dataIds.add(node.getLong("id")));
        }
        if ((collection = QueryServiceHelper.query((String)this.entity, (String)(selectFields = isTreeType ? this.selectFields(Arrays.asList("id", "ctrlstrategy", "createorg", "longNumber", "level", "isLeaf")) : this.selectFields(Arrays.asList("id", "ctrlstrategy", "createorg"))), (QFilter[])(filters = new QFilter[]{new QFilter("id", "in", dataIds)}))).isEmpty()) {
            return false;
        }
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(collection.size());
        String ctrlStrategy = ((DynamicObject)collection.get(0)).getString("ctrlstrategy");
        long createOrgId = ((DynamicObject)collection.get(0)).getLong("createorg");
        return this.basicsValidate(collection, useOrgId, createOrgId, ctrlStrategy, idNumberMap);
    }

    private boolean isAllGlobalShare(List<Long> dataIds) {
        QFilter[] filters = new QFilter[]{new QFilter("ctrlstrategy", "=", (Object)"5"), new QFilter("id", "in", dataIds)};
        DynamicObjectCollection col = QueryServiceHelper.query((String)this.entity, (String)"id,number,ctrlStrategy", (QFilter[])filters);
        return col.size() == dataIds.size();
    }

    private boolean basicsValidate(DynamicObjectCollection collection, long useOrgId, long createOrgId, String ctrlStrategy, Map<Long, String> idNumberMap) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)useOrgId)};
        DynamicObject useOrg = QueryServiceHelper.queryOne((String)ORG_ENTITY, (String)"id,name", (QFilter[])qFilters);
        String useOrgName = null == useOrg ? "" : useOrg.getString("name");
        for (DynamicObject data : collection) {
            String number = data.getString(this.numberField);
            long orgId = data.getLong("createorg");
            if (orgId != useOrgId) {
                this.view.showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u7ec4\u7ec7\uff1a\u201d%s\u201c\u4e0e\u57fa\u7840\u6570\u636e\u7684\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u76f8\u540c\u65f6\uff0c\u624d\u80fd\u8fdb\u884c\u7ba1\u7406\u6743\u8f6c\u8ba9\u3002\u8bf7\u901a\u8fc7\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u5b57\u6bb5\u8fdb\u884c\u8fc7\u6ee4\u3002", (String)"BaseDataChangeOrgValidator_1", (String)"bos-bd-business", (Object[])new Object[0]), useOrgName));
                return false;
            }
            if (createOrgId != orgId) {
                this.view.showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u521b\u5efa\u7ec4\u7ec7\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u8fdb\u884c\u7ba1\u7406\u6743\u8f6c\u8ba9\u3002", (String)"BaseDataChangeOrgValidator_0", (String)"bos-bd-business", (Object[])new Object[0]), number));
                return false;
            }
            Long masterId = this.getMasterId(data.get(this.masterIdPropName));
            Long dataId = data.getLong("id");
            if (!dataId.equals(masterId)) {
                this.view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u8f6c\u8ba9\u7ba1\u7406\u6743\u3002", (String)"BaseDataChangeOrgValidator_3", (String)"bos-bd-business", (Object[])new Object[0]), number));
                return false;
            }
            String currentStrategy = data.getString("ctrlstrategy");
            if (!ctrlStrategy.equals(currentStrategy)) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u8f6c\u8ba9\u7ba1\u7406\u6743\u3002", (String)"BaseDataChangeOrgValidator_4", (String)"bos-bd-business", (Object[])new Object[0]));
                return false;
            }
            if ("7".equals(currentStrategy)) {
                this.view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u79c1\u6709\u578b\u6570\u636e\u4e0d\u5141\u8bb8\u8f6c\u8ba9\u7ba1\u7406\u6743\u3002", (String)"BaseDataChangeOrgValidator_10", (String)"bos-bd-business", (Object[])new Object[0]), number));
                return false;
            }
            idNumberMap.put(data.getLong("id"), number);
        }
        return true;
    }

    private Long getMasterId(Object data) {
        if (data instanceof DynamicObject) {
            return (Long)((DynamicObject)data).getPkValue();
        }
        if (data instanceof Long) {
            return (Long)data;
        }
        return Long.valueOf(data.toString());
    }
}

