/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.bd.service.BaseDataCustomService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BaseDataDeleteValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(BaseDataDeleteValidator.class);
    private static final String ORG_ENTITY = "bos_org";
    private static final String IS_MULTI_USEORG = "isMultiUseOrg";

    public void validate() {
        String useOrgIdStr = this.getOption().getVariableValue("createOrg", null);
        boolean isMultiUseOrg = this.getOption().containsVariable(IS_MULTI_USEORG);
        Long useOrgId = 0L;
        DynamicObject view = null;
        if (!isMultiUseOrg) {
            if (StringUtils.isEmpty((CharSequence)useOrgIdStr)) {
                return;
            }
            useOrgId = Long.valueOf(useOrgIdStr);
            view = BusinessDataServiceHelper.loadSingleFromCache((String)ORG_ENTITY, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)useOrgId)});
        }
        HashMap<Long, ExtendedDataEntity> needJudgeAssignedMap = new HashMap<Long, ExtendedDataEntity>(16);
        boolean isIncludeFreeAssignData = false;
        for (ExtendedDataEntity dynamicObject : this.dataEntities) {
            boolean isFreeAssign;
            String ctrlStrategy;
            DynamicObject baseData = dynamicObject.getDataEntity();
            DynamicObject createOrg = baseData.getDynamicObject("createorg");
            if (createOrg == null) continue;
            if (!isMultiUseOrg && !useOrgId.equals(createOrg.getPkValue())) {
                String msgName = "";
                if (view != null) {
                    msgName = view.getString("name");
                }
                this.addErrorMessage(dynamicObject, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BaseDataDeleteValidator_0", (String)"bos-bd-business", (Object[])new Object[0]), msgName));
            }
            boolean isCuAssign = "1".equals(ctrlStrategy = baseData.getString("ctrlstrategy")) || "3".equals(ctrlStrategy);
            boolean bl = isFreeAssign = "2".equals(ctrlStrategy) || "4".equals(ctrlStrategy);
            if (isFreeAssign || isCuAssign) {
                needJudgeAssignedMap.put((Long)dynamicObject.getBillPkId(), dynamicObject);
            }
            if (!isFreeAssign) continue;
            isIncludeFreeAssignData = true;
        }
        this.validateAssign(needJudgeAssignedMap, isIncludeFreeAssignData, useOrgId, isMultiUseOrg);
    }

    private void validateAssign(Map<Long, ExtendedDataEntity> needJudgeAssignedMap, boolean isIncludeFreeAssignData, Long useOrgId, boolean isMultiUseOrg) {
        Set<Long> customDataIds = new BaseDataCustomService().selectCustomDataIds(this.entityKey, needJudgeAssignedMap.keySet());
        for (Long dataId : customDataIds) {
            ExtendedDataEntity customData = needJudgeAssignedMap.remove(dataId);
            if (Objects.isNull(customData)) continue;
            this.addErrorMessage(customData, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BaseDataDeleteValidator_1", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        if (needJudgeAssignedMap.isEmpty()) {
            return;
        }
        Set<Object> assignedDataIds = Collections.emptySet();
        try {
            BaseDataAssignService service = new BaseDataAssignService(this.entityKey);
            assignedDataIds = isMultiUseOrg ? service.getAllAssignDataIds(needJudgeAssignedMap.keySet()) : (isIncludeFreeAssignData ? service.getAllAssignDataIds(needJudgeAssignedMap.keySet(), useOrgId) : service.getDirectSubAssignData(needJudgeAssignedMap.keySet(), useOrgId));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u5206\u914d\u60c5\u51b5\u5f02\u5e38\u3002", (Throwable)e);
        }
        for (Long dataId : assignedDataIds) {
            ExtendedDataEntity dataEntity = needJudgeAssignedMap.remove(dataId);
            if (Objects.isNull(dataEntity)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u5206\u914d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BaseDataDeleteValidator_2", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }
}

