/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.ext.IndividualizeBusinessService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.form.FormMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang.StringUtils;

public class BaseDataIndividualizeValidator {
    static final String SYSTEM_TYPE = "bos-bd-business";
    protected final String entityId;
    protected final String masterIdPropName;
    protected String numberField = "number";
    private static final String PERM_ID_INDIVIDUALIZE = "0DYOW+U/0B9B";
    private static final String FILED_VIEW_ID = "view.id";
    private static final String FILED_ORG_ID = "org.id";

    public BaseDataIndividualizeValidator(String entityId, String masterIdPropName) {
        this.entityId = entityId;
        this.masterIdPropName = masterIdPropName;
        if (StringUtils.isNotEmpty((String)entityId) && BaseDataCommonService.isOtherMasterIdType(entityId)) {
            this.numberField = "masterid.number";
        }
    }

    public BaseDataResponse validateIndividualize(Long useOrgId, String appId, Set<Long> dataIds) {
        BaseDataResponse response = this.individualizePreValidate(useOrgId, appId, dataIds);
        if (!response.isSuccess()) {
            return response;
        }
        String selectProperties = BaseDataCommonService.isTreeType(this.entityId) ? "id,createOrg.id,ctrlStrategy,isLeaf,longNumber," + this.masterIdPropName + "," + this.numberField : "id,createOrg.id,ctrlStrategy," + this.masterIdPropName + "," + this.numberField;
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)this.entityId, (String)selectProperties, (QFilter[])filters);
        this.strategyAndCreateOrgValidate(doc, useOrgId, response, dataIds);
        if (!response.isSuccess()) {
            return response;
        }
        this.isBaseDataIndividualized(useOrgId, doc, response, dataIds);
        if (!response.isSuccess()) {
            return response;
        }
        this.isHasRightToUseBaseData(useOrgId, dataIds, doc, response);
        if (!response.isSuccess()) {
            return response;
        }
        response = this.isExistsDuplicatedNumber(useOrgId, dataIds, doc);
        if (!response.isSuccess()) {
            return response;
        }
        this.treeTypeValidate(doc, dataIds, response, useOrgId);
        return response;
    }

    protected void strategyAndCreateOrgValidate(DynamicObject[] doc, Long useOrgId, BaseDataResponse response, Set<Long> dataIds) {
        if (null == doc || doc.length == 0 || doc.length != dataIds.size()) {
            response.setSuccess(false);
            response.setErrorMsg(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BaseDataIndividualizeValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        StringBuilder errorMsg = new StringBuilder();
        String firstCtrlStrategy = doc[0].getString("ctrlstrategy");
        for (DynamicObject obj : doc) {
            if (!firstCtrlStrategy.equals(obj.getString("ctrlstrategy"))) {
                response.setSuccess(false);
                response.setErrorMsg(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7684\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u624d\u80fd\u4e2a\u6027\u5316\u3002", (String)"BaseDataIndividualizeValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            String number = obj.getString(this.numberField);
            Long createOrgId = obj.getLong("createOrg.id");
            if (useOrgId.equals(createOrgId)) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u81ea\u5df1\u521b\u5efa\u7684\u6570\u636e\u3002\n", (String)"BaseDataIndividualizeValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
                continue;
            }
            String ctrlStrategy = obj.getString("ctrlstrategy");
            if ("1".equals(ctrlStrategy) || "2".equals(ctrlStrategy)) continue;
            errorMsg.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u63a7\u5236\u7b56\u7565\u662f\u9010\u7ea7\u5206\u914d\u3001\u81ea\u7531\u5206\u914d\u624d\u80fd\u4e2a\u6027\u5316\u3002\n", (String)"BaseDataIndividualizeValidator_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
        }
        if (StringUtils.isNotEmpty((String)errorMsg.toString())) {
            response.setErrorMsg(errorMsg.toString());
            response.setSuccess(false);
        }
    }

    private BaseDataResponse individualizePreValidate(Long useOrgId, String appId, Set<Long> dataIds) {
        BaseDataResponse response = this.paramIsNotNull(useOrgId, appId = null != appId ? appId : this.getAppId(this.entityId), dataIds);
        if (!response.isSuccess()) {
            return response;
        }
        if (Boolean.FALSE.equals(BaseDataServiceHelper.checkBaseDataCtrl((String)this.entityId))) {
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u53ea\u6709\u53d7\u63a7\u57fa\u7840\u8d44\u6599\u624d\u652f\u6301\u4e2a\u6027\u5316\u3002", (String)"BaseDataIndividualizeValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        if (Boolean.TRUE.equals(BaseDataServiceHelper.isNoneCustomEntity((String)this.entityId))) {
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u8be5\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e2a\u6027\u5316\u3002", (String)"BaseDataIndividualizeValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        if (!this.hasOpPerm(useOrgId, appId)) {
            String caption = FormMetadataCache.getFormConfig((String)this.entityId).getCaption().getLocaleValue();
            return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u4e2a\u6027\u5316\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BaseDataIndividualizeValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), caption));
        }
        if (!this.isOrgInCtrlView(useOrgId)) {
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u8be5\u4f7f\u7528\u7ec4\u7ec7\u4e0d\u662f\u89c6\u56fe\u4e0a\u7684\u7ba1\u63a7\u5355\u5143\u3002", (String)"BaseDataIndividualizeValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return response;
    }

    protected boolean hasOpPerm(Long useOrgId, String appId) {
        Long userId = RequestContext.get().getCurrUserId();
        int permRes = PermissionServiceHelper.checkPermission((Long)userId, (Long)useOrgId, (String)appId, (String)this.entityId, (String)PERM_ID_INDIVIDUALIZE);
        return 1 == permRes;
    }

    private String getAppId(String entityId) {
        if (null != entityId) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            return null != mainEntityType ? mainEntityType.getAppId() : null;
        }
        return null;
    }

    private BaseDataResponse isExistsDuplicatedNumber(Long useOrgId, Set<Long> dataIds, DynamicObject[] dataCol) {
        IndividualizeBusinessService service = BaseDataBusinessServiceUtils.getIndividualizeBusinessService(this.entityId);
        List<Long> errorDataIds = service.numberSameValidate(this.entityId, useOrgId, new ArrayList<Long>(dataIds));
        BaseDataResponse response = new BaseDataResponse(CollectionUtils.isEmpty(errorDataIds), null);
        if (!CollectionUtils.isEmpty(errorDataIds)) {
            String numberField = BaseDataCommonService.isOtherMasterIdType(this.entityId) ? "masterid.number" : "number";
            Map<Long, String> id2NumberMap = Arrays.stream(dataCol).collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString(numberField)));
            HashMap resultMap = new HashMap(errorDataIds.size());
            StringBuilder sbd = new StringBuilder();
            for (Long errorDataId : errorDataIds) {
                HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(10);
                String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"BaseDataIndividualizeValidator_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), id2NumberMap.get(errorDataId));
                sbd.append(errorMsg).append("\r\n");
                errorMsgMap.put(useOrgId, errorMsg);
                resultMap.put(errorDataId, errorMsgMap);
            }
            response.setSuccess(false);
            response.setResult(resultMap);
            response.setErrorMsg(sbd.toString());
        }
        return response;
    }

    private BaseDataResponse paramIsNotNull(Long useOrgId, String appId, Set<Long> dataIds) {
        BaseDataResponse response = new BaseDataResponse(false, "");
        if (null == this.entityId) {
            response.setErrorMsg("entityId is empty");
        } else if (null == useOrgId) {
            response.setErrorMsg("useOrgId is empty");
        } else if (null == appId) {
            response.setErrorMsg("appId is empty");
        } else if (CollectionUtils.isEmpty(dataIds)) {
            response.setErrorMsg("dataIds is empty");
        } else {
            response.setSuccess(true);
        }
        return response;
    }

    private void treeTypeValidate(DynamicObject[] doc, Set<Long> dataIds, BaseDataResponse response, Long useOrgId) {
        if (!BaseDataCommonService.isTreeType(this.entityId)) {
            return;
        }
        StringBuilder errorMsg = this.treeTypeValidate(doc, dataIds, useOrgId);
        if (StringUtils.isNotEmpty((String)errorMsg.toString())) {
            response.setSuccess(false);
            response.setErrorMsg(errorMsg.toString());
        }
    }

    protected StringBuilder treeTypeValidate(DynamicObject[] doc, Set<Long> dataIds, Long useOrgId) {
        StringBuilder errorMsg = new StringBuilder();
        if (TreeBaseDataCommonService.isAssignUnDetail(this.entityId)) {
            TreeBaseDataCommonService service = new TreeBaseDataCommonService(this.entityId);
            Collection<DynamicObject> unLastVisibleNodes = service.getUnLastVisibleNodeByIds(useOrgId, dataIds, this.numberField);
            if (!unLastVisibleNodes.isEmpty()) {
                ArrayList messages = new ArrayList(unLastVisibleNodes.size());
                String msg = ResManager.loadKDString((String)"%1$s\uff1a\u4e0d\u662f\u7ec4\u7ec7\u53ef\u89c1\u8303\u56f4\u7684\u672b\u7ea7\u8d44\u6599\uff0c\u4e0d\u80fd\u4e2a\u6027\u5316\u3002", (String)"BaseDataIndividualizeValidator_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                unLastVisibleNodes.forEach(e -> messages.add(String.format(msg, e.getString(this.numberField))));
                errorMsg.append(String.join((CharSequence)"\r\n", messages));
            }
            return errorMsg;
        }
        for (DynamicObject obj : doc) {
            Boolean isLeaf = obj.getBoolean("isleaf");
            String number = obj.getString(this.numberField);
            if (!Boolean.FALSE.equals(isLeaf)) continue;
            errorMsg.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5b58\u5728\u4e0b\u7ea7\u8d44\u6599\uff0c\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"BaseDataIndividualizeValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
        }
        return errorMsg;
    }

    private void isHasRightToUseBaseData(Long useOrgId, Set<Long> dataIds, DynamicObject[] docArr, BaseDataResponse response) {
        HashMap<Long, String> idToNumberMap = new HashMap<Long, String>(dataIds.size());
        for (DynamicObject obj : docArr) {
            Long dataId = Long.valueOf(obj.getPkValue().toString());
            String number = obj.getString(this.numberField);
            idToNumberMap.put(dataId, number);
        }
        String selectProperties = "id,number,createOrg.id";
        QFilter qFilter = new QFilter("id", "in", dataIds);
        DynamicObjectCollection doc = BaseDataServiceHelper.queryBaseData((String)this.entityId, (Long)useOrgId, (QFilter)qFilter, (String)selectProperties);
        HashSet<Long> useDataIds = new HashSet<Long>(dataIds.size());
        doc.forEach(v -> useDataIds.add(v.getLong("id")));
        StringBuilder errorMsg = this.isHasRightToUseBaseData(dataIds, idToNumberMap, useDataIds);
        if (StringUtils.isNotEmpty((String)errorMsg.toString())) {
            response.setErrorMsg(errorMsg.toString());
            response.setSuccess(false);
        }
    }

    protected StringBuilder isHasRightToUseBaseData(Set<Long> dataIds, Map<Long, String> idToNumberMap, Set<Long> useDataIds) {
        StringBuilder errorMsg = new StringBuilder();
        for (Long dataId : dataIds) {
            if (useDataIds.contains(dataId)) continue;
            String number = idToNumberMap.get(dataId);
            errorMsg.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5f53\u524d\u7ec4\u7ec7\u65e0\u6743\u4f7f\u7528\u8be5\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u5148\u5206\u914d\u3002\n", (String)"BaseDataIndividualizeValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
        }
        return errorMsg;
    }

    private void isBaseDataIndividualized(Long useOrgId, DynamicObject[] doc, BaseDataResponse response, Set<Long> dataIds) {
        HashMap<Long, Long> mstId2IdMap = new HashMap<Long, Long>(dataIds.size());
        Arrays.stream(doc).forEach(obj -> mstId2IdMap.put(obj.getLong(this.masterIdPropName), obj.getLong("id")));
        String selectProperties = "id,createOrg.id," + this.masterIdPropName + "," + this.numberField;
        QFilter[] filters = new QFilter[]{new QFilter(this.masterIdPropName, "in", mstId2IdMap.keySet()), new QFilter("createOrg.id", "=", (Object)useOrgId)};
        DynamicObject[] masterObjects = BusinessDataServiceHelper.load((String)this.entityId, (String)selectProperties, (QFilter[])filters);
        StringBuilder errorMsg = this.alreadyIndividualized(useOrgId, dataIds, mstId2IdMap, masterObjects);
        if (StringUtils.isNotEmpty((String)errorMsg.toString())) {
            response.setSuccess(false);
            response.setErrorMsg(errorMsg.toString());
        }
    }

    protected StringBuilder alreadyIndividualized(Long useOrgId, Set<Long> dataIds, Map<Long, Long> mstId2IdMap, DynamicObject[] masterObjects) {
        StringBuilder errorMsg = new StringBuilder();
        for (DynamicObject masterObj : masterObjects) {
            long masterId = masterObj.getLong(this.masterIdPropName);
            if (masterObj.getPkValue().equals(masterId) || !useOrgId.equals(masterObj.getLong("createOrg.id"))) continue;
            String number = masterObj.getString(this.numberField);
            String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5df2\u4e2a\u6027\u5316\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u518d\u4e2a\u6027\u5316\u3002\n", (String)"BaseDataIndividualizeValidator_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), number);
            errorMsg.append(msg);
        }
        return errorMsg;
    }

    private boolean isOrgInCtrlView(Long useOrgId) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entityId);
        if (null == ctrlView) {
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter(FILED_VIEW_ID, "=", ctrlView.getPkValue()), new QFilter(FILED_ORG_ID, "=", (Object)useOrgId), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE)};
        return null != BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"id", (QFilter[])filters);
    }
}

