/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BaseDataUnAuditValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(BaseDataUnAuditValidator.class);
    private static final String BOS_ORG = "bos_org";

    public void validate() {
        String useOrg = this.getOption().getVariableValue("createorg", "0");
        DynamicObject view = null;
        if (null != useOrg) {
            view = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_ORG, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(useOrg))});
        }
        for (ExtendedDataEntity dynamicObject : this.dataEntities) {
            DynamicObject baseData = dynamicObject.getDataEntity();
            if (baseData == null) continue;
            String entity = baseData.getDataEntityType().getName();
            DynamicObject createOrg = baseData.getDynamicObject("createorg");
            if (entity == null || createOrg == null) continue;
            String creatOrgId = createOrg.getPkValue().toString();
            if (null == useOrg || "0".equals(useOrg) || creatOrgId.equals(useOrg)) continue;
            String msgName = "";
            if (view != null) {
                msgName = view.getString("name");
            }
            this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BaseDataUnAuditValidator_1", (String)"bos-bd-business", (Object[])new Object[]{msgName}));
        }
    }

    private void validateAssign(Map<Long, ExtendedDataEntity> needJudgeAssignedMap, boolean isIncludeFreeAssignData, String entityNumber, String useOrg) {
        Set<Long> assignedDataIds;
        if (needJudgeAssignedMap.isEmpty() || StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        BaseDataAssignService service = new BaseDataAssignService(entityNumber);
        HashSet<Long> dataIds = new HashSet<Long>(needJudgeAssignedMap.keySet());
        if (isIncludeFreeAssignData) {
            try {
                assignedDataIds = service.getAllAssignTypeData(dataIds, Long.valueOf(useOrg));
            }
            catch (Exception e) {
                assignedDataIds = new HashSet<Long>(dataIds);
                LOGGER.error("\u53cd\u5ba1\u6838\u65f6\uff0c\u88ab\u53cd\u5ba1\u6838\u6570\u636e\u662f\u5426\u5b58\u5728\u5df2\u7ecf\u5206\u914d\u60c5\u51b5\u5f02\u5e38...", (Throwable)e);
            }
        } else {
            try {
                assignedDataIds = service.getAssignToDirectSubChildData(dataIds, Long.valueOf(useOrg));
            }
            catch (Exception e) {
                assignedDataIds = new HashSet<Long>(dataIds);
                LOGGER.error("\u53cd\u5ba1\u6838\u65f6\uff0c\u88ab\u53cd\u5ba1\u6838\u6570\u636e\u662f\u5426\u5b58\u5728\u5df2\u7ecf\u5206\u914d\u60c5\u51b5\u5f02\u5e38...", (Throwable)e);
            }
        }
        if (CollectionUtils.isEmpty(assignedDataIds)) {
            return;
        }
        for (Long dataId : assignedDataIds) {
            ExtendedDataEntity dataEntity = needJudgeAssignedMap.remove(dataId);
            if (null == dataEntity) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5206\u914d\uff0c\u8bf7\u5148\u53d6\u6d88\u5206\u914d\u518d\u53cd\u5ba1\u6838\u3002", (String)"BaseDataUnAuditValidator_0", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }
}

