/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.ext.ChangeManageRightBusinessService;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.bd.validator.AbstractBaseDataValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.AssignQueryResponse;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class ChangeManageRightValidator
extends AbstractBaseDataValidator {
    private static final String ORG_ID = "org.id";
    private static final String ORG_PERM_CHANGE = "4730fc9f000000ac";
    private static final String BOS_ORG_STRUCTURE = "bos_org_structure";
    private static final String ORG_ENTITY = "bos_org";

    public ChangeManageRightValidator(String entity) {
        this.entity = entity;
        this.init();
    }

    public BaseDataResponse validate(Long useOrgId, String appId, Set<Long> dataIds, Long targetOrgId) {
        QFilter idFilter;
        QFilter[] filters;
        BaseDataResponse response = this.isParamsNotEmpty(useOrgId, appId = null != appId ? appId : this.getAppId(this.entity), dataIds, targetOrgId);
        if (!response.isSuccess()) {
            return response;
        }
        if (Boolean.FALSE.equals(BaseDataServiceHelper.checkBaseDataCtrl((String)this.entity))) {
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u53ea\u6709\u53d7\u63a7\u57fa\u7840\u8d44\u6599\u624d\u80fd\u7ba1\u7406\u6743\u8f6c\u8ba9\u3002", (String)"ChangeManageRightValidator_0", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        long userId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)useOrgId, (String)appId, (String)this.entity, (String)ORG_PERM_CHANGE) == 0) {
            String caption = FormMetadataCache.getFormConfig((String)this.entity).getCaption().getLocaleValue();
            return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u7ba1\u7406\u6743\u8f6c\u8ba9\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"ChangeManageRightValidator_1", (String)"bos-bd-business", (Object[])new Object[0]), caption));
        }
        if (useOrgId.equals(targetOrgId)) {
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u548c\u76ee\u6807\u7ec4\u7ec7\u4e0d\u80fd\u76f8\u540c\u3002", (String)"ChangeManageRightValidator_14", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        response = this.isOrgInView(useOrgId, targetOrgId);
        if (!response.isSuccess()) {
            return response;
        }
        String selectProperties = BaseDataCommonService.isTreeType(this.entity) ? "id," + this.numberField + ",createOrg,status,ctrlStrategy,isLeaf,longNumber," + this.masterIdPropName : "id," + this.numberField + ",createOrg,status,ctrlStrategy," + this.masterIdPropName;
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.entity, (String)selectProperties, (QFilter[])(filters = new QFilter[]{idFilter = new QFilter("id", "in", dataIds)}));
        if (null == doc || doc.isEmpty() || doc.size() != dataIds.size()) {
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ChangeManageRightValidator_2", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        if (BaseDataCommonService.isTreeType(this.entity) && !this.isAllGlobalShare(dataIds)) {
            List<DynamicObject> allNodes = this.getAllNodes(dataIds, useOrgId);
            allNodes.forEach(node -> dataIds.add(node.getLong("id")));
        }
        if (!(response = this.checkDataRule(useOrgId, appId, dataIds.toArray(), ORG_PERM_CHANGE, ResManager.loadKDString((String)"\u7ba1\u7406\u6743\u8f6c\u8ba9", (String)"ChangeManageRightValidator_3", (String)"bos-bd-business", (Object[])new Object[0]))).isSuccess()) {
            return response;
        }
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(doc.size());
        String firstCtrlStrategy = ((DynamicObject)doc.get(0)).getString("ctrlstrategy");
        response = this.basicsValidate(doc, useOrgId, this.getCreateOrgId((DynamicObject)doc.get(0)), firstCtrlStrategy, idNumberMap);
        if (!response.isSuccess()) {
            return response;
        }
        response = this.isTargetOrgCorrect(useOrgId, appId, dataIds, doc, targetOrgId);
        if (!response.isSuccess()) {
            return response;
        }
        ArrayList<Long> tempDataList = new ArrayList<Long>(dataIds);
        response = this.validateBeforeChangeManage(useOrgId, appId, tempDataList, targetOrgId);
        response.setSuccess(!CollectionUtils.isEmpty(tempDataList));
        return response;
    }

    private String getAppId(String entityId) {
        if (null != entityId) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            return null != mainEntityType ? mainEntityType.getAppId() : null;
        }
        return null;
    }

    private List<DynamicObject> removeWhichIsNotCurrentTree(List<DynamicObject> allNodes, Set<Long> dataIds) {
        ArrayList<DynamicObject> currentTreeNodes = new ArrayList<DynamicObject>(allNodes.size());
        ArrayList<ArrayList<DynamicObject>> groupTreeNodes = new ArrayList<ArrayList<DynamicObject>>(allNodes.size());
        for (DynamicObject dynamicObject : allNodes) {
            if (!Boolean.TRUE.equals(dynamicObject.get("isleaf"))) continue;
            Long leafNodeId = dynamicObject.getLong("id");
            ArrayList<DynamicObject> treeNodeByGroups = new ArrayList<DynamicObject>(10);
            treeNodeByGroups.add(dynamicObject);
            this.getWholeTreeNode(leafNodeId, allNodes, treeNodeByGroups);
            groupTreeNodes.add(treeNodeByGroups);
        }
        for (List list : groupTreeNodes) {
            boolean isContainCurrentTree = this.isContainCurrentTree(list, dataIds);
            if (!isContainCurrentTree) continue;
            currentTreeNodes.addAll(list);
        }
        return currentTreeNodes;
    }

    private void getWholeTreeNode(Long leafNodeId, List<DynamicObject> allNodes, List<DynamicObject> treeNodeByGroups) {
        for (DynamicObject node : allNodes) {
            Object parent = node.get("parent");
            Long nodeId = node.getLong("id");
            if (!nodeId.equals(leafNodeId) || null == parent) continue;
            DynamicObject parentObj = (DynamicObject)parent;
            Long parentId = parentObj.getLong("id");
            treeNodeByGroups.add(parentObj);
            this.getWholeTreeNode(parentId, allNodes, treeNodeByGroups);
        }
    }

    private boolean isContainCurrentTree(List<DynamicObject> treeNodes, Set<Long> dataIds) {
        for (DynamicObject treeNode : treeNodes) {
            if (!dataIds.contains(treeNode.getLong("id"))) continue;
            return true;
        }
        return false;
    }

    private BaseDataResponse isOrgInView(Long useOrgId, Long targetOrgId) {
        DynamicObject orgView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        Long orgIdViewId = (Long)orgView.getPkValue();
        ArrayList<Long> orgIds = new ArrayList<Long>(2);
        orgIds.add(useOrgId);
        orgIds.add(targetOrgId);
        QFilter idFilter = new QFilter(ORG_ID, "in", orgIds);
        QFilter viewFilter = new QFilter("view.id", "=", (Object)orgIdViewId);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)ORG_ID, (QFilter[])new QFilter[]{idFilter, viewFilter});
        if (CollectionUtils.isEmpty((Collection)doc) || doc.size() != orgIds.size()) {
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7/\u76ee\u6807\u7ec4\u7ec7\u4e0d\u5728\u63a7\u5236\u89c6\u56fe\u5185\u3002", (String)"ChangeManageRightValidator_4", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        return new BaseDataResponse(true, "");
    }

    private BaseDataResponse isParamsNotEmpty(Long useOrgId, String appId, Set<Long> dataIds, Long targetOrgId) {
        BaseDataResponse response = new BaseDataResponse(true, "");
        if (null == useOrgId) {
            response.setSuccess(false);
            response.setErrorMsg("useOrgId is null");
        } else if (StringUtils.isEmpty((String)appId)) {
            response.setSuccess(false);
            response.setErrorMsg("appId is null");
        } else if (CollectionUtils.isEmpty(dataIds)) {
            response.setSuccess(false);
            response.setErrorMsg("dataIds is isEmpty");
        } else if (null == targetOrgId) {
            response.setSuccess(false);
            response.setErrorMsg("targetOrgId is null");
        } else {
            response.setSuccess(true);
        }
        return response;
    }

    private BaseDataResponse basicsValidate(DynamicObjectCollection collection, long useOrgId, long firstCreateOrgId, String firStCtrlStrategy, Map<Long, String> idNumberMap) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)useOrgId)};
        DynamicObject useOrg = QueryServiceHelper.queryOne((String)ORG_ENTITY, (String)"id,name", (QFilter[])qFilters);
        String useOrgName = null == useOrg ? "" : useOrg.getString("name");
        for (DynamicObject data : collection) {
            String number = data.getString(this.numberField);
            long orgId = data.getLong("createorg");
            if (orgId != useOrgId) {
                return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u8f6c\u8ba9\u7ba1\u7406\u6743\u3002", (String)"ChangeManageRightValidator_6", (String)"bos-bd-business", (Object[])new Object[0]), number, useOrgName));
            }
            if (firstCreateOrgId != orgId) {
                return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u521b\u5efa\u7ec4\u7ec7\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u8fdb\u884c\u7ba1\u7406\u6743\u8f6c\u8ba9\u3002", (String)"ChangeManageRightValidator_5", (String)"bos-bd-business", (Object[])new Object[0]), number));
            }
            Long masterId = AbstractBaseDataService.getLongPropertyFromDynamicObject(data, this.masterIdPropName);
            Long dataId = data.getLong("id");
            if (!dataId.equals(masterId)) {
                return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%s\uff1a\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u8f6c\u8ba9\u7ba1\u7406\u6743\u3002", (String)"ChangeManageRightValidator_7", (String)"bos-bd-business", (Object[])new Object[0]), number));
            }
            String currentStrategy = data.getString("ctrlstrategy");
            if (!firStCtrlStrategy.equals(currentStrategy)) {
                return new BaseDataResponse(false, ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u8f6c\u8ba9\u7ba1\u7406\u6743\u3002", (String)"ChangeManageRightValidator_8", (String)"bos-bd-business", (Object[])new Object[0]));
            }
            if ("7".equals(currentStrategy)) {
                return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%s\uff1a\u79c1\u6709\u578b\u6570\u636e\u4e0d\u5141\u8bb8\u8f6c\u8ba9\u7ba1\u7406\u6743\u3002", (String)"ChangeManageRightValidator_13", (String)"bos-bd-business", (Object[])new Object[0]), number));
            }
            idNumberMap.put(data.getLong("id"), number);
        }
        return new BaseDataResponse(true, "");
    }

    private boolean isAllGlobalShare(Set<Long> dataIds) {
        QFilter[] filters = new QFilter[]{new QFilter("ctrlstrategy", "=", (Object)"5"), new QFilter("id", "in", dataIds)};
        DynamicObjectCollection col = QueryServiceHelper.query((String)this.entity, (String)"id,number,ctrlStrategy", (QFilter[])filters);
        return col.size() == dataIds.size();
    }

    public List<DynamicObject> getAllNodes(Set<Long> dataIds, Long useOrgId) {
        ArrayList<String> selectFields = new ArrayList<String>(10);
        if (CollectionUtils.isEmpty(selectFields)) {
            selectFields = new ArrayList(10);
        }
        selectFields.add("id");
        selectFields.add("createorg");
        selectFields.add("number");
        selectFields.add("longnumber");
        selectFields.add("level");
        selectFields.add("isleaf");
        selectFields.add("parent");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds), BaseDataServiceHelper.getBaseDataFilter((String)this.entity, (Long)useOrgId)};
        DynamicObjectCollection col = QueryServiceHelper.query((String)this.entity, (String)this.buildSelectFields(new HashSet<String>(selectFields)), (QFilter[])filters);
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(this.entity);
        List<Long> rootIds = this.getRootNodeIds(this.entity, col);
        if (CollectionUtils.isEmpty(rootIds)) {
            return new ArrayList<DynamicObject>(1);
        }
        QFilter useRangeFilter = BaseDataServiceHelper.getBaseDataFilter((String)this.entity, (Long)useOrgId);
        List<DynamicObject> allNodes = service.getChildNodesByParentIds(rootIds, useRangeFilter, selectFields, true);
        return this.removeWhichIsNotCurrentTree(allNodes, dataIds);
    }

    private String buildSelectFields(Collection<String> fields) {
        HashSet<String> fieldSet = new HashSet<String>(fields);
        fieldSet.addAll(Arrays.asList("id", "parent", "longnumber"));
        return String.join((CharSequence)String.valueOf(','), fieldSet);
    }

    private List<Long> getRootNodeIds(String entity, DynamicObjectCollection col) {
        HashSet<String> rootLongNumbers = new HashSet<String>(16);
        String longNumberDLM = BaseDataCommonService.getLongNumberDLM(entity);
        for (DynamicObject obj : col) {
            int level = obj.getInt("level");
            String longNumber = obj.getString("longnumber");
            String rootLongNumber = null;
            if (1 == level) {
                rootLongNumber = longNumber;
            } else if (longNumber.contains(longNumberDLM)) {
                rootLongNumber = longNumber.substring(0, longNumber.indexOf(longNumberDLM));
            }
            rootLongNumbers.add(rootLongNumber);
        }
        String selectProperties = "id,number,level,longNumber";
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", rootLongNumbers)};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entity, (String)selectProperties, (QFilter[])filters);
        ArrayList<Long> rootIds = new ArrayList<Long>(doc.size());
        doc.forEach(data -> rootIds.add(data.getLong("id")));
        return rootIds;
    }

    private BaseDataResponse isTargetOrgCorrect(Long useOrgId, String appId, Set<Long> dataIds, DynamicObjectCollection col, Long targetOrgId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)((DynamicObject)col.get(0)).getLong("id"))};
        DynamicObject obj = QueryServiceHelper.queryOne((String)this.entity, (String)"id,ctrlStrategy", (QFilter[])qFilters);
        String ctrlStrategy = obj.getString("ctrlstrategy");
        if ("1".equals(ctrlStrategy)) {
            AssignQueryResponse response = BaseDataServiceHelper.assignQueryByData(new ArrayList<Long>(dataIds), (String)this.entity, (Long)useOrgId, (String)appId);
            if (!response.isSuccess()) {
                return new BaseDataResponse(false, response.getErrorMsg());
            }
            Map assignData = response.getData();
            if (CollectionUtils.isEmpty((Map)assignData)) {
                return new BaseDataResponse(true, "");
            }
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
            String viewNumber = ctrlView.getString("number");
            List targetOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewNumber, (long)useOrgId);
            List<Long> directSubOrgIds = this.getDirectSubOrg(ctrlView.getLong("id"), useOrgId);
            if (!CollectionUtils.isEmpty(directSubOrgIds)) {
                targetOrgIds.addAll(directSubOrgIds);
            }
            if (!CollectionUtils.isEmpty((Collection)targetOrgIds) && !targetOrgIds.contains(targetOrgId)) {
                return new BaseDataResponse(false, ResManager.loadKDString((String)"\u9010\u7ea7\u5206\u914d\u7684\u57fa\u7840\u8d44\u6599\u5df2\u5206\u914d\uff0c\u76ee\u6807\u7ec4\u7ec7\u5fc5\u987b\u662f\u5f53\u524d\u4f7f\u7528\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u6216\u76f4\u63a5\u4e0b\u7ea7\u3002", (String)"ChangeManageRightValidator_9", (String)"bos-bd-business", (Object[])new Object[0]));
            }
        }
        return new BaseDataResponse(true, "");
    }

    private List<Long> getDirectSubOrg(Long viewId, Long orgId) {
        ArrayList<Long> directSubOrgIds = new ArrayList<Long>(10);
        ORM ormOV = ORM.create();
        QFilter[] qFilters = new QFilter[]{new QFilter("view.id", "=", (Object)viewId), new QFilter("parent.id", "=", (Object)orgId)};
        try (DataSet ds = ormOV.queryDataSet(ChangeManageRightValidator.class.getName(), BOS_ORG_STRUCTURE, ORG_ID, qFilters);){
            for (Row row : ds) {
                Long directSubOrg = row.getLong(ORG_ID);
                directSubOrgIds.add(directSubOrg);
            }
        }
        return directSubOrgIds;
    }

    public BaseDataResponse validateBeforeChangeManage(Long useOrgId, String appId, List<Long> dataIds, Long targetOrgId) {
        BaseDataResponse response = new BaseDataResponse(true, "");
        if (targetOrgId == null || CollectionUtils.isEmpty(dataIds)) {
            return response;
        }
        List<String> selectFields = Arrays.asList("id", this.numberField, "ctrlstrategy", this.masterIdPropName);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)dataIds.get(0), (String)this.entity, (String)this.buildSelectFields(selectFields));
        String ctrlStrategy = obj.getString("ctrlstrategy");
        List<DynamicObject> dataList = this.getData(this.entity, dataIds);
        if ("1".equals(ctrlStrategy) || "2".equals(ctrlStrategy)) {
            List<Long> masterIds = this.getMasterIds(this.entity, dataList);
            response = this.validateIndividualized(this.entity, useOrgId, targetOrgId, masterIds, dataIds);
            if (CollectionUtils.isEmpty(dataIds)) {
                return response;
            }
            if (!response.isSuccess()) {
                this.removeFail(dataList, response);
            }
        }
        HashMap<Long, String> dataId2Number = new HashMap<Long, String>(dataList.size());
        HashMap<String, Long> number2dataId = new HashMap<String, Long>(dataList.size());
        for (DynamicObject data : dataList) {
            String number = data.getString(this.numberField);
            dataId2Number.put(data.getLong("id"), number);
            number2dataId.put(number, data.getLong("id"));
        }
        response = this.isExistsDuplicatedNumber(this.entity, useOrgId, targetOrgId, number2dataId, dataIds, response.getResult());
        if (CollectionUtils.isEmpty(dataIds)) {
            return response;
        }
        if ("1".equals(ctrlStrategy)) {
            response = this.validateCuAssign(this.entity, useOrgId, appId, dataIds, targetOrgId, response.getResult(), dataId2Number);
            if (CollectionUtils.isEmpty(dataIds)) {
                return response;
            }
        }
        return this.businessValidate(useOrgId, targetOrgId, dataIds, response);
    }

    private void removeFail(List<DynamicObject> dataList, BaseDataResponse response) {
        Map result = response.getResult();
        if (CollectionUtils.isEmpty((Map)result)) {
            return;
        }
        Set errorDataIds = result.keySet();
        dataList.removeIf(object -> errorDataIds.contains(object.getLong("id")));
    }

    private List<DynamicObject> getData(String entityId, List<Long> dataIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("id", "in", dataIds));
        List<String> selectFields = Arrays.asList("id", this.numberField, "ctrlstrategy", this.masterIdPropName);
        DynamicObject[] dataCol = BusinessDataServiceHelper.load((String)entityId, (String)this.buildSelectFields(selectFields), (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(dataCol.length);
        Collections.addAll(dataList, dataCol);
        return dataList;
    }

    private List<Long> getMasterIds(String entityId, List<DynamicObject> dataList) {
        HashSet<Long> masterIds = new HashSet<Long>(10);
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        for (DynamicObject data : dataList) {
            masterIds.add(data.getLong(masterIdPropName));
        }
        return new ArrayList<Long>(masterIds);
    }

    private BaseDataResponse isExistsDuplicatedNumber(String entityId, Long useOrgId, Long targetOrgId, Map<String, Long> number2dataId, List<Long> dataIds, Map<Long, Map<Long, String>> result) {
        BaseDataResponse response = new BaseDataResponse(true, "");
        ChangeManageRightBusinessService finalBusinessService = BaseDataBusinessServiceUtils.getChangeManageRightService(entityId);
        List<Long> unPassDataIds = finalBusinessService.numberSameValidate(entityId, targetOrgId, dataIds);
        if (CollectionUtils.isEmpty(unPassDataIds)) {
            return new BaseDataResponse(true, "");
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entityId, (String)("id," + this.numberField), (QFilter[])new QFilter[]{new QFilter("id", "in", unPassDataIds)});
        if (!doc.isEmpty()) {
            if (null == result) {
                result = new HashMap<Long, Map<Long, String>>(doc.size());
            }
            HashSet<Long> treeErrorDataIds = new HashSet<Long>(doc.size());
            for (DynamicObject data : doc) {
                HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(1);
                String errorMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5728\u76ee\u6807\u7ec4\u7ec7\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8f6c\u8ba9\u3002", (String)"ChangeManageRightValidator_10", (String)"bos-bd-business", (Object[])new Object[0]), data.getString(this.numberField));
                errorMsgMap.put(targetOrgId, errorMsg);
                Long dataId = number2dataId.get(data.getString(this.numberField));
                dataIds.remove(dataId);
                treeErrorDataIds.add(dataId);
                result.put(dataId, errorMsgMap);
            }
            if (BaseDataCommonService.isTreeType(this.entity) && !CollectionUtils.isEmpty(treeErrorDataIds) && !this.isAllGlobalShare(treeErrorDataIds)) {
                List<DynamicObject> allNodes = this.getAllNodes(treeErrorDataIds, useOrgId);
                allNodes.forEach(node -> dataIds.remove(node.getLong("id")));
            }
            response.setSuccess(false);
            response.setResult(result);
            return response;
        }
        return response;
    }

    private BaseDataResponse validateIndividualized(String entityId, Long useOrgId, Long targetOrgId, List<Long> masterIds, List<Long> dataIds) {
        BaseDataResponse response = new BaseDataResponse(true, "");
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter(masterIdPropName, "in", masterIds));
        qFilters.add(new QFilter("createorg", "=", (Object)targetOrgId));
        qFilters.add(new QFilter("id", "!=", (Object)masterIdPropName, true));
        List<String> selectFields = Arrays.asList("id", this.numberField, "ctrlstrategy", masterIdPropName);
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)entityId, (String)this.buildSelectFields(selectFields), (QFilter[])qFilters.toArray(new QFilter[0]));
        if (doc.length > 0) {
            HashMap result = new HashMap(doc.length);
            HashSet<Long> treeErrorDataIds = new HashSet<Long>(doc.length);
            for (DynamicObject data : doc) {
                Long masterId = data.getLong(masterIdPropName);
                HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(1);
                String errorMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5728\u76ee\u6807\u7ec4\u7ec7\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8f6c\u8ba9\u3002", (String)"ChangeManageRightValidator_11", (String)"bos-bd-business", (Object[])new Object[0]), data.getString(this.numberField));
                errorMsgMap.put(targetOrgId, errorMsg);
                result.put(masterId, errorMsgMap);
                dataIds.remove(masterId);
                treeErrorDataIds.add(masterId);
            }
            if (BaseDataCommonService.isTreeType(this.entity) && !CollectionUtils.isEmpty(treeErrorDataIds) && !this.isAllGlobalShare(treeErrorDataIds)) {
                List<DynamicObject> allNodes = this.getAllNodes(treeErrorDataIds, useOrgId);
                allNodes.forEach(node -> dataIds.remove(node.getLong("id")));
            }
            response.setSuccess(false);
            response.setResult(result);
        }
        return response;
    }

    private BaseDataResponse validateCuAssign(String entityId, Long useOrgId, String appId, List<Long> dataIds, Long targetOrgId, Map<Long, Map<Long, String>> result, Map<Long, String> dataId2Number) {
        BaseDataResponse response = new BaseDataResponse(true, "");
        AssignQueryResponse assignResponse = BaseDataServiceHelper.assignQueryByData(dataIds, (String)entityId, (Long)useOrgId, (String)appId);
        if (!assignResponse.isSuccess()) {
            throw new KDBizException(assignResponse.getErrorMsg());
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        String viewNumber = ctrlView.getString("number");
        Map assignData = assignResponse.getData();
        List subordinateOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)viewNumber, Collections.singletonList(targetOrgId), (boolean)true, (boolean)true);
        HashSet<Long> assignOrgIds = new HashSet<Long>(16);
        if (!CollectionUtils.isEmpty((Map)assignData)) {
            for (List orgIds : assignData.values()) {
                assignOrgIds.addAll(orgIds);
            }
            Map<Long, String> orgIdToName = this.getOrgIdToName(assignOrgIds);
            Set entrySet = assignData.entrySet();
            if (null == result) {
                result = new HashMap<Long, Map<Long, String>>(entrySet.size());
            }
            HashSet<Long> treeErrorDataIds = new HashSet<Long>(16);
            for (Map.Entry entry : entrySet) {
                Long dataId = (Long)entry.getKey();
                List useOrgIds = (List)entry.getValue();
                useOrgIds.removeAll(subordinateOrgIds);
                if (CollectionUtils.isEmpty((Collection)useOrgIds)) continue;
                HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(useOrgIds.size());
                Long tempUseOrgId = (Long)useOrgIds.get(0);
                String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5728\u7ec4\u7ec7\u201c%2$s\u201d\u5b58\u5728\u5206\u914d\u8bb0\u5f55\uff0c\u8f6c\u8ba9\u540e\u5c06\u5f71\u54cd\u4e1a\u52a1\u4f7f\u7528\u3002", (String)"ChangeManageRightValidator_12", (String)"bos-bd-business", (Object[])new Object[0]), dataId2Number.get(dataId), orgIdToName.get(tempUseOrgId));
                errorMsgMap.put(tempUseOrgId, errorMsg);
                dataIds.remove(dataId);
                treeErrorDataIds.add(dataId);
                result.put(dataId, errorMsgMap);
            }
            if (BaseDataCommonService.isTreeType(this.entity) && !CollectionUtils.isEmpty(treeErrorDataIds) && !this.isAllGlobalShare(treeErrorDataIds)) {
                List<DynamicObject> allNodes = this.getAllNodes(treeErrorDataIds, useOrgId);
                allNodes.forEach(node -> dataIds.remove(node.getLong("id")));
            }
            if (!CollectionUtils.isEmpty(result)) {
                response.setSuccess(false);
                response.setResult(result);
                return response;
            }
        }
        return response;
    }

    private Map<Long, String> getOrgIdToName(Set<Long> assignOrgIds) {
        HashMap<Long, String> orgIdToName = new HashMap<Long, String>(assignOrgIds.size());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("id", "in", assignOrgIds));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)ORG_ENTITY, (String)"id,number,name", (QFilter[])qFilters.toArray(new QFilter[0]));
        doc.forEach(obj -> orgIdToName.put(obj.getLong("id"), obj.getString("name")));
        return orgIdToName;
    }

    private BaseDataResponse businessValidate(Long useOrgId, Long targetOrgId, List<Long> dataIds, BaseDataResponse response) {
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)this.entity);
        ArrayList<Long> checkIds = new ArrayList<Long>(8);
        checkIds.addAll(dataIds);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("id", "=", (Object)targetOrgId));
        DynamicObject targetOrg = BusinessDataServiceHelper.loadSingle((String)ORG_ENTITY, (String)"id,number,name", (QFilter[])qFilters.toArray(new QFilter[0]));
        Map bizCheckResultMap = null != baseDataCtrlPlugin ? baseDataCtrlPlugin.orgPermChangeCheck(checkIds, targetOrg) : Collections.emptyMap();
        ChangeManageRightBusinessService businessService = BaseDataBusinessServiceUtils.getChangeManageRightService(this.entity);
        Map<Long, String> businessCheckResultMap = businessService.validateBeforeChange(this.entity, targetOrgId, dataIds);
        if (!CollectionUtils.isEmpty((Map)bizCheckResultMap)) {
            this.removeDataInvalid(useOrgId, targetOrgId, dataIds, bizCheckResultMap, response);
        } else if (!CollectionUtils.isEmpty(businessCheckResultMap)) {
            this.removeDataInvalid(useOrgId, targetOrgId, dataIds, businessCheckResultMap, response);
        } else {
            response.setSuccess(true);
            return response;
        }
        return response;
    }

    private void removeDataInvalid(Long useOrgId, Long targetOrgId, List<Long> dataIds, Map<Long, String> bizCheckResultMap, BaseDataResponse response) {
        Map result = null != response.getResult() ? response.getResult() : new HashMap(bizCheckResultMap.size());
        Set<Map.Entry<Long, String>> entrySet = bizCheckResultMap.entrySet();
        for (Map.Entry<Long, String> entry : entrySet) {
            Long dataId = entry.getKey();
            String errorMsg = entry.getValue();
            HashMap<Long, String> errorMap = new HashMap<Long, String>(1);
            errorMap.put(targetOrgId, errorMsg);
            result.put(dataId, errorMap);
        }
        dataIds.removeAll(bizCheckResultMap.keySet());
        if (BaseDataCommonService.isTreeType(this.entity) && !CollectionUtils.isEmpty(bizCheckResultMap.keySet()) && !this.isAllGlobalShare(bizCheckResultMap.keySet())) {
            List<DynamicObject> allNodes = this.getAllNodes(bizCheckResultMap.keySet(), useOrgId);
            allNodes.forEach(node -> dataIds.remove(node.getLong("id")));
        }
        response.setSuccess(false);
        response.setResult(result);
    }
}

