/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.validator.BaseDataAssignValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class FreeStrategyAssignValidator
extends BaseDataAssignValidator {
    private Map<Long, String> unableAssign = new HashMap<Long, String>(16);

    public FreeStrategyAssignValidator(String entityId, Long assignOrgId, String appId, Set<Long> dataIds, Set<Long> orgIds) {
        super(entityId, assignOrgId, appId, dataIds, orgIds);
    }

    @Override
    String businessTreeTypeValidate(BaseDataResponse response) {
        if (BaseDataCommonService.isTreeType(this.entityId)) {
            response.setSuccess(false);
            response.setErrorMsg(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u53ea\u80fd\u5904\u7406\u975e\u6811\u5f62\u57fa\u7840\u8d44\u6599\u7684\u5206\u914d\u3002", (String)"FreeStrategyAssignValidator_0", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        return super.businessTreeTypeValidate(response);
    }

    @Override
    DynamicObjectCollection dataExistValidate(String selectProperties, BaseDataResponse response) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)this.dataIds), BaseDataServiceHelper.getBaseDataFilter((String)this.entityId, (Long)this.assignOrgId)};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.entityId, (String)selectProperties, (QFilter[])filters);
        if (doc.size() == this.dataIds.size()) {
            return doc;
        }
        HashSet copy = new HashSet(this.dataIds);
        doc.forEach(v -> copy.remove(v.getLong("id")));
        String msg = ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u6ca1\u6709\u6570\u636e\u7684\u4f7f\u7528\u6743\u9650\u3002", (String)"FreeStrategyAssignValidator_1", (String)"bos-bd-business", (Object[])new Object[0]);
        copy.forEach(v -> this.unableAssign.put((Long)v, msg));
        this.dataIds.removeAll(copy);
        return doc;
    }

    @Override
    void batchForeachValidate(DynamicObjectCollection doc, BaseDataResponse response) {
        if (this.orgIds.size() == 1 && this.assignOrgId.equals(this.orgIds.iterator().next())) {
            for (DynamicObject obj : doc) {
                Long dataId = obj.getLong("id");
                this.dataIds.remove(dataId);
                this.unableAssign.put(dataId, ResManager.loadKDString((String)"\u4e0d\u80fd\u5c06\u81ea\u5df1\u521b\u5efa\u7684\u6570\u636e\u5206\u914d\u7ed9\u81ea\u5df1\u3002", (String)"FreeStrategyAssignValidator_2", (String)"bos-bd-business", (Object[])new Object[0]));
            }
            return;
        }
        for (DynamicObject obj : doc) {
            Long dataId = obj.getLong("id");
            long masterId = obj.getLong(this.masterIdProName);
            if (masterId == 0L) {
                this.dataIds.remove(dataId);
                this.unableAssign.put(dataId, ResManager.loadKDString((String)"\u5b58\u5728masterId\u4e3a0\u7684\u5f02\u5e38\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u590d\u6570\u636e\u3002", (String)"FreeStrategyAssignValidator_3", (String)"bos-bd-business", (Object[])new Object[0]));
                continue;
            }
            if (!"2".equals(obj.getString("ctrlstrategy"))) {
                this.dataIds.remove(dataId);
                this.unableAssign.put(dataId, ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u53ea\u80fd\u5206\u914d\u201c\u63a7\u5236\u7b56\u7565\u201d\u4e3a\u201c\u81ea\u7531\u5206\u914d\u201d\u7c7b\u578b\u7684\u6570\u636e\u3002", (String)"FreeStrategyAssignValidator_4", (String)"bos-bd-business", (Object[])new Object[0]));
                continue;
            }
            if (!dataId.equals(masterId)) {
                this.dataIds.remove(dataId);
                this.unableAssign.put(dataId, ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u7684\u201c\u81ea\u7531\u5206\u914d\u201d\u7c7b\u578b\u6570\u636e\u4e0d\u80fd\u5206\u914d\u3002", (String)"FreeStrategyAssignValidator_5", (String)"bos-bd-business", (Object[])new Object[0]));
                continue;
            }
            if (!this.assignOrgId.equals(obj.getLong("createOrg.id"))) {
                this.dataIds.remove(dataId);
                this.unableAssign.put(dataId, ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u5206\u914d\u7684\u7ec4\u7ec7\u4e0d\u662f\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5206\u914d\u3002", (String)"FreeStrategyAssignValidator_7", (String)"bos-bd-business", (Object[])new Object[0]));
                continue;
            }
            if (this.isIgnoreStatus || "C".equals(obj.getString(this.billStatusKey))) continue;
            this.dataIds.remove(dataId);
            this.unableAssign.put(dataId, ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u7684\u6570\u636e\u4e0d\u80fd\u5206\u914d\u3002", (String)"FreeStrategyAssignValidator_6", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }

    public Map<Long, String> getUnEnableAssignFail() {
        return this.unableAssign;
    }
}

