/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.validator.AbstractBaseDataPreValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.util.CollectionUtils;

public class TreeBaseDataAssignPreValidator
extends AbstractBaseDataPreValidator {
    private static final String KEY_IS_LEAF = "isLeaf";
    private static final String KEY_LONG_NUMBER = "longNumber";
    private final Long currentOrgId;
    private final String entityId;

    public TreeBaseDataAssignPreValidator(String entityId, Long currentOrgId) {
        this.currentOrgId = currentOrgId;
        this.entityId = entityId;
        super.init(null, entityId, "assign");
    }

    public BaseDataResponse treeValidate(List<Long> dataIds) {
        DynamicObjectCollection collection = this.getDataCollectionByDataIds(dataIds, Collections.emptyList());
        HashMap<Long, String> selectNodeMap = new HashMap<Long, String>(dataIds.size());
        ArrayList<String> longNumberList = new ArrayList<String>(10);
        String dlm = BaseDataCommonService.getLongNumberDLM(this.entityId);
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(this.entityId);
        if (TreeBaseDataCommonService.isAssignUnDetail(this.entityId)) {
            collection.forEach(e -> this.collectLongNumber(e.getString(KEY_LONG_NUMBER), longNumberList, dlm));
            List<TreeNode> nodes = service.getIntegrityRootNodes(new HashSet<Long>(dataIds), longNumberList, this.currentOrgId);
            return this.checkCtrlStrategy(nodes);
        }
        HashSet<Long> leafNodeIds = new HashSet<Long>(collection.size());
        for (DynamicObject data : collection) {
            Long id = data.getLong("id");
            selectNodeMap.put(id, data.getString("number"));
            if (!data.getBoolean(KEY_IS_LEAF)) continue;
            leafNodeIds.add(id);
            this.collectLongNumber(data.getString(KEY_LONG_NUMBER), longNumberList, dlm);
        }
        List<TreeNode> nodes = service.getIntegrityNodes(longNumberList, leafNodeIds, this.currentOrgId);
        if (CollectionUtils.isEmpty(nodes)) {
            return this.excludeDetailResp(selectNodeMap);
        }
        BaseDataResponse response = new BaseDataResponse(true, "");
        for (TreeNode node : nodes) {
            selectNodeMap.remove(Long.valueOf(node.getId()));
            if (!this.inconsistentStrategy(node.getChildren(), node.getType(), selectNodeMap, response)) continue;
            response.setSuccess(false);
            return response;
        }
        if (!CollectionUtils.isEmpty(selectNodeMap)) {
            return this.excludeDetailResp(selectNodeMap);
        }
        return response;
    }

    private boolean inconsistentStrategy(List<TreeNode> nodes, String strategy, Map<Long, String> selectNodeMap, BaseDataResponse response) {
        if (CollectionUtils.isEmpty(nodes)) {
            return false;
        }
        for (TreeNode node : nodes) {
            boolean inconsistent;
            selectNodeMap.remove(Long.valueOf(node.getId()));
            String childStrategy = node.getType();
            boolean bl = inconsistent = StringUtils.isEmpty((CharSequence)childStrategy) || !childStrategy.equals(strategy);
            if (inconsistent) {
                response.setErrorMsg(ResManager.loadKDString((String)"\u4e0a\u4e0b\u7ea7\u8d44\u6599\u63a7\u5236\u7b56\u7565\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u3002", (String)"TreeBaseDataAssignPreValidator_1", (String)"bos-bd-business", (Object[])new Object[0]));
                return true;
            }
            if (!this.inconsistentStrategy(node.getChildren(), strategy, selectNodeMap, response)) continue;
            return true;
        }
        return false;
    }

    private BaseDataResponse excludeDetailResp(Map<Long, String> selectNodeMap) {
        if (!CollectionUtils.isEmpty(selectNodeMap)) {
            StringJoiner joiner = new StringJoiner("\r\n");
            selectNodeMap.forEach((k, v) -> joiner.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5206\u914d\u65f6\u5fc5\u987b\u5305\u542b\u660e\u7ec6\u8d44\u6599\u624d\u80fd\u5206\u914d\u3002", (String)"TreeBaseDataAssignPreValidator_0", (String)"bos-bd-business", (Object[])new Object[0]), v)));
            return new BaseDataResponse(false, joiner.toString());
        }
        return new BaseDataResponse(true, null);
    }

    private void collectLongNumber(String longNumber, List<String> longNumberList, String dlm) {
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            longNumberList.add(longNumber);
            if (longNumber.contains(dlm)) {
                this.getLongNumbers(longNumberList, longNumber, dlm);
            }
        }
    }

    private void getLongNumbers(List<String> numberList, String longNumber, String dlm) {
        int lastIndex = longNumber.lastIndexOf(dlm);
        String number = longNumber.substring(0, lastIndex);
        numberList.add(number);
        if (number.contains(dlm)) {
            this.getLongNumbers(numberList, number, dlm);
        }
    }

    private BaseDataResponse checkCtrlStrategy(List<TreeNode> nodes) {
        BaseDataResponse response = new BaseDataResponse(true, "");
        if (CollectionUtils.isEmpty(nodes)) {
            return response;
        }
        for (TreeNode node : nodes) {
            if (!this.validateChildrenStrategy(node.getChildren(), node.getType(), response)) break;
        }
        return response;
    }

    private boolean validateChildrenStrategy(List<TreeNode> children, String strategy, BaseDataResponse response) {
        if (CollectionUtils.isEmpty(children)) {
            return true;
        }
        for (TreeNode node : children) {
            String childStrategy = node.getType();
            if (StringUtils.isEmpty((CharSequence)childStrategy) || !childStrategy.equals(strategy)) {
                response.setSuccess(false);
                response.setErrorMsg(ResManager.loadKDString((String)"\u4e0a\u4e0b\u7ea7\u8d44\u6599\u63a7\u5236\u7b56\u7565\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u3002", (String)"TreeBaseDataAssignPreValidator_1", (String)"bos-bd-business", (Object[])new Object[0]));
                return false;
            }
            boolean sameStrategy = this.validateChildrenStrategy(node.getChildren(), strategy, response);
            if (sameStrategy) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Set<String> getSelectFields() {
        Set<String> selectFields = super.getSelectFields();
        selectFields.addAll(Arrays.asList(KEY_LONG_NUMBER, KEY_IS_LEAF));
        return selectFields;
    }

    @Override
    protected boolean permValidate(String appId, Long orgId) {
        return this.assignPermValidate(appId, orgId);
    }

    @Override
    protected String generateOpMsg() {
        return ResManager.loadKDString((String)"\u5206\u914d", (String)"TreeBaseDataAssignPreValidator_2", (String)"bos-bd-business", (Object[])new Object[0]);
    }

    @Override
    protected String getPermItemId() {
        return "80513208000000ac";
    }
}

