/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataCustomService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TreeBaseDataDeleteValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(TreeBaseDataDeleteValidator.class);
    private static final String SYSTEM_TYPE = "bos-bd-business";
    private static final String LONG_NUMBER = "longnumber";
    private static final String IS_MULTI_USEORG = "isMultiUseOrg";
    private Set<String> failNumberSet = new HashSet<String>(16);
    private Set<Long> customDataIds = new HashSet<Long>(16);
    private Set<Long> assignedDataIds = Collections.emptySet();
    private Set<String> existReferenceDataSet = new HashSet<String>(16);

    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        Long useOrgId = 0L;
        boolean isMultiUseOrg = this.getOption().containsVariable(IS_MULTI_USEORG);
        try {
            String orgId = this.getOption().getVariableValue("createOrg");
            if (!isMultiUseOrg) {
                if (StringUtils.isEmpty((CharSequence)orgId)) {
                    return;
                }
                useOrgId = Long.parseLong(orgId);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4f7f\u7528\u7ec4\u7ec7\u5f02\u5e38...", (Throwable)e);
            return;
        }
        boolean isIncludeFreeAssignData = false;
        HashSet<Long> needJudgeAssignedDataIds = new HashSet<Long>(16);
        String regex = "\\" + TreeBaseDataCommonService.getLongNumberDLM(this.getEntityKey());
        this.quickSortInternally(regex);
        BaseDataCheckRefrence check = new BaseDataCheckRefrence();
        this.addIgnoreRefEntityIds(check);
        IDataEntityType type = this.dataEntities[0].getDataEntity().getDataEntityType();
        BasedataEntityType entityType = (BasedataEntityType)type;
        String primaryKey = entityType.getPrimaryKey().getName();
        ArrayList<Object> dataIds = new ArrayList<Object>(this.dataEntities.length);
        HashMap<Object, String> pkNumberMap = new HashMap<Object, String>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean isCuAssign;
            DynamicObject baseData = dataEntity.getDataEntity();
            Object pk = baseData.get(primaryKey);
            dataIds.add(pk);
            pkNumberMap.put(pk, baseData.getString(LONG_NUMBER));
            String ctrlStrategy = baseData.getString("ctrlstrategy");
            boolean isFreeAssign = "4".equals(ctrlStrategy) || "2".equals(ctrlStrategy);
            boolean bl = isCuAssign = "1".equals(ctrlStrategy) || "3".equals(ctrlStrategy);
            if (isFreeAssign || isCuAssign) {
                needJudgeAssignedDataIds.add((Long)dataEntity.getBillPkId());
            }
            if (!isFreeAssign) continue;
            isIncludeFreeAssignData = true;
        }
        this.validateAssign(needJudgeAssignedDataIds, isIncludeFreeAssignData, useOrgId, isMultiUseOrg);
        Map referenceResultMap = check.checkRef(entityType, dataIds.toArray());
        for (Object pk : referenceResultMap.keySet()) {
            String longNum = (String)pkNumberMap.get(pk);
            this.existReferenceDataSet.add(longNum);
            this.failNumberSet.add(longNum);
        }
        this.deleteValidate(entityType, useOrgId, isMultiUseOrg);
    }

    private void deleteValidate(BasedataEntityType entityType, Long useOrgId, Boolean isMultiUseOrg) {
        String dlm = BaseDataCommonService.getLongNumberDLM(entityType.getName());
        boolean enableVersion = BaseDataBusinessServiceUtils.isEnableVersion(this.entityKey);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dynamicObject = this.dataEntities[i].getDataEntity();
            String currLongNumber = dynamicObject.getString(LONG_NUMBER);
            String parentLongNumber = dynamicObject.getString("parent.longnumber");
            DynamicObject createOrg = dynamicObject.getDynamicObject("createorg");
            if (!isMultiUseOrg.booleanValue() && createOrg != null && !useOrgId.equals(createOrg.getPkValue())) {
                this.failNumberSet.add(currLongNumber);
                this.failNumberSet.add(parentLongNumber);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TreeBaseDataDeleteValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.dataEntities[i] = null;
                continue;
            }
            Long dataId = (Long)dynamicObject.getPkValue();
            if (this.customDataIds.contains(dataId) && !enableVersion) {
                this.failNumberSet.add(currLongNumber);
                this.failNumberSet.add(parentLongNumber);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TreeBaseDataDeleteValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.dataEntities[i] = null;
                continue;
            }
            if (this.assignedDataIds.contains(dataId) && !enableVersion) {
                this.failNumberSet.add(currLongNumber);
                this.failNumberSet.add(parentLongNumber);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u5206\u914d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TreeBaseDataDeleteValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.dataEntities[i] = null;
                continue;
            }
            if (this.existReferenceDataSet.contains(currLongNumber)) {
                this.failNumberSet.add(parentLongNumber);
                this.dataEntities[i] = null;
                continue;
            }
            if (this.unableDelete(currLongNumber, dlm)) {
                this.failNumberSet.add(currLongNumber);
                this.failNumberSet.add(parentLongNumber);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5b50\u8282\u70b9\u672a\u80fd\u5220\u9664\u3002", (String)"TreeBaseDataDeleteValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.dataEntities[i] = null;
                continue;
            }
            boolean enable = dynamicObject.getBoolean("enable");
            if (enable) continue;
            this.failNumberSet.add(currLongNumber);
            this.failNumberSet.add(parentLongNumber);
            this.dataEntities[i] = null;
        }
    }

    private boolean unableDelete(String currLongNumber, String dlm) {
        for (String longNum : this.failNumberSet) {
            if (StringUtils.isBlank((CharSequence)longNum) || !longNum.startsWith(currLongNumber)) continue;
            if (longNum.equals(currLongNumber)) {
                return true;
            }
            while (longNum.contains(dlm)) {
                if (!(longNum = StringUtils.substringBeforeLast((String)longNum, (String)dlm)).equals(currLongNumber)) continue;
                return true;
            }
        }
        return false;
    }

    private void validateAssign(Set<Long> needJudgeAssignedDataIds, boolean isIncludeFreeAssignData, Long useOrgId, boolean isMultiUseOrg) {
        Set<Long> cusDataIds = new BaseDataCustomService().selectCustomDataIds(this.entityKey, needJudgeAssignedDataIds);
        this.customDataIds.addAll(cusDataIds);
        needJudgeAssignedDataIds.removeAll(cusDataIds);
        if (needJudgeAssignedDataIds.isEmpty()) {
            return;
        }
        try {
            BaseDataAssignService service = new BaseDataAssignService(this.entityKey);
            this.assignedDataIds = isMultiUseOrg ? service.getAllAssignDataIds(needJudgeAssignedDataIds) : (isIncludeFreeAssignData ? service.getAllAssignDataIds(needJudgeAssignedDataIds, useOrgId) : service.getDirectSubAssignData(needJudgeAssignedDataIds, useOrgId));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5df2\u5206\u914d\u60c5\u51b5\u5f02\u5e38\u3002", (Throwable)e);
        }
    }

    private void quickSortInternally(String regex) {
        Arrays.parallelSort(this.dataEntities, (src, pivot) -> {
            DynamicObject dynamicObject = src.getDataEntity();
            DynamicObject dest = pivot.getDataEntity();
            int srcLength = dynamicObject.getString(LONG_NUMBER).split(regex).length;
            int destLength = dest.getString(LONG_NUMBER).split(regex).length;
            return Integer.compare(destLength, srcLength);
        });
    }

    private void addIgnoreRefEntityIds(BaseDataCheckRefrence checker) {
        this.refChecker(checker, "ignorerefentityids");
        this.refChecker(checker, "checkrefentityids");
    }

    private void refChecker(BaseDataCheckRefrence checker, String operateFlag) {
        String[] entityIds;
        RefObject opValue = new RefObject();
        boolean success = this.getOption().tryGetVariableValue(operateFlag, opValue);
        if (!success) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            return;
        }
        for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)String.valueOf(','))) {
            if (StringUtils.isBlank((CharSequence)entityId)) continue;
            if ("ignorerefentityids".equals(operateFlag)) {
                checker.getIgnoreRefEntityIds().add(entityId);
                continue;
            }
            if (!"checkrefentityids".equals(operateFlag)) continue;
            checker.getCheckRefEntityIds().add(entityId);
        }
    }
}

