/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import com.alibaba.fastjson.JSONArray;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AccountingSysBaseListPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener {
    private static final String TREEVIEW = "treeview";
    private static final String SEARCHTEXTKEY = "searchTextKey";
    private static final String SELECTED_NODEKEY_PRE = "selectedNodeKey_";
    private static final String ALL_ACCOUNTINGORG_KEY = "all_AccountingOrg_key";
    private static final String SEARCHNODEKEY = "searchNodeKey";

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        ArrayList<Long> idList = new ArrayList<Long>();
        Long id = Long.valueOf(currentNodeId.toString());
        idList.add(id);
        boolean isIncludechild = (Boolean)this.getModel().getValue("chkincludechild");
        if (isIncludechild) {
            List allSubOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("10"), idList, (boolean)true);
            e.addQFilter(new QFilter("baseacctorg", "in", (Object)allSubOrgs));
        } else {
            DynamicObject[] secLevOrg;
            for (DynamicObject dynamicObject : secLevOrg = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org.id", (QFilter[])new QFilter[]{new QFilter("view.id", "=", (Object)Long.valueOf("10")), new QFilter("parent", "=", (Object)id)})) {
                idList.add(dynamicObject.getLong("org.id"));
            }
            e.addQFilter(new QFilter("baseacctorg", "in", idList));
        }
        e.setCancel(true);
    }

    public void initialize() {
        super.initialize();
        TreeView tv = (TreeView)this.getControl(TREEVIEW);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterBindData(EventObject e) {
        List<TreeNode> adminOrgMap = this.getAllAccountingOrg();
        this.getView().getPageCache().put(this.getView().getPageId() + ALL_ACCOUNTINGORG_KEY, SerializationUtils.toJsonString(adminOrgMap));
    }

    public void registerListener(EventObject e) {
        Search search_tree = (Search)this.getControl("searchap_tree");
        search_tree.addEnterListener((SearchEnterListener)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u67e5\u8be2\u5173\u952e\u5b57\u3002", (String)"AccountingSysBaseListPlugin_1", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<TreeNode> treeNodes = new ArrayList();
        String oldSearchText = this.getPageCache().get(this.getView().getPageId() + SEARCHTEXTKEY);
        if (searchText.equals(oldSearchText)) {
            treeNodes = this.getTreeNodeFromCache();
        } else {
            treeNodes = this.searchTreeNode(searchText, treeNodes);
            this.putTreeNodeToCache(treeNodes);
        }
        if (null != treeNodes && treeNodes.size() == 1) {
            TreeNode node = (TreeNode)treeNodes.get(0);
            this.focusAndExpandParentNode(node);
            return;
        }
        if (null != treeNodes && treeNodes.size() > 1) {
            this.hanleMultiSearchResult(treeNodes, searchText);
            return;
        }
        this.getView().showTipNotification(BaseMessage.getMessage((String)"M00030"));
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        String rootId = "";
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewType("10");
        TreeNode treeRootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (treeRootNode != null) {
            rootId = treeRootNode.getId();
            treeRootNode.setChildren(new ArrayList());
            this.getTreeModel().setRoot(treeRootNode);
            this.getTreeModel().setCurrentNodeId((Object)rootId);
        }
    }

    private List<TreeNode> refreshNodeChildren(String nodeId, OrgTreeParam param) {
        if (param == null) {
            return Collections.emptyList();
        }
        param.setId(Long.parseLong(nodeId));
        return OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        this.getTreeModel().setCurrentNodeId(e.getNodeId());
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        if (!ObjectUtils.isEmpty((Object)parameter.getPkId())) {
            return;
        }
        Object nodeId = this.getTreeModel().getCurrentNodeId();
        if (nodeId == null) {
            return;
        }
        long orgId = Long.parseLong(nodeId.toString());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_accountingsys_base", (String)"id", (QFilter[])new QFilter[]{new QFilter("baseacctorg", "=", (Object)orgId)});
        if (null != dynamicObjects && dynamicObjects.length > 0) {
            DynamicObject existAcctSysBase = dynamicObjects[0];
            parameter.setPkId(existAcctSysBase.getPkValue());
        } else {
            parameter.setCustomParam("orgId", nodeId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode curNode = this.getTreeModel().getRoot().getTreeNode(nodeId, 20);
        if (curNode == null) {
            return;
        }
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewType("10");
        e.setChildNodes(this.refreshNodeChildren(nodeId, param));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("new".equals(evt.getOperationKey())) {
            String appId;
            Long orgId = Long.valueOf(this.getTreeModel().getCurrentNodeId().toString());
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            int hasAddPerm = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)(appId = this.getView().getFormShowParameter().getAppId()), (String)"bd_accountingsys_base", (String)"47156aff000000ac");
            if (hasAddPerm != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u7684\u201c\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u8bbe\u7f6e\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"AccountingSysBaseListPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent nodeEvent) {
        long nodeId = Long.parseLong(nodeEvent.getNodeId().toString());
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("10");
        param.setId(nodeId);
        ArrayList<TreeNode> childList = new ArrayList<TreeNode>(16);
        String checkedNodesStr = this.getPageCache().get(this.getView().getPageId() + ALL_ACCOUNTINGORG_KEY);
        List AccountingOrgList = (List)SerializationUtils.fromJsonString((String)checkedNodesStr, List.class);
        TreeNode childNode = null;
        for (int i = 0; i < AccountingOrgList.size(); ++i) {
            LinkedHashMap map = (LinkedHashMap)AccountingOrgList.get(i);
            String parentId = (String)map.get("parentid");
            if (nodeId != Long.parseLong(parentId)) continue;
            String name = (String)map.get("text");
            String id = (String)map.get("id");
            childNode = new TreeNode(parentId, id, name);
            List cChildList = (List)JSONArray.toJSON(map.get("children"));
            childNode.setChildren(cChildList);
            childList.add(childNode);
        }
        if (!childList.isEmpty()) {
            tvLeft.addNodes(childList);
        }
    }

    private List<TreeNode> getTreeNodeFromCache() {
        String searchNodesStr = this.getView().getPageCache().get(this.getView().getPageId() + SEARCHNODEKEY);
        List searchNodes = (List)SerializationUtils.fromJsonString((String)searchNodesStr, List.class);
        ArrayList<TreeNode> tempList = new ArrayList<TreeNode>(searchNodes.size());
        TreeNode tempNode = null;
        for (int i = 0; i < searchNodes.size(); ++i) {
            Map tempMap = (Map)searchNodes.get(i);
            tempNode = new TreeNode((String)tempMap.get("parentid"), (String)tempMap.get("id"), (String)tempMap.get("text"));
            tempList.add(tempNode);
        }
        return tempList;
    }

    private void putTreeNodeToCache(List<TreeNode> treeNodes) {
        this.getView().getPageCache().put(this.getView().getPageId() + SEARCHNODEKEY, SerializationUtils.toJsonString(treeNodes));
    }

    private void focusAndExpandParentNode(TreeNode node) {
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        ArrayList<TreeNode> parentNodes = new ArrayList<TreeNode>(16);
        this.getParentNode(node, parentNodes);
        for (int i = parentNodes.size() - 1; i > -1; --i) {
            TreeNode parentNode = (TreeNode)parentNodes.get(i);
            treeView.queryTreeNodeChildren(parentNode.getParentid(), parentNode.getId());
            treeView.expand(parentNode.getId());
        }
        treeView.focusNode(node);
        TreeView tv = (TreeView)this.getControl(TREEVIEW);
        tv.treeNodeClick(node.getParentid(), node.getId());
    }

    private void getParentNode(TreeNode treeNode, List<TreeNode> parentNodes) {
        String checkedNodesStr = this.getPageCache().get(this.getView().getPageId() + ALL_ACCOUNTINGORG_KEY);
        List AccountingOrgList = (List)SerializationUtils.fromJsonString((String)checkedNodesStr, List.class);
        String parentId = treeNode.getParentid();
        if (StringUtils.isNotEmpty((CharSequence)parentId)) {
            TreeNode parentNode = null;
            for (int i = 0; i < AccountingOrgList.size(); ++i) {
                LinkedHashMap map = (LinkedHashMap)AccountingOrgList.get(i);
                String id = (String)map.get("id");
                if (!parentId.equals(id)) continue;
                String pParentId = (String)map.get("parentid");
                String name = (String)map.get("text");
                parentNode = new TreeNode(pParentId, id, name);
                parentNodes.add(parentNode);
                this.getParentNode(parentNode, parentNodes);
            }
        }
    }

    private List<TreeNode> getAllAccountingOrg() {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("10");
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        List orgChildrenTreeData = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        ArrayList<TreeNode> allAccountingOrg = new ArrayList<TreeNode>();
        allAccountingOrg.addAll(orgChildrenTreeData);
        this.getChildNode(orgChildrenTreeData, allAccountingOrg);
        return allAccountingOrg;
    }

    private void getChildNode(List<TreeNode> orgChildrenTreeData, List<TreeNode> allAccountingOrg) {
        for (TreeNode node : orgChildrenTreeData) {
            List childNode = node.getChildren();
            if (null == childNode || childNode.isEmpty()) continue;
            allAccountingOrg.addAll(node.getChildren());
            this.getChildNode(node.getChildren(), allAccountingOrg);
        }
    }

    private List<TreeNode> searchTreeNode(String searchText, List<TreeNode> treeNodes) {
        String sql = "SELECT o.fid,o.fname,t.fparentid,o.fnumber from t_org_structure t  left join T_ORG_ORG o  on t.forgid=o.fid  where t.FVIEWID = ? and (o.fname like ? or o.fnumber like ?) order by flevel,flongnumber asc";
        Object[] params = new SqlParameter[]{new SqlParameter(":fviewid", 12, (Object)Long.valueOf("10")), new SqlParameter(":fname", 12, (Object)("%" + searchText + "%")), new SqlParameter(":fnumber", 12, (Object)("%" + searchText + "%"))};
        treeNodes = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<TreeNode>>(){

            public List<TreeNode> handle(ResultSet rs) throws SQLException {
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
                String format = OrgUnitServiceHelper.getOrgTreeNodeFormat();
                while (rs.next()) {
                    String id = rs.getString(1);
                    String name = rs.getString(2);
                    String parentid = rs.getString(3);
                    String number = rs.getString(4);
                    String formatName = OrgUnitServiceHelper.formatOrgTreeNodeName((String)number, (String)name, (String)format);
                    TreeNode treeNode = new TreeNode(parentid, id, formatName);
                    treeNodes.add(treeNode);
                }
                return treeNodes;
            }
        });
        return treeNodes;
    }

    private void hanleMultiSearchResult(List<TreeNode> treeNodes, String searchText) {
        String oldSearchText = this.getPageCache().get(this.getView().getPageId() + SEARCHTEXTKEY);
        String selectedNodeKey = SELECTED_NODEKEY_PRE + this.getView().getPageId();
        if (null != oldSearchText && searchText.equals(oldSearchText)) {
            String oldSelectedNodeId = this.getPageCache().get(selectedNodeKey);
            for (int i = 0; i < treeNodes.size(); ++i) {
                TreeNode node = treeNodes.get(i);
                String orgId = node.getId();
                if (!orgId.equals(oldSelectedNodeId)) continue;
                int index = i + 1 >= treeNodes.size() ? 0 : i + 1;
                TreeNode nextNode = treeNodes.get(index);
                String nextNodeId = nextNode.getId();
                this.focusAndExpandParentNode(nextNode);
                this.getPageCache().put(selectedNodeKey, nextNodeId);
                return;
            }
        } else {
            TreeNode node = treeNodes.get(0);
            String orgId = node.getId();
            this.focusAndExpandParentNode(node);
            this.getPageCache().put(this.getView().getPageId() + SEARCHTEXTKEY, searchText);
            this.getPageCache().put(selectedNodeKey, orgId);
            return;
        }
    }
}

