/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BaseDataListPlugin
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final String QUERY_PERM = "47150e89000000ac";
    private static final String ORG_ENTITY = "bos_org";
    private QFilter qfilter;
    private static final String USEORG_FILEDNAME = "useorg.id";
    private String useOrgId = null;
    private Map<String, List<Map<String, List<Object>>>> filterValues = null;
    private List<Map<String, List<Object>>> customfilter = null;
    private static final String ORGPERM_CHANGE = "4730fc9f000000ac";
    private static final String ORGPERM_CHANGE_CALLBACK = "permChangeCallBack";
    public static final String ctrlstrategy_cu_assign = "1";
    public static final String ctrlstrategy_cu_free_assign = "2";
    public static final String ctrlstrategy_ou_assign = "3";
    public static final String ctrlstrategy_ou_free_assign = "4";
    public static final String ctrlstrategy_global_share = "5";
    public static final String ctrlstrategy_cu_share = "6";
    public static final String ctrlstrategy_private = "7";

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        if (!("orgpermchange".equals(itemkey) || "tblassign".equals(itemkey) || "tblassign_search".equals(itemkey))) {
            return;
        }
        String entityName = this.getEntityNumber();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"BaseDataListPlugin_58", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "orgpermchange": {
                if (!this.checkOrgPermChangeDatas(ids)) {
                    return;
                }
                DynamicObject data = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)entityName, (String)"org");
                DynamicObject org = data.getDynamicObject("org");
                params.put("ids", ids);
                params.put("org", org.getPkValue());
                params.put("objecttype", entityName);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, ORGPERM_CHANGE_CALLBACK);
                this.showForm("orgpermchangepage", params, callBack, ShowType.Modal);
                break;
            }
            case "tblassign_search": {
                if (!this.checkAssignDatas(ids)) {
                    return;
                }
                params.put("ids", ids);
                params.put("useOrgId", Long.parseLong(this.getPageCache().get("createOrg")));
                params.put("entityNumber", this.getEntityNumber());
                this.showForm("bd_assign_query", params, null, ShowType.Modal);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("assign".equalsIgnoreCase(operate.getOperateKey())) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            ArrayList<Long> ids = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                ids.add((Long)row.getPrimaryKeyValue());
            }
            args.cancel = !this.checkAssignDatas(ids);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"BaseDataListPlugin_45", (String)"bos-bd-formplugin", (Object[])new Object[0])));
        orgColumn.setFieldName(USEORG_FILEDNAME);
        orgColumn.setMustInput(true);
        if (filterColumnList.contains(orgColumn)) {
            return;
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        DynamicObjectCollection col = this.getAllUseOrg();
        String defaultOrg = this.getDefaultUseOrg();
        for (DynamicObject org : col) {
            if (org == null) continue;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(org.getString("name")));
            item.setValue(String.valueOf(org.getPkValue()));
            combos.add(item);
        }
        orgColumn.setComboItems(combos);
        orgColumn.setType("enum");
        orgColumn.setDefaultValue(this.useOrgId == null ? defaultOrg : this.useOrgId);
        filterColumnList.add(orgColumn);
        if (this.filterValues == null) {
            this.filterValues = new HashMap<String, List<Map<String, List<Object>>>>();
            this.filterValues.put("fastfilter", new ArrayList());
            this.filterValues.put("customfilter", new ArrayList());
            for (FilterColumn filterColumn : filterColumnList) {
                HashMap<String, List> customFiter = new HashMap<String, List>();
                ArrayList<String> fieldName = new ArrayList<String>();
                fieldName.add(filterColumn.getFieldName());
                customFiter.put("FieldName", fieldName);
                if (USEORG_FILEDNAME.equals(filterColumn.getFieldName())) {
                    ArrayList<String> value = new ArrayList<String>();
                    value.add(defaultOrg);
                    customFiter.put("Value", value);
                } else if (filterColumn.getDefaultValues() != null && filterColumn.getDefaultValues().size() > 0) {
                    customFiter.put("Value", filterColumn.getDefaultValues());
                }
                if (customFiter.get("Value") == null) continue;
                this.filterValues.get("customfilter").add(customFiter);
            }
            this.customfilter = this.filterValues.get("customfilter");
            String customfilterSer = SerializationUtils.toJsonString(this.customfilter);
            this.getPageCache().put("customfilter", customfilterSer);
            this.getPageCache().put("createOrg", defaultOrg);
        }
    }

    public void setFilter(SetFilterEvent e) {
        String appId;
        long userId;
        QFilter dataPermissionFilter;
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        String customfilterSer = this.getPageCache().get("customfilter");
        if (customfilterSer == null) {
            return;
        }
        this.customfilter = (List)SerializationUtils.fromJsonString((String)customfilterSer, ArrayList.class);
        for (Map<String, List<Object>> customFiter : this.customfilter) {
            List<Object> fieldNames = customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0 || !USEORG_FILEDNAME.equals(fieldNames.get(0))) continue;
            List<Object> orgFilterIds = customFiter.get("Value");
            if (orgFilterIds == null || orgFilterIds.size() == 0 || orgFilterIds.get(0) == null || StringUtils.isBlank((Object)orgFilterIds.get(0))) {
                this.qfilter = new QFilter("id", "=", (Object)-1L);
                break;
            }
            if (orgFilterIds.get(0) != null && orgFilterIds.get(0) instanceof Long) {
                this.qfilter = BaseDataServiceHelper.getBaseDataFilter((String)this.getEntityNumber(), (Long)((Long)orgFilterIds.get(0)));
                orgIds.add((Long)orgFilterIds.get(0));
                break;
            }
            if (orgFilterIds.get(0) == null || !(orgFilterIds.get(0) instanceof String)) break;
            this.qfilter = BaseDataServiceHelper.getBaseDataFilter((String)this.getEntityNumber(), (Long)Long.valueOf((String)orgFilterIds.get(0)));
            orgIds.add(Long.valueOf((String)orgFilterIds.get(0)));
            break;
        }
        List filters = e.getQFilters();
        Iterator it = filters.iterator();
        while (it.hasNext()) {
            QFilter filter = (QFilter)it.next();
            if (!filter.getProperty().equals(USEORG_FILEDNAME)) continue;
            it.remove();
        }
        if (this.qfilter != null) {
            filters.add(this.qfilter);
            e.setQFilters(filters);
        }
        if ((dataPermissionFilter = PermissionServiceHelper.getDataPermission((long)(userId = Long.parseLong(RequestContext.get().getUserId())), (String)(appId = this.getView().getFormShowParameter().getAppId()), (String)this.getEntityNumber(), orgIds)) != null) {
            filters.add(dataPermissionFilter);
        }
        super.setFilter(e);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.filterValues = args.getSearchClickEvent().getFilterValues();
        List<Map<String, List<Object>>> customFiterList = this.filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        String customfilterSer = SerializationUtils.toJsonString(customFiterList);
        this.getPageCache().remove("customfilter");
        this.getPageCache().put("customfilter", customfilterSer);
        String orgId = null;
        this.getPageCache().remove("createOrg");
        Iterator<Map<String, List<Object>>> iterator = customFiterList.iterator();
        while (iterator.hasNext()) {
            List<Object> orgIds;
            Map<String, List<Object>> customFiter = iterator.next();
            List<Object> fieldNames = customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0 || !USEORG_FILEDNAME.equals(fieldNames.get(0)) || (orgIds = customFiter.get("Value")) == null || orgIds.size() == 0) continue;
            this.useOrgId = orgId = String.valueOf(orgIds.get(0));
            iterator.remove();
            this.getPageCache().put("createOrg", String.valueOf(orgId));
            break;
        }
        super.filterContainerSearchClick(args);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private String getEntityNumber() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = listShowParameter.getBillFormId();
        return entity;
    }

    private String getDefaultUseOrg() {
        String defaultUseOrg = null;
        DynamicObjectCollection col = this.getAllUseOrg();
        if (!col.isEmpty()) {
            defaultUseOrg = String.valueOf(((DynamicObject)col.get(0)).getPkValue());
        }
        return defaultUseOrg;
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
    }

    private boolean checkAssignDatas(List<Long> ids) {
        String selectFields = "id, ctrlstrategy, status, org";
        QFilter[] qfArr = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection dyCol = QueryServiceHelper.query((String)this.getEntityNumber(), (String)selectFields, (QFilter[])qfArr);
        if (dyCol.size() == 0) {
            return false;
        }
        long orgId = ((DynamicObject)dyCol.get(0)).getLong("org");
        String ctrlstrategy = ((DynamicObject)dyCol.get(0)).getString("ctrlstrategy");
        for (int i = 0; i < dyCol.size(); ++i) {
            if (!"C".equalsIgnoreCase(((DynamicObject)dyCol.get(i)).getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u7684\u6570\u636e\u4e0d\u80fd\u88ab\u5206\u914d", (String)"BaseDataListPlugin_46", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (orgId != ((DynamicObject)dyCol.get(i)).getLong("org")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ba1\u7406\u7ec4\u7ec7\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u88ab\u6279\u91cf\u5206\u914d", (String)"BaseDataListPlugin_47", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (ctrlstrategy.equals(((DynamicObject)dyCol.get(i)).getString("ctrlstrategy"))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u88ab\u6279\u91cf\u5206\u914d", (String)"BaseDataListPlugin_48", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!(ctrlstrategy_cu_assign.equals(ctrlstrategy) || ctrlstrategy_cu_free_assign.equals(ctrlstrategy) || ctrlstrategy_ou_assign.equals(ctrlstrategy) || ctrlstrategy_ou_free_assign.equals(ctrlstrategy))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565\u4e3a\u5206\u914d\u7c7b\u578b\u7684\u6570\u636e\u624d\u80fd\u88ab\u5206\u914d", (String)"BaseDataListPlugin_49", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        String createOrg = this.getPageCache().get("createOrg");
        ORM orm = ORM.create();
        DynamicObject useOrg = orm.getById(ORG_ENTITY, (Object)Long.parseLong(createOrg));
        if ((ctrlstrategy_cu_free_assign.equals(ctrlstrategy) || ctrlstrategy_cu_assign.equals(ctrlstrategy)) && !useOrg.getBoolean("fiscontrolunit")) {
            String ctrlstrategyName = null;
            ctrlstrategyName = ctrlstrategy_cu_free_assign.equals(ctrlstrategy) ? ResManager.loadKDString((String)"\u6309\u7ba1\u63a7\u5355\u5143\u81ea\u7531\u5206\u914d", (String)"BaseDataListPlugin_50", (String)"bos-bd-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6309\u7ba1\u63a7\u5355\u5143\u9010\u7ea7\u5206\u914d", (String)"BaseDataListPlugin_51", (String)"bos-bd-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7%1$s\u4e0d\u662f\u7ba1\u63a7\u5355\u5143\uff0c\u4e0d\u80fd\u5206\u914d\u63a7\u5236\u7b56\u7565\u4e3a%2$s\u7684\u57fa\u7840\u6570\u636e\u3002", (String)"BaseDataListPlugin_52", (String)"bos-bd-formplugin", (Object[])new Object[0]), useOrg.getString("name"), ctrlstrategyName));
            return false;
        }
        return true;
    }

    private boolean checkOrgPermChangeDatas(List<Long> ids) {
        String selectFields = "id, ctrlstrategy, org";
        QFilter[] qfArr = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection dyCol = QueryServiceHelper.query((String)this.getEntityNumber(), (String)selectFields, (QFilter[])qfArr);
        if (dyCol.size() == 0) {
            return false;
        }
        long orgId = ((DynamicObject)dyCol.get(0)).getLong("org");
        String ctrlstrategy = ((DynamicObject)dyCol.get(0)).getString("ctrlstrategy");
        for (int i = 0; i < dyCol.size(); ++i) {
            if (orgId != ((DynamicObject)dyCol.get(i)).getLong("org")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ba1\u7406\u7ec4\u7ec7\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u8f6c\u8ba9\u7ba1\u7406\u6743", (String)"BaseDataListPlugin_53", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (ctrlstrategy.equals(((DynamicObject)dyCol.get(i)).getString("ctrlstrategy"))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u8f6c\u8ba9\u7ba1\u7406\u6743", (String)"BaseDataListPlugin_54", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (PermissionServiceHelper.checkFunctionPermission((long)Long.parseLong(RequestContext.get().getUserId()), (long)orgId, (String)this.getEntityNumber(), (String)ORGPERM_CHANGE) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u7ba1\u7406\u6743\u8f6c\u8ba9\u6743\u9650\u3002", (String)"BaseDataListPlugin_55", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String callBackId = closedCallBackEvent.getActionId();
        if (callBackId.equals(ORGPERM_CHANGE_CALLBACK)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List hasPermOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)this.getEntityNumber(), (String)QUERY_PERM);
        event.setRefEntityId(ORG_ENTITY);
        event.setRefPropKey("bos_org.id");
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter qf = new QFilter("id", "in", (Object)hasPermOrgs);
        qfList.add(qf);
        event.setQfilters(qfList);
    }

    private DynamicObjectCollection getAllUseOrg() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List hasPermOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)this.getEntityNumber(), (String)QUERY_PERM);
        String useOrgFunc = BaseDataServiceHelper.getUseOrgFunc((String)this.getEntityNumber());
        QFilter[] filters = null;
        QFilter idsFilter = new QFilter("id", "in", (Object)hasPermOrgs);
        if (useOrgFunc == null) {
            filters = new QFilter[]{idsFilter};
        } else {
            String orgFuncPro = OrgServiceHelper.getOrgBizPro((String)useOrgFunc);
            QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)Boolean.TRUE);
            filters = new QFilter[]{idsFilter, orgFuncFilter};
        }
        ORM orm = ORM.create();
        DynamicObjectCollection col = orm.query(ORG_ENTITY, "id,name", filters);
        return col;
    }
}

