/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TaskScanunitListPlugin
extends AbstractListPlugin
implements ClickListener,
ItemClickListener,
RowClickEventListener {
    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("modifytime desc");
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"labelapdel"});
        this.addClickListeners(new String[]{"imageap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("imageap".equalsIgnoreCase(key)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("imageap", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"TaskSscunitListPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("imageap".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteRightUser();
        }
    }

    private void deleteRightUser() {
        IDataModel model = this.getModel();
        String sscUnitIdStr = this.getPageCache().get("sscUnitId");
        Long sscUnitId = Long.parseLong(sscUnitIdStr);
        int entryIndex = model.getEntryCurrentRowIndex("entryentity");
        Long selectedEntryId = Long.valueOf(model.getValue("entryid", entryIndex) + "");
        model.getValue("entryentity", entryIndex);
        this.deleteUserEntry(sscUnitId, selectedEntryId);
        List<Map<String, Object>> userList = this.getUserList(sscUnitId);
        ArrayList<Long> userIds = new ArrayList<Long>(userList.size());
        ArrayList<Long> entryIds = new ArrayList<Long>(userList.size());
        for (int i = 0; i < userList.size(); ++i) {
            long userId = (Long)userList.get(i).get("userId");
            long entryId = (Long)userList.get(i).get("entryId");
            userIds.add(userId);
            entryIds.add(entryId);
        }
        if (userList.size() > 0) {
            this.setListPerson(userIds, entryIds, userList);
            this.getView().updateView("entryentity");
        } else {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    private void deleteUserEntry(Long sscUnitId, Long entryid) {
        DynamicObject[] sscUnitColl;
        QFilter sscUnitIdQfilter = new QFilter("id", "=", (Object)sscUnitId);
        for (DynamicObject dynamicObject : sscUnitColl = BusinessDataServiceHelper.load((String)"bos_sscunitlist", (String)"id,seq,entryentity.id,entryentity.seq", (QFilter[])sscUnitIdQfilter.toArray())) {
            int i;
            DynamicObjectCollection col = (DynamicObjectCollection)dynamicObject.get("entryentity");
            for (i = 0; i < col.size(); ++i) {
                long id = (Long)((DynamicObject)col.get(i)).get("id");
                if (id != entryid) continue;
                col.remove(i);
            }
            for (i = 0; i < col.size(); ++i) {
                DynamicObject dyn = (DynamicObject)col.get(i);
                dyn.set("seq", (Object)(i + 1));
            }
        }
        SaveServiceHelper.save((DynamicObject[])sscUnitColl);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ((BillList)this.getControl("billlistap")).setPageRow(1000);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList entryentity = (BillList)this.getControl("billlistap");
        boolean isExistData = this.isExistData();
        if (!isExistData) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"nodata_flexpanel"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"usercard_flexpanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"sscunitgroup_flexpanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"nodata_flexpanel"});
        entryentity.clearSelection();
        entryentity.selectRows(0);
        this.init();
    }

    private boolean isExistData() {
        DynamicObjectCollection scanPointColl = QueryServiceHelper.query((String)"bos_sscunitlist", (String)"id", (QFilter[])new QFilter[0]);
        return scanPointColl != null && scanPointColl.size() != 0;
    }

    private void init() {
        ListSelectedRowCollection currentListAllRowCollection = ((IListView)this.getView()).getCurrentListAllRowCollection();
        if (currentListAllRowCollection != null && currentListAllRowCollection.size() > 0 && !"".equals(Arrays.toString(currentListAllRowCollection.getPrimaryKeyValues()))) {
            Object[] primaryKeyValues = currentListAllRowCollection.getPrimaryKeyValues();
            String idFirst = primaryKeyValues[0] + "";
            this.getPageCache().put("sscUnitId", idFirst);
            Long id = Long.parseLong(idFirst);
            List<Map<String, Object>> userList = this.getUserList(id);
            ArrayList<Long> userIds = new ArrayList<Long>(userList.size());
            ArrayList<Long> entryIds = new ArrayList<Long>(userList.size());
            for (int i = 0; i < userList.size(); ++i) {
                long userId = (Long)userList.get(i).get("userId");
                long entryId = (Long)userList.get(i).get("entryId");
                userIds.add(userId);
                entryIds.add(entryId);
            }
            if (userList.size() > 0) {
                this.setListPerson(userIds, entryIds, userList);
                this.getView().updateView("entryentity");
            } else {
                this.getModel().deleteEntryData("entryentity");
            }
        }
    }

    private void setListPerson(List<Long> userIds, List<Long> entryIds, List<Map<String, Object>> userList) {
        this.getModel().deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField("userfield", new Object[0]);
        tvs.addField("dptname", new Object[0]);
        tvs.addField("entryid", new Object[0]);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_user");
        Map mapObjects = BusinessDataReader.loadFromCache((Object[])userIds.toArray(), (DynamicObjectType)type, (boolean)false);
        for (Map.Entry entry : mapObjects.entrySet()) {
            Long userId = (Long)((DynamicObject)entry.getValue()).get("id");
            Long userDpt = this.getDptNameByUserId(userId);
            Long entryId = this.getRightEntryIdByUserId(userId, userList);
            tvs.addRow(new Object[]{userId, userDpt, entryId});
        }
        model.batchCreateNewEntryRow("entryentity", tvs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private Long getRightEntryIdByUserId(Long userId, List<Map<String, Object>> userList) {
        for (Map<String, Object> map : userList) {
            Long userId1 = (Long)map.get("userId");
            if (!userId1.equals(userId)) continue;
            return (Long)map.get("entryId");
        }
        return null;
    }

    private List<Map<String, Object>> getUserList(Long id) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String selectFields = "id,entryentity.id entryid,entryentity.displayname displayname";
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_sscunitlist", (String)selectFields, (QFilter[])filter.toArray());
        if (coll.size() > 0) {
            HashMap<String, Object> map = null;
            for (DynamicObject dynamicObject : coll) {
                map = new HashMap<String, Object>();
                Long userId = (Long)dynamicObject.get("displayname");
                Long entryId = (Long)dynamicObject.get("entryid");
                DynamicObject bosUserById = this.getBosUserById(userId);
                if (bosUserById == null) continue;
                String name = bosUserById.get("name") + "";
                map.put("userId", userId);
                map.put("name", name);
                map.put("entryId", entryId);
                list.add(map);
            }
        }
        this.sortUserIdByName(list);
        return list;
    }

    private DynamicObject getBosUserById(Long bosUserId) {
        DynamicObject bosUserInfo = null;
        QFilter userIdFilter = new QFilter("id", "=", (Object)bosUserId);
        DynamicObject[] bosUserInfos = BusinessDataServiceHelper.load((String)"bos_user", (String)"name", (QFilter[])new QFilter[]{userIdFilter});
        if (bosUserInfos.length < 1) {
            return bosUserInfo;
        }
        bosUserInfo = bosUserInfos[0];
        return bosUserInfo;
    }

    private void sortUserIdByName(List<Map<String, Object>> maps) {
        Collections.sort(maps, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                String name1 = (String)o1.get("name");
                String name2 = (String)o2.get("name");
                if (name1 == null && name2 == null) {
                    return 0;
                }
                Collator instance = Collator.getInstance(Locale.CHINA);
                return instance.compare(name1, name2);
            }
        });
    }

    private Long getDptNameByUserId(Long idArr) {
        boolean ispartjob;
        Long userDpt = 0L;
        String selectField = "id,entryentity.dpt,entryentity.ispartjob ";
        QFilter idFilter = new QFilter("id", "=", (Object)idArr);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_user", (String)selectField, (QFilter[])idFilter.toArray());
        if (coll.size() > 0 && !(ispartjob = ((Boolean)((DynamicObject)coll.get(0)).get("entryentity.ispartjob")).booleanValue())) {
            userDpt = (Long)((DynamicObject)coll.get(0)).get("entryentity.dpt");
        }
        return userDpt;
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        ListSelectedRowCollection listCol = evt.getListSelectedRowCollection();
        if (listCol.size() > 0) {
            ListSelectedRow listRow = listCol.get(0);
            this.getPageCache().put("sscUnitId", listRow.getPrimaryKeyValue() + "");
            List<Map<String, Object>> userList = this.getUserList(Long.valueOf(listRow.getPrimaryKeyValue() + ""));
            ArrayList<Long> userIds = new ArrayList<Long>(userList.size());
            ArrayList<Long> entryIds = new ArrayList<Long>(userList.size());
            for (int i = 0; i < userList.size(); ++i) {
                long userId = (Long)userList.get(i).get("userId");
                long entryId = (Long)userList.get(i).get("entryId");
                userIds.add(userId);
                entryIds.add(entryId);
            }
            if (userList.size() > 0) {
                this.setListPerson(userIds, entryIds, userList);
            } else {
                this.getModel().deleteEntryData("entryentity");
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map map = args.getSearchClickEvent().getFilterValues();
        List customlist = (List)map.get("customfilter");
        this.getModel().deleteEntryData("entryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource().getClass().getName().equals("kd.bos.entity.operate.New")) {
            BillList entryentity = (BillList)this.getControl("billlistap");
            entryentity.selectRows(0);
            this.init();
        } else if (afterDoOperationEventArgs.getSource().getClass().getName().equals("kd.bos.entity.operate.Delete")) {
            if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                BillList entryentity = (BillList)this.getControl("billlistap");
                entryentity.selectRows(0);
                this.init();
            }
        } else if (afterDoOperationEventArgs.getSource().getClass().getName().equals("kd.bos.form.operate.Modify")) {
            this.initRightPage();
        }
    }

    private void initRightPage() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        Long primaryKey = (Long)listSelectedRows.get(0).getPrimaryKeyValue();
        this.getPageCache().put("sscUnitId", primaryKey + "");
        List<Map<String, Object>> userList = this.getUserList(primaryKey);
        ArrayList<Long> userIds = new ArrayList<Long>(userList.size());
        ArrayList<Long> entryIds = new ArrayList<Long>(userList.size());
        for (int i = 0; i < userList.size(); ++i) {
            long userId = (Long)userList.get(i).get("userId");
            long entryId = (Long)userList.get(i).get("entryId");
            userIds.add(userId);
            entryIds.add(entryId);
        }
        if (userList.size() > 0) {
            this.setListPerson(userIds, entryIds, userList);
        } else {
            this.getModel().deleteEntryData("entryentity");
        }
    }
}

