/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.basedata.WorkCalendarLoadService;
import kd.bd.assistant.plugin.util.TimeUtils;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.WorkCalendar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.time.FastDateFormat;

public class WorkCalendarEditPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
IConfirmCallBack,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(WorkCalendarEditPlugin.class);
    private static final String IS_INIT_CALLBACK = "isInitCallBack";
    private static final String IS_COPY_LASTYEAR_CALLBACK = "isCopyLastyearCallBack";
    public static final FastDateFormat SDF = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final String ORGTREE = "orgtree";
    private static final String WORKCALENDARAP = "workcalendarap";
    private static final String BOS_BD_FORMPLUGIN = "bos-bd-formplugin";
    private static final String ISINDIVIDUATION = "isindividuation";
    private static final String ORGID = "orgId";
    private static final String RELOAD = "reload";
    private static final String BD_WORKCALENDAR = "bd_workcalendar";
    private static final String DATEENTRY = "dateentry";
    private static final String WORKDATE = "workdate";
    private static final String DATETYPE = "datetype";
    private static final String SEARCHTEXTKEY = "searchTextKey";
    private static final String SELECTED_NODEKEY_PRE = "selectedNodeKey_";
    private static final String ALL_ADMINORG_KEY = "all_adminOrg_key";
    private static final String SEARCHNODEKEY = "searchNodeKey";
    private static final String WORKCALENDAREDITPLUGIN_2 = "WorkCalendarEditPlugin_2";
    private static final String WARNING_CONFIRM = "warning_confirm";

    public void initialize() {
        TreeView orgtree = (TreeView)this.getControl(ORGTREE);
        orgtree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        orgtree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"setworkcalendar", "preyear", "nextyear", "initworkcalendar", "syncworkcalendar"});
        WorkCalendar workCalendar = (WorkCalendar)this.getView().getControl(WORKCALENDARAP);
        workCalendar.addClickListener((ClickListener)this);
    }

    public void registerListener(EventObject e) {
        Search search_tree = (Search)this.getControl("searchap_tree");
        search_tree.addEnterListener((SearchEnterListener)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u67e5\u8be2\u5173\u952e\u5b57\u3002", (String)"WorkCalendarEditPlugin_10", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        ArrayList<TreeNode> treeNodes = new ArrayList();
        String oldSearchText = this.getPageCache().get(this.getView().getPageId() + SEARCHTEXTKEY);
        if (searchText.equals(oldSearchText)) {
            treeNodes = this.getTreeNodeFromCache();
        } else {
            treeNodes = this.searchTreeNode(searchText, treeNodes);
            this.putTreeNodeToCache(treeNodes);
        }
        if (null != treeNodes && treeNodes.size() == 1) {
            TreeNode node = (TreeNode)treeNodes.get(0);
            this.focusAndExpandParentNode(node);
            return;
        }
        if (null != treeNodes && treeNodes.size() > 1) {
            this.hanleMultiSearchResult(treeNodes, searchText);
            return;
        }
        this.getView().showTipNotification(BaseMessage.getMessage((String)"M00030"));
    }

    private List<TreeNode> getTreeNodeFromCache() {
        String searchNodesStr = this.getView().getPageCache().get(this.getView().getPageId() + SEARCHNODEKEY);
        List searchNodes = (List)SerializationUtils.fromJsonString((String)searchNodesStr, List.class);
        ArrayList<TreeNode> tempList = new ArrayList<TreeNode>(searchNodes.size());
        TreeNode tempNode = null;
        for (int i = 0; i < searchNodes.size(); ++i) {
            Map tempMap = (Map)searchNodes.get(i);
            tempNode = new TreeNode((String)tempMap.get("parentid"), (String)tempMap.get("id"), (String)tempMap.get("text"));
            tempList.add(tempNode);
        }
        return tempList;
    }

    private void putTreeNodeToCache(List<TreeNode> treeNodes) {
        this.getView().getPageCache().put(this.getView().getPageId() + SEARCHNODEKEY, SerializationUtils.toJsonString(treeNodes));
    }

    private void focusAndExpandParentNode(TreeNode node) {
        TreeView treeView = (TreeView)this.getView().getControl(ORGTREE);
        ArrayList<TreeNode> parentNodes = new ArrayList<TreeNode>(16);
        this.getParentNode(node, parentNodes);
        for (int i = parentNodes.size() - 1; i > -1; --i) {
            TreeNode parentNode = (TreeNode)parentNodes.get(i);
            treeView.queryTreeNodeChildren(parentNode.getParentid(), parentNode.getId());
            treeView.expand(parentNode.getId());
        }
        if (node == null) {
            return;
        }
        treeView.focusNode(node);
    }

    private void getParentNode(TreeNode treeNode, List<TreeNode> parentNodes) {
        List adminOrgList;
        String checkedNodesStr = this.getPageCache().get(this.getView().getPageId() + ALL_ADMINORG_KEY);
        if (StringUtils.isEmpty((CharSequence)checkedNodesStr)) {
            return;
        }
        try {
            adminOrgList = (List)SerializationUtils.fromJsonString((String)GzipUtils.uncompress((String)checkedNodesStr, (String)"UTF-8"), List.class);
        }
        catch (IOException e) {
            logger.error("\u884c\u653f\u7ec4\u7ec7\u7f13\u5b58\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            return;
        }
        String parentId = treeNode.getParentid();
        if (StringUtils.isNotEmpty((CharSequence)parentId)) {
            TreeNode parentNode = null;
            for (int i = 0; i < adminOrgList.size(); ++i) {
                LinkedHashMap map = (LinkedHashMap)adminOrgList.get(i);
                String id = (String)map.get("id");
                if (!parentId.equals(id)) continue;
                String pParentId = (String)map.get("parentid");
                String name = (String)map.get("text");
                parentNode = new TreeNode(pParentId, id, name);
                parentNodes.add(parentNode);
                this.getParentNode(parentNode, parentNodes);
            }
        }
    }

    private List<TreeNode> getAllAdminOrg() {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("01");
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        List orgChildrenTreeData = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        ArrayList<TreeNode> allAdminOrg = new ArrayList<TreeNode>();
        allAdminOrg.addAll(orgChildrenTreeData);
        this.getChildNode(orgChildrenTreeData, allAdminOrg);
        return allAdminOrg;
    }

    private void getChildNode(List<TreeNode> orgChildrenTreeData, List<TreeNode> allAdminOrg) {
        for (TreeNode node : orgChildrenTreeData) {
            List childNode = node.getChildren();
            if (null == childNode || childNode.isEmpty()) continue;
            allAdminOrg.addAll(node.getChildren());
            this.getChildNode(node.getChildren(), allAdminOrg);
        }
    }

    private List<TreeNode> searchTreeNode(String searchText, List<TreeNode> treeNodes) {
        String sql = "SELECT o.fid,o.fname,t.fparentid,o.fnumber from t_org_structure t  left join T_ORG_ORG o  on t.forgid=o.fid  where t.FVIEWID = ? and (o.fname like ? or o.fnumber like ?) order by flevel,flongnumber asc";
        Object[] params = new SqlParameter[]{new SqlParameter(":fviewid", 12, (Object)Long.valueOf("01")), new SqlParameter(":fname", 12, (Object)("%" + searchText + "%")), new SqlParameter(":fnumber", 12, (Object)("%" + searchText + "%"))};
        treeNodes = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<TreeNode>>(){

            public List<TreeNode> handle(ResultSet rs) throws SQLException {
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
                String format = OrgUnitServiceHelper.getOrgTreeNodeFormat();
                while (rs.next()) {
                    String id = rs.getString(1);
                    String name = rs.getString(2);
                    String parentid = rs.getString(3);
                    String number = rs.getString(4);
                    String formatName = OrgUnitServiceHelper.formatOrgTreeNodeName((String)number, (String)name, (String)format);
                    TreeNode treeNode = new TreeNode(parentid, id, formatName);
                    treeNodes.add(treeNode);
                }
                return treeNodes;
            }
        });
        return treeNodes;
    }

    private void hanleMultiSearchResult(List<TreeNode> treeNodes, String searchText) {
        String oldSearchText = this.getPageCache().get(this.getView().getPageId() + SEARCHTEXTKEY);
        String selectedNodeKey = SELECTED_NODEKEY_PRE + this.getView().getPageId();
        if (null != oldSearchText && searchText.equals(oldSearchText)) {
            String oldSelectedNodeId = this.getPageCache().get(selectedNodeKey);
            for (int i = 0; i < treeNodes.size(); ++i) {
                TreeNode node = treeNodes.get(i);
                String orgId = node.getId();
                if (!orgId.equals(oldSelectedNodeId)) continue;
                int index = i + 1 >= treeNodes.size() ? 0 : i + 1;
                TreeNode nextNode = treeNodes.get(index);
                String nextNodeId = nextNode.getId();
                this.focusAndExpandParentNode(nextNode);
                this.getPageCache().put(selectedNodeKey, nextNodeId);
                return;
            }
        } else {
            TreeNode node = treeNodes.get(0);
            String orgId = node.getId();
            this.focusAndExpandParentNode(node);
            this.getPageCache().put(this.getView().getPageId() + SEARCHTEXTKEY, searchText);
            this.getPageCache().put(selectedNodeKey, orgId);
            return;
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!QueryServiceHelper.exists((String)"bos_org", null)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5728\u4f01\u4e1a\u5efa\u6a21\u521b\u5efa\u884c\u653f\u7ec4\u7ec7\u3002", (String)"WorkCalendarEditPlugin_0", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterBindData(EventObject eventobject) {
        if (this.getModel().getValue("year") == null || String.valueOf(this.getModel().getDataEntity().get("year")).trim().length() == 0) {
            this.setCurYear(Calendar.getInstance().get(1));
        }
        this.initOrgTree();
        if (this.isExistCalendar()) {
            int year = Integer.parseInt(String.valueOf(this.getModel().getValue("year")));
            this.loadWorkCalendar(year);
        } else {
            if (!this.hasWorkCalendarPerm()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u7684\u201c\u5de5\u4f5c\u65e5\u5386\u8bbe\u7f6e\u201d\u7684\u76f8\u5173\u6743\u9650\u3002", (String)WORKCALENDAREDITPLUGIN_2, (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6ca1\u6709\u5de5\u4f5c\u65e5\u5386\u6570\u636e\uff0c\u662f\u5426\u73b0\u5728\u5f00\u59cb\u521d\u59cb\u5316\uff1f", (String)"WorkCalendarEditPlugin_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IS_INIT_CALLBACK, (IFormPlugin)this));
        }
        List<TreeNode> adminOrgMap = this.getAllAdminOrg();
        try {
            String orgStr = SerializationUtils.toJsonString(adminOrgMap);
            logger.info("\u538b\u7f29\u524d\u5b57\u8282\u6570" + orgStr.getBytes().length);
            String compressOrgStr = GzipUtils.compress((String)orgStr, (String)"UTF-8");
            logger.info("\u538b\u7f29\u540e\u5b57\u8282\u6570" + compressOrgStr.getBytes().length);
            this.getView().getPageCache().put(this.getView().getPageId() + ALL_ADMINORG_KEY, compressOrgStr);
        }
        catch (IOException e) {
            logger.error("\u884c\u653f\u7ec4\u7ec7\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    private boolean isExistCalendar() {
        QFilter[] qf = new QFilter[]{new QFilter(ISINDIVIDUATION, "=", (Object)"0")};
        return QueryServiceHelper.exists((String)BD_WORKCALENDAR, (QFilter[])qf);
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        String orgId = this.getFocusOrdId();
        int year = Integer.parseInt(String.valueOf(this.getModel().getValue("year")));
        if (callBackId.equals(IS_INIT_CALLBACK)) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", "");
                params.put(ORGID, orgId);
                params.put("year", this.getModel().getValue("year"));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, RELOAD);
                this.showForm(BD_WORKCALENDAR, params, closeCallBack, ShowType.Modal);
            } else if (mbce.getResult().equals((Object)MessageBoxResult.Cancel)) {
                this.getView().close();
            }
        } else if (IS_COPY_LASTYEAR_CALLBACK.equalsIgnoreCase(callBackId)) {
            int nextyear = year + 1;
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.generateNextYearEntry(nextyear);
                this.setCurYear(nextyear);
                this.loadWorkCalendar(nextyear);
            }
        } else if (WARNING_CONFIRM.equals(callBackId) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            QFilter[] qf = new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(this.getFocusOrdId()))};
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_workcalendar_init", (String)"id", (QFilter[])qf);
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("bd_workcalendar_init");
            if (dynamicObject != null) {
                showParameter.setPkId((Object)dynamicObject.getLong("id"));
            }
            showParameter.setCustomParam(ORGID, (Object)this.getFocusOrdId());
            showParameter.setCustomParam("year", this.getModel().getValue("year"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        int year = Calendar.getInstance().get(1);
        this.setCurYear(year);
        if (!this.loadWorkCalendar(year)) {
            this.loadEmptyWorkCalendar(year);
        }
    }

    private String getFocusOrdId() {
        TreeView orgtree = (TreeView)this.getControl(ORGTREE);
        Map map = orgtree.getTreeState().getFocusNode();
        String orgId = (String)map.get("id");
        this.getModel().setValue("org", (Object)orgId);
        return orgId;
    }

    public void queryTreeNodeChildren(TreeNodeEvent nodeEvent) {
        List adminOrgList;
        long nodeId = Long.parseLong(nodeEvent.getNodeId().toString());
        TreeView tvLeft = (TreeView)this.getControl(ORGTREE);
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("01");
        param.setId(nodeId);
        ArrayList<TreeNode> childList = new ArrayList<TreeNode>(16);
        String checkedNodesStr = this.getPageCache().get(this.getView().getPageId() + ALL_ADMINORG_KEY);
        if (StringUtils.isEmpty((CharSequence)checkedNodesStr)) {
            nodeEvent.setCancel(true);
            return;
        }
        try {
            adminOrgList = (List)SerializationUtils.fromJsonString((String)GzipUtils.uncompress((String)checkedNodesStr, (String)"UTF-8"), List.class);
        }
        catch (IOException e) {
            logger.error("\u884c\u653f\u7ec4\u7ec7\u7f13\u5b58\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            return;
        }
        TreeNode childNode = null;
        for (int i = 0; i < adminOrgList.size(); ++i) {
            LinkedHashMap map = (LinkedHashMap)adminOrgList.get(i);
            String parentId = (String)map.get("parentid");
            if (nodeId != Long.parseLong(parentId)) continue;
            String name = (String)map.get("text");
            String id = (String)map.get("id");
            childNode = new TreeNode(parentId, id, name);
            List cChildList = (List)JSONArray.toJSON(map.get("children"));
            childNode.setChildren(cChildList);
            childList.add(childNode);
        }
        if (!childList.isEmpty()) {
            tvLeft.addNodes(childList);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String orgId = this.getFocusOrdId();
        int year = Integer.parseInt(String.valueOf(this.getModel().getValue("year")));
        if (c.getKey().toLowerCase().startsWith("setworkcalendar")) {
            if (!this.hasWorkCalendarPerm()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u7684\u201c\u5de5\u4f5c\u65e5\u5386\u8bbe\u7f6e\u201d\u7684\u76f8\u5173\u6743\u9650\u3002", (String)WORKCALENDAREDITPLUGIN_2, (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.setWorkCalendar(orgId);
        } else if ("initworkcalendar".equals(c.getKey())) {
            if (!this.hasWorkCalendarPerm()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u7684\u201c\u5de5\u4f5c\u65e5\u5386\u8bbe\u7f6e\u201d\u7684\u76f8\u5173\u6743\u9650\u3002", (String)WORKCALENDAREDITPLUGIN_2, (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.openInitWorkCalendar();
        } else if (c.getKey().toLowerCase().startsWith("preyear")) {
            this.preyear(year);
        } else if (c.getKey().toLowerCase().startsWith("nextyear")) {
            if (!this.hasWorkCalendarPerm()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u7684\u201c\u5de5\u4f5c\u65e5\u5386\u8bbe\u7f6e\u201d\u7684\u76f8\u5173\u6743\u9650\u3002", (String)WORKCALENDAREDITPLUGIN_2, (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.nextyear(orgId, year);
        } else if (c.getKey().toLowerCase().startsWith(WORKCALENDARAP)) {
            WorkCalendar workCalendar = (WorkCalendar)this.getControl(WORKCALENDARAP);
            if (!this.hasWorkCalendarPerm()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u7684\u201c\u5de5\u4f5c\u65e5\u5386\u8bbe\u7f6e\u201d\u7684\u76f8\u5173\u6743\u9650\u3002", (String)WORKCALENDAREDITPLUGIN_2, (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.markWorkCalendar(workCalendar, this.getFocusOrdId());
        } else if (c.getKey().toLowerCase().startsWith("syncworkcalendar")) {
            if (!this.hasWorkCalendarPerm()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u7684\u201c\u5de5\u4f5c\u65e5\u5386\u8bbe\u7f6e\u201d\u7684\u76f8\u5173\u6743\u9650\u3002", (String)WORKCALENDAREDITPLUGIN_2, (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.syncWorkCalendar();
        }
    }

    private void syncWorkCalendar() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("bd_workcalendar_agreement");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bd_workcalendar_agreement"));
        this.getView().showForm(formShowParameter);
    }

    private void nextyear(String orgId, int year) {
        int nextyear = year + 1;
        Object curId = this.getModel().getValue("id");
        if (this.loadWorkCalendar(nextyear) || StringUtils.isBlank((Object)curId)) {
            this.setCurYear(nextyear);
        } else {
            this.getModel().setValue("id", curId);
            this.getModel().setValue("dataorg", (Object)orgId);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u5e74\u5de5\u4f5c\u65e5\u5386\u4e0d\u5b58\u5728\uff0c\u662f\u5426\u590d\u5236\u4e0a\u4e00\u5e74\u5de5\u4f5c\u65e5\u5386\uff1f", (String)"WorkCalendarEditPlugin_5", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), nextyear), MessageBoxOptions.YesNo, new ConfirmCallBackListener(IS_COPY_LASTYEAR_CALLBACK, (IFormPlugin)this));
        }
    }

    private void preyear(int year) {
        int lastyear = year - 1;
        Object curId = this.getModel().getValue("id");
        if (this.loadWorkCalendar(lastyear)) {
            this.setCurYear(lastyear);
        } else if (year > Calendar.getInstance().get(1)) {
            this.loadEmptyWorkCalendar(lastyear);
        } else {
            this.getModel().setValue("id", curId);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e%s\u5e74\u7684\u5de5\u4f5c\u65e5\u5386\u3002", (String)"WorkCalendarEditPlugin_12", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), String.valueOf(year - 1)));
            return;
        }
    }

    private void setWorkCalendar(String orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String id = "";
        ORM orm = ORM.create();
        QFilter[] qf = new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(orgId)), new QFilter(ISINDIVIDUATION, "=", (Object)"0")};
        DynamicObject col = orm.queryOne(BD_WORKCALENDAR, "id", qf);
        if (col != null) {
            id = col.getString("id");
        }
        this.getModel().setValue("id", (Object)id);
        this.getModel().setValue("dataorg", (Object)orgId);
        params.put("id", id);
        params.put(ORGID, this.getFocusOrdId());
        params.put("year", this.getModel().getValue("year"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, RELOAD);
        this.showForm(BD_WORKCALENDAR, params, closeCallBack, ShowType.Modal);
    }

    private void openInitWorkCalendar() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5386\u53f2\u671f\u95f4\u8bbe\u7f6e\u540e\u5c06\u65e0\u6cd5\u4fee\u6539\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"WorkCalendarEditPlugin_14", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(WARNING_CONFIRM));
    }

    private void markWorkCalendar(WorkCalendar workCalendar, String orgId) {
        ArrayList dateList = workCalendar.getDateList();
        if (!this.markDateValidate(dateList)) {
            return;
        }
        String dateType = workCalendar.getDateType();
        this.recordMarkWorkCalendar(orgId, dateList, dateType, null);
        workCalendar.setDateTypeCallBack((List)dateList, dateType);
    }

    public void recordMarkWorkCalendar(String orgId, List<String> dateList, String dateType, Boolean isSkip) {
        boolean haveWorkCalendar;
        QFilter[] filters = new QFilter[2];
        filters[0] = new QFilter("org", "=", (Object)Long.valueOf(orgId));
        ORM orm = ORM.create();
        filters[1] = new QFilter(ISINDIVIDUATION, "=", (Object)"1");
        DynamicObjectCollection workCalendarCol = orm.query(BD_WORKCALENDAR, "id, dateentry.*", filters);
        boolean bl = haveWorkCalendar = workCalendarCol != null && workCalendarCol.size() != 0;
        if (haveWorkCalendar) {
            this.modifyCurrentWorkCalendar(dateList, dateType, orm, workCalendarCol, isSkip);
        } else {
            try {
                this.addIdentifyWorkCalendar(orgId, dateList, dateType, orm);
            }
            catch (ParseException e) {
                logger.info("ParseException", (Object)e);
            }
        }
    }

    private void addIdentifyWorkCalendar(String orgId, List<String> dateList, String dateType, ORM orm) throws ParseException {
        DynamicObject[] insertedObjs;
        DynamicObject obj = orm.newDynamicObject(BD_WORKCALENDAR);
        obj.set("org", (Object)Long.valueOf(orgId));
        obj.set(ISINDIVIDUATION, (Object)"1");
        this.genEntityCommon(obj, orgId);
        for (DynamicObject newObj : insertedObjs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj})) {
            DynamicObjectCollection dateentry = newObj.getDynamicObjectCollection(DATEENTRY);
            for (int i = 0; i < dateList.size(); ++i) {
                DynamicObject row = new DynamicObject(dateentry.getDynamicObjectType());
                row.set("seq", (Object)i);
                row.set(WORKDATE, (Object)SDF.parse(dateList.get(i)));
                row.set(DATETYPE, (Object)dateType);
                dateentry.add((Object)row);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
        }
    }

    private void modifyCurrentWorkCalendar(List<String> dateList, String dateType, ORM orm, DynamicObjectCollection workCalendarCol, Boolean isSkip) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)BD_WORKCALENDAR);
        EntryProp entryProp = (EntryProp)met.getProperty(DATEENTRY);
        EntryType entryType = (EntryType)entryProp.getItemType();
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(workCalendarCol.size());
        for (DynamicObject obj : workCalendarCol) {
            DynamicObjectCollection dateentry = obj.getDynamicObjectCollection(DATEENTRY);
            if (dateentry == null) continue;
            List<Map<String, Object>> recordDateList = this.removeDuplicateMarkRecord(dateentry, dateList, dateType, isSkip);
            int index = 1;
            for (Map<String, Object> dateMap : recordDateList) {
                DynamicObject newObj = new DynamicObject((DynamicObjectType)entryType, null);
                newObj.set("seq", (Object)index++);
                newObj.set(WORKDATE, dateMap.get(WORKDATE));
                newObj.set(DATETYPE, dateMap.get(DATETYPE));
                dateentry.add((Object)newObj);
            }
            objList.add(obj);
        }
        orm.update(objList);
    }

    private List<Map<String, Object>> removeDuplicateMarkRecord(DynamicObjectCollection dateentry, List<String> dateList, String dateType, Boolean isSkip) {
        HashMap<String, Object> oldDateMap;
        int oldCount = 0;
        if (dateentry != null) {
            oldCount = dateentry.size();
        }
        int newDateCount = dateList.size();
        ArrayList<Map<String, Object>> recordDateList = new ArrayList<Map<String, Object>>(oldCount + newDateCount);
        HashMap<String, String> newDateMap = new HashMap<String, String>(newDateCount);
        try {
            for (String date : dateList) {
                oldDateMap = new HashMap<String, Object>(2);
                oldDateMap.put(DATETYPE, dateType);
                oldDateMap.put(WORKDATE, SDF.parse(date));
                recordDateList.add(oldDateMap);
                newDateMap.put(date, dateType);
            }
        }
        catch (ParseException e) {
            logger.info(e.getMessage());
        }
        if (dateentry != null) {
            for (int i = oldCount - 1; i >= 0; --i) {
                DynamicObject newObj = (DynamicObject)dateentry.get(i);
                if (newDateMap.get(SDF.format(newObj.getDate(WORKDATE))) == null) {
                    oldDateMap = new HashMap(2);
                    oldDateMap.put(WORKDATE, newObj.getDate(WORKDATE));
                    oldDateMap.put(DATETYPE, newObj.get(DATETYPE));
                    recordDateList.add(oldDateMap);
                    dateentry.remove(i);
                    continue;
                }
                if (isSkip != null && isSkip.booleanValue()) {
                    recordDateList.removeIf(map -> map.get(WORKDATE).equals(newObj.getDate(WORKDATE)));
                    continue;
                }
                dateentry.remove(i);
            }
        }
        return recordDateList;
    }

    private boolean markDateValidate(List<String> dateList) {
        if (dateList == null || dateList.size() == 0) {
            return false;
        }
        boolean isSucess = true;
        String startDateStr = dateList.get(0);
        Calendar today = Calendar.getInstance();
        try {
            Date startDate = SDF.parse(startDateStr);
            if (today.getTime().getTime() > startDate.getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u6807\u6ce8\u660e\u5929\u53ca\u4e4b\u540e\u7684\u65e5\u5386\u3002", (String)"WorkCalendarEditPlugin_11", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                isSucess = false;
            } else {
                String endDateStr = dateList.get(dateList.size() - 1);
                Date endDate = SDF.parse(endDateStr);
                Date startvaliddate = (Date)this.getModel().getValue("startvaliddate");
                Date endvaliddate = (Date)this.getModel().getValue("endvaliddate");
                if (startvaliddate == null || endvaliddate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u7684\u5de5\u4f5c\u65e5\u5386\u5931\u8d25\uff0c\u8bf7\u5148\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u5386\u3002", (String)"WorkCalendarEditPlugin_7", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                    isSucess = false;
                }
                if (null != startvaliddate && null != endvaliddate && (startvaliddate.getTime() > startDate.getTime() || endvaliddate.getTime() < endDate.getTime())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6807\u6ce8\u5f53\u524d\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u6709\u6548\u671f\u95f4\u4e4b\u5916\u7684\u65e5\u5386\u3002", (String)"WorkCalendarEditPlugin_8", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                    isSucess = false;
                }
            }
        }
        catch (ParseException e) {
            logger.info(e.getMessage());
        }
        return isSucess;
    }

    private void initOrgTree() {
        TreeView orgtree = (TreeView)this.getControl(ORGTREE);
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("01");
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (root == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u5931\u8d25\u3002\u6ca1\u6709\u53ef\u7528\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u5230\u201c\u7ec4\u7ec7\u7ba1\u7406\u201d\u4e0b\u7684\u201c\u884c\u653f\u7ec4\u7ec7\u201d\u65b0\u589e\u3002", (String)"WorkCalendarEditPlugin_13", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        if (root.getChildren() == null) {
            root.setChildren(new ArrayList());
        }
        orgtree.addNode(root);
        root.setIsOpened(true);
        orgtree.focusNode(root);
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (this.getModel().getValue("id") != null && String.valueOf(this.getModel().getValue("id")).trim().length() != 0) {
            param.setPkId((Object)Long.parseLong((String)this.getModel().getValue("id")));
            Object orgId = params.get(ORGID);
            if (orgId != null && orgId.equals(this.getModel().getValue("dataorg"))) {
                param.setBillStatus(BillOperationStatus.EDIT);
            }
        }
        param.setCustomParams(params);
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private void loadEmptyWorkCalendar(int year) {
        this.setCurYear(year);
        WorkCalendar workCalendar = (WorkCalendar)this.getControl(WORKCALENDARAP);
        workCalendar.setYear(year);
        workCalendar.setData();
    }

    private boolean loadWorkCalendar(int year) {
        boolean isLoaded = false;
        String orgId = this.getFocusOrdId();
        HashMap<String, String> orgMap = new HashMap<String, String>();
        orgMap.put("org", orgId);
        List<Map<String, String>> workDataList = WorkCalendarLoadService.loadWorkCalendar(orgMap, year);
        this.getModel().setValue("dataorg", orgMap.get("dataorg"));
        if (workDataList != null && workDataList.size() > 0) {
            isLoaded = true;
            this.getModel().setValue("id", orgMap.get("id"));
            String startvaliddate = this.getMinDateFromWorkData(workDataList);
            String endvaliddate = this.getMaxDateFromWorkData(workDataList);
            this.getModel().setValue("startvaliddate", (Object)startvaliddate);
            this.getModel().setValue("endvaliddate", (Object)endvaliddate);
            WorkCalendar workCalendar = (WorkCalendar)this.getControl(WORKCALENDARAP);
            workCalendar.setYear(year);
            workCalendar.setWorkDataList(workDataList);
            workCalendar.setData();
        } else {
            this.getModel().setValue("id", (Object)"");
        }
        return isLoaded;
    }

    private String getMaxDateFromWorkData(List<Map<String, String>> workDataList) {
        String maxDate = null;
        if (CollectionUtils.isEmpty(workDataList)) {
            return maxDate;
        }
        maxDate = workDataList.get(0).get("workDate");
        for (Map<String, String> map : workDataList) {
            String workDate = map.get("workDate");
            try {
                if (SDF.parse(workDate).compareTo(SDF.parse(maxDate)) <= 0) continue;
                maxDate = workDate;
            }
            catch (ParseException e) {
                logger.error("getMaxDateFromWorkData error :" + e);
                return null;
            }
        }
        return maxDate;
    }

    private String getMinDateFromWorkData(List<Map<String, String>> workDataList) {
        String minDate = null;
        if (CollectionUtils.isEmpty(workDataList)) {
            return minDate;
        }
        minDate = workDataList.get(0).get("workDate");
        for (Map<String, String> map : workDataList) {
            String workDate = map.get("workDate");
            try {
                if (SDF.parse(workDate).compareTo(SDF.parse(minDate)) >= 0) continue;
                minDate = workDate;
            }
            catch (ParseException e) {
                logger.error("getMaxDateFromWorkData error :" + e);
                return null;
            }
        }
        return minDate;
    }

    private void setCurYear(int year) {
        this.getModel().setValue("year", (Object)year);
        Label label = (Label)this.getControl("yearshow");
        String text = ResManager.loadKDString((String)"%s\u5e74", (String)"WorkCalendarEditPlugin_18", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[]{year});
        label.setText(text);
    }

    private void generateNextYearEntry(int nextyear) {
        MainEntityType type;
        Object id = this.getModel().getValue("id");
        DynamicObject[] curWorkCalendarArr = BusinessDataServiceHelper.load((Object[])new Object[]{id}, (DynamicObjectType)(type = EntityMetadataCache.getDataEntityType((String)BD_WORKCALENDAR)));
        if (curWorkCalendarArr == null || curWorkCalendarArr.length == 0) {
            return;
        }
        DynamicObject curWorkCalendar = curWorkCalendarArr[0];
        curWorkCalendar.set("expiringyearto", (Object)nextyear);
        int month = 12;
        curWorkCalendar.set("expiringmonthto", (Object)month);
        DynamicObjectCollection dateentry = curWorkCalendar.getDynamicObjectCollection(DATEENTRY);
        if (dateentry != null && dateentry.size() > 0) {
            int seq = dateentry.size();
            DynamicObject lastObj = (DynamicObject)dateentry.get(seq - 1);
            Date lastWorkDate = lastObj.getDate(WORKDATE);
            Calendar smallDate = Calendar.getInstance();
            smallDate.setTime(lastWorkDate);
            smallDate.add(5, 1);
            Calendar bigDate = Calendar.getInstance();
            bigDate.set(nextyear, month - 1, 1, 0, 0, 0);
            bigDate.set(nextyear, month - 1, bigDate.getActualMaximum(5), 0, 0, 0);
            int days = TimeUtils.daysBetween(smallDate, bigDate);
            this.genCurWorkCalendarEntity(curWorkCalendar, dateentry, days, seq + 1, smallDate);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curWorkCalendar});
    }

    private void genEntityCommon(DynamicObject obj, String orgId) {
        obj.set("org", (Object)orgId);
        obj.set("createorg", (Object)orgId);
        obj.set("enable", (Object)"1");
        obj.set("status", (Object)"A");
        obj.set("creator", (Object)RequestContext.get().getUserId());
        Date date = new Date();
        obj.set("createtime", (Object)date);
        obj.set("modifier", (Object)RequestContext.get().getUserId());
        obj.set("modifytime", (Object)date);
        obj.set("minofendtimepm", (Object)0);
        obj.set("hourofendtimepm", (Object)0);
        obj.set("minofbegintimepm", (Object)0);
        obj.set("hourofbegintimepm", (Object)0);
        obj.set("minofendtimeam", (Object)0);
        obj.set("hourofendtimeam", (Object)0);
        obj.set("minofbegintimeam", (Object)0);
        obj.set("hourofbegintimeam", (Object)0);
    }

    private void genCurWorkCalendarEntity(DynamicObject curWorkCalendar, DynamicObjectCollection dateentry, int days, int seq, Calendar smallDate) {
        Object[] isRestDay = this.getRestDays(curWorkCalendar);
        Object[] isHalfWorkDay = this.getHalfWorkDays(curWorkCalendar);
        String orgId = String.valueOf(this.getModel().getValue("dataorg"));
        int year = smallDate.get(1);
        int nextYear = year + 1;
        Calendar nextYearCal = Calendar.getInstance();
        nextYearCal.set(1, nextYear);
        int nextYearDays = nextYearCal.getActualMaximum(6);
        int newxYearStart = days - nextYearDays;
        Map<String, Object> markDateMap = this.getMarkDateMap(orgId, year, days);
        Calendar curCal = Calendar.getInstance();
        ArrayList<String> dateList = new ArrayList<String>(markDateMap.size());
        ArrayList workDataList = new ArrayList();
        for (int i = 0; i < days; ++i) {
            DynamicObject row = new DynamicObject(dateentry.getDynamicObjectType());
            row.set("seq", (Object)(i + seq));
            Date workDate = smallDate.getTime();
            String workDateStr = SDF.format(workDate);
            row.set(WORKDATE, (Object)workDate);
            curCal.setTime(workDate);
            curCal.set(1, year);
            String workDateKey = SDF.format(curCal.getTime());
            Object dateTypeObj = markDateMap.get(workDateKey);
            if (dateTypeObj != null) {
                String dateType = String.valueOf(dateTypeObj);
                row.set(DATETYPE, (Object)dateType);
                dateList.add(workDateStr);
                this.recordMarkWorkCalendar(orgId, dateList, dateType, null);
                dateList.clear();
            } else {
                int curDate = smallDate.get(7) - 1;
                dateTypeObj = (Boolean)isRestDay[curDate] != false ? "4" : ((Boolean)isHalfWorkDay[curDate] != false ? "2" : "1");
                row.set(DATETYPE, dateTypeObj);
            }
            dateentry.add((Object)row);
            smallDate.add(5, 1);
            if (i < newxYearStart) continue;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("workDate", workDateStr);
            data.put("dateType", dateTypeObj == null ? "1" : dateTypeObj.toString());
            workDataList.add(data);
        }
        WorkCalendar workCalendar = (WorkCalendar)this.getControl(WORKCALENDARAP);
        workCalendar.setYear(nextYear);
        workCalendar.setWorkDataList(workDataList);
        workCalendar.setData();
    }

    private Map<String, Object> getMarkDateMap(String orgId, int year, int days) {
        Calendar startDate = Calendar.getInstance();
        startDate.set(year, 0, 1);
        Calendar endDate = Calendar.getInstance();
        endDate.add(5, days);
        endDate.set(year, 11, 31);
        Map<String, Object> markDateMap = WorkCalendarLoadService.getMarkDateMap(orgId, SDF.format(startDate.getTime()), SDF.format(endDate.getTime()));
        return markDateMap;
    }

    private Object[] getRestDays(DynamicObject obj) {
        Object[] isRestDay = new Object[]{obj.get("issunrest"), obj.get("ismonrest"), obj.get("istuerest"), obj.get("iswedrest"), obj.get("isthurest"), obj.get("isfrirest"), obj.get("issatrest")};
        return isRestDay;
    }

    private Object[] getHalfWorkDays(DynamicObject obj) {
        Object[] isHalfWorkDay = new Object[]{obj.get("ishalfsunrest"), obj.get("ishalfmonrest"), obj.get("ishalftuerest"), obj.get("ishalfwedrest"), obj.get("ishalfthurest"), obj.get("ishalffrirest"), obj.get("ishalfsatrest")};
        return isHalfWorkDay;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map hashMap;
        Boolean agree;
        if (RELOAD.equals(e.getActionId())) {
            if (this.isExistCalendar()) {
                int year = Calendar.getInstance().get(1);
                this.setCurYear(year);
                if (!this.loadWorkCalendar(year)) {
                    this.loadEmptyWorkCalendar(year);
                }
            } else {
                this.getView().close();
            }
        }
        if ("bd_workcalendar_agreement".equals(e.getActionId()) && (agree = (Boolean)e.getReturnData()) != null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("bd_workcalendar_sync");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bd_workcalendar_sync"));
            this.getView().showForm(formShowParameter);
        }
        if ("bd_workcalendar_sync".equals(e.getActionId()) && (hashMap = (Map)e.getReturnData()) != null) {
            String msg;
            boolean flag = false;
            if ("success".equals(hashMap.get("status"))) {
                try {
                    AtomicBoolean isEmpty = new AtomicBoolean(true);
                    Map holidayDetail = (Map)hashMap.get("data");
                    if (!holidayDetail.isEmpty()) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        HashMap<Object, List> collect = new HashMap<Object, List>(16);
                        Date min = null;
                        Date max = null;
                        for (Map.Entry entry : holidayDetail.entrySet()) {
                            Date date = format.parse((String)entry.getKey());
                            ArrayList dateList = (ArrayList)collect.get(entry.getValue());
                            if (dateList == null) {
                                dateList = new ArrayList();
                            }
                            if (min == null) {
                                min = date;
                                max = date;
                            } else if (date.before(min)) {
                                min = date;
                            } else if (date.after(max)) {
                                max = date;
                            }
                            dateList.add(entry.getKey());
                            collect.put(entry.getValue(), dateList);
                        }
                        HashMap<String, String> orgMap = new HashMap<String, String>();
                        String focusOrdId = this.getFocusOrdId();
                        orgMap.put("org", focusOrdId);
                        List<Map<String, String>> workDataList = WorkCalendarLoadService.loadWorkCalendar(orgMap, format.format(min), format.format(max));
                        List workDate = workDataList.stream().map(v -> (String)v.get("workDate")).collect(Collectors.toList());
                        collect.forEach((k, v) -> {
                            v.retainAll(workDate);
                            if (!v.isEmpty()) {
                                isEmpty.set(false);
                                this.recordMarkWorkCalendar(focusOrdId, (List<String>)v, (String)k, null);
                            }
                        });
                    }
                    if (isEmpty.get()) {
                        String msg2 = ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff0c\u672a\u627e\u5230\u7b26\u5408\u540c\u6b65\u89c4\u5219\u7684\u516c\u5171\u5047\u671f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WorkCalendarEditPlugin_17", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
                        this.getView().showTipNotification(msg2);
                        return;
                    }
                    flag = true;
                }
                catch (Exception exception) {
                    logger.error("\u516c\u5171\u5047\u671f\u5728\u7ebf\u540c\u6b65\u5931\u8d25", (Throwable)exception);
                }
            }
            if (flag) {
                msg = ResManager.loadKDString((String)"\u516c\u5171\u5047\u671f\u5728\u7ebf\u540c\u6b65\u6210\u529f\u3002", (String)"WorkCalendarEditPlugin_15", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg);
                int year = Integer.parseInt(String.valueOf(this.getModel().getValue("year")));
                this.loadWorkCalendar(year);
            } else {
                msg = ResManager.loadKDString((String)"\u516c\u5171\u5047\u671f\u5728\u7ebf\u540c\u6b65\u5931\u8d25\u3002", (String)"WorkCalendarEditPlugin_16", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
        }
    }

    private boolean hasWorkCalendarPerm() {
        String orgId = this.getFocusOrdId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appId = this.getView().getFormShowParameter().getAppId();
        int hasNewPerm = PermissionServiceHelper.checkPermission((Long)userId, (Long)Long.valueOf(orgId), (String)appId, (String)BD_WORKCALENDAR, (String)"47156aff000000ac");
        int hasDodifyPerm = PermissionServiceHelper.checkPermission((Long)userId, (Long)Long.valueOf(orgId), (String)appId, (String)BD_WORKCALENDAR, (String)"4715a0df000000ac");
        int hasViewPerm = PermissionServiceHelper.checkPermission((Long)userId, (Long)Long.valueOf(orgId), (String)appId, (String)BD_WORKCALENDAR, (String)"47150e89000000ac");
        return hasNewPerm == 1 && hasDodifyPerm == 1 && hasViewPerm == 1;
    }
}

