/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.basedata.WorkCalendarEditPlugin;
import kd.bd.assistant.plugin.util.TimeUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class WorkCalendarEntityPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(WorkCalendarEntityPlugin.class);
    private static final int DEFAULT_YEAR_COUNT = 100;
    public final SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
    private static final String EXPIRING_YEAR_FROM = "expiringyearfrom";
    private static final String EXPIRING_MONTH_FROM = "expiringmonthfrom";
    private static final String EXPIRING_YEAR_TO = "expiringyearto";
    private static final String BOS_BD_FORMPLUGIN = "bos-bd-formplugin";
    private static final String EXPIRING_MONTH_TO = "expiringmonthto";
    private static final String DATEENTRY = "dateEntry";
    private static final String WORKDATE = "workdate";
    private static final String DATETYPE = "datetype";

    public void initialize() {
        this.addClickListeners(new String[]{"btnsave"});
        this.initProperty();
    }

    public void afterCreateNewData(EventObject e) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("bd_workcalendar".equals(formId)) {
            Calendar cal = Calendar.getInstance();
            this.getModel().setValue(EXPIRING_YEAR_FROM, (Object)cal.get(1));
            this.getModel().setValue(EXPIRING_MONTH_FROM, (Object)(cal.get(2) + 1));
        }
        this.editOrgId();
    }

    private void initProperty() {
        String formId = this.getView().getFormShowParameter().getFormId();
        Calendar cal = Calendar.getInstance();
        int currentYear = cal.get(1);
        if ("bd_workcalendar".equals(formId)) {
            this.genYearComboItems(EXPIRING_YEAR_FROM, currentYear, currentYear + 100);
            this.genYearComboItems(EXPIRING_YEAR_TO, currentYear, currentYear + 100);
        } else {
            this.genYearComboItems(EXPIRING_YEAR_FROM, currentYear - 3, currentYear);
            this.genYearComboItems(EXPIRING_YEAR_TO, currentYear - 3, currentYear);
        }
    }

    private void genYearComboItems(String propertyName, int startYear, int endYear) {
        ComboEdit propertyField = (ComboEdit)this.getControl(propertyName);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(endYear - startYear);
        for (int i = startYear; i <= endYear; ++i) {
            String month = String.valueOf(i);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(month));
            comboItem.setValue(month);
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (!(source instanceof AbstractOperate)) {
            return;
        }
        AbstractOperate op = (AbstractOperate)source;
        if ("save".equalsIgnoreCase(op.getOperateKey())) {
            if (!this.getModel().getDataChanged()) {
                args.cancel = true;
                this.getView().close();
                return;
            }
            String formId = this.getView().getFormShowParameter().getFormId();
            if ("bd_workcalendar".equals(formId)) {
                if (this.validate()) {
                    log.debug("\u5f00\u59cb\u4fdd\u5b58\u6570\u636e");
                    this.editOrgId();
                    this.generateDate();
                } else {
                    args.cancel = true;
                }
            } else if ("bd_workcalendar_init".equals(formId)) {
                if (this.initValidate()) {
                    List<String> monthList = this.isExistCalendarDetail();
                    if (!monthList.isEmpty()) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5931\u8d25\u3002\u5df2\u7ecf\u8bbe\u7f6e\u7684\u5386\u53f2\u671f\u95f4\u4e0d\u80fd\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u671f\u95f4\u3002\u4ee5\u4e0b\u671f\u95f4\u5df2\u7ecf\u5b58\u5728\u65e5\u5386\u6570\u636e\uff1a", (String)"WorkCalendarEntityPlugin_11", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), String.join((CharSequence)"\n", monthList), MessageTypes.Default);
                        args.setCancel(true);
                    }
                } else {
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("bd_workcalendar_init".equals(formId) && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            boolean isSkip = true;
            this.initGenerateDate(isSkip);
            this.individuationData(isSkip);
            this.getModel().setDataChanged(false);
        }
    }

    private void editOrgId() {
        Object orgId = this.getView().getFormShowParameter().getCustomParam("orgId");
        this.getModel().setValue("org", orgId);
        this.getModel().setValue("createorg", orgId);
    }

    private void individuationData(boolean isSkip) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        WorkCalendarEditPlugin calendarEditPlugin = new WorkCalendarEditPlugin();
        for (DynamicObject dy : entryentity) {
            Date startDate = dy.getDate("startdate");
            Date endDate = dy.getDate("enddate");
            String dateType = dy.getString("datetype1");
            List<String> dateList = WorkCalendarEntityPlugin.findEveryDay(startDate, endDate);
            calendarEditPlugin.recordMarkWorkCalendar(((DynamicObject)this.getModel().getValue("org")).getString("id"), dateList, dateType, isSkip);
        }
    }

    public static List<String> findEveryDay(Date dBegin, Date dEnd) {
        ArrayList<String> dates = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (dBegin != null && dEnd != null) {
            dates.add(sdf.format(dBegin));
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(dBegin);
            while (dEnd.after(calBegin.getTime())) {
                calBegin.add(5, 1);
                dates.add(sdf.format(calBegin.getTime()));
            }
        }
        return dates;
    }

    private boolean initValidate() {
        if (!this.dateExclusionValidate()) {
            return false;
        }
        if (!this.amTimeValidate()) {
            return false;
        }
        if (!this.pmTimeValidate()) {
            return false;
        }
        DynamicObject obj = this.getDynamicObject();
        if (obj.get(EXPIRING_YEAR_FROM) == null || obj.get(EXPIRING_MONTH_FROM) == null || obj.get(EXPIRING_YEAR_TO) == null || obj.get(EXPIRING_MONTH_TO) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkCalendarEntityPlugin_5", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        int yearFrom = obj.getInt(EXPIRING_YEAR_FROM);
        int monthFrom = obj.getInt(EXPIRING_MONTH_FROM);
        int yearTo = obj.getInt(EXPIRING_YEAR_TO);
        int monthTo = obj.getInt(EXPIRING_MONTH_TO);
        if (yearTo < yearFrom || yearTo == yearFrom && monthTo < monthFrom) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"WorkCalendarEntityPlugin_7", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        Calendar currDate = Calendar.getInstance();
        int currYear = currDate.get(1);
        int currMonth = currDate.get(2);
        if (yearTo > currYear || currYear == yearTo && monthTo > currMonth + 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"WorkCalendarEntityPlugin_13", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        if (!this.dateIsOverlapValidate(entity)) {
            return false;
        }
        Calendar fromDate = Calendar.getInstance();
        fromDate.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
        fromDate.set(14, 0);
        Calendar toDate = Calendar.getInstance();
        toDate.set(yearTo, monthTo - 1, toDate.getActualMaximum(5), 0, 0, 0);
        toDate.set(14, 0);
        return this.dateInValidate(entity, fromDate.getTime(), toDate.getTime());
    }

    private boolean dateIsOverlapValidate(DynamicObjectCollection entity) {
        for (int i = 0; i < entity.size() - 1; ++i) {
            for (int j = i + 1; j < entity.size(); ++j) {
                DynamicObject dy = (DynamicObject)entity.get(i);
                DynamicObject dy1 = (DynamicObject)entity.get(j);
                if (dy == null || dy1 == null) continue;
                Date startdate = dy.getDate("startdate");
                Date startdate1 = dy1.getDate("startdate");
                Date enddate = dy.getDate("enddate");
                Date enddate1 = dy1.getDate("enddate");
                if (startdate == null || startdate1 == null || enddate == null || enddate1 == null || startdate.after(enddate1) || enddate.before(startdate1)) continue;
                String message = ResManager.loadKDString((String)"\u4f8b\u5916\u65e5\u671f\u7b2c%1$s\u884c\u548c\u7b2c%2$s\u884c\u7684\u6709\u6548\u671f\u91cd\u53e0\uff0c\u8bf7\u68c0\u67e5\u5e76\u66f4\u6539\u65e5\u671f\u8303\u56f4\u3002", (String)"WorkCalendarEntityPlugin_10", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(message, i + 1, j + 1));
                return false;
            }
        }
        return true;
    }

    private boolean dateInValidate(DynamicObjectCollection entity, Date fromDate, Date toDate) {
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entity.get(i);
            if (dynamicObject == null) continue;
            Date startdate = dynamicObject.getDate("startdate");
            Date enddate = dynamicObject.getDate("enddate");
            if (startdate == null || enddate == null || !startdate.before(fromDate) && !enddate.after(toDate)) continue;
            String message = ResManager.loadKDString((String)"\u4f8b\u5916\u65e5\u671f\u7b2c%s\u884c\u4e0d\u5728\u6709\u6548\u671f\u95f4\u5185\uff0c\u8bf7\u68c0\u67e5\u5e76\u66f4\u6539\u65e5\u671f\u8303\u56f4\u3002", (String)"WorkCalendarEntityPlugin_12", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(message, i + 1));
            return false;
        }
        return true;
    }

    private List<String> isExistCalendarDetail() {
        DynamicObject obj = this.getDynamicObject();
        int yearFrom = obj.getInt(EXPIRING_YEAR_FROM);
        int monthFrom = obj.getInt(EXPIRING_MONTH_FROM);
        int yearTo = obj.getInt(EXPIRING_YEAR_TO);
        int monthTo = obj.getInt(EXPIRING_MONTH_TO);
        Calendar fromDate = Calendar.getInstance();
        fromDate.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
        fromDate.set(14, 0);
        Calendar toDate = Calendar.getInstance();
        toDate.set(yearTo, monthTo - 1, 1, 0, 0, 0);
        toDate.set(yearTo, monthTo - 1, toDate.getActualMaximum(5), 0, 0, 0);
        toDate.set(14, 0);
        Calendar currDate = Calendar.getInstance();
        if (toDate.after(currDate)) {
            toDate.set(currDate.get(1), currDate.get(2), currDate.get(5) - 1);
            this.getModel().setValue(EXPIRING_MONTH_TO, (Object)(currDate.get(2) + 1));
            if (currDate.get(5) == 1) {
                toDate.set(currDate.get(1), currDate.get(2) - 1, toDate.getActualMaximum(5));
                this.getModel().setValue(EXPIRING_MONTH_TO, (Object)currDate.get(2));
            }
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        List<Calendar> monthList = this.getOverlapMonthList(fromDate, toDate, format);
        return this.getFormatDateIntervalList(monthList, format);
    }

    private List<Calendar> getOverlapMonthList(Calendar fromDate, Calendar toDate, SimpleDateFormat format) {
        long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        QFilter[] qFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("isindividuation", "=", (Object)"0")};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_workcalendar", (String)"id, workdate, dateentry", (QFilter[])qFilters);
        if (dynamicObject != null) {
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("dateentry");
            List dyList = collection.stream().filter(entry -> !entry.getDate(WORKDATE).after(toDate.getTime()) && !entry.getDate(WORKDATE).before(fromDate.getTime())).collect(Collectors.toList());
            Map<Date, Long> dateMap = dyList.stream().map(v -> {
                try {
                    return format.parse(v.getString(WORKDATE));
                }
                catch (ParseException e) {
                    log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5931\u8d25");
                    return null;
                }
            }).collect(Collectors.groupingBy(e -> e, Collectors.counting()));
            Iterator<Map.Entry<Date, Long>> iterator = dateMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Date, Long> entry2 = iterator.next();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(entry2.getKey());
                if (calendar.get(2) == toDate.get(2)) {
                    if (entry2.getValue() == (long)toDate.get(5)) continue;
                    iterator.remove();
                    continue;
                }
                if (entry2.getValue().equals(calendar.getActualMaximum(5))) continue;
                iterator.remove();
            }
            ArrayList<Calendar> monthList = new ArrayList<Calendar>(10);
            for (Date date : dateMap.keySet()) {
                if (date.before(fromDate.getTime()) || date.after(toDate.getTime())) continue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                monthList.add(calendar);
            }
            return monthList.stream().sorted().collect(Collectors.toList());
        }
        return new ArrayList<Calendar>(10);
    }

    private List<String> getFormatDateIntervalList(List<Calendar> monthList, SimpleDateFormat format) {
        ArrayList dateMapList = new ArrayList();
        int flag = 0;
        for (int i = 0; i < monthList.size() - 1; ++i) {
            if (i == 0) {
                HashMap<String, String> dateMap = new HashMap<String, String>();
                dateMap.put("startDate", format.format(monthList.get(0).getTime()));
                dateMap.put("endDate", format.format(monthList.get(0).getTime()));
                dateMapList.add(dateMap);
            }
            Calendar calendar = monthList.get(i);
            calendar.add(2, 1);
            if (calendar.equals(monthList.get(i + 1))) {
                Map map = (Map)dateMapList.get(flag);
                map.put("startDate", map.get("startDate"));
                map.put("endDate", format.format(monthList.get(i + 1).getTime()));
                continue;
            }
            ++flag;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("startDate", format.format(monthList.get(i + 1).getTime()));
            hashMap.put("endDate", format.format(monthList.get(i + 1).getTime()));
            dateMapList.add(hashMap);
        }
        ArrayList<String> finalDateList = new ArrayList<String>(10);
        for (Map map : dateMapList) {
            finalDateList.add((String)map.get("startDate") + " \uff5e " + (String)map.get("endDate"));
        }
        if (monthList.size() == 1) {
            finalDateList.add(format.format(monthList.get(0).getTime()));
        }
        return finalDateList;
    }

    private boolean validate() {
        if (!this.dateExclusionValidate()) {
            return false;
        }
        if (!this.amTimeValidate()) {
            return false;
        }
        if (!this.pmTimeValidate()) {
            return false;
        }
        return this.expiringDateValidate();
    }

    private boolean dateExclusionValidate() {
        boolean[] isHalfWorkDay;
        boolean result = true;
        boolean[] isRestDay = this.getRestDays(this.getModel());
        if (isRestDay.length != (isHalfWorkDay = this.getHalfWorkDays(this.getModel())).length) {
            return result;
        }
        for (int i = 0; i < isRestDay.length; ++i) {
            if (!isRestDay[i] || !isHalfWorkDay[i]) continue;
            result = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u4f11\u606f\u65e5\u548c\u534a\u5929\u5de5\u4f5c\u65e5\u4e0d\u80fd\u52fe\u9009\u540c\u4e00\u5929\u3002", (String)"WorkCalendarEntityPlugin_0", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            break;
        }
        return result;
    }

    private boolean amTimeValidate() {
        boolean result = false;
        DynamicObject obj = this.getDynamicObject();
        if (this.validateNotNull(obj)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0a\u5348\u65f6\u95f4\u5fc5\u987b\u5f55\u5165\u3002", (String)"WorkCalendarEntityPlugin_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return result;
        }
        result = TimeUtils.compareHourAndMinute(obj.getInt("hourofbegintimeam"), obj.getInt("minofbegintimeam"), obj.getInt("hourofendtimeam"), obj.getInt("minofendtimeam"));
        if (!result) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5de5\u4f5c\u65e5\u4e0a\u5348\u201d\u7684\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"WorkCalendarEntityPlugin_8", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
        }
        return result;
    }

    private boolean validateNotNull(DynamicObject obj) {
        return this.nullToZero(obj, "hourofbegintimeam") || this.nullToZero(obj, "minofbegintimeam") || this.nullToZero(obj, "hourofendtimeam") || this.nullToZero(obj, "minofendtimeam");
    }

    private boolean pmTimeValidate() {
        DynamicObject obj = this.getDynamicObject();
        if (this.nullToZero(obj, "hourofbegintimepm") || this.nullToZero(obj, "minofbegintimepm") || this.nullToZero(obj, "hourofendtimepm") || this.nullToZero(obj, "minofendtimepm")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0b\u5348\u65f6\u95f4\u5fc5\u987b\u5f55\u5165\u3002", (String)"WorkCalendarEntityPlugin_3", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        boolean result = TimeUtils.compareHourAndMinute(obj.getInt("hourofbegintimepm"), obj.getInt("minofbegintimepm"), obj.getInt("hourofendtimepm"), obj.getInt("minofendtimepm"));
        if (!result) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5de5\u4f5c\u65e5\u4e0b\u5348\u201d\u7684\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"WorkCalendarEntityPlugin_9", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        result = TimeUtils.compareHourAndMinute(obj.getInt("hourofbegintimepm"), obj.getInt("minofbegintimepm"), obj.getInt("hourofendtimeam"), obj.getInt("minofendtimeam"));
        if (result) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5de5\u4f5c\u65e5\u4e0a\u5348\u201d\u7684\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u5de5\u4f5c\u65e5\u4e0b\u5348\u201d\u7684\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"WorkCalendarEntityPlugin_14", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean nullToZero(DynamicObject obj, String propertyName) {
        Object property = obj.get(propertyName);
        if (property == null || property.toString().length() == 0) {
            obj.set(propertyName, (Object)0);
            return true;
        }
        return false;
    }

    private boolean expiringDateValidate() {
        DynamicObject obj = this.getDynamicObject();
        if (obj.get(EXPIRING_YEAR_FROM) == null || obj.get(EXPIRING_MONTH_FROM) == null || obj.get(EXPIRING_YEAR_TO) == null || obj.get(EXPIRING_MONTH_TO) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkCalendarEntityPlugin_5", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        Calendar curDate = Calendar.getInstance();
        int yearFrom = obj.getInt(EXPIRING_YEAR_FROM);
        int monthFrom = obj.getInt(EXPIRING_MONTH_FROM);
        int curYear = curDate.get(1);
        if (yearFrom < curYear || yearFrom == curYear && monthFrom - 1 < curDate.get(2)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"WorkCalendarEntityPlugin_6", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        int yearTo = obj.getInt(EXPIRING_YEAR_TO);
        int monthTo = obj.getInt(EXPIRING_MONTH_TO);
        if (yearTo < yearFrom || yearTo == yearFrom && monthTo < monthFrom) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"WorkCalendarEntityPlugin_7", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject getDynamicObject() {
        IDataModel model = this.getModel();
        return model.getDataEntity();
    }

    private void generateDate() {
        IDataModel model = this.getModel();
        DynamicObject obj = model.getDataEntity();
        int yearFrom = obj.getInt(EXPIRING_YEAR_FROM);
        int monthFrom = obj.getInt(EXPIRING_MONTH_FROM);
        int yearTo = obj.getInt(EXPIRING_YEAR_TO);
        int monthTo = obj.getInt(EXPIRING_MONTH_TO);
        Calendar curDate = Calendar.getInstance();
        curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 0, 0, 0);
        Calendar fromDate = Calendar.getInstance();
        fromDate.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
        if (curDate.after(fromDate)) {
            fromDate.setTime(curDate.getTime());
        }
        Calendar toDate = Calendar.getInstance();
        toDate.set(yearTo, monthTo - 1, 1, 0, 0, 0);
        toDate.set(yearTo, monthTo - 1, toDate.getActualMaximum(5), 0, 0, 0);
        boolean[] isRestDay = this.getRestDays(model);
        boolean[] isHalfWorkDay = this.getHalfWorkDays(model);
        int oldCalendarCount = this.removeDuplicateRecord(fromDate);
        int days = TimeUtils.daysBetween(fromDate, toDate);
        model.batchCreateNewEntryRow(DATEENTRY, days);
        for (int i = 0; i < days; ++i) {
            int index = oldCalendarCount + i;
            model.setValue(WORKDATE, (Object)this.SDF.format(fromDate.getTime()), index);
            if (isRestDay[fromDate.get(7) - 1]) {
                model.setValue(DATETYPE, (Object)"4", index);
            } else if (isHalfWorkDay[fromDate.get(7) - 1]) {
                model.setValue(DATETYPE, (Object)"2", index);
            } else {
                model.setValue(DATETYPE, (Object)"1", index);
            }
            fromDate.add(5, 1);
        }
    }

    private void initGenerateDate(boolean isSkip) {
        int i;
        IDataModel model = this.getModel();
        DynamicObject obj = model.getDataEntity();
        int yearFrom = obj.getInt(EXPIRING_YEAR_FROM);
        int monthFrom = obj.getInt(EXPIRING_MONTH_FROM);
        int yearTo = obj.getInt(EXPIRING_YEAR_TO);
        int monthTo = obj.getInt(EXPIRING_MONTH_TO);
        Calendar fromDate = Calendar.getInstance();
        fromDate.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
        fromDate.set(14, 0);
        Calendar toDate = Calendar.getInstance();
        toDate.set(yearTo, monthTo - 1, 1, 0, 0, 0);
        toDate.set(yearTo, monthTo - 1, toDate.getActualMaximum(5), 0, 0, 0);
        toDate.set(14, 0);
        Calendar currDate = Calendar.getInstance();
        if (toDate.after(currDate)) {
            toDate.set(currDate.get(1), currDate.get(2), currDate.get(5) - 1);
            if (currDate.get(5) == 1) {
                toDate.set(currDate.get(1), currDate.get(2) - 1, toDate.getActualMaximum(5));
            }
        }
        boolean[] isRestDay = this.getRestDays(model);
        boolean[] isHalfWorkDay = this.getHalfWorkDays(model);
        long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        QFilter[] qFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("isindividuation", "=", (Object)"0")};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_workcalendar", (QFilter[])qFilters);
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bd_workcalendar");
            dynamicObject.set("org", (Object)orgId);
            dynamicObject.set("isindividuation", (Object)"0");
            dynamicObject.set("createorg", (Object)orgId);
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("status", (Object)"A");
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            Date date = new Date();
            dynamicObject.set("createtime", (Object)date);
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)date);
            dynamicObject.set("minofendtimepm", (Object)0);
            dynamicObject.set("hourofendtimepm", (Object)0);
            dynamicObject.set("minofbegintimepm", (Object)0);
            dynamicObject.set("hourofbegintimepm", (Object)0);
            dynamicObject.set("minofendtimeam", (Object)0);
            dynamicObject.set("hourofendtimeam", (Object)0);
            dynamicObject.set("minofbegintimeam", (Object)0);
            dynamicObject.set("hourofbegintimeam", (Object)0);
        }
        DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection(DATEENTRY);
        List<DynamicObject> beforeCalendarList = this.initBeforeFromDate(fromDate, entrys);
        List<DynamicObject> afterCalendarList = this.initAfterToDate(toDate, entrys);
        for (int i2 = 0; i2 < beforeCalendarList.size(); ++i2) {
            DynamicObject oldObj = beforeCalendarList.get(i2);
            this.getModel().createNewEntryRow(DATEENTRY);
            this.getModel().setValue(WORKDATE, (Object)oldObj.getDate(WORKDATE), i2);
            this.getModel().setValue(DATETYPE, oldObj.get(DATETYPE), i2);
        }
        int days = TimeUtils.daysBetween(fromDate, toDate);
        if (days > 0) {
            model.batchCreateNewEntryRow(DATEENTRY, days);
        }
        for (i = 0; i < days; ++i) {
            int index = beforeCalendarList.size() + i;
            if (isSkip) {
                List dynamicObjectList = entrys.stream().filter(entry -> fromDate.getTime().equals(entry.getDate(WORKDATE))).collect(Collectors.toList());
                if (dynamicObjectList.size() > 0) {
                    DynamicObject dy = (DynamicObject)dynamicObjectList.get(0);
                    this.getModel().setValue(WORKDATE, (Object)dy.getDate(WORKDATE), index);
                    this.getModel().setValue(DATETYPE, dy.get(DATETYPE), index);
                } else {
                    model.setValue(WORKDATE, (Object)fromDate.getTime(), index);
                    if (isRestDay[fromDate.get(7) - 1]) {
                        model.setValue(DATETYPE, (Object)"4", index);
                    } else if (isHalfWorkDay[fromDate.get(7) - 1]) {
                        model.setValue(DATETYPE, (Object)"2", index);
                    } else {
                        model.setValue(DATETYPE, (Object)"1", index);
                    }
                }
            }
            fromDate.add(5, 1);
        }
        for (i = 0; i < afterCalendarList.size(); ++i) {
            int entryIndex = beforeCalendarList.size() + days + i;
            DynamicObject oldObj = afterCalendarList.get(i);
            this.getModel().createNewEntryRow(DATEENTRY);
            this.getModel().setValue(WORKDATE, (Object)oldObj.getDate(WORKDATE), entryIndex);
            this.getModel().setValue(DATETYPE, oldObj.get(DATETYPE), entryIndex);
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DATEENTRY);
        dynamicObject.set(DATEENTRY, (Object)entryEntity);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private int removeDuplicateRecord(Calendar fromDate) {
        int i;
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(DATEENTRY);
        Calendar oldCal = Calendar.getInstance();
        ArrayList<DynamicObject> oldCalendarList = new ArrayList<DynamicObject>();
        for (i = rowCount - 1; i >= 0; --i) {
            DynamicObject oldObj = model.getEntryRowEntity(DATEENTRY, i);
            if (oldObj.getDate(WORKDATE) == null) continue;
            oldCal.setTime(oldObj.getDate(WORKDATE));
            if (fromDate.before(oldCal) || TimeUtils.isSameDate(fromDate, oldCal)) {
                model.deleteEntryRow(DATEENTRY, i);
                continue;
            }
            oldCalendarList.add(oldObj);
        }
        rowCount = model.getEntryRowCount(DATEENTRY);
        for (i = rowCount - 1; i >= 0; --i) {
            model.deleteEntryRow(DATEENTRY, i);
        }
        int oldRecordCount = oldCalendarList.size();
        int entryIndex = 0;
        for (int i2 = oldRecordCount - 1; i2 >= 0; --i2) {
            DynamicObject oldObj = (DynamicObject)oldCalendarList.get(i2);
            model.createNewEntryRow(DATEENTRY);
            model.setValue(WORKDATE, (Object)oldObj.getDate(WORKDATE), entryIndex);
            model.setValue(DATETYPE, oldObj.get(DATETYPE), entryIndex);
            ++entryIndex;
        }
        return oldRecordCount;
    }

    private List<DynamicObject> initAfterToDate(Calendar toDate, DynamicObjectCollection entrys) {
        Calendar oldCal = Calendar.getInstance();
        ArrayList<DynamicObject> afterCalendarList = new ArrayList<DynamicObject>();
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject oldObj = (DynamicObject)entrys.get(i);
            if (oldObj.getDate(WORKDATE) == null) continue;
            oldCal.setTime(oldObj.getDate(WORKDATE));
            if (!toDate.before(oldCal)) continue;
            afterCalendarList.add(oldObj);
        }
        return afterCalendarList;
    }

    private List<DynamicObject> initBeforeFromDate(Calendar fromDate, DynamicObjectCollection entrys) {
        Calendar oldCal = Calendar.getInstance();
        ArrayList<DynamicObject> beforeCalendarList = new ArrayList<DynamicObject>();
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject oldObj = (DynamicObject)entrys.get(i);
            if (oldObj.getDate(WORKDATE) == null) continue;
            oldCal.setTime(oldObj.getDate(WORKDATE));
            if (!fromDate.after(oldCal)) continue;
            beforeCalendarList.add(oldObj);
        }
        return beforeCalendarList;
    }

    private boolean[] getRestDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isRestDay = new boolean[]{obj.getBoolean("issunrest"), obj.getBoolean("ismonrest"), obj.getBoolean("istuerest"), obj.getBoolean("iswedrest"), obj.getBoolean("isthurest"), obj.getBoolean("isfrirest"), obj.getBoolean("issatrest")};
        return isRestDay;
    }

    private boolean[] getHalfWorkDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isHalfWorkDay = new boolean[]{obj.getBoolean("ishalfsunrest"), obj.getBoolean("ishalfmonrest"), obj.getBoolean("ishalftuerest"), obj.getBoolean("ishalfwedrest"), obj.getBoolean("ishalfthurest"), obj.getBoolean("ishalffrirest"), obj.getBoolean("ishalfsatrest")};
        return isHalfWorkDay;
    }
}

