/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class WorkCalendarLoadService {
    public static final String ID = "id";
    public static final String SELECTED_ORG_ID = "org";
    public static final String DATA_ORG_ID = "dataorg";
    public static final String WORK_DATE = "workDate";
    public static final String DATE_TYPE = "dateType";
    private static Log logger = LogFactory.getLog(WorkCalendarLoadService.class);
    private static final String DATEENTRY_WORKDATE = "dateentry.workdate";
    private static final String YYY_MM_DD = "yyy-MM-dd";

    public static List<Map<String, String>> loadWorkCalendar(Map<String, String> orgMap, int year) {
        if (orgMap == null || !orgMap.containsKey(SELECTED_ORG_ID)) {
            return new ArrayList<Map<String, String>>();
        }
        String dateFrom = year + "-01-01";
        String dateTo = year + "-12-31";
        return WorkCalendarLoadService.loadWorkCalendar(orgMap, dateFrom, dateTo);
    }

    public static List<Map<String, String>> loadWorkCalendar(Map<String, String> orgMap, String dateFrom, String dateTo) {
        if (orgMap == null || !orgMap.containsKey(SELECTED_ORG_ID) || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> workDataList = new ArrayList<Map<String, String>>();
        orgMap.put(DATA_ORG_ID, orgMap.get(SELECTED_ORG_ID));
        WorkCalendarLoadService.load(workDataList, orgMap, dateFrom, dateTo);
        if (workDataList.size() == 0) {
            return workDataList;
        }
        WorkCalendarLoadService.fillFullYear(workDataList, orgMap, dateFrom, dateTo);
        return workDataList;
    }

    public static Map<String, Object> getMarkDateMap(String orgId, String dateFrom, String dateTo) {
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return markDateMap;
        }
        WorkCalendarLoadService.findAllMarkDate(markDateMap, orgId, dateFrom, dateTo);
        return markDateMap;
    }

    private static void load(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr) {
        String orgId = orgMap.get(DATA_ORG_ID);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            logger.info("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5de5\u4f5c\u65e5\u5386,org\u4e3a\u7a7a");
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        ORM orm = ORM.create();
        QFilter[] qf = new QFilter[]{new QFilter(SELECTED_ORG_ID, "=", (Object)Long.valueOf(orgId)), new QFilter("isindividuation", "=", (Object)"0"), new QFilter(DATEENTRY_WORKDATE, ">=", (Object)dateFrom), new QFilter(DATEENTRY_WORKDATE, "<=", (Object)dateTo)};
        String selectFields = "id,number,org,createorg,issunrest,ismonrest,istuerest,iswedrest,isthurest,isfrirest,issatrest,hourofbegintimeam,minofbegintimeam,hourofendtimeam,minofendtimeam,hourofbegintimepm,minofbegintimepm,hourofendtimepm,minofendtimepm,enable,status,modifytime,isindividuation,ishalfsunrest,ishalfmonrest,ishalftuerest,ishalfwedrest,ishalfthurest,ishalffrirest,ishalfsatrest,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto,masterid,dateentry.id,dateentry.workdate,dateentry.datetype";
        String orderBys = "dateentry.workdate asc";
        DynamicObjectCollection obj = orm.query("bd_workcalendar", selectFields, qf, orderBys);
        if (obj != null && obj.size() > 0) {
            WorkCalendarLoadService.handleQueryResult(workDataList, orgMap, dateFromStr, dateToStr, orgId, obj);
        } else {
            String parentId = WorkCalendarLoadService.getOrgPrentId(orgId);
            if (StringUtils.isNotBlank((CharSequence)parentId) && !"0".equals(parentId)) {
                orgMap.put(DATA_ORG_ID, parentId);
                WorkCalendarLoadService.load(workDataList, orgMap, dateFromStr, dateToStr);
            }
        }
    }

    private static void handleQueryResult(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr, String orgId, DynamicObjectCollection obj) {
        Map<String, Object> markDateMap = WorkCalendarLoadService.getMarkDateMap(orgMap.get(SELECTED_ORG_ID), dateFromStr, dateToStr);
        String selectOrgId = orgMap.get(SELECTED_ORG_ID);
        if (StringUtils.isNotBlank((CharSequence)selectOrgId) && !orgId.equals(selectOrgId)) {
            markDateMap = WorkCalendarLoadService.getMarkDateMap(selectOrgId, dateFromStr, dateToStr);
        }
        DynamicObjectCollection entry = ((DynamicObject)obj.get(0)).getDynamicObjectCollection("dateentry");
        orgMap.put(ID, String.valueOf(((DynamicObject)obj.get(0)).getPkValue()));
        SimpleDateFormat SDF = new SimpleDateFormat(YYY_MM_DD);
        for (DynamicObject workday : entry) {
            HashMap<String, String> data = new HashMap<String, String>();
            String dateKey = SDF.format(workday.getDate(WORK_DATE));
            data.put(WORK_DATE, dateKey);
            Object dateType = markDateMap.get(dateKey);
            if (dateType == null) {
                data.put(DATE_TYPE, workday.getString(DATE_TYPE));
            } else {
                data.put(DATE_TYPE, dateType.toString());
            }
            workDataList.add(data);
        }
    }

    private static void fillFullYear(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFrom, String dateTo) {
        String minDateFrom = workDataList.get(0).get(WORK_DATE);
        String maxDateFrom = workDataList.get(workDataList.size() - 1).get(WORK_DATE);
        Date fDate = null;
        Date tDate = null;
        Date minDate = null;
        Date maxDate = null;
        try {
            Calendar cal;
            SimpleDateFormat SDF = new SimpleDateFormat(YYY_MM_DD);
            fDate = SDF.parse(dateFrom);
            tDate = SDF.parse(dateTo);
            minDate = SDF.parse(minDateFrom);
            maxDate = SDF.parse(maxDateFrom);
            if (fDate.compareTo(minDate) < 0) {
                cal = Calendar.getInstance();
                cal.setTime(minDate);
                cal.add(5, -1);
                workDataList.addAll(WorkCalendarLoadService.fillDate(orgMap.get(SELECTED_ORG_ID), orgMap.get(DATA_ORG_ID), dateFrom, SDF.format(cal.getTime())));
            }
            if (maxDate.compareTo(tDate) < 0) {
                cal = Calendar.getInstance();
                cal.setTime(maxDate);
                cal.add(5, 1);
                workDataList.addAll(WorkCalendarLoadService.fillDate(orgMap.get(SELECTED_ORG_ID), orgMap.get(DATA_ORG_ID), SDF.format(cal.getTime()), dateTo));
            }
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
    }

    private static List<Map<String, String>> fillDate(String org, String dataOrg, String dateFrom, String dateTo) {
        ArrayList<Map<String, String>> tempWorkDataList = new ArrayList<Map<String, String>>();
        if (StringUtils.isBlank((CharSequence)org) || "0".equals(org)) {
            return tempWorkDataList;
        }
        HashMap<String, String> orgMap = new HashMap<String, String>();
        orgMap.put(SELECTED_ORG_ID, org);
        orgMap.put(DATA_ORG_ID, WorkCalendarLoadService.getOrgPrentId(dataOrg));
        WorkCalendarLoadService.load(tempWorkDataList, orgMap, dateFrom, dateTo);
        return tempWorkDataList;
    }

    private static void findAllMarkDate(Map<String, Object> markDateMap, String orgId, String dateFromStr, String dateToStr) {
        String parentOrgId;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] filters = new QFilter[]{new QFilter(SELECTED_ORG_ID, "=", (Object)Long.valueOf(orgId)), new QFilter("isindividuation", "=", (Object)"1"), new QFilter(DATEENTRY_WORKDATE, ">=", (Object)dateFrom), new QFilter(DATEENTRY_WORKDATE, "<=", (Object)dateTo)};
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)"bd_workcalendar", (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            SimpleDateFormat SDF = new SimpleDateFormat(YYY_MM_DD);
            for (DynamicObject date : entityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(parentOrgId = WorkCalendarLoadService.getOrgPrentId(orgId))) && !"0".equals(parentOrgId)) {
            WorkCalendarLoadService.findAllMarkDate(markDateMap, parentOrgId, dateFromStr, dateToStr);
        }
    }

    private static String getOrgPrentId(String id) {
        String parentId = "";
        QFilter[] qf = new QFilter[]{new QFilter("view.isdefault", "=", (Object)"1"), new QFilter("view.treetype", "=", (Object)"01"), new QFilter(SELECTED_ORG_ID, "=", (Object)Long.valueOf(id))};
        DynamicObject parentObj = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,parent", (QFilter[])qf);
        if (parentObj == null) {
            return parentId;
        }
        return parentObj.getString("parent");
    }
}

