/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class BdCtrlStrtgyUtils {
    private static final Log logger = LogFactory.getLog(BdCtrlStrtgyUtils.class);
    public static final String ENTITY_BASEDATAVIEW = "bd_basedataview";
    public static final String ENTITY_BDCTRLSTRTGY = "bd_bdctrlstrtgy";
    public static final String ENTRY_ORGSTRTGY = "entryentity";
    public static final String SUBENTRY_FIELDSTRTGY = "subentry_fieldstrtgy";
    public static final String ENTITY_ORG_VIEW = "bos_org_viewschema";
    public static final String PROP_BASEDATA = "basedata";
    public static final String PROP_BASEDATAVIEW = "basedataview";
    public static final String PROP_CREATEORG = "createorg";
    public static final String PROP_FIELDNUMBER = "fieldnumber";
    public static final String PROP_FIELDNAME = "fieldname";
    public static final String PROP_ISALLOWSHARE = "isallowshare";
    public static final String PROP_ISALLOWUPDATE = "isallowupdate";
    public static final String PROP_ID = "id";

    public static void getShareInfoFromBdCtrlStrtgy(String baseData, Long orgId, Map<String, Boolean> mapShare, Map<String, Boolean> mapUpdate) {
        String selector = "id,ctrlview";
        DynamicObject entityBdView = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_BASEDATAVIEW, (String)selector, (QFilter[])new QFilter[]{new QFilter(PROP_BASEDATA, "=", (Object)baseData)});
        if (entityBdView == null) {
            return;
        }
        String bdViewId = (String)entityBdView.get(PROP_ID);
        Long ctrlviewID = 0L;
        if (entityBdView.get("ctrlview") instanceof Long) {
            ctrlviewID = (Long)entityBdView.get("ctrlview");
        } else if (entityBdView.get("ctrlview") instanceof DynamicObject) {
            ctrlviewID = (Long)((DynamicObject)entityBdView.get("ctrlview")).getPkValue();
        }
        DynamicObject entityBdCtrlStrtgy = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_BDCTRLSTRTGY, (QFilter[])new QFilter[]{new QFilter(PROP_BASEDATAVIEW, "=", (Object)bdViewId), new QFilter("entryentity.createorg", "=", (Object)orgId)});
        if (entityBdCtrlStrtgy == null) {
            DynamicObject ctrlview = BusinessDataServiceHelper.loadSingleFromCache((Object)ctrlviewID, (String)ENTITY_ORG_VIEW);
            List parentOrgIdList = OrgUnitServiceHelper.getSuperiorOrgs((String)ctrlview.getString("number"), (long)orgId);
            if (parentOrgIdList != null && parentOrgIdList.size() > 0) {
                BdCtrlStrtgyUtils.getShareInfoFromBdCtrlStrtgy(baseData, (Long)parentOrgIdList.get(0), mapShare, mapUpdate);
                return;
            }
            return;
        }
        DynamicObjectCollection entry = entityBdCtrlStrtgy.getDynamicObjectCollection(ENTRY_ORGSTRTGY);
        int entrySize = entry.size();
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject entryRow = (DynamicObject)entry.get(i);
            Long createOrgId = (Long)entryRow.get("createorg.id");
            if (!createOrgId.equals(orgId)) continue;
            String ctrlStrategy = entryRow.getString("ctrlstrategy");
            boolean isShare = ctrlStrategy.equals("5");
            DynamicObjectCollection subEntry = entryRow.getDynamicObjectCollection(SUBENTRY_FIELDSTRTGY);
            for (DynamicObject subEntryRow : subEntry) {
                String fieldNumber = subEntryRow.getString(PROP_FIELDNUMBER);
                String isAllowShare = subEntryRow.getString(PROP_ISALLOWSHARE);
                String isAllowUpdate = subEntryRow.getString(PROP_ISALLOWUPDATE);
                boolean bIsAllowShare = true;
                boolean bIsAllowUpdate = false;
                if ("0".equals(isAllowShare)) {
                    bIsAllowShare = false;
                }
                if ("1".equals(isAllowUpdate) && bIsAllowShare) {
                    bIsAllowUpdate = true;
                }
                mapShare.put(fieldNumber, bIsAllowShare);
                mapUpdate.put(fieldNumber, bIsAllowUpdate);
            }
            break;
        }
    }

    public static String trimFieldNumber(String pFieldNumber) {
        int lastDotIndex = pFieldNumber.lastIndexOf(46);
        if (lastDotIndex != -1) {
            pFieldNumber = pFieldNumber.substring(lastDotIndex + 1, pFieldNumber.length());
        }
        return pFieldNumber;
    }

    public static boolean setVisibleByBdCtrlStrtgy(String baseData, Long orgId, IFormView fv, OperationStatus status) {
        HashMap<String, Boolean> mapShare = new HashMap<String, Boolean>();
        HashMap<String, Boolean> mapUpdate = new HashMap<String, Boolean>();
        BdCtrlStrtgyUtils.getShareInfoFromBdCtrlStrtgy(baseData, orgId, mapShare, mapUpdate);
        if (mapShare.size() == 0) {
            return false;
        }
        for (Map.Entry entry : mapShare.entrySet()) {
            fv.setVisible((Boolean)entry.getValue(), new String[]{BdCtrlStrtgyUtils.trimFieldNumber((String)entry.getKey())});
        }
        if (OperationStatus.EDIT == status) {
            for (Map.Entry entry : mapUpdate.entrySet()) {
                fv.setEnable((Boolean)entry.getValue(), new String[]{BdCtrlStrtgyUtils.trimFieldNumber((String)entry.getKey())});
            }
        }
        return true;
    }

    public static void setListVisibleByBdCtrlStrtgy(String baseData, Long orgId, IFormView fv) {
        QFilter[] qfArr = new QFilter[]{new QFilter("basedataview.basedata", "=", (Object)baseData), new QFilter("entryentity.subentry_fieldstrtgy.isallowshare", "=", (Object)"0")};
        Map ctrlStrtgys = BusinessDataServiceHelper.loadFromCache((String)ENTITY_BDCTRLSTRTGY, (QFilter[])qfArr);
        if (ctrlStrtgys == null || ctrlStrtgys.size() == 0) {
            return;
        }
        DynamicObject ctrlStrtgy = (DynamicObject)ctrlStrtgys.values().iterator().next();
        DynamicObjectCollection orgEntry = ctrlStrtgy.getDynamicObjectCollection(ENTRY_ORGSTRTGY);
        for (DynamicObject ctrl : orgEntry) {
            DynamicObjectCollection proEntry = ctrl.getDynamicObjectCollection(SUBENTRY_FIELDSTRTGY);
            for (DynamicObject obj : proEntry) {
                fv.setVisible(Boolean.valueOf(false), new String[]{obj.getString(PROP_FIELDNUMBER)});
            }
        }
    }

    private boolean isCanModify() {
        return false;
    }
}

