/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.assistant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.basedata.common.BaseDataCommon;
import kd.bos.basedata.common.BaseDataCtrlLog;
import kd.bos.basedata.service.BDCtrlLogServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.assistant.OrgPermChangeService;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgPermChangePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IConfirmCallBack {
    private static final String ENTITY_ASSISTANT_DATA = "bos_assistantdata_detail";
    private static final String ENTITY_ASSISTANT_GROUP = "bos_assistantdatagroup";
    private static final String TARGET_ORG = "targetorg";
    private static final String GROUP_ID = "groupId";
    private static final String ENTITY_ID = "entityId";
    private static final String CTRL_VIEW = "ctrlview";
    private static final String CTRL_VIEW_NUMBER = "ctrlview.number";
    private static final String CTRL_VIEW_ID = "ctrlview.id";
    private static final String BOS_DESIGNER_PLUGIN = "bos-bd-formplugin";
    private static final String CONFIRM_ORGCHANGE = "confirmOrgChange";
    private static final String ORIORG = "oriorg";

    public void initialize() {
        this.addClickListeners(new String[]{"save"});
        OrgEdit org = (OrgEdit)this.getView().getControl(TARGET_ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(ORIORG, this.getView().getFormShowParameter().getCustomParam("createOrg"));
        String groupId = (String)this.getView().getFormShowParameter().getCustomParam(GROUP_ID);
        if (StringUtils.isBlank((CharSequence)groupId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{TARGET_ORG, "save"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7c7b\u522b\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgPermChangePlugin_assistant_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(groupId), (String)ENTITY_ASSISTANT_GROUP);
        if (null == group || null == group.get(CTRL_VIEW)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{TARGET_ORG, "save"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7c7b\u522b\u4fe1\u606f\uff0c\u6216\u8005\u7c7b\u522b\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgPermChangePlugin_assistant_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String view = group.getString(CTRL_VIEW_NUMBER);
        OrgEdit orgEdit = (OrgEdit)this.getControl(TARGET_ORG);
        orgEdit.setOrgFunc(view);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        if (TARGET_ORG.equals(arg0.getProperty().getName())) {
            String groupId = (String)this.getView().getFormShowParameter().getCustomParam(GROUP_ID);
            DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(groupId), (String)ENTITY_ASSISTANT_GROUP);
            String view = group.getString(CTRL_VIEW_NUMBER);
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            param.setCustomParam("orgViewSchemeNumber", (Object)view);
            if (!ENTITY_ASSISTANT_DATA.equals(this.getView().getFormShowParameter().getCustomParam(ENTITY_ID))) {
                return;
            }
            long groupCreatorId = (Long)group.getDynamicObject("createorg").getPkValue();
            if (groupCreatorId == 0L) {
                param.getTreeFilterParameter().getQFilters().add(new QFilter("1", "!=", (Object)"1"));
                return;
            }
            ArrayList<Long> orgIds = new ArrayList<Long>(Collections.singletonList(groupCreatorId));
            HashSet allOrgIds = new HashSet(OrgUnitServiceHelper.getAllSubordinateOrgs((Long)group.getLong(CTRL_VIEW_ID), orgIds, (boolean)true));
            Object srcOrg = this.getModel().getValue(ORIORG);
            if (null != srcOrg) {
                allOrgIds.remove((Long)((DynamicObject)srcOrg).getPkValue());
            }
            param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", allOrgIds));
        }
    }

    public void click(EventObject evt) {
        String msg;
        Control control = (Control)evt.getSource();
        if (!"save".equals(control.getKey())) {
            return;
        }
        DynamicObject originalOrg = (DynamicObject)this.getModel().getValue(ORIORG);
        DynamicObject org = (DynamicObject)this.getModel().getValue(TARGET_ORG);
        String groupId = (String)this.getView().getFormShowParameter().getCustomParam(GROUP_ID);
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_ID);
        if (ENTITY_ASSISTANT_DATA.equals(entityId)) {
            String msg2 = OrgPermChangeService.paramValidate(org, ids, groupId);
            if (StringUtils.isNotBlank((CharSequence)msg2)) {
                this.getView().showTipNotification(msg2);
                return;
            }
            msg2 = OrgPermChangeService.getConfirmMsgByOrgRelation(originalOrg, org, groupId);
            if (StringUtils.isNotBlank((CharSequence)msg2)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_ORGCHANGE, (IConfirmCallBack)this);
                this.getView().showConfirm(msg2, MessageBoxOptions.OKCancel, confirmCallBacks);
                return;
            }
            OrgPermChangeService.assistantDetailOrgChange(org, ids);
            this.doAfterOrgChange();
            return;
        }
        List allIds = (List)this.getView().getFormShowParameter().getCustomParam("allIds");
        if (!CollectionUtils.isEmpty((Collection)ids)) {
            allIds = ids;
        }
        if (StringUtils.isNotBlank((CharSequence)(msg = OrgPermChangeService.paramValidate(org, allIds, groupId)))) {
            this.getView().showTipNotification(msg);
            return;
        }
        msg = OrgPermChangeService.overRangValidate(Long.valueOf(groupId), org);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        OrgPermChangeService.assistantGroupOrgChange(org, allIds, groupId);
        this.doAfterOrgGroupChange();
    }

    private void doAfterOrgGroupChange() {
        String pageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(pageId);
        if (parentView == null) {
            return;
        }
        String listPageId = parentView.getFormShowParameter().getParentPageId();
        AbstractListView listView = (AbstractListView)parentView.getViewNoPlugin(listPageId);
        if (null != listView) {
            listView.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"OrgPermChangePlugin_assistant_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            ITreeListView treeView = listView.getTreeListView();
            treeView.focusRootNode();
            String groupNumber = (String)parentView.getModel().getValue("number");
            if (StringUtils.isNotEmpty((CharSequence)groupNumber)) {
                String opName = ResManager.loadKDString((String)"\u7ba1\u7406\u6743\u8f6c\u8ba9", (String)"OrgPermChangePlugin_assistant_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                String description = String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\uff0c\u7ba1\u7406\u6743\u8f6c\u8ba9\u6210\u529f", (String)"OrgPermChangePlugin_assistant_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), groupNumber);
                String appId = this.getView().getFormShowParameter().getAppId();
                ArrayList<BaseDataCtrlLog> bdCtrlLogs = new ArrayList<BaseDataCtrlLog>(1);
                BaseDataCtrlLog bdCtrlLog = new BaseDataCtrlLog(appId, ENTITY_ASSISTANT_GROUP, opName, Long.valueOf(RequestContext.get().getOrgId()), description);
                bdCtrlLog.setMultiLangDesc(new MultiLangEnumBridge("\u7f16\u7801%s\uff0c\u7ba1\u7406\u6743\u8f6c\u8ba9\u6210\u529f", "OrgPermChangePlugin_assistant_9", BOS_DESIGNER_PLUGIN));
                bdCtrlLog.setArgs(new String[]{groupNumber});
                bdCtrlLog.setOpKey("Transfer of Management Rights");
                bdCtrlLog.setOpNameBridge(new MultiLangEnumBridge("\u7ba1\u7406\u6743\u8f6c\u8ba9", "OrgPermChangePlugin_assistant_8", BOS_DESIGNER_PLUGIN));
                bdCtrlLogs.add(bdCtrlLog);
                BDCtrlLogServiceHelper.saveLogBatch(bdCtrlLogs);
            }
        }
        parentView.close();
        this.getView().sendFormAction(parentView);
        this.getView().sendFormAction((IFormView)listView);
        this.getView().close();
    }

    private void doAfterOrgChange() {
        String pageId = this.getView().getFormShowParameter().getParentPageId();
        if (null == this.getView().getViewNoPlugin(pageId)) {
            this.getView().close();
            return;
        }
        IFormView view = this.getView().getViewNoPlugin(pageId);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"OrgPermChangePlugin_assistant_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        this.getView().sendFormAction(view);
        ArrayList<BaseDataCtrlLog> logList = new ArrayList<BaseDataCtrlLog>(1);
        String logNumberStr = view.getPageCache().get("logNumbers");
        if (StringUtils.isNotEmpty((CharSequence)logNumberStr)) {
            List logNumbers = (List)SerializationUtils.fromJsonString((String)logNumberStr, List.class);
            for (String logNumber : logNumbers) {
                String description = String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\uff0c\u7ba1\u7406\u6743\u8f6c\u8ba9\u6210\u529f", (String)"OrgPermChangePlugin_assistant_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), logNumber);
                BaseDataCtrlLog log = new BaseDataCtrlLog("basedata", ENTITY_ASSISTANT_DATA, "orgchange", Long.valueOf(RequestContext.get().getOrgId()), description);
                log.setOpKey("orgchange");
                log.setOpShowName(BaseDataCommon.getOpName((String)ENTITY_ASSISTANT_DATA, (String)"orgchange"));
                log.setMultiLangDesc(new MultiLangEnumBridge("\u7f16\u7801%s\uff0c\u7ba1\u7406\u6743\u8f6c\u8ba9\u6210\u529f", "OrgPermChangePlugin_assistant_9", BOS_DESIGNER_PLUGIN));
                log.setArgs(new String[]{logNumber});
                log.setKeyWord(logNumber);
                logList.add(log);
            }
            BDCtrlLogServiceHelper.saveLogBatch(logList);
        }
        this.getView().close();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_ID);
        if (ENTITY_ASSISTANT_GROUP.equals(entityId)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(1);
            DynamicObject org = (DynamicObject)this.getModel().getValue(TARGET_ORG);
            if (org != null) {
                returnData.put(TARGET_ORG, org.getPkValue());
            }
            this.getView().returnDataToParent(returnData);
        } else if (this.getView().getParentView() instanceof ListView) {
            ListView listView = (ListView)this.getView().getParentView();
            BillList billList = (BillList)listView.getControl("billlistap");
            billList.refresh();
        } else {
            this.getView().getParentView().updateView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String key = event.getCallBackId();
        if (CONFIRM_ORGCHANGE.equals(key) && event.getResult() == MessageBoxResult.Yes) {
            List allIds = (List)this.getView().getFormShowParameter().getCustomParam("allIds");
            DynamicObject org = (DynamicObject)this.getModel().getValue(TARGET_ORG);
            OrgPermChangeService.assistantDetailOrgChange(org, allIds);
            this.doAfterOrgChange();
        }
    }
}

