/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.dao;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ParentBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AssistantUtils;
import kd.bos.license.api.ILicenseService;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AssistantdataDetailPlugin
extends AbstractBasePlugIn {
    private static Log LOGGER = LogFactory.getLog(AssistantdataDetailPlugin.class);
    public static final String GROUP_NUMBER = "group";
    public static final String PARENT_ID = "parent";
    private static final String BOS_DESIGNER_PLUGIN = "bos-bd-formplugin";
    private static final String ENTITY_ASSISTANT = "bos_assistantdata_detail";
    private static final String ENTITY_ASSISTANT_GROUP = "bos_assistantdatagroup";
    private static final String ORG_STRUCTURE_ENTITY = "bos_org_structure";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_SAVE_NEW = "btnsaveandnew";
    private static final String SPLIT = ".";
    private static final String CREATEORG = "createOrg";
    private static final String CTRL_VIEW = "ctrlview";
    private static final String CTRL_VIEW_ID = "ctrlview.id";
    private static final String CREATE_ORG_ID = "createorg.id";
    private static final String CLOUD = "cloud_";
    private static final String MY_ROOT = "myroot";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ParentBasedataEdit parent = (ParentBasedataEdit)this.getView().getControl(PARENT_ID);
        parent.addBeforeF7SelectListener(this::beforeParentF7Select);
        this.addClickListeners(new String[]{BTN_SAVE, BTN_SAVE_NEW});
    }

    public void afterCreateNewData(EventObject e) {
        Object group;
        boolean isSwitchCreateOrg;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String asstTypeId = (String)parameter.getCustomParam("_Assistant_Group_");
        IFormView parentView = this.getView().getViewNoPlugin(parameter.getParentPageId());
        long defRootOrgId = OrgUnitServiceHelper.getRootOrgId();
        String createOrg = null;
        if (asstTypeId != null) {
            this.getModel().setValue(GROUP_NUMBER, (Object)asstTypeId);
            DynamicObject group2 = (DynamicObject)this.getView().getModel().getValue(GROUP_NUMBER);
            long orgId = group2.get(CREATE_ORG_ID) == null ? defRootOrgId : group2.getLong(CREATE_ORG_ID);
            createOrg = String.valueOf(orgId);
        }
        if (parentView instanceof ListView) {
            boolean notDataDetailNode;
            ListView listView = (ListView)parentView;
            String currentNodeId = (String)listView.getTreeListView().getTreeModel().getCurrentNodeId();
            boolean bl = notDataDetailNode = StringUtils.isBlank((CharSequence)currentNodeId) || currentNodeId.startsWith(CLOUD) || currentNodeId.startsWith("app_") || MY_ROOT.equals(currentNodeId);
            if (!notDataDetailNode) {
                this.getModel().setValue(GROUP_NUMBER, (Object)currentNodeId);
            }
        }
        if (parentView != null && StringUtils.isBlank(createOrg)) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            createOrg = pageCache.get(CREATEORG);
        }
        DynamicObject currCreateOrg = (DynamicObject)this.getModel().getValue("createorg");
        Long currOrg = RequestContext.get().getOrgId();
        boolean bl = isSwitchCreateOrg = currCreateOrg == null || (Long)currCreateOrg.getPkValue() == defRootOrgId || currCreateOrg.getPkValue().equals(currOrg);
        if (StringUtils.isNotBlank((CharSequence)createOrg) && isSwitchCreateOrg) {
            this.getModel().setValue("createorg", (Object)Long.parseLong(createOrg));
        }
        if ((group = this.getModel().getValue(GROUP_NUMBER)) instanceof DynamicObject) {
            this.getModel().setValue("ctrlstrategy", (Object)((DynamicObject)group).getString("ctrlstrategy"));
        }
    }

    public void afterBindData(EventObject e) {
        ILicenseService service;
        boolean isSingleOrgManageMode;
        DynamicObject group;
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{GROUP_NUMBER, "createorg"});
        Map parentInfo = (Map)this.getView().getFormShowParameter().getCustomParam("tree_parent_id");
        if (parentInfo != null) {
            String fieldKey = (String)parentInfo.get("key");
            String value = (String)parentInfo.get("value");
            if (value.contains(CLOUD)) {
                return;
            }
            this.getModel().setValue(fieldKey, (Object)value);
        }
        if (null != (group = (DynamicObject)this.getView().getModel().getValue(GROUP_NUMBER))) {
            this.getModel().setValue(CTRL_VIEW, group.get(CTRL_VIEW_ID));
        }
        if (isSingleOrgManageMode = (service = (ILicenseService)ServiceFactory.getService((String)"ILicenseService")).isSingleOrgManageMode()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CTRL_VIEW});
        }
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        Object source = e.getSource();
        BaseView view = (BaseView)source;
        DynamicObject dataEntity = view.getModel().getDataEntity();
        Long fid = dataEntity.getLong("group_Id");
        this.getModel().setValue(GROUP_NUMBER, (Object)fid);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if ("name".equals(property)) {
            this.namePropertyChanged();
        } else if (PARENT_ID.equals(property)) {
            this.parentPropertyChanged();
        } else if ("number".equals(property)) {
            this.numberPropertyChanged();
        } else if (GROUP_NUMBER.equals(property)) {
            this.groupPropertyChanged();
        }
    }

    private void groupPropertyChanged() {
        DynamicObject group = (DynamicObject)this.getModel().getValue(GROUP_NUMBER);
        if (group != null && group.get("createorg") != null) {
            String parentNumber;
            QFilter[] filters;
            DynamicObject parentObj;
            Object createOrg = ((DynamicObject)group.get("createorg")).getPkValue();
            this.getModel().setValue("createorg", createOrg);
            String number = (String)this.getModel().getValue("number");
            if (StringUtils.isNotBlank((CharSequence)number) && number.contains(SPLIT) && (parentObj = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_ASSISTANT, (String)"id,number", (QFilter[])(filters = new QFilter[]{new QFilter("number", "=", (Object)(parentNumber = number.substring(0, number.lastIndexOf(SPLIT)))), new QFilter(GROUP_NUMBER, "=", group.getPkValue())}))) != null) {
                this.getModel().setValue(PARENT_ID, parentObj.getPkValue());
            }
        }
        if (null != group) {
            this.getModel().setValue(CTRL_VIEW, group.get(CTRL_VIEW_ID));
        }
    }

    private void numberPropertyChanged() {
        if (StringUtils.isBlank((Object)this.getModel().getValue(GROUP_NUMBER))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7c7b\u522b\u3002", (String)"AssistantdataDetailPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isNotBlank((CharSequence)number) && number.contains(SPLIT)) {
            DynamicObject groupObj = (DynamicObject)this.getModel().getValue(GROUP_NUMBER);
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
            if (groupObj == null || createOrg == null) {
                return;
            }
            long createOrgId = createOrg.getLong("id");
            Long groupId = (Long)groupObj.getPkValue();
            QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("number", "=", (Object)number.substring(0, number.lastIndexOf(SPLIT))), AssistantDataServiceHelper.getAssistantDataFilter((Long)groupId, (Long)createOrgId)};
            DynamicObject parentObj = QueryServiceHelper.queryOne((String)ENTITY_ASSISTANT, (String)"id", (QFilter[])filters);
            if (parentObj != null) {
                this.getModel().setValue(PARENT_ID, (Object)parentObj.getLong("id"));
            }
        }
    }

    private void parentPropertyChanged() {
        Object name;
        String parentLongName = "";
        DynamicObject parentObj = (DynamicObject)this.getModel().getValue(PARENT_ID);
        if (Objects.nonNull(parentObj)) {
            parentLongName = parentObj.getString("fullname");
            String strategy = (String)this.getModel().getValue("ctrlstrategy");
            Long createOrgId = AssistantUtils.getCreateOrgIdById((Long)parentObj.getPkValue());
            if ("6".equals(strategy) && createOrgId != 0L) {
                this.getView().getModel().setValue("createorg", (Object)createOrgId);
            }
        }
        if (StringUtils.isNotBlank((Object)(name = this.getModel().getValue("name")))) {
            this.getModel().setValue("fullname", StringUtils.isBlank((CharSequence)parentLongName) ? name : parentLongName + "!" + name);
        }
    }

    private void namePropertyChanged() {
        String parentLongName = "";
        DynamicObject parentObj = (DynamicObject)this.getModel().getValue(PARENT_ID);
        Object name = this.getModel().getValue("name");
        if (parentObj != null) {
            parentLongName = parentObj.getString("fullname");
        }
        if (StringUtils.isNotBlank((Object)name)) {
            this.getModel().setValue("fullname", StringUtils.isBlank((CharSequence)parentLongName) ? name : parentLongName + "!" + name);
        }
    }

    @Deprecated
    public void beforeCreateOrgF7Select(BeforeF7SelectEvent arg0) {
    }

    @Deprecated
    public void beforeGroupF7Select(BeforeF7SelectEvent arg0) {
    }

    public void beforeParentF7Select(BeforeF7SelectEvent arg0) {
        long createOrgId;
        Object createOrg;
        ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
        param.setShowTitle(false);
        param.setCaption(ResManager.loadKDString((String)"\u4e0a\u7ea7\u8f85\u52a9\u8d44\u6599", (String)"AssistantdataDetailPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        DynamicObject groupObj = (DynamicObject)this.getModel().getValue(GROUP_NUMBER);
        Long groupId = 0L;
        if (groupObj != null) {
            groupId = (Long)groupObj.getPkValue();
            param.setCustomParam("prop_assistant_type_id", (Object)groupId);
        }
        if (Objects.nonNull(createOrg = this.getModel().getValue(CREATEORG))) {
            createOrgId = (Long)((DynamicObject)createOrg).getPkValue();
        } else if (groupObj == null) {
            createOrgId = OrgUnitServiceHelper.getRootOrgId();
        } else {
            long viewId = groupObj.getLong(CTRL_VIEW);
            QFilter orgFilter = new QFilter("view.id", "=", (Object)viewId);
            orgFilter.and("parent.id", "=", (Object)0L);
            DynamicObject orgStructure = QueryServiceHelper.queryOne((String)ORG_STRUCTURE_ENTITY, (String)"org.id", (QFilter[])new QFilter[]{orgFilter});
            createOrgId = orgStructure == null ? OrgUnitServiceHelper.getRootOrgId() : orgStructure.getLong("org.id");
        }
        QFilter filter = AssistantDataServiceHelper.getAssistantDataFilter((Long)groupId, (Long)createOrgId);
        filter.and(new QFilter(GROUP_NUMBER, "=", (Object)groupId));
        List filters = param.getListFilterParameter().getQFilters();
        filters.add(filter);
    }

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (CollectionUtils.isEmpty((Collection)sourceDataList)) {
            return;
        }
        this.parsingCreateOrg(sourceDataList);
        this.parsingGroupId(sourceDataList);
        this.parsingParent(sourceDataList);
    }

    private void parsingCreateOrg(List<Map<String, Object>> sourceDataList) {
        Map<String, List<BaseDataItem>> orgItemMap = this.parsingAttributes(sourceDataList, "bos_org", "createorg");
        if (!orgItemMap.isEmpty()) {
            this.backFillPropId(orgItemMap, "bos_org");
        }
    }

    private void parsingGroupId(List<Map<String, Object>> sourceDataList) {
        Map<String, List<BaseDataItem>> groupItemMap = this.parsingAttributes(sourceDataList, ENTITY_ASSISTANT_GROUP, GROUP_NUMBER);
        if (!groupItemMap.isEmpty()) {
            this.backFillPropId(groupItemMap, ENTITY_ASSISTANT_GROUP);
        }
    }

    private void backFillPropId(Map<String, List<BaseDataItem>> propItemMap, String entity) {
        QFilter filter = this.parsingFilter(propItemMap);
        HashSet<String> fields = new HashSet<String>(propItemMap.keySet());
        fields.add("id");
        HashMap<Object, Set> prop2IdMap = new HashMap<Object, Set>(16);
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), entity, String.join((CharSequence)",", fields), new QFilter[]{filter});){
            for (Row row : ds) {
                Long groupId = row.getLong("id");
                for (String importProp : propItemMap.keySet()) {
                    prop2IdMap.computeIfAbsent(row.get(importProp), k -> new HashSet(16)).add(groupId);
                }
            }
        }
        for (List<BaseDataItem> dataItems : propItemMap.values()) {
            for (BaseDataItem dataItem : dataItems) {
                Set dataIds = (Set)prop2IdMap.get(dataItem.importValue);
                if (null == dataIds || dataIds.size() != 1) continue;
                dataItem.setId((Long)dataIds.iterator().next());
            }
        }
    }

    private QFilter parsingFilter(Map<String, List<BaseDataItem>> groupItemMap) {
        QFilter filter = null;
        for (Map.Entry<String, List<BaseDataItem>> entry : groupItemMap.entrySet()) {
            HashSet values = new HashSet(16);
            entry.getValue().forEach(e -> values.add(((BaseDataItem)e).importValue));
            QFilter propFilter = new QFilter(entry.getKey(), "in", values);
            filter = null == filter ? propFilter : filter.or(propFilter);
        }
        return filter;
    }

    private Map<String, List<BaseDataItem>> parsingAttributes(List<Map<String, Object>> sourceDataList, String entity, String prop) {
        HashMap<String, List<BaseDataItem>> propItemMap = new HashMap<String, List<BaseDataItem>>(16);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        for (Map<String, Object> source : sourceDataList) {
            Map propInfo = (Map)source.get(prop);
            if (null == propInfo || propInfo.containsKey("id")) continue;
            BaseDataItem item = new BaseDataItem(propInfo);
            this.parsingAttributes(item, dt, propInfo);
            if (null == item.importValue) continue;
            propItemMap.computeIfAbsent(item.importProp, k -> new ArrayList(10)).add(item);
        }
        return propItemMap;
    }

    private void parsingParent(List<Map<String, Object>> sourceDataList) {
        HashSet<Long> groupIds = new HashSet<Long>(16);
        Map<String, List<BaseDataItem>> parentItemMap = this.getParentItem(sourceDataList, groupIds);
        if (parentItemMap.isEmpty()) {
            return;
        }
        QFilter[] filters = new QFilter[]{this.parsingFilter(parentItemMap), new QFilter(GROUP_NUMBER, "in", groupIds)};
        HashSet<String> fields = new HashSet<String>(parentItemMap.keySet());
        fields.addAll(Arrays.asList("id", "group.id", "group.ctrlstrategy", "createorg"));
        HashSet<Long> privateStrategyGroups = new HashSet<Long>(16);
        HashMap<Long, Map> map = new HashMap<Long, Map>(16);
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), ENTITY_ASSISTANT, String.join((CharSequence)",", fields), filters);){
            for (Row row : ds) {
                Long groupId = row.getLong("group.id");
                boolean isPrivate = "7".equals(row.getString("group.ctrlstrategy"));
                if (isPrivate) {
                    privateStrategyGroups.add(groupId);
                }
                Map propValueMap = map.computeIfAbsent(groupId, k -> new HashMap(16));
                Long dataId = row.getLong("id");
                Long orgId = row.getLong("createorg");
                for (String importProp : parentItemMap.keySet()) {
                    Object importValue = row.get(importProp);
                    Map org2DataMap = propValueMap.computeIfAbsent(importValue, k -> new HashMap(16));
                    org2DataMap.computeIfAbsent(orgId, k -> new HashSet(2)).add(dataId);
                }
            }
        }
        for (List<BaseDataItem> dataItems : parentItemMap.values()) {
            for (BaseDataItem dataItem : dataItems) {
                Collection dataIds;
                Map org2DataMap;
                Map propValueMap = (Map)map.get(dataItem.groupId);
                if (CollectionUtils.isEmpty((Map)propValueMap) || CollectionUtils.isEmpty((Map)(org2DataMap = (Map)propValueMap.get(dataItem.importValue)))) continue;
                if (privateStrategyGroups.contains(dataItem.groupId)) {
                    dataIds = (Set)org2DataMap.get(dataItem.orgId);
                    if (null == dataIds || dataIds.size() != 1) continue;
                    dataItem.setId((Long)dataIds.iterator().next());
                    continue;
                }
                dataIds = new ArrayList(10);
                org2DataMap.values().forEach(arg_0 -> dataIds.addAll(arg_0));
                if (dataIds.size() <= 0) continue;
                dataItem.setId((Long)dataIds.get(0));
            }
        }
    }

    private Map<String, List<BaseDataItem>> getParentItem(List<Map<String, Object>> sourceDataList, Set<Long> groupIds) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITY_ASSISTANT);
        HashMap<String, List<BaseDataItem>> parentItemMap = new HashMap<String, List<BaseDataItem>>(16);
        for (Map<String, Object> source : sourceDataList) {
            boolean notExistGroup;
            Map parentInfo = (Map)source.get(PARENT_ID);
            Map groupInfo = (Map)source.get(GROUP_NUMBER);
            boolean notNeedParsing = null == parentInfo || parentInfo.containsKey("id");
            boolean bl = notExistGroup = null == groupInfo || !groupInfo.containsKey("id");
            if (notNeedParsing || notExistGroup) continue;
            BaseDataItem item = new BaseDataItem(parentInfo);
            Map orgInfo = (Map)source.get("createorg");
            if (null != orgInfo && orgInfo.containsKey("id")) {
                item.orgId = Long.valueOf(orgInfo.get("id").toString());
            }
            Object groupId = groupInfo.get("id");
            item.groupId = Long.valueOf(groupId.toString());
            groupIds.add(item.groupId);
            this.parsingAttributes(item, dt, parentInfo);
            if (null == item.importValue) continue;
            parentItemMap.computeIfAbsent(item.importProp, k -> new ArrayList(10)).add(item);
        }
        return parentItemMap;
    }

    private void parsingAttributes(BaseDataItem item, MainEntityType dt, Map<String, Object> propInfo) {
        if (StringUtils.isBlank((CharSequence)item.importProp)) {
            return;
        }
        DynamicProperty property = dt.getProperty(item.importProp);
        Object value = propInfo.get(item.importProp);
        if (null == property || StringUtils.isBlank((CharSequence)property.getAlias()) || StringUtils.isBlank((Object)value)) {
            return;
        }
        try {
            item.importValue = this.getImportFieldValue(value, item.importProp, property);
        }
        catch (ParseException e) {
            LOGGER.error("\u89e3\u6790\u5bf9\u8c61\u503c\u5f02\u5e38", (Throwable)e);
        }
    }

    private Object getImportFieldValue(Object value, String field, DynamicProperty property) throws ParseException {
        if (property instanceof MuliLangTextProp) {
            if (value instanceof Map) {
                return LocaleString.fromMap((Map)((Map)value)).toString();
            }
            return value;
        }
        if (property instanceof LongProp && !(value instanceof Long)) {
            return Long.valueOf(value.toString());
        }
        if (property instanceof DecimalProp && value instanceof String) {
            return new BigDecimal(new BigDecimal((String)value).stripTrailingZeros().toPlainString());
        }
        if (property instanceof TimeProp) {
            return TimeProp.timeToSecond((Object)value.toString(), (String)field);
        }
        if (property instanceof DateTimeProp && !(value instanceof Date)) {
            return ((DateTimeProp)property).getDateFormat().parse(value.toString());
        }
        return value;
    }

    public void afterImportData(ImportDataEventArgs e) {
        Object value = this.getModel().getValue(GROUP_NUMBER);
        if (null != value) {
            DynamicObject group = (DynamicObject)value;
            String strategy = group.getString("ctrlstrategy");
            this.getModel().setValue("ctrlstrategy", (Object)strategy);
        }
    }

    private static class BaseDataItem {
        private Long groupId;
        private Long orgId;
        private String number;
        private String name;
        private String importProp;
        private Object importValue;
        private Map<String, Object> dataMap;

        private BaseDataItem(Map<String, Object> dataMap) {
            this.name = (String)dataMap.get("name");
            this.number = (String)dataMap.get("number");
            this.dataMap = dataMap;
            this.setImportProp(dataMap);
        }

        private void setId(Long value) {
            this.dataMap.put("id", value);
        }

        private void setImportProp(Map<String, Object> dataMap) {
            this.importProp = (String)dataMap.get("importprop");
            if (StringUtils.isNotBlank((CharSequence)this.importProp)) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)this.number)) {
                this.importProp = "number";
            } else if (StringUtils.isNotBlank((CharSequence)this.name)) {
                this.importProp = "name";
            }
        }
    }
}

