/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AssistantLisUtil;
import kd.bos.form.plugin.AssistantTreeListEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.ILicenseService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AssistantGroupEdit
extends AbstractBasePlugIn {
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String CREATEORG = "createOrg";
    private static final String ORG_PERM_CHANGE_ENTITYID = "bos_org_change_page";
    private static final String ASSISTANT_GROUP_ENTITYID = "bos_assistantdatagroup";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_SAVE_NEW = "btnsaveandnew";
    private static final String CTRLVIEW = "ctrlview";
    private static final String IMPORT = "btnimport";
    private static final String ORGCHANGE = "btnorgchange";
    private static final String TOOL_BAR = "toolbarap";
    private static final String FBIZCLOUDID = "fbizcloudid";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String OP_SAVE = "save";
    private static final String GROUP_CONTROL = "isgroupcontrol";
    private static final String BOS_BD_FORMPLUGIN = "bos-bd-formplugin";

    public void initialize() {
        this.addItemClickListeners(new String[]{TOOL_BAR});
        this.addClickListeners(new String[]{BTN_SAVE, BTN_SAVE_NEW, IMPORT, ORGCHANGE});
    }

    public void afterCreateNewData(EventObject e) {
        String operate;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String currentId = (String)parameter.getCustomParam("id");
        if (currentId == null) {
            return;
        }
        String createOrg = (String)parameter.getCustomParam(CREATEORG);
        if (StringUtils.isNotBlank((CharSequence)createOrg)) {
            this.getModel().setValue("createorg", (Object)Long.parseLong(createOrg));
        }
        if (!"addnew".equals(operate = (String)parameter.getCustomParam("operate")) || "myroot".equals(currentId)) {
            return;
        }
        if (currentId.contains(PREFIX_CLOUD)) {
            String[] currNodeArr = currentId.split("_");
            this.getModel().setValue(FBIZCLOUDID, (Object)currNodeArr[1]);
        }
    }

    public void afterBindData(EventObject e) {
        ILicenseService service;
        boolean isSingleOrgManageMode;
        OperationStatus status;
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String operate = (String)parameter.getCustomParam("operate");
        if ("addnew".equals(operate)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ORGCHANGE});
        }
        if ("edit".equals(operate)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SAVE_NEW});
        }
        if (this.enableChangeStrategy()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{CTRLVIEW});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{CTRLSTRATEGY});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{CTRLVIEW});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{CTRLSTRATEGY});
        }
        if (parameter instanceof BillShowParameter && (status = parameter.getStatus()) == OperationStatus.VIEW) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ORGCHANGE, BTN_SAVE, BTN_SAVE_NEW, IMPORT});
        }
        if (isSingleOrgManageMode = (service = (ILicenseService)ServiceFactory.getService((String)"ILicenseService")).isSingleOrgManageMode()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ORGCHANGE, CTRLVIEW, GROUP_CONTROL, CTRLSTRATEGY});
        }
        boolean isPrivate = "7".equals(this.getModel().getValue(CTRLSTRATEGY));
        Object view = this.getModel().getValue(CTRLVIEW);
        if (isSingleOrgManageMode || isPrivate || Objects.isNull(view)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{GROUP_CONTROL});
        } else {
            DynamicObject viewObj = (DynamicObject)view;
            Long rootOrgId = AssistantLisUtil.getRootOrgIdByView(viewObj.getLong("id"));
            String createOrg = (String)parameter.getCustomParam(CREATEORG);
            this.getView().setEnable(Boolean.valueOf(rootOrgId.toString().equals(createOrg)), new String[]{GROUP_CONTROL});
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue(CREATEORG);
        if (BTN_SAVE.equals(key) || BTN_SAVE_NEW.equals(key)) {
            DynamicObject ctrlView = (DynamicObject)this.getModel().getValue(CTRLVIEW);
            if (null == ctrlView) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a7\u5236\u89c6\u56fe\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u4fdd\u5b58\u6570\u636e\u3002", (String)"AssistantGroupEdit_12", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (null == createOrg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u4fdd\u5b58\u6570\u636e\u3002", (String)"AssistantGroupEdit_11", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (!this.isCreateOrgInCtrlView((Long)createOrg.getPkValue(), (Long)ctrlView.getPkValue())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5728\u63a7\u5236\u89c6\u56fe\u5185\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AssistantGroupEdit_0", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (ORGCHANGE.equals(key)) {
            if (StringUtils.isBlank((Object)createOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f85\u8f6c\u8ba9\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssistantGroupEdit_10", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String opOrg = (String)this.getView().getFormShowParameter().getCustomParam(CREATEORG);
            if (StringUtils.isBlank((CharSequence)opOrg) || !AssistantLisUtil.validateUserPerm((AbstractFormPlugin)this, "4730fc9f000000ac", Long.parseLong(opOrg), ASSISTANT_GROUP_ENTITYID)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8f85\u52a9\u8d44\u6599\u5206\u7c7b\u201d\u7684\u201c\u7ba1\u7406\u6743\u8f6c\u8ba9\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssistantGroupEdit_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if (IMPORT.equals(key)) {
            this.getPageCache().put("isbatchinput", "true");
        } else if (ORGCHANGE.equals(key)) {
            this.showOrgChange();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        if (FBIZCLOUDID.equals(property)) {
            this.getModel().setValue("parent", null);
        } else if (CTRLVIEW.equals(property)) {
            Object view = this.getModel().getValue(CTRLVIEW);
            if (Objects.isNull(view)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{GROUP_CONTROL});
                this.getModel().setValue(GROUP_CONTROL, (Object)Boolean.FALSE);
                return;
            }
            boolean isPrivate = "7".equals(this.getModel().getValue(CTRLSTRATEGY));
            DynamicObject viewObj = (DynamicObject)view;
            Long rootOrgId = AssistantLisUtil.getRootOrgIdByView(viewObj.getLong("id"));
            String createOrgId = (String)this.getView().getFormShowParameter().getCustomParam(CREATEORG);
            if (StringUtils.isNotEmpty((CharSequence)createOrgId) && rootOrgId.toString().equals(createOrgId)) {
                if (isPrivate) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{GROUP_CONTROL});
                    this.getModel().setValue(GROUP_CONTROL, (Object)Boolean.FALSE);
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{GROUP_CONTROL});
                }
            } else {
                this.getModel().setValue(GROUP_CONTROL, (Object)false);
                this.getView().setEnable(Boolean.FALSE, new String[]{GROUP_CONTROL});
            }
        } else if (CTRLSTRATEGY.equals(property)) {
            boolean isRootOrg = false;
            Object view = this.getModel().getValue(CTRLVIEW);
            if (!Objects.isNull(view)) {
                DynamicObject viewObj = (DynamicObject)view;
                Long rootOrgId = AssistantLisUtil.getRootOrgIdByView(viewObj.getLong("id"));
                String createOrgId = (String)this.getView().getFormShowParameter().getCustomParam(CREATEORG);
                isRootOrg = StringUtils.isNotEmpty((CharSequence)createOrgId) && rootOrgId.toString().equals(createOrgId);
            }
            ChangeData changeData = e.getChangeSet()[0];
            if (!isRootOrg || "7".equals(changeData.getNewValue())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{GROUP_CONTROL});
                this.getModel().setValue(GROUP_CONTROL, (Object)Boolean.FALSE);
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{GROUP_CONTROL});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate operate;
        String opKey;
        super.afterDoOperation(args);
        if (args.getSource() instanceof FormOperate && StringUtils.equalsIgnoreCase((CharSequence)(opKey = (operate = (FormOperate)args.getSource()).getOption().getVariableValue("oriOperationKey", operate.getOperateKey())), (CharSequence)OP_SAVE) && args.getOperationResult().isSuccess()) {
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String isbatchinput = this.getPageCache().get("isbatchinput");
        if (ObjectUtils.isEmpty((Object)isbatchinput)) {
            String nodeId = "";
            Object parentObj = this.getModel().getDataEntity().get("parent");
            if (ObjectUtils.isEmpty((Object)parentObj)) {
                parentObj = this.getModel().getDataEntity().get(FBIZCLOUDID);
                if (parentObj != null) {
                    nodeId = PREFIX_CLOUD + ((DynamicObject)parentObj).getPkValue();
                }
            } else {
                nodeId = ((DynamicObject)parentObj).getPkValue().toString();
            }
            if (StringUtils.isNotBlank((CharSequence)nodeId)) {
                this.getView().returnDataToParent((Object)nodeId);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object targetOrg;
        super.closedCallBack(closedCallBackEvent);
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        Object object = targetOrg = returnData == null ? null : (Object)returnData.get("targetOrg");
        if (targetOrg == null || StringUtils.isBlank(targetOrg)) {
            return;
        }
        this.getModel().setValue("createorg", (Object)Long.parseLong(targetOrg.toString()));
        this.getView().updateView();
    }

    private boolean isCreateOrgInCtrlView(long orgId, long viewId) {
        List ids = OrgUnitServiceHelper.getAllOrgByViewId((long)viewId, (boolean)true);
        return ids.contains(orgId);
    }

    private boolean enableChangeStrategy() {
        Object pkId = this.getModel().getDataEntity().getPkValue();
        if (pkId == null) {
            return false;
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select top 1 fgroupid from t_bas_assistantdataentry where ", new Object[0]).append("fgroupid = ?", new Object[]{pkId});
        try (DataSet ds = DB.queryDataSet((String)AssistantTreeListEdit.class.getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)builder);){
            boolean bl = ds.hasNext();
            return bl;
        }
    }

    private void showOrgChange() {
        Object groupPk = this.getView().getModel().getDataEntity().getPkValue();
        if (StringUtils.isBlank((Object)groupPk)) {
            return;
        }
        long groupId = Long.parseLong(groupPk.toString());
        if (AssistantLisUtil.isGroupControl(groupId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u96c6\u56e2\u7ba1\u63a7\u201d\u7684\u8d44\u6599\u4e0d\u80fd\u8fdb\u884c\u7ba1\u7406\u6743\u8f6c\u8ba9\uff0c\u5982\u9700\u8f6c\u8ba9\uff0c\u8bf7\u5148\u53bb\u9664\u96c6\u56e2\u7ba1\u63a7\u7684\u52fe\u9009\u3002", (String)"AssistantGroupEdit_2", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue(CREATEORG);
        Long sourceOrg = (Long)createOrg.getPkValue();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(ORG_PERM_CHANGE_ENTITYID);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("groupId", (Object)groupPk.toString());
        showParameter.setCustomParam(CREATEORG, (Object)sourceOrg);
        showParameter.setCustomParam("ids", new ArrayList<Long>(Collections.singletonList(groupId)));
        showParameter.setCustomParam("entityId", (Object)ASSISTANT_GROUP_ENTITYID);
        showParameter.setCustomParam("fromAssistantGroup", (Object)"true");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ORGCHANGE));
        this.getView().showForm(showParameter);
    }
}

