/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AssistantGroupListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(AssistantGroupListPlugin.class);
    private static final String VIEW_ID = "view.id";
    private static final String CREATEORG_NUMBER = "createorg.number";
    private static final String CTRL_VIEW_ID = "ctrlview.id";
    private static final String ENTITY_ASSISTANT_GROUP = "bos_assistantdatagroup";

    public void setFilter(SetFilterEvent e) {
        QFilter viewFilter;
        DynamicObjectCollection useOrgStructures;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (!listShowParameter.isLookUp()) {
            return;
        }
        List useOrgIds = listShowParameter.getUseOrgIds();
        if (!CollectionUtils.isEmpty((Collection)useOrgIds)) {
            return;
        }
        Long useOrgId = listShowParameter.getUseOrgId();
        if (useOrgId == 0L) {
            useOrgId = this.getUseOrgOrDefault();
        }
        if (CollectionUtils.isEmpty((Collection)(useOrgStructures = QueryServiceHelper.query((String)"bos_org_structure", (String)"longnumber,view.id", (QFilter[])new QFilter[]{viewFilter = new QFilter("org", "=", (Object)useOrgId)})))) {
            return;
        }
        HashSet<String> createOrgNumbers = new HashSet<String>(16);
        HashMap<Long, List> viewOrgMap = new HashMap<Long, List>(useOrgStructures.size());
        for (DynamicObject orgStructure : useOrgStructures) {
            String longNumber;
            Long viewId = orgStructure.getLong(VIEW_ID);
            if (viewId.equals(1L) || viewId.equals(15L) || StringUtils.isEmpty((CharSequence)(longNumber = orgStructure.getString("longnumber")))) continue;
            String[] viewCreateOrgNumbers = longNumber.split("!");
            HashSet<String> viewOrgSet = new HashSet<String>(Arrays.asList(viewCreateOrgNumbers));
            createOrgNumbers.addAll(viewOrgSet);
            viewOrgMap.computeIfAbsent(viewId, k -> new ArrayList()).addAll(Arrays.asList(viewCreateOrgNumbers));
        }
        String groupSelectFields = "createorg.number,ctrlview.id,id";
        QFilter groupFilter = new QFilter(CTRL_VIEW_ID, "in", viewOrgMap.keySet());
        groupFilter.and(CREATEORG_NUMBER, "in", createOrgNumbers);
        DynamicObjectCollection groups = QueryServiceHelper.query((String)ENTITY_ASSISTANT_GROUP, (String)groupSelectFields, (QFilter[])new QFilter[]{groupFilter});
        HashSet<Long> availableGroups = new HashSet<Long>(groups.size());
        for (DynamicObject group : groups) {
            Long viewId = group.getLong(CTRL_VIEW_ID);
            String createOrgNumber = group.getString(CREATEORG_NUMBER);
            if (!((List)viewOrgMap.get(viewId)).contains(createOrgNumber)) continue;
            Long groupId = group.getLong("id");
            availableGroups.add(groupId);
        }
        e.getQFilters().add(new QFilter("id", "in", availableGroups));
    }

    private Long getUseOrgOrDefault() {
        IDataModel parentModel;
        String parentViewPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentViewPageId);
        HashMap allFields = new HashMap(16);
        try {
            parentModel = parentView.getModel();
            allFields.putAll(parentModel.getDataEntityType().getAllFields());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u521b\u5efa\u7ec4\u7ec7\u5931\u8d25\uff1a", (Throwable)e);
            return OrgUnitServiceHelper.getRootOrgId();
        }
        if (!allFields.containsKey("createorg") || parentModel.getValue("createorg") == null) {
            return OrgUnitServiceHelper.getRootOrgId();
        }
        Object createOrg = parentModel.getValue("createorg");
        if (createOrg instanceof DynamicObject) {
            return ((DynamicObject)createOrg).getLong("id");
        }
        if (createOrg instanceof Long) {
            return (Long)createOrg;
        }
        return OrgUnitServiceHelper.getRootOrgId();
    }
}

