/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AssistantLisUtil {
    private static final Log LOGGER = LogFactory.getLog(AssistantLisUtil.class);
    private static final String ENTITY_ASSISTANT_DATA = "bos_assistantdata_detail";
    private static final String ENTITY_ASSISTANT_GROUP = "bos_assistantdatagroup";
    private static final String PARA_ASSISTANT_TYPE_ID = "prop_assistant_type_id";
    private static final String PROP_GROUP = "group";
    private static final String PROP_GROUP_ID = "group.id";
    private static final String PROP_GROUP_NUMBER = "group.number";

    public static boolean validateUserPerm(AbstractFormPlugin plugin, String permItem, Long createOrg, String entity) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)createOrg, (String)AssistantLisUtil.getAppId(entity, plugin), (String)entity, (String)permItem) == 1;
    }

    public static String getCreateOrg(StandardTreeListPlugin plugin) {
        String createOrg = plugin.getPageCache().get("createOrg");
        if (StringUtils.isNotBlank((CharSequence)createOrg)) {
            return createOrg;
        }
        List<Long> hasPermOrgIds = AssistantLisUtil.getAssistantQueryPermissionOrgId(plugin);
        long loginOrg = RequestContext.get().getOrgId();
        if (!CollectionUtils.isEmpty(hasPermOrgIds)) {
            if (hasPermOrgIds.contains(loginOrg)) {
                return String.valueOf(loginOrg);
            }
            return hasPermOrgIds.get(0).toString();
        }
        List allOrgId = OrgUnitServiceHelper.getAllOrg((String)"15");
        if (!CollectionUtils.isEmpty((Collection)allOrgId) && !allOrgId.contains(loginOrg)) {
            return ((Long)allOrgId.get(0)).toString();
        }
        return String.valueOf(loginOrg);
    }

    public static List<Long> getAssistantQueryPermissionOrgId(StandardTreeListPlugin plugin) {
        long userId = RequestContext.get().getCurrUserId();
        String appId = AssistantLisUtil.getAppId(ENTITY_ASSISTANT_DATA, (AbstractFormPlugin)plugin);
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)ENTITY_ASSISTANT_DATA, (String)"47150e89000000ac");
        return result.getHasPermOrgs();
    }

    public static boolean isGroupControl(long assistantGroupId) {
        DynamicObject groupDynamicObject = BusinessDataServiceHelper.loadSingle((Object)assistantGroupId, (String)ENTITY_ASSISTANT_GROUP);
        return null != groupDynamicObject && groupDynamicObject.getBoolean("isgroupcontrol");
    }

    private static String getAppId(String entity, AbstractFormPlugin plugin) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entity);
        String appNumber = plugin.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        return appid;
    }

    public static Long getRootOrgIdByView(Long viewId) {
        OrgTreeParam orgTreeParam = new OrgTreeParam();
        orgTreeParam.setId(0L);
        orgTreeParam.setOrgViewId(viewId.longValue());
        Map rootNodeMap = OrgUnitServiceHelper.getTreeRootNodeMapById((OrgTreeParam)orgTreeParam);
        if (!CollectionUtils.isEmpty((Map)rootNodeMap)) {
            return (Long)rootNodeMap.get("id");
        }
        return OrgUnitServiceHelper.getRootOrgId();
    }

    static String getGroupId(ListShowParameter parameter) {
        Object group = parameter.getCustomParam(PARA_ASSISTANT_TYPE_ID);
        if (StringUtils.isNotBlank((Object)group)) {
            return group.toString();
        }
        group = parameter.getCustomParam(PROP_GROUP);
        if (StringUtils.isNotBlank((Object)group)) {
            return group.toString();
        }
        List filters = parameter.getListFilterParameter().getQFilters();
        return AssistantLisUtil.parsingGroupFromFilter(filters);
    }

    private static String parsingGroupFromFilter(List<QFilter> filters) {
        HashSet groupIds = new HashSet(1);
        HashSet groupNums = new HashSet(1);
        filters.forEach(f -> AssistantLisUtil.parsingAttributeValue(f, groupIds, groupNums));
        if (groupIds.size() > 1) {
            return null;
        }
        if (groupNums.isEmpty() && groupIds.size() == 1) {
            return ((Long)groupIds.iterator().next()).toString();
        }
        QFilter[] groupFilters = new QFilter[]{new QFilter("number", "in", groupNums)};
        try (DataSet ds = ORM.create().queryDataSet(AssistantLisUtil.class.getName(), ENTITY_ASSISTANT_GROUP, "id", groupFilters);){
            ds.forEach(r -> groupIds.add(r.getLong("id")));
        }
        return groupIds.size() == 1 ? ((Long)groupIds.iterator().next()).toString() : null;
    }

    private static void parsingAttributeValue(QFilter filter, Set<Long> groupIds, Set<String> groupNums) {
        if (null == filter) {
            return;
        }
        String property = filter.getProperty();
        Object value = filter.getValue();
        String cp = filter.getCP();
        try {
            if (PROP_GROUP.equalsIgnoreCase(property) || PROP_GROUP_ID.equalsIgnoreCase(property)) {
                if ("=".equals(cp)) {
                    groupIds.add(Long.valueOf(value.toString()));
                } else if ("in".equals(cp)) {
                    if (value instanceof Iterable) {
                        ((Iterable)value).forEach(i -> groupIds.add(Long.valueOf(i.toString())));
                    } else if (value.getClass().isArray()) {
                        int length = Array.getLength(value);
                        for (int i2 = 0; i2 < length; ++i2) {
                            groupIds.add(Long.valueOf(Array.get(value, i2).toString()));
                        }
                    }
                }
            } else if (PROP_GROUP_NUMBER.equalsIgnoreCase(property)) {
                if ("=".equals(cp)) {
                    groupNums.add(value.toString());
                } else if ("in".equals(cp)) {
                    if (value instanceof Iterable) {
                        ((Iterable)value).forEach(i -> groupNums.add(i.toString()));
                    } else if (value.getClass().isArray()) {
                        int length = Array.getLength(value);
                        for (int i3 = 0; i3 < length; ++i3) {
                            groupNums.add(Array.get(value, i3).toString());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4ece\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u89e3\u6790\u5206\u7c7bID\u5f02\u5e38...", (Throwable)e);
        }
        filter.getNests(true).forEach(f -> AssistantLisUtil.parsingAttributeValue(f.getFilter(), groupIds, groupNums));
    }

    static List<Long> getUseOrgIds(ListShowParameter listShowParameter, IFormView parentView) {
        ArrayList<Long> useOrgIds = new ArrayList<Long>(10);
        if (!CollectionUtils.isEmpty((Collection)listShowParameter.getUseOrgIds())) {
            for (Object useOrgIdObj : listShowParameter.getUseOrgIds()) {
                useOrgIds.add(Long.valueOf(String.valueOf(useOrgIdObj)));
            }
            return useOrgIds;
        }
        long useOrgId = listShowParameter.getUseOrgId();
        if (useOrgId != 0L) {
            useOrgIds.add(useOrgId);
            return useOrgIds;
        }
        Long flexUseOrgId = AssistantLisUtil.getUseOrgOnFlex(parentView);
        if (null != flexUseOrgId) {
            useOrgIds.add(flexUseOrgId);
            return useOrgIds;
        }
        Long billUseOrgId = AssistantLisUtil.getUseOrgFromParentView(parentView);
        if (null != billUseOrgId) {
            useOrgIds.add(billUseOrgId);
        }
        return useOrgIds;
    }

    private static Long getUseOrgOnFlex(IFormView parentView) {
        if (null == parentView) {
            return null;
        }
        FormShowParameter parentFormShowParameter = parentView.getFormShowParameter();
        Object orgId = parentFormShowParameter.getCustomParam("orgId");
        if (Objects.nonNull(orgId)) {
            return Long.valueOf(orgId.toString());
        }
        return null;
    }

    private static Long getUseOrgFromParentView(IFormView parentView) {
        if (null == parentView) {
            return null;
        }
        Map allFields = parentView.getModel().getDataEntityType().getAllFields();
        if (!CollectionUtils.isEmpty((Map)allFields) && allFields.containsKey("createorg")) {
            Object createOrgObj = parentView.getModel().getValue("createorg");
            if (createOrgObj instanceof DynamicObject) {
                return ((DynamicObject)createOrgObj).getLong("id");
            }
            if (createOrgObj instanceof Long) {
                return (Long)createOrgObj;
            }
        }
        return null;
    }
}

