/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AssistantLisUtil;
import kd.bos.form.plugin.AssistantTreeListEdit;
import kd.bos.form.plugin.AssistantTreeUtils;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AssistantLowerDataQuery
extends AssistantTreeListEdit {
    private static Log log = LogFactory.getLog(AssistantLowerDataQuery.class);
    private static final String DEFAULT_FUNC = "16";

    @Override
    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("group.number,number,seq");
        String createOrg = this.getPageCache().get("createOrg");
        if (StringUtils.isEmpty((CharSequence)createOrg)) {
            return;
        }
        long createOrgId = Long.parseLong(createOrg);
        String currentNodeId = (String)this.treeListView.getTreeModel().getCurrentNodeId();
        if (null == currentNodeId) {
            QFilter unLoadDataFilter = new QFilter("1", "!=", (Object)1);
            e.setMainOrgQFilter(unLoadDataFilter);
            return;
        }
        if ("myroot".equals(currentNodeId)) {
            QFilter orgFilter = this.getSubOrgCtrlFilter(createOrgId);
            e.setMainOrgQFilter(orgFilter);
            return;
        }
        if (currentNodeId.startsWith("cloud_")) {
            QFilter orgFilter = this.getSubOrgCtrlFilter(createOrgId);
            List<TreeNode> groupNodes = this.getGroupNodes(currentNodeId);
            ArrayList groupIds = new ArrayList(groupNodes.size());
            groupNodes.forEach(groupNode -> groupIds.add(Long.valueOf(groupNode.getId())));
            QFilter groupFilter = new QFilter("group.id", "in", groupIds);
            orgFilter.and(groupFilter);
            e.setMainOrgQFilter(orgFilter);
            return;
        }
        e.setMainOrgQFilter(this.getSubDataFilter(Long.valueOf(currentNodeId), createOrgId));
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        Object createOrgParam = lsp.getCustomParam("createOrg");
        if (createOrgParam == null) {
            return;
        }
        this.getPageCache().put("createOrg", createOrgParam.toString());
        long createOrgId = Long.parseLong(createOrgParam.toString());
        FilterColumn createOrgFilterColumn = args.getFilterColumn("createorg.name");
        createOrgFilterColumn.setDefaultValue(Long.toString(createOrgId));
    }

    @Override
    void setFilterColumn(FilterColumn filterColumn) {
        List<ComboItem> combos;
        HasPermOrgResult result = this.getPermOrg();
        if (result.hasAllOrgPerm()) {
            combos = this.buildComboItems(null);
        } else {
            ArrayList hasPermOrgIds = result.getHasPermOrgs();
            if (null == hasPermOrgIds) {
                hasPermOrgIds = new ArrayList(0);
            }
            combos = this.buildComboItems(new QFilter[]{new QFilter("id", "in", hasPermOrgIds)});
        }
        ((CommonFilterColumn)filterColumn).setComboItems(combos);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (!"createorg.id".equals(args.getFieldName())) {
            return;
        }
        HasPermOrgResult result = this.getPermOrg();
        if (result.hasAllOrgPerm()) {
            return;
        }
        ArrayList hasPermOrgIds = result.getHasPermOrgs();
        if (null == hasPermOrgIds) {
            hasPermOrgIds = new ArrayList(0);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(Collections.singletonList(new QFilter("id", "in", hasPermOrgIds)));
        List f7SelectFilters = args.getQfilters();
        if (f7SelectFilters == null) {
            args.setQfilters(filters);
        } else {
            f7SelectFilters.addAll(filters);
        }
    }

    private HasPermOrgResult getPermOrg() {
        String appId = null;
        String appNumber = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isNotBlank((CharSequence)appNumber)) {
            try {
                appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType met = EntityMetadataCache.getDataEntityType((String)"bos_assistantdata_detail");
                appId = met.getAppId();
            }
        }
        return PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bos_assistantdata_detail", (String)"2AXP/7L+N72=");
    }

    @Override
    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        ListShowParameter fsp = (ListShowParameter)this.getView().getFormShowParameter();
        Object groupId = fsp.getCustomParam("groupId");
        String initCurrentNode = this.getPageCache().get("initCurrentNode");
        if (groupId == null || "false".equals(initCurrentNode)) {
            return;
        }
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode treeNode = root.getTreeNode(groupId.toString());
        this.getTreeModel().setCurrentNodeId((Object)groupId.toString());
        this.getTreeListView().getTreeView().focusNode(treeNode);
        this.getPageCache().put("initCurrentNode", "false");
    }

    private QFilter getSubOrgCtrlFilter(long createOrgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(createOrgId);
        List subordinateOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)DEFAULT_FUNC, orgIds, (boolean)false);
        return new QFilter("createorg.id", "in", (Object)subordinateOrgIds);
    }

    private QFilter getSubDataFilter(Long currentNodeId, long createOrgId) {
        String viewId = AssistantDataServiceHelper.getAssistantDataCtrlView((Long)currentNodeId);
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(createOrgId);
        List subordinateOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)viewId, orgIds, (boolean)false);
        return new QFilter("createorg.id", "in", (Object)subordinateOrgIds);
    }

    private List<TreeNode> getGroupNodes(String currentNodeId) {
        Long createOrgId = 0L;
        String createOrg = AssistantLisUtil.getCreateOrg(this);
        if (StringUtils.isNotBlank((CharSequence)createOrg)) {
            this.getPageCache().put("createOrg", createOrg);
            createOrgId = Long.valueOf(createOrg);
        }
        QFilter cloudFilter = new QFilter("fbizcloudid", "=", (Object)currentNodeId.split("_")[1]);
        return AssistantTreeUtils.getGroupNodesByQflter(createOrgId, cloudFilter);
    }
}

