/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.bd.ctsy.utils.CtsyDBUtils;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AssistantLisUtil;
import kd.bos.form.plugin.AssistantTreeUtils;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.ILicenseService;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AssistantTreeListEdit
extends StandardTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(AssistantTreeListEdit.class);
    private static final String BOS_FORM_BUSINESS = "bos-bd-formplugin";
    static final String ASSISTANT_DATA_ENTITYID = "bos_assistantdata_detail";
    private static final String ASSISTANT_GROUP_ENTITYID = "bos_assistantdatagroup";
    private static final String ORG_PERM_CHANGE_ENTITYID = "bos_org_change_page";
    private static final String TEMP_TREELIST_F7 = "bos_treelistf7";
    private static final String TOOLBAR = "tbmain";
    private static final String DISABLE = "tbldisable";
    private static final String DELETE = "tbldel";
    private static final String NEW = "tblnew";
    private static final String ORG_CHANGE = "tborgchange";
    private static final String LOWERDATAQUERY_OPKEY = "lowerdataquery";
    private static final String OPERATE_DELETE = "delete";
    private static final String OPERATE_DISABLE = "disable";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDI = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String BTN_EXPORT_GROUP = "exportgroup";
    private static final String BTN_IMPORT_GROUP = "importgroup";
    private static final String PREFIX_APP = "app_";
    static final String PREFIX_CLOUD = "cloud_";
    static final String MYROOT = "myroot";
    private static final String F7_ROOT_NODE = "0";
    private static final String PARAM_IS_PARENT = "isParentAsst";
    private static final String PARAM_IS_CHILD = "isChildAsst";
    private static final String PARAM_ASST_PARENT_ID = "assistantParentId";
    private static final String PARAM_ASST_PARENT_NAME = "assistantParentName";
    private static final String PARAM_EXPORT_GROUP = "exportGroup";
    private static final String GROUP_FIELD_FID = "group";
    static final String GROUP_ID = "group.id";
    private static final String PARENT_ID = "parent.id";
    static final String CREATEORG_FILEDNAME = "createorg.id";
    static final String CREATEORG_NAME_FILEDNAME = "createorg.name";
    private static final String TREEVIEW = "treeview";
    private static final String PROP_SHOW_DISABLED = "isshowdisabled";
    private static final String CONFIRM_ORGCHANGE = "confirmOrgChange";
    private static final String EDIT_GROUP = "editGroup";
    private static final String OPTION_USEORG = "useOrg";
    static final String CREATEORG = "createOrg";
    private static final String VERIFY_ORG = "verifyOrg";
    private static final String LOG_NUMBERS = "logNumbers";
    private static final String VALUE = "value";
    private static final String PARENTID = "parentid";
    private static final String TREE_PARENT_ID = "tree_parent_id";
    private boolean isSingleOrgManageMode = false;
    private boolean needQueryChildNode = true;
    private static final List<String> HIDE_FIELDS_LIST = new ArrayList<String>(10);

    public void preOpenForm(PreOpenFormEventArgs e) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (!listShowParameter.isLookUp()) {
            return;
        }
        String groupId = AssistantLisUtil.getGroupId(listShowParameter);
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            listShowParameter.setFormId("bos_listf7");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TOOLBAR});
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        String treeNodeId = (String)parameter.getCustomParam("treeRootNodeId");
        if (StringUtils.isNotBlank((CharSequence)treeNodeId) && !parameter.isLookUp()) {
            TreeNode node = this.getTreeModel().getRoot().getTreeNode(treeNodeId, 10);
            node.setParentid("");
            node.setIsOpened(true);
            this.getTreeListView().getTreeModel().setRoot(node);
            this.getTreeModel().setCurrentNodeId((Object)node.getId());
        }
        this.isSingleOrgManageMode = ((ILicenseService)ServiceFactory.getService(ILicenseService.class)).isSingleOrgManageMode();
        if (this.isSingleOrgManageMode) {
            Long orgId = RequestContext.get().getOrgId();
            this.getPageCache().put(CREATEORG, String.valueOf(orgId));
            this.getPageCache().put(VERIFY_ORG, String.valueOf(orgId));
        }
    }

    public void treeToolbarClick(EventObject e) {
        Control ctl = (Control)e.getSource();
        if (ctl.getKey().equals(BTN_NEW)) {
            this.treeToolBarAddClick();
        } else if (ctl.getKey().equals(BTN_EDI)) {
            this.treeToolBarEditClick();
        } else if (ctl.getKey().equals(BTN_DEL)) {
            this.treeToolBarDeleteClick();
        }
    }

    private void treeToolBarAddClick() {
        String createOrg = AssistantLisUtil.getCreateOrg(this);
        long createOrgId = Long.parseLong(createOrg);
        GroupProp prop = this.getTreeModel().getGroupProp();
        String entityId = prop.getBaseEntityId();
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        if (!Objects.equals(currentNodeId, this.getTreeModel().getRoot().getId()) && !currentNodeId.contains(PREFIX_CLOUD)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4e91\u8282\u70b9\u4e0b\u65b0\u589e\u5206\u7c7b\u3002", (String)"AssistantTreeListEdit_18", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)createOrg)) {
            this.getView().showTipNotification(AssistantTreeListEdit.getChoseValidBusinessOrg());
            return;
        }
        if (!AssistantLisUtil.validateUserPerm((AbstractFormPlugin)this, "47156aff000000ac", createOrgId, ASSISTANT_GROUP_ENTITYID)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8f85\u52a9\u8d44\u6599\u5206\u7c7b\u201d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AssistantTreeListEdit_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (this.isOrgDisableOrFreeze(createOrgId, 15L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u7981\u7528/\u5c01\u5b58\u72b6\u6001\u3002", (String)"AssistantTreeListEdit_46", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        this.addGroupNode(entityId, currentNodeId, createOrg);
    }

    private static String getChoseValidBusinessOrg() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6709\u6548\u7684\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"AssistantTreeListEdit_17", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
    }

    private void treeToolBarEditClick() {
        String createOrg = AssistantLisUtil.getCreateOrg(this);
        long createOrgId = Long.parseLong(createOrg);
        GroupProp prop = this.getTreeModel().getGroupProp();
        String entityId = prop.getBaseEntityId();
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        if (!AssistantLisUtil.validateUserPerm((AbstractFormPlugin)this, "4715a0df000000ac", createOrgId, ASSISTANT_GROUP_ENTITYID)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8f85\u52a9\u8d44\u6599\u5206\u7c7b\u201d\u7684\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AssistantTreeListEdit_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (this.getTreeModel().getRoot().getId().equals(currentNodeId) || currentNodeId.contains(PREFIX_CLOUD)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u4e91\u8282\u70b9\u3002", (String)"AssistantTreeListEdit_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7ec4\u8282\u70b9\u3002", (String)"AssistantTreeListEdit_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (!prop.isNeedRefreshTree()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u5237\u65b0\u60c5\u51b5\u4e0d\u5141\u8bb8\u4fee\u6539\u8282\u70b9\u3002", (String)"AssistantTreeListEdit_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        this.editGroupNode(entityId, currentNodeId, createOrg);
    }

    private void treeToolBarDeleteClick() {
        String createOrg = AssistantLisUtil.getCreateOrg(this);
        long createOrgId = Long.parseLong(createOrg);
        GroupProp prop = this.getTreeModel().getGroupProp();
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        if (!AssistantLisUtil.validateUserPerm((AbstractFormPlugin)this, "4715e1f1000000ac", createOrgId, ASSISTANT_GROUP_ENTITYID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8f85\u52a9\u8d44\u6599\u5206\u7c7b\u201d\u7684\u201c\u5220\u9664\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AssistantTreeListEdit_9", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (this.getTreeModel().getRoot().getId().equals(currentNodeId) || currentNodeId.contains(PREFIX_CLOUD)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u4e91\u8282\u70b9\u3002", (String)"AssistantTreeListEdit_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7ec4\u8282\u70b9\u3002", (String)"AssistantTreeListEdit_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (!prop.isNeedRefreshTree()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u5237\u65b0\u60c5\u51b5\u4e0d\u5141\u8bb8\u5220\u9664\u8282\u70b9\u3002", (String)"AssistantTreeListEdit_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(Long.parseLong(currentNodeId));
        if (!this.isAssistantDataCreatorOrg(ASSISTANT_GROUP_ENTITYID, createOrgId, ids)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u5206\u7c7b\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u7981\u6b62\u64cd\u4f5c\u3002", (String)"AssistantTreeListEdit_10", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 10);
        if (currentNode == null) {
            return;
        }
        QFilter groupFilter = new QFilter(GROUP_ID, "=", (Object)Long.valueOf(currentNodeId));
        if (QueryServiceHelper.exists((String)ASSISTANT_DATA_ENTITYID, (QFilter[])new QFilter[]{groupFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7c7b\u522b\u4e0b\u5b58\u5728\u8f85\u52a9\u8d44\u6599\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AssistantTreeListEdit_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        String text = currentNode.getText();
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("group_bar_del", (IFormPlugin)this);
        String confirmMsg = String.format(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u8f85\u52a9\u8d44\u6599\u7c7b\u522b\u201c%s\u201d\uff1f", (String)"AssistantTreeListEdit_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), text);
        this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, confirmCallBacks);
    }

    private void addGroupNode(String entityId, String currentNodeId, String createOrg) {
        BillShowParameter formShowParameter = this.createFormShowParameter(entityId, currentNodeId, "group_bar_add");
        formShowParameter.setCustomParam("operate", (Object)"addnew");
        formShowParameter.setCustomParam(CREATEORG, (Object)createOrg);
        BasedataEntityType basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
        if (currentNodeId.equals(this.getTreeModel().getRoot().getId()) || basedataEntityType == null) {
            this.getView().showForm((FormShowParameter)formShowParameter);
            return;
        }
        HashMap<String, String> parentInfo = new HashMap<String, String>(2);
        for (IDataEntityProperty pro : basedataEntityType.getProperties()) {
            if (!(pro instanceof ParentBasedataProp)) continue;
            parentInfo.put("key", pro.getName());
            parentInfo.put(VALUE, currentNodeId);
            formShowParameter.setCustomParam(TREE_PARENT_ID, parentInfo);
            break;
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void editGroupNode(String entityId, String currentNodeId, String createOrg) {
        BillShowParameter formShowParameter = this.createFormShowParameter(entityId, currentNodeId, "group_bar_edit");
        formShowParameter.setPkId(this.getTreeModel().getCurrentNodeId());
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("operate", (Object)"edit");
        formShowParameter.setCustomParam(CREATEORG, (Object)createOrg);
        HashMap<String, String> parentInfo = new HashMap<String, String>(1);
        parentInfo.put(VALUE, currentNodeId);
        formShowParameter.setCustomParam("tree_curr_id", parentInfo);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(Long.parseLong(currentNodeId));
        long createOrgId = Long.parseLong(createOrg);
        if (!this.isAssistantDataCreatorOrg(ASSISTANT_GROUP_ENTITYID, createOrgId, ids)) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EDIT_GROUP);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void setFilterOnF7(SetFilterEvent e) {
        Map focusNode;
        String groupId;
        QFilter groupFilter;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (!listShowParameter.isLookUp()) {
            return;
        }
        String parentViewPageId = listShowParameter.getParentPageId();
        IFormView parentView = null;
        if (StringUtils.isNotEmpty((CharSequence)parentViewPageId)) {
            parentView = this.getView().getViewNoPlugin(parentViewPageId);
        }
        List<Long> useOrgIds = AssistantLisUtil.getUseOrgIds(listShowParameter, parentView);
        long currUserId = RequestContext.get().getCurrUserId();
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        QFilter dataRule = service.getDataRuleWithoutDim(currUserId, this.getAppId(), ASSISTANT_DATA_ENTITYID, "47150e89000000ac", useOrgIds);
        if (Objects.nonNull(dataRule)) {
            List customFilters = e.getCustomQFilters();
            customFilters.add(dataRule);
            e.setCustomQFilters(customFilters);
        }
        QFilter qFilter = groupFilter = null != (groupId = AssistantLisUtil.getGroupId(listShowParameter)) ? new QFilter(GROUP_FIELD_FID, "=", (Object)Long.valueOf(groupId)) : null;
        if (null == groupFilter) {
            return;
        }
        QFilter useRangeFilter = this.getUseRangeFilter(groupId, useOrgIds);
        Optional.ofNullable(useRangeFilter).ifPresent(arg_0 -> ((QFilter)groupFilter).and(arg_0));
        TreeView tv = (TreeView)this.getView().getControl(TREEVIEW);
        if (tv != null && !CollectionUtils.isEmpty((Map)(focusNode = tv.getTreeState().getFocusNode())) && !this.getF7RootNodeId().equals(focusNode.get("id"))) {
            Object nodeId = focusNode.get("id");
            String dlm = BaseDataCommonService.getLongNumberDLM((String)ASSISTANT_DATA_ENTITYID);
            Long dataId = Long.valueOf(nodeId.toString());
            DynamicObject data = QueryServiceHelper.queryOne((String)ASSISTANT_DATA_ENTITYID, (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataId)});
            if (data != null) {
                QFilter dataFilter = new QFilter("id", "=", (Object)dataId).or(new QFilter("longnumber", "like", (Object)(data.get("longnumber") + dlm + "%")));
                groupFilter = groupFilter.and(dataFilter);
            }
        }
        e.setMainOrgQFilter(groupFilter);
    }

    public void setFilter(SetFilterEvent e) {
        String currentNodeId;
        if (this.isSingleOrgManageMode) {
            return;
        }
        super.setFilter(e);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            this.setFilterOnF7(e);
            return;
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String createOrg = pageCache.get(CREATEORG);
        if (StringUtils.isBlank((CharSequence)createOrg)) {
            return;
        }
        long createOrgId = Long.parseLong(createOrg);
        long currUserId = RequestContext.get().getCurrUserId();
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(createOrgId);
        QFilter dataRule = service.getDataRuleWithoutDim(currUserId, this.getAppId(), ASSISTANT_DATA_ENTITYID, "47150e89000000ac", orgIdList);
        if (Objects.nonNull(dataRule)) {
            List customQFilters = e.getCustomQFilters();
            customQFilters.add(dataRule);
            e.setCustomQFilters(customQFilters);
        }
        if (null == (currentNodeId = (String)this.treeListView.getTreeModel().getCurrentNodeId())) {
            QFilter unLoadDataFilter = new QFilter("1", "!=", (Object)1);
            e.setMainOrgQFilter(unLoadDataFilter);
            return;
        }
        if (MYROOT.equals(currentNodeId)) {
            e.setMainOrgQFilter(null);
            return;
        }
        if (currentNodeId.startsWith(PREFIX_CLOUD)) {
            QFilter cloudQFilter = new QFilter("fbizcloudid", "=", (Object)currentNodeId.split("_")[1]);
            List<TreeNode> groupNodes = AssistantTreeUtils.getGroupNodesByQflter(createOrgId, cloudQFilter);
            ArrayList groupIds = new ArrayList(groupNodes.size());
            groupNodes.forEach(groupNode -> groupIds.add(Long.valueOf(groupNode.getId())));
            QFilter groupFilter = new QFilter(GROUP_ID, "in", groupIds);
            e.setMainOrgQFilter(groupFilter);
            return;
        }
        QFilter qFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)Long.parseLong(currentNodeId), (Long)createOrgId);
        e.setMainOrgQFilter(qFilter);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setClearSelection(true);
        this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_NEW, BTN_EDI, BTN_DEL});
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        TreeNode root = this.getTreeModel().getRoot();
        if (!listShowParameter.isLookUp() || null == root || null == e.getNodeId()) {
            return;
        }
        if (!Objects.equals(root.getId(), e.getNodeId())) {
            TreeNode node = root.getTreeNode(e.getNodeId().toString());
            if (null == node) {
                return;
            }
            List children = node.getChildren();
            if (null != children && children.isEmpty()) {
                this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), e.getNodeId().toString());
            }
        }
    }

    private QFilter enableFilter() {
        if (null == this.getView().getControl(PROP_SHOW_DISABLED)) {
            return null;
        }
        if (!((Boolean)this.getModel().getValue(PROP_SHOW_DISABLED)).booleanValue()) {
            return new QFilter("enable", "=", (Object)true);
        }
        return null;
    }

    public void refreshNode(RefreshNodeEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            this.refreshNodeOnF7(e);
            return;
        }
        TreeNode root = AssistantTreeUtils.getAssistantRootNode();
        root.setIsOpened(true);
        long createOrgId = 0L;
        String createOrg = AssistantLisUtil.getCreateOrg(this);
        if (StringUtils.isNotBlank((CharSequence)createOrg)) {
            this.getPageCache().put(CREATEORG, createOrg);
            this.getPageCache().put(VERIFY_ORG, createOrg);
            createOrgId = Long.parseLong(createOrg);
        }
        AssistantTreeUtils.buildAssistantTree(root, createOrgId, this.getAppId());
        String isManualRefresh = this.getPageCache().get("isManualRefresh");
        if ("1".equals(isManualRefresh)) {
            this.getPageCache().put("isManualRefresh", null);
            this.getTreeModel().setRoot(root);
        }
        this.afterFreshNode(root, e);
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (PROP_SHOW_DISABLED.equals(name) && parameter.isLookUp()) {
            this.needQueryChildNode = false;
            this.getTreeModel().setCurrentNodeId((Object)"");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String field = e.getProperty().getName();
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (PROP_SHOW_DISABLED.equals(field) && parameter.isLookUp()) {
            TreeView treeView = this.treeListView.getTreeView();
            treeView.deleteAllNodes();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDI, BTN_DEL});
            String nodeText = ResManager.loadKDString((String)"\u5168\u90e8", (String)"AssistantTreeListEdit_42", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            String rootNodeId = this.getF7RootNodeId();
            if (!F7_ROOT_NODE.equals(rootNodeId)) {
                nodeText = (String)parameter.getCustomParam(PARAM_ASST_PARENT_NAME);
            }
            TreeNode root = new TreeNode("", rootNodeId, nodeText);
            root.setIsOpened(true);
            this.treeListView.getTreeView().deleteAllNodes();
            this.getTreeModel().setRoot(root);
            this.getTreeModel().setCurrentNodeId((Object)root.getId());
            treeView.addNode(root);
            treeView.treeNodeClick(root.getParentid(), root.getId());
            this.needQueryChildNode = true;
            this.treeListView.getTreeModel().refreshNode((Object)root.getId());
            this.treeListView.getTreeView().focusNode(root);
            this.treeListView.getTreeView().expand(root.getId());
        }
    }

    private void refreshNodeOnF7(RefreshNodeEvent e) {
        if (!this.needQueryChildNode) {
            this.needQueryChildNode = true;
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String group = AssistantLisUtil.getGroupId(listShowParameter);
        if (group == null) {
            e.setChildNodes(new ArrayList(0));
            return;
        }
        Object isChildAsst = listShowParameter.getCustomParam(PARAM_IS_CHILD);
        String assistantParentId = (String)listShowParameter.getCustomParam(PARAM_ASST_PARENT_ID);
        if (Boolean.TRUE.equals(isChildAsst) && StringUtils.isBlank((CharSequence)assistantParentId)) {
            e.setChildNodes(new ArrayList(0));
            return;
        }
        Long currNodeId = Long.valueOf(e.getNodeId().toString());
        QFilter treeFilter = this.getTreeFilter(group);
        QFilter[] filters = new QFilter[]{new QFilter(PARENT_ID, "=", (Object)currNodeId), treeFilter};
        String selectFields = AssistantTreeListEdit.getSelectField("id", PARENT_ID, "number", "name", "isleaf");
        DynamicObjectCollection coll = QueryServiceHelper.query((String)ASSISTANT_DATA_ENTITYID, (String)selectFields, (QFilter[])filters);
        List parentIds = coll.stream().map(r -> r.get("id")).collect(Collectors.toList());
        filters = new QFilter[]{new QFilter(PARENT_ID, "in", parentIds), treeFilter};
        HashSet pIds = new HashSet(parentIds.size());
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), ASSISTANT_DATA_ENTITYID, PARENT_ID, filters, null, -1, (Distinctable)WithDistinctable.get());){
            ds.forEach(r -> pIds.add(r.getLong(PARENT_ID)));
        }
        List childNodes = coll.stream().map(data -> {
            Long dataId = data.getLong("id");
            TreeNode node = new TreeNode(this.getF7RootNodeId(), dataId.toString(), data.getString("name"));
            if (pIds.contains(dataId)) {
                node.addChildren(new ArrayList(0));
            }
            return node;
        }).collect(Collectors.toList());
        e.setChildNodes(childNodes);
    }

    private QFilter getTreeFilter(Object group) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String parentViewPageId = listShowParameter.getParentPageId();
        IFormView parentView = null;
        if (StringUtils.isNotEmpty((CharSequence)parentViewPageId)) {
            parentView = this.getView().getViewNoPlugin(parentViewPageId);
        }
        List<Long> useOrgIds = AssistantLisUtil.getUseOrgIds(listShowParameter, parentView);
        QFilter filter = new QFilter(GROUP_FIELD_FID, "=", (Object)Long.valueOf(group.toString()));
        QFilter useRangeFilter = this.getUseRangeFilter(group.toString(), useOrgIds);
        Optional.ofNullable(useRangeFilter).ifPresent(arg_0 -> ((QFilter)filter).and(arg_0));
        QFilter enableFilter = this.enableFilter();
        Optional.ofNullable(enableFilter).ifPresent(arg_0 -> ((QFilter)filter).and(arg_0));
        Object isParentAsst = listShowParameter.getCustomParam(PARAM_IS_PARENT);
        String assistantParentId = (String)listShowParameter.getCustomParam(PARAM_ASST_PARENT_ID);
        if (Boolean.TRUE.equals(isParentAsst)) {
            filter.and(new QFilter("isleaf", "=", (Object)Boolean.FALSE));
        } else if (StringUtils.isNotBlank((CharSequence)assistantParentId)) {
            filter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        }
        return filter;
    }

    private QFilter getUseRangeFilter(String groupId, List<Long> useOrgIds) {
        if (null == groupId || CollectionUtils.isEmpty(useOrgIds)) {
            return null;
        }
        Long typeId = Long.valueOf(groupId);
        return typeId.equals(0L) ? null : AssistantDataServiceHelper.getAssistantDataFilter((Long)Long.parseLong(groupId), useOrgIds);
    }

    private void afterFreshNode(TreeNode root, RefreshNodeEvent e) {
        List<TreeNode> childNodes;
        TreeNode node;
        TreeView tv = (TreeView)this.getView().getControl(TREEVIEW);
        Map focusNode = tv.getTreeState().getFocusNode();
        String parentId = "";
        String id = "";
        String text = "";
        if (focusNode != null && (node = this.getTreeModel().getRoot().getTreeNode((String)focusNode.get("id"), 10)) == null) {
            TreeNode parent = this.getTreeModel().getRoot().getTreeNode((String)focusNode.get(PARENTID), 10);
            focusNode.put("id", parent.getId());
            focusNode.put(PARENTID, parent.getParentid());
            focusNode.put("text", parent.getText());
        }
        if (focusNode != null) {
            parentId = parentId + focusNode.get(PARENTID);
            id = id + focusNode.get("id");
            text = text + this.getTreeNodeName(root, id);
        } else {
            parentId = "";
            id = MYROOT;
            text = ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599", (String)"AssistantTreeListEdit_14", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        }
        TreeNode treeNode = new TreeNode(parentId, id, text);
        if (MYROOT.equals(e.getNodeId().toString())) {
            childNodes = this.getChildren(root, e.getNodeId());
            e.setChildNodes(childNodes);
            if (id.equals(e.getNodeId().toString())) {
                tv.deleteAllNodes();
                tv.addNode(root);
                tv.treeNodeClick(parentId, root.getId());
                tv.focusNode(root);
                this.getTreeModel().setRoot(root);
            } else {
                tv.updateNode(treeNode);
                tv.focusNode(treeNode);
                tv.expand(id);
                this.getTreeModel().setCurrentNodeId((Object)id);
            }
            return;
        }
        childNodes = this.getChildren(root, e.getNodeId());
        String freshNodeId = e.getNodeId() == null ? MYROOT : (String)e.getNodeId();
        TreeNode freshNode = this.getTreeModel().getRoot().getTreeNode(freshNodeId, 10);
        if (childNodes != null && !childNodes.isEmpty()) {
            freshNode.addChildren(childNodes);
        }
        if (childNodes == null) {
            childNodes = new ArrayList<TreeNode>();
        }
        e.setChildNodes(childNodes);
        tv.updateNode(freshNode);
        tv.focusNode(treeNode);
        tv.expand(freshNodeId);
        this.getTreeModel().setCurrentNodeId((Object)id);
    }

    private String getTreeNodeName(TreeNode curNode, Object nodeId) {
        if (curNode == null) {
            return null;
        }
        if (Objects.equals(nodeId, curNode.getId())) {
            return curNode.getText();
        }
        if (curNode.getChildren() != null) {
            for (TreeNode node : curNode.getChildren()) {
                String name = this.getTreeNodeName(node, nodeId);
                if (name == null) continue;
                return name;
            }
        }
        return null;
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        String groupId;
        BillShowParameter billShowParameter = evt.getParameter();
        Map parentInfo = (Map)billShowParameter.getCustomParam(TREE_PARENT_ID);
        if (parentInfo != null && parentInfo.containsKey("key") && parentInfo.containsKey(VALUE) && StringUtils.isNotBlank((CharSequence)(groupId = (String)parentInfo.get(VALUE))) && (groupId.startsWith(PREFIX_CLOUD) || groupId.startsWith(PREFIX_APP))) {
            billShowParameter.setCustomParam(TREE_PARENT_ID, null);
        }
        if (billShowParameter.getPkId() != null) {
            Long pkId = (Long)billShowParameter.getPkId();
            String createOrg = this.getPageCache().get(CREATEORG);
            long createOrgId = StringUtils.isBlank((CharSequence)createOrg) ? OrgUnitServiceHelper.getRootOrgId() : Long.parseLong(createOrg);
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(pkId);
            if (!this.isAssistantDataCreatorOrg(ASSISTANT_DATA_ENTITYID, createOrgId, ids)) {
                billShowParameter.setStatus(OperationStatus.VIEW);
            }
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        String nodeId = String.valueOf(evt.getNodeId());
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (nodeId.startsWith(PREFIX_CLOUD) || nodeId.startsWith(PREFIX_APP) || MYROOT.equals(nodeId) || listShowParameter.isLookUp()) {
            evt.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        if (this.isSingleOrgManageMode) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ORG_CHANGE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ctrlstrategy"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        String key = e.getActionId();
        String dataChanged = this.getPageCache().get("listdatachanged");
        if ("1".equals(dataChanged)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            if (billList != null) {
                billList.getEntryState().setKeepPageData(false);
            }
            this.getPageCache().remove("listdatachanged");
            String refreshNodeId = this.getTreeModel().getRoot().getId();
            if (e.getReturnData() instanceof String && StringUtils.isNotBlank((Object)e.getReturnData())) {
                refreshNodeId = (String)e.getReturnData();
            }
            this.treeListView.getTreeModel().refreshNode((Object)refreshNodeId);
            TreeNodeEvent event = new TreeNodeEvent((Object)this);
            event.setNodeId((Object)this.getTreeModel().getRoot().getId());
            this.treeListView.focusRootNode();
        }
        if (ORG_CHANGE.equals(key) && this.getView() instanceof ListView && (rows = ((ListView)this.getView()).getSelectedRows()) != null && !rows.isEmpty()) {
            ((ListView)this.getView()).refresh();
        }
        if (BTN_IMPORT_GROUP.equals(key)) {
            String refreshNodeId = this.getTreeModel().getRoot().getId();
            this.treeListView.getTreeModel().refreshNode((Object)refreshNodeId);
            TreeNodeEvent event = new TreeNodeEvent((Object)this);
            event.setNodeId((Object)this.getTreeModel().getRoot().getId());
            this.treeListView.focusRootNode();
        }
        ((ListView)this.getView()).refresh();
        Object currentNode = this.getTreeListView().getTreeModel().getCurrentNodeId();
        if (currentNode != null) {
            this.getTreeListView().getTreeView().expand(currentNode.toString());
        }
    }

    private boolean cancelClick(BeforeItemClickEvent evt) {
        HashSet<String> itemKeys = new HashSet<String>(Arrays.asList(DELETE, ORG_CHANGE, NEW, ORG_CHANGE, "importdata", "importdetails", "importexport_userset", BTN_IMPORT_GROUP, "tblnamehistory", "tblnamehistoryview"));
        if (itemKeys.contains(evt.getItemKey()) && CtsyDBUtils.ctsyBaseDataUseOnly((String)ASSISTANT_DATA_ENTITYID)) {
            if (!evt.isCancel()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u542f\u4e86\u8de8\u79df\u6237\u4e3b\u6570\u636e\u57df\u7ba1\u63a7\uff0c\u5f53\u524d\u64cd\u4f5c\u4e0d\u652f\u6301\uff0c\u8bf7\u5230\u96c6\u56e2\u79df\u6237\u6267\u884c\u3002", (String)"AssistantTreeListEdit_52", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                evt.setCancel(true);
            }
            return true;
        }
        return false;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (this.cancelClick(evt)) {
            return;
        }
        super.itemClick((ItemClickEvent)evt);
        String key = evt.getItemKey();
        String currentNodeId = (String)this.treeListView.getTreeModel().getCurrentNodeId();
        String createOrg = this.getPageCache().get(CREATEORG);
        if (LOWERDATAQUERY_OPKEY.equalsIgnoreCase(evt.getOperationKey())) {
            if (StringUtils.isBlank((CharSequence)createOrg) || !AssistantLisUtil.validateUserPerm((AbstractFormPlugin)this, "2AXP/7L+N72=", Long.parseLong(createOrg), ASSISTANT_DATA_ENTITYID)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8f85\u52a9\u8d44\u6599\u201d\u7684\u201c\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u6570\u636e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssistantTreeListEdit_47", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                evt.setCancel(true);
            }
            return;
        }
        switch (key) {
            case "tborgchange": {
                this.beforeOrgChangeClick(evt);
                break;
            }
            case "tblnew": {
                if (StringUtils.isBlank((CharSequence)currentNodeId) || currentNodeId.equals(this.getTreeModel().getRoot().getId()) || currentNodeId.contains(PREFIX_CLOUD)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u8f85\u52a9\u8d44\u6599\u9700\u9009\u4e2d\u4e91\u8282\u70b9\u4e0b\u7684\u5177\u4f53\u7c7b\u522b\u3002\u5982\u9700\u589e\u52a0\u7c7b\u522b\uff0c\u8bf7\u9009\u62e9\u5de6\u6811\u7684\u201c+\u201d\u65b0\u589e\u3002", (String)"AssistantTreeListEdit_15", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (StringUtils.isBlank((CharSequence)createOrg)) {
                    this.getView().showTipNotification(AssistantTreeListEdit.getChoseValidBusinessOrg());
                    evt.setCancel(true);
                    return;
                }
                String selectFields = "id,ctrlview.id,isgroupcontrol";
                DynamicObject group = QueryServiceHelper.queryOne((String)ASSISTANT_GROUP_ENTITYID, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(currentNodeId))});
                if (null == group) {
                    return;
                }
                Long viewId = group.getLong("ctrlview.id");
                if (this.isOrgDisableOrFreeze(Long.valueOf(createOrg), viewId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u7981\u7528/\u5c01\u5b58\u72b6\u6001\u3002", (String)"AssistantTreeListEdit_46", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (!AssistantLisUtil.validateUserPerm((AbstractFormPlugin)this, "47156aff000000ac", Long.parseLong(createOrg), ASSISTANT_DATA_ENTITYID)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8f85\u52a9\u8d44\u6599\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssistantTreeListEdit_20", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                boolean isGroupControl = group.getBoolean("isgroupcontrol");
                Long rootOrgId = AssistantLisUtil.getRootOrgIdByView(viewId);
                boolean isRootOrg = Long.valueOf(createOrg).equals(rootOrgId);
                if (!isGroupControl || isRootOrg) break;
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)rootOrgId, (String)"bos_org", (String)"name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\u3002\u8be5\u7c7b\u522b\u5c5e\u4e8e\u96c6\u56e2\u7ba1\u63a7\u7684\u8d44\u6599\uff0c\u8f85\u52a9\u8d44\u6599\u53ea\u80fd\u7531\u201c%1$s\u201d\u7ec4\u7ec7\u521b\u5efa\u3002", (String)"AssistantTreeListEdit_22", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), null == org ? "" : org.getString("name")));
                evt.setCancel(true);
                break;
            }
            case "tbldel": {
                if (AssistantLisUtil.validateUserPerm((AbstractFormPlugin)this, "4715e1f1000000ac", Long.parseLong(createOrg), ASSISTANT_DATA_ENTITYID)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8f85\u52a9\u8d44\u6599\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssistantTreeListEdit_44", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "tbldisable": {
                if (AssistantLisUtil.validateUserPerm((AbstractFormPlugin)this, "47160c2b000000ac", Long.parseLong(createOrg), ASSISTANT_DATA_ENTITYID)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8f85\u52a9\u8d44\u6599\u201d\u7684\u201c\u7981\u7528\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssistantTreeListEdit_43", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "exportgroup": {
                if (!AssistantLisUtil.validateUserPerm((AbstractFormPlugin)this, "4730fc9f000004ae", Long.parseLong(createOrg), ASSISTANT_GROUP_ENTITYID)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201d\u8f85\u52a9\u8d44\u6599\u7c7b\u522b\u201c\u7684\u201d\u5bfc\u51fa\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssistantTreeListEdit_50", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
            case "importgroup": {
                if (AssistantLisUtil.validateUserPerm((AbstractFormPlugin)this, "4730fc9f000003ae", Long.parseLong(createOrg), ASSISTANT_GROUP_ENTITYID)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201d\u8f85\u52a9\u8d44\u6599\u7c7b\u522b\u201c\u7684\u201d\u5bfc\u5165\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssistantTreeListEdit_51", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    private void beforeOrgChangeClick(BeforeItemClickEvent evt) {
        String createOrg = this.getPageCache().get(CREATEORG);
        if (StringUtils.isBlank((CharSequence)createOrg) || !AssistantLisUtil.validateUserPerm((AbstractFormPlugin)this, "4730fc9f000000ac", Long.parseLong(createOrg), ASSISTANT_DATA_ENTITYID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8f85\u52a9\u8d44\u6599\u201d\u7684\u201c\u7ba1\u7406\u6743\u8f6c\u8ba9\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssistantTreeListEdit_48", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (!this.checkData()) {
            evt.setCancel(true);
            return;
        }
        if (this.longNumberLevelIsNull()) {
            evt.setCancel(true);
        }
    }

    private boolean checkData() {
        if (this.getView() instanceof ListView) {
            List<Long> ids = this.getListSelectedRows();
            String createOrg = this.getPageCache().get(CREATEORG);
            if (StringUtils.isBlank((CharSequence)createOrg)) {
                this.getView().showTipNotification(AssistantTreeListEdit.getChoseValidBusinessOrg());
                return false;
            }
            long createOrgId = Long.parseLong(createOrg);
            QFilter[] filters = new QFilter[]{new QFilter("createorg", "!=", (Object)createOrgId), new QFilter("id", "in", ids)};
            ArrayList numbers = new ArrayList(10);
            try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), ASSISTANT_DATA_ENTITYID, "number", filters);){
                ds.forEach(r -> numbers.add(r.getString("number")));
            }
            if (!numbers.isEmpty()) {
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)createOrgId, (String)"bos_org", (String)"name");
                String orgName = null == org ? "" : org.getString("name");
                String tip = ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\uff1a\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u662f\u8d44\u6599\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u7ba1\u7406\u6743\u8f6c\u8ba9\u3002", (String)"AssistantTreeListEdit_12", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
                if (numbers.size() == 1) {
                    this.getView().showTipNotification(String.format(tip, numbers.get(0), orgName));
                } else {
                    StringJoiner joiner = new StringJoiner("\r\n");
                    numbers.forEach(e -> joiner.add(String.format(tip, e, orgName)));
                    this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"AssistantTreeListEdit_49", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), joiner.toString(), MessageTypes.Default);
                }
                return false;
            }
            filters = new QFilter[]{new QFilter("id", "in", ids)};
            if (ORM.create().count(((Object)((Object)this)).getClass().getName(), ASSISTANT_DATA_ENTITYID, GROUP_FIELD_FID, filters, (Distinctable)WithDistinctable.get()) > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u7c7b\u522b\u4e0b\u7684\u8f85\u52a9\u8d44\u6599\u624d\u80fd\u7ba1\u7406\u6743\u8f6c\u8ba9\u3002", (String)"AssistantTreeListEdit_31", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean longNumberLevelIsNull() {
        if (this.getView() instanceof ListView) {
            DynamicObject[] nodes;
            List<Long> ids = this.getListSelectedRows();
            String selectProperties = "id,number,level,longNumber";
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
            for (DynamicObject obj : nodes = BusinessDataServiceHelper.load((String)ASSISTANT_DATA_ENTITYID, (String)selectProperties, (QFilter[])filters)) {
                int level = obj.getInt("level");
                String longNumber = obj.getString("longnumber");
                String number = obj.getString("number");
                if (level == 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u7ea7\u6b21\u4e0d\u80fd\u4e3a0\u3002", (String)"AssistantTreeListEdit_28", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), number));
                    return true;
                }
                if (!kd.bos.util.StringUtils.isEmpty((String)longNumber)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssistantTreeListEdit_29", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), number));
                return true;
            }
        }
        return false;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String currentNodeId = (String)this.treeListView.getTreeModel().getCurrentNodeId();
        String createOrg = this.getPageCache().get(CREATEORG);
        Long sourceOrg = StringUtils.isBlank((CharSequence)createOrg) ? OrgUnitServiceHelper.getRootOrgId() : Long.parseLong(createOrg);
        List<Long> ids = this.getListSelectedRows();
        if (ORG_CHANGE.equals(key) && !ids.isEmpty()) {
            this.transferOfManagement(sourceOrg, currentNodeId, ids);
        } else if (BTN_EXPORT_GROUP.equals(key)) {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)ASSISTANT_GROUP_ENTITYID, (boolean)true);
            lsp.setFormId(TEMP_TREELIST_F7);
            lsp.setLookUp(true);
            lsp.setUseOrgId(Long.parseLong(createOrg));
            lsp.setCustomParam(PARAM_EXPORT_GROUP, (Object)"true");
            lsp.addCustPlugin("kd.bos.form.plugin.AssistantGroupExportListPlugin");
            this.getView().showForm((FormShowParameter)lsp);
        } else if (BTN_IMPORT_GROUP.equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bos_importstart");
            showParameter.setCustomParam("BillFormId", (Object)ASSISTANT_GROUP_ENTITYID);
            showParameter.setCustomParam("ListName", (Object)ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u5206\u7c7b", (String)"AssistantTreeListEdit_21", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            showParameter.setCustomParam("dataType", (Object)ASSISTANT_GROUP_ENTITYID);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_IMPORT_GROUP));
            this.getView().showForm(showParameter);
        }
    }

    private List<Long> getListSelectedRows() {
        ListSelectedRowCollection rows;
        ArrayList<Long> rowsList = new ArrayList<Long>();
        if (this.getView() instanceof ListView && (rows = ((ListView)this.getView()).getSelectedRows()) != null && !rows.isEmpty()) {
            ArrayList<String> numbers = new ArrayList<String>(rows.size());
            for (ListSelectedRow row : rows) {
                rowsList.add((Long)row.getPrimaryKeyValue());
                numbers.add(row.getNumber());
            }
            this.getPageCache().put(LOG_NUMBERS, SerializationUtils.toJsonString(numbers));
        }
        return rowsList;
    }

    private void lowerDataQuery(Long sourceOrg, String currentNodeId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("bos_assistantdata_query");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("groupId", (Object)currentNodeId);
        showParameter.setCustomParam(CREATEORG, (Object)sourceOrg);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void transferOfManagement(Long sourceOrg, String currentNodeId, List<Long> ids) {
        String rootId = this.getTreeModel().getRoot().getId();
        if (StringUtils.isBlank((CharSequence)currentNodeId) || currentNodeId.equals(rootId) || currentNodeId.contains(PREFIX_CLOUD)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e91\u8282\u70b9\u4e0b\u7684\u5177\u4f53\u7c7b\u522b\u3002", (String)"AssistantTreeListEdit_27", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (AssistantLisUtil.isGroupControl(Long.parseLong(currentNodeId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u96c6\u56e2\u7ba1\u63a7\u201d\u7684\u8d44\u6599\u4e0d\u80fd\u8fdb\u884c\u7ba1\u7406\u6743\u8f6c\u8ba9\uff0c\u5982\u9700\u8f6c\u8ba9\uff0c\u8bf7\u5148\u53bb\u9664\u96c6\u56e2\u7ba1\u63a7\u7684\u52fe\u9009\u3002", (String)"AssistantTreeListEdit_24", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (this.havePrivateCtrl(currentNodeId, ids)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u79c1\u6709\u201d\u578b\u6570\u636e\u4e0d\u652f\u6301\u7ba1\u7406\u6743\u8f6c\u8ba9\u3002", (String)"AssistantTreeListEdit_25", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (this.groupIsCtrlStrategyCuShare(Long.parseLong(currentNodeId))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_ORGCHANGE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7ba1\u7406\u6743\u8f6c\u8ba9\u5c06\u8f6c\u8ba9\u9009\u4e2d\u8d44\u6599\u7684\u6240\u6709\u5c42\u7ea7\u3002\u786e\u5b9a\u6267\u884c\uff1f", (String)"AssistantTreeListEdit_26", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            return;
        }
        this.showOrgPermChangeForm(currentNodeId, sourceOrg, ids, new ArrayList<Long>(1));
    }

    private boolean havePrivateCtrl(String currentNodeId, List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter(GROUP_FIELD_FID, "=", (Object)Long.parseLong(currentNodeId)), new QFilter("group.ctrlstrategy", "=", (Object)"7"), new QFilter("id", "in", ids)};
        return QueryServiceHelper.exists((String)ASSISTANT_DATA_ENTITYID, (QFilter[])filters);
    }

    private boolean groupIsCtrlStrategyCuShare(long groupId) {
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((Object)groupId, (String)ASSISTANT_GROUP_ENTITYID, (String)"id,ctrlstrategy");
        return "6".equals(group.getString("ctrlstrategy"));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String key = event.getCallBackId();
        if (CONFIRM_ORGCHANGE.equals(key) && event.getResult() == MessageBoxResult.Yes) {
            String currentNodeId = (String)this.treeListView.getTreeModel().getCurrentNodeId();
            String createOrg = this.getPageCache().get(CREATEORG);
            if (StringUtils.isBlank((CharSequence)createOrg)) {
                LOGGER.info("\u65e0\u64cd\u4f5c\u7ec4\u7ec7.");
                return;
            }
            Long sourceOrg = Long.parseLong(createOrg);
            List<Long> ids = this.getListSelectedRows();
            List<Long> allIds = this.getAllNode(currentNodeId, ids, sourceOrg);
            this.showOrgPermChangeForm(currentNodeId, sourceOrg, ids, allIds);
        }
    }

    private void showOrgPermChangeForm(String currentNodeId, Long sourceOrg, List<Long> ids, List<Long> allIds) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(ORG_PERM_CHANGE_ENTITYID);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("groupId", (Object)currentNodeId);
        showParameter.setCustomParam(CREATEORG, (Object)sourceOrg);
        showParameter.setCustomParam("ids", ids);
        if (!CollectionUtils.isEmpty(allIds)) {
            showParameter.setCustomParam("allIds", allIds);
        }
        showParameter.setCustomParam("entityId", (Object)ASSISTANT_DATA_ENTITYID);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ORG_CHANGE);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void initTree() {
        TreeNode root;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            String nodeText = ResManager.loadKDString((String)"\u5168\u90e8", (String)"AssistantTreeListEdit_42", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            String rootNodeId = this.getF7RootNodeId();
            if (!F7_ROOT_NODE.equals(rootNodeId)) {
                nodeText = (String)listShowParameter.getCustomParam(PARAM_ASST_PARENT_NAME);
            }
            root = new TreeNode("", rootNodeId, nodeText);
        } else {
            root = AssistantTreeUtils.getAssistantRootNode();
        }
        root.setIsOpened(true);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDI, BTN_DEL});
    }

    private List<TreeNode> getChildren(TreeNode curNode, Object nodeId) {
        if (curNode == null) {
            return Collections.emptyList();
        }
        if (Objects.equals(nodeId, curNode.getId())) {
            return curNode.getChildren();
        }
        List children = curNode.getChildren();
        if (children == null || children.isEmpty()) {
            return Collections.emptyList();
        }
        List<TreeNode> result = Collections.emptyList();
        for (TreeNode node : curNode.getChildren()) {
            if (Objects.equals(nodeId, node.getId())) {
                result = node.getChildren();
                return result;
            }
            result = this.getChildren(node, nodeId);
        }
        return result;
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        List orgIdList = args.getSelectMainOrgIds();
        if (!orgIdList.isEmpty()) {
            Long mainOrgId = (Long)orgIdList.get(0);
            IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
            List orgIds = orgService.getAllSuperiorOrgs("16", mainOrgId.longValue());
            orgIdList.addAll(orgIds);
            FilterContainer filtercontainer = (FilterContainer)this.getControl("filtercontainerap");
            filtercontainer.setSelectedMainOrgIds(orgIdList);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        this.isSingleOrgManageMode = licenseService.isSingleOrgManageMode();
        if (this.isSingleOrgManageMode) {
            Iterator<FilterColumn> commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns().iterator();
            this.hideFields(commonFilterColumns);
            Iterator<FilterColumn> schemeFilterColumns = args.getFilterContainerInitEvent().getSchemeFilterColumns().iterator();
            this.hideFields(schemeFilterColumns);
            Iterator<FilterColumn> fastFilterColumns = args.getFilterContainerInitEvent().getFastFilterColumns().iterator();
            this.hideFields(fastFilterColumns);
            return;
        }
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if (!CREATEORG_NAME_FILEDNAME.equals(filterColumn.getFieldName())) continue;
            this.setFilterColumn(filterColumn);
            return;
        }
        super.filterContainerInit(args);
    }

    void setFilterColumn(FilterColumn filterColumn) {
        if (filterColumn.getDefaultValues().isEmpty()) {
            return;
        }
        String createOrg = AssistantLisUtil.getCreateOrg(this);
        List<Long> hasPermOrgs = AssistantLisUtil.getAssistantQueryPermissionOrgId(this);
        if (!CollectionUtils.isEmpty(hasPermOrgs)) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", hasPermOrgs)};
            List<ComboItem> combos = this.buildComboItems(filters);
            ((CommonFilterColumn)filterColumn).setComboItems(combos);
            filterColumn.setDefaultValue(createOrg != null ? createOrg : filterColumn.getDefaultValues().get(0).toString());
        } else {
            filterColumn.setDefaultValue(createOrg);
        }
    }

    List<ComboItem> buildComboItems(QFilter[] filters) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(20);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])filters, (String)"id");
        for (DynamicObject org : col) {
            if (org == null) continue;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(org.getString("name")));
            item.setValue(String.valueOf(org.get("id")));
            combos.add(item);
        }
        return combos;
    }

    private void hideFields(Iterator<FilterColumn> filterColumns) {
        while (filterColumns.hasNext()) {
            FilterColumn filterColumn = filterColumns.next();
            if (!HIDE_FIELDS_LIST.contains(filterColumn.getFieldName())) continue;
            filterColumns.remove();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFilterList = (List)filterValues.get("customfilter");
        List fastFilter = (List)filterValues.get("fastfilter");
        if (customFilterList == null) {
            return;
        }
        for (Map customFilter : customFilterList) {
            List orgIds;
            List fieldNames = (List)customFilter.get("FieldName");
            if (fieldNames == null || fieldNames.isEmpty() || !CREATEORG_FILEDNAME.equals(fieldNames.get(0)) || (orgIds = (List)customFilter.get("Value")) == null || orgIds.isEmpty()) continue;
            String orgId = String.valueOf(orgIds.get(0));
            String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
            String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
            String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
            String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
            this.getPageCache().remove(searchNodesCacheKey);
            this.getPageCache().remove(matchNodesCacheKey);
            this.getPageCache().remove(oldSearchTextCacheKey);
            this.getPageCache().remove(searchIndexCacheKey);
            this.getPageCache().remove(CREATEORG);
            this.getPageCache().put(CREATEORG, String.valueOf(orgId));
            this.getPageCache().put(VERIFY_ORG, String.valueOf(orgId));
            if (!fastFilter.isEmpty()) break;
            TreeView tv = (TreeView)this.getView().getControl(TREEVIEW);
            TreeNode root = AssistantTreeUtils.getAssistantRootNode();
            tv.focusNode(root);
            this.treeListView.getTreeModel().setRoot(root);
            this.treeListView.getTreeModel().refreshNode((Object)this.getTreeModel().getRoot().getId());
            break;
        }
        super.filterContainerSearchClick(args);
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        if (listShowParameter.isLookUp() || row == null) {
            return;
        }
        Object assistantDataId = row.getPrimaryKeyValue();
        assistantDataId = Long.parseLong(assistantDataId.toString());
        DynamicObject assistantData = BusinessDataServiceHelper.loadSingleFromCache((Object)assistantDataId, (String)ASSISTANT_DATA_ENTITYID);
        Long assistantTypeId = 0L;
        if (assistantData == null) {
            return;
        }
        if (assistantData.get(GROUP_FIELD_FID) instanceof Long) {
            assistantTypeId = (Long)assistantData.get(GROUP_FIELD_FID);
        } else if (assistantData.get(GROUP_FIELD_FID) instanceof DynamicObject) {
            assistantTypeId = (Long)((DynamicObject)assistantData.get(GROUP_FIELD_FID)).getPkValue();
        }
        TreeNode node = this.getTreeModel().getRoot().getTreeNode(assistantTypeId.toString(), 10);
        if (node == null) {
            return;
        }
        this.getTreeListView().getTreeView().expand(node.getParentid());
        this.getTreeListView().getTreeView().expand(node.getId());
        this.getTreeListView().getTreeView().focusNode(node);
        this.getTreeListView().getTreeModel().setCurrentNodeId((Object)node.getId());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate) {
            String useOrg = this.getPageCache().get(CREATEORG);
            if (StringUtils.isEmpty((CharSequence)useOrg)) {
                this.getView().showTipNotification(AssistantTreeListEdit.getChoseValidBusinessOrg());
                args.setCancel(true);
                return;
            }
            OperateOption option = ((AbstractOperate)source).getOption();
            option.setVariableValue(OPTION_USEORG, useOrg);
            String appId = this.getView().getFormShowParameter().getAppId();
            ((AbstractOperate)source).getOption().setVariableValue("currbizappid", appId);
            String operateKey = ((AbstractOperate)source).getOperateKey();
            if (OPERATE_DISABLE.equals(operateKey) || OPERATE_DELETE.equals(operateKey)) {
                String operationName = ((AbstractOperate)source).getOperateName().toString();
                if (!this.checkCreateOrgIsCurrentOrg(args.getListSelectedData(), Long.valueOf(useOrg), operationName)) {
                    args.setCancel(true);
                    return;
                }
            }
            if (OPERATE_DISABLE.equals(operateKey)) {
                args.setListSelectedData(this.getSelectRowsContainsChildren(args.getListSelectedData()));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (LOWERDATAQUERY_OPKEY.equals(opKey) && operationResult.isSuccess()) {
            String currentNodeId = (String)this.treeListView.getTreeModel().getCurrentNodeId();
            String createOrg = this.getPageCache().get(CREATEORG);
            Long sourceOrg = StringUtils.isBlank((CharSequence)createOrg) ? OrgUnitServiceHelper.getRootOrgId() : Long.parseLong(createOrg);
            this.lowerDataQuery(sourceOrg, currentNodeId);
        }
    }

    private boolean isAssistantDataCreatorOrg(String entity, Long createOrg, List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return true;
        }
        Map assistantDataMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)entity);
        for (Map.Entry entry : assistantDataMap.entrySet()) {
            DynamicObject obj = (DynamicObject)entry.getValue();
            Long createOrgId = obj == null || obj.get(CREATEORG_FILEDNAME) == null ? 0L : obj.getLong(CREATEORG_FILEDNAME);
            if (createOrg.equals(createOrgId)) continue;
            return false;
        }
        return true;
    }

    private boolean isAssistantDataSameGroup(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return true;
        }
        Map assistantGroupMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)ASSISTANT_DATA_ENTITYID);
        Long firstGroupId = ((DynamicObject)assistantGroupMap.values().iterator().next()).getLong(GROUP_ID);
        for (Map.Entry entry : assistantGroupMap.entrySet()) {
            DynamicObject obj = (DynamicObject)entry.getValue();
            if (firstGroupId.equals(obj.getLong(GROUP_ID))) continue;
            return false;
        }
        return true;
    }

    private List<Long> getAllNode(String currentNodeId, List<Long> ids, Long sourceOrg) {
        HashSet<String> rootLongNumbers = new HashSet<String>(ids.size());
        String selectProperties = "id,number,ctrlstrategy,longnumber";
        QFilter idFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection assistantDataCol = QueryServiceHelper.query((String)ASSISTANT_DATA_ENTITYID, (String)selectProperties, (QFilter[])new QFilter[]{idFilter});
        String dlm = BaseDataCommonService.getLongNumberDLM((String)ASSISTANT_DATA_ENTITYID);
        for (DynamicObject obj : assistantDataCol) {
            String tempNumber = obj.getString("longnumber");
            String[] longNumberArr = tempNumber.split(dlm);
            if (longNumberArr.length > 1) {
                rootLongNumbers.add(longNumberArr[0]);
                continue;
            }
            if (longNumberArr.length != 1) break;
            rootLongNumbers.add(tempNumber);
        }
        QFilter groupFilter = new QFilter(GROUP_FIELD_FID, "=", (Object)Long.parseLong(currentNodeId));
        QFilter orgFilter = new QFilter(CREATEORG_FILEDNAME, "=", (Object)sourceOrg);
        QFilter longNumberFilter = new QFilter("longnumber", "in", rootLongNumbers);
        for (String rootLongNumber : rootLongNumbers) {
            longNumberFilter.or("longnumber", "like", (Object)(rootLongNumber + dlm + "%"));
        }
        QFilter[] filters = new QFilter[]{groupFilter, orgFilter, longNumberFilter};
        DynamicObjectCollection allAssistantData = QueryServiceHelper.query((String)ASSISTANT_DATA_ENTITYID, (String)selectProperties, (QFilter[])filters);
        HashSet<Long> allIds = new HashSet<Long>(allAssistantData.size());
        for (DynamicObject assistantData : allAssistantData) {
            allIds.add(assistantData.getLong("id"));
        }
        return new ArrayList<Long>(allIds);
    }

    private String getAppId() {
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appId = "";
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)ASSISTANT_DATA_ENTITYID);
            try {
                appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception e) {
                appId = met.getAppId();
                LOGGER.error("AssistantTreeListEdit getAppId error:", (Throwable)e);
            }
        }
        return appId;
    }

    private static String getSelectField(String ... props) {
        StringJoiner stringJoiner = new StringJoiner(",");
        Stream.of(props).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }

    private ListSelectedRowCollection getSelectRowsContainsChildren(ListSelectedRowCollection selectedRows) {
        List selectedDataIds = selectedRows.stream().map(v -> Long.valueOf(v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        List dataIds = new TreeBaseDataCommonService(ASSISTANT_DATA_ENTITYID).getChildNodeIdsByParentIds(selectedDataIds, null, true);
        ListSelectedRowCollection result = new ListSelectedRowCollection();
        for (Long dataId : dataIds) {
            ListSelectedRow selectRow = new ListSelectedRow((Object)dataId);
            result.add((Object)selectRow);
        }
        return result;
    }

    private boolean checkCreateOrgIsCurrentOrg(ListSelectedRowCollection selectedRows, Long useOrgId, String operationName) {
        Object[] selectedDataIds = selectedRows.getPrimaryKeyValues();
        QFilter filter = new QFilter("id", "in", (Object)selectedDataIds);
        filter.and(CREATEORG_FILEDNAME, "!=", (Object)useOrgId);
        DynamicObject selectedData = QueryServiceHelper.queryOne((String)ASSISTANT_DATA_ENTITYID, (String)"number", (QFilter[])new QFilter[]{filter});
        if (selectedData == null) {
            return true;
        }
        DynamicObject useOrg = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)useOrgId)});
        if (useOrg == null) {
            return false;
        }
        String number = selectedData.getString("number");
        String msg = ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u201d%2$s\u201c\u4e0d\u662f\u8f85\u52a9\u8d44\u6599\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u80fd%3$s\u3002", (String)"AssistantTreeListEdit_45", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        this.getView().showTipNotification(String.format(msg, number, useOrg.getString("name"), operationName));
        return false;
    }

    private boolean isOrgDisableOrFreeze(Long createOrg, Long viewId) {
        QFilter filter = new QFilter("view.id", "=", (Object)viewId);
        filter.and("org.id", "=", (Object)createOrg);
        QFilter statusFilter = new QFilter("org.enable", "=", (Object)Boolean.FALSE);
        statusFilter.or("isfreeze", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])new QFilter[]{filter, statusFilter});
    }

    private String getF7RootNodeId() {
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        String parentId = (String)lsp.getCustomParam(PARAM_ASST_PARENT_ID);
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            return parentId;
        }
        return F7_ROOT_NODE;
    }

    static {
        HIDE_FIELDS_LIST.add("createorg.number");
        HIDE_FIELDS_LIST.add(CREATEORG_NAME_FILEDNAME);
        HIDE_FIELDS_LIST.add("org.number");
        HIDE_FIELDS_LIST.add("org.name");
        HIDE_FIELDS_LIST.add("useorg.number");
        HIDE_FIELDS_LIST.add("useorg.name");
        HIDE_FIELDS_LIST.add("useorg.id");
    }
}

