/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.StringUtils;

public class AssistantTreeUtils {
    private static Log log = LogFactory.getLog(AssistantTreeUtils.class);
    private static final String BOS_FORM_BUSINESS = "bos-bd-formplugin";
    private static final String MYROOT = "myroot";
    private static final String PREFIX_APP = "app_";
    private static final String GROUP_FIELD_FID = "group";
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String ID = "id";
    private static final String ASSISTANT_GROUP_ENTITYID = "bos_assistantdatagroup";
    private static final String ASSISTANT_DETAIL_ENTITYID = "bos_assistantdata_detail";
    private static final String PARENT = "parent";

    public static TreeNode getAssistantRootNode() {
        TreeNode root = new TreeNode();
        root.setId(MYROOT);
        root.setText(ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599", (String)"AssistantTreeListEdit_14", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        root.setParentid("");
        return root;
    }

    public static void buildAssistantTree(TreeNode root, long orgId) {
        AssistantTreeUtils.buildAssistantTree(root, orgId, "");
    }

    public static void buildAssistantTree(TreeNode root, long orgId, String appId) {
        List<TreeNode> groupNodes;
        List<TreeNode> cloudNodes = AssistantTreeUtils.getCloudNodes();
        if (StringUtils.isEmpty((String)appId)) {
            groupNodes = AssistantTreeUtils.getGroupNodes(orgId);
        } else {
            long currUserId = RequestContext.get().getCurrUserId();
            PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
            ArrayList<Long> orgIdList = new ArrayList<Long>(1);
            orgIdList.add(orgId);
            QFilter dataRuleFilter = service.getDataRuleWithoutDim(currUserId, appId, ASSISTANT_GROUP_ENTITYID, "47150e89000000ac", orgIdList);
            groupNodes = AssistantTreeUtils.getGroupNodesByQflter(orgId, dataRuleFilter);
        }
        root.addChildren(cloudNodes);
        ArrayList<TreeNode> tmpList = new ArrayList<TreeNode>();
        tmpList.addAll(cloudNodes);
        tmpList.addAll(groupNodes);
        HashMap idMap = new HashMap();
        tmpList.forEach(node -> idMap.put(node.getId(), node));
        tmpList.forEach(node -> {
            if (idMap.containsKey(node.getParentid())) {
                TreeNode treeNode = (TreeNode)idMap.get(node.getParentid());
                treeNode.addChild(node);
            }
        });
    }

    private static QFilter[] appendCloudIdQFilter(QFilter[] oldCloudIdFilter, String fieldName) {
        Set disabledCloudIds;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Map cloudBlackMap = RunModeServiceHelper.getCloudBlacklist();
        if (!CollectionUtils.isEmpty((Map)cloudBlackMap)) {
            filterList.add(new QFilter(fieldName, "not in", cloudBlackMap.keySet()));
        }
        if (!CollectionUtils.isEmpty((Collection)(disabledCloudIds = ManageServiceHelper.getDisabledCloudIds()))) {
            filterList.add(new QFilter(fieldName, "not in", (Object)disabledCloudIds));
        }
        if (CollectionUtils.isEmpty(filterList)) {
            return oldCloudIdFilter;
        }
        filterList.addAll(Arrays.asList(oldCloudIdFilter));
        return filterList.toArray(new QFilter[0]);
    }

    private static List<TreeNode> getCloudNodes() {
        DynamicObject[] objects;
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>(10);
        String fields = "id, number, name";
        String orderby = "sequence asc";
        QFilter[] filters = new QFilter[]{};
        filters = AssistantTreeUtils.appendCloudIdQFilter(filters, ID);
        for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)fields, (QFilter[])filters, (String)orderby)) {
            TreeNode node = new TreeNode();
            String name = object.getLocaleString("name").getLocaleValue();
            if (StringUtils.isEmpty((String)name)) continue;
            node.setText(name);
            node.setParentid("0");
            node.setId(PREFIX_CLOUD + object.getString(ID));
            node.setData((Object)"cloud");
            cloudNode.add(node);
        }
        return cloudNode;
    }

    protected static List<TreeNode> getGroupNodes(Long createOrgId) {
        return AssistantTreeUtils.getGroupNodes(createOrgId, null);
    }

    protected static List<TreeNode> getGroupNodesByQflter(Long createOrgId, QFilter qFilter) {
        return AssistantTreeUtils.getGroupNodes(createOrgId, qFilter);
    }

    private static List<TreeNode> getGroupNodes(Long createOrgId, QFilter qFilter) {
        ArrayList<TreeNode> groupNodes = new ArrayList<TreeNode>(10);
        String fields = "id, number, name, parent, fbizcloudid,createorg,ctrlview";
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)ASSISTANT_GROUP_ENTITYID, (String)fields, (QFilter[])new QFilter[]{qFilter});
        HashMap<String, List<Long>> viewSuperiorMap = new HashMap<String, List<Long>>();
        ArrayList<String> allViewFunclist = new ArrayList<String>();
        ArrayList<String> allNotHaveView = new ArrayList<String>();
        for (DynamicObject object : objects) {
            if (AssistantTreeUtils.filterGroup(object, createOrgId, viewSuperiorMap, allViewFunclist, allNotHaveView)) continue;
            TreeNode node = new TreeNode();
            String name = object.getLocaleString("name").getLocaleValue();
            if (StringUtils.isEmpty((String)name)) continue;
            node.setText(name);
            node.setId(object.getString(ID));
            node.setData((Object)GROUP_FIELD_FID);
            String bizCloudId = "";
            if (object.getDynamicObject("fbizcloudid") == null) continue;
            bizCloudId = object.getDynamicObject("fbizcloudid").getString(ID);
            DynamicObject parent = object.getDynamicObject(PARENT);
            if (parent != null) {
                node.setParentid(String.valueOf(parent.getLong(ID)));
            } else {
                node.setParentid(PREFIX_CLOUD + bizCloudId);
            }
            groupNodes.add(node);
        }
        return groupNodes;
    }

    private static boolean filterGroup(DynamicObject object, Long orgId, HashMap<String, List<Long>> viewSuperiorMap, List<String> allViewFunclist, List<String> allNotHaveView) {
        DynamicObject groupCreateOrg = object.getDynamicObject("createorg");
        if (groupCreateOrg == null) {
            return true;
        }
        Long groupOrgId = groupCreateOrg.getLong(ID);
        DynamicObject ctrlView = object.getDynamicObject("ctrlview");
        if (ctrlView == null) {
            return true;
        }
        String ctrlViewNumber = ctrlView.getString("number");
        if (!allViewFunclist.contains(ctrlViewNumber) && allNotHaveView.contains(ctrlViewNumber)) {
            return true;
        }
        if (!allViewFunclist.contains(ctrlViewNumber) && !allNotHaveView.contains(ctrlViewNumber)) {
            if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)ctrlViewNumber)) {
                allViewFunclist.add(ctrlViewNumber);
            } else {
                allNotHaveView.add(ctrlViewNumber);
                return true;
            }
        }
        if (groupOrgId != null && groupOrgId.equals(orgId)) {
            return false;
        }
        List allSuperorIds = viewSuperiorMap.get(ctrlViewNumber);
        if (CollectionUtils.isEmpty(allSuperorIds)) {
            allSuperorIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)ctrlViewNumber, (long)orgId);
            allSuperorIds.add(orgId);
            log.info("\u67e5\u8be2\u89c6\u56fe", (Object)("\u5f53\u524d\u7ec4\u7ec7" + orgId + "\u63a7\u5236\u89c6\u56fe" + ctrlViewNumber + "\u4e0a\u7ea7\u7ec4\u7ec7 \u3010" + SerializationUtils.toJsonString((Object)allSuperorIds) + "\u3011"));
            viewSuperiorMap.put(ctrlViewNumber, allSuperorIds);
        }
        return !allSuperorIds.contains(groupCreateOrg.getLong(ID));
    }
}

