/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataCustomService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.bdctrl.helper.BaseDataAssignServiceHelper;
import kd.bos.form.plugin.bdctrl.helper.PermissionValidatorHelper;
import kd.bos.form.plugin.bdctrl.validator.TreeBaseDataAssignPreValidator;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AssignPlugin
extends AbstractListPlugin
implements TreeNodeQueryListener,
SearchEnterListener,
TreeNodeCheckListener,
F7SelectedListRemoveListener {
    private static Log logger = LogFactory.getLog(AssignPlugin.class);
    public static final String TREEVIEW = "treeviewap";
    private static final String ASSIGN_QUERY_CALLBACK = "assignQueryCallBack";
    private Long useOrgId = null;
    private static final String ASIGNEDDATAS = "asignedDatas";
    public static final String BILLLIST_AP = "billListap";
    public static final String ENTITY_NUMBER = "entityNumber";
    public static final String USEORGID = "useOrgId";
    public static final String _CTRLSTRATEGY = "_ctrlstrategy";
    public static final String BOS_BD_FORMPLUGIN = "bos-bd-formplugin";
    public static final String ORGID = "org.id";
    public static final String FVIEWID = ":fviewid";
    public static final String FISCTRLUNIT = ":fisctrlunit";
    private static final String BILLLISTAP2 = "billlistap2";
    private static final String BILLLISTAP = "billlistap";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String ALLORGLIST_KEY = "allOrgListKey";
    private static final String CACHE_ASSIGN_ID = "tree_assign_id";
    private List<Long> initDataIds = null;
    private List<TreeNode> treeNodes = null;
    private static final String F7_SELECT_LIST = "f7selectedlistap";
    private static final String BTN_ASSIGN = "btn_assign";
    private static final String CALL_BACK_ACTION = "TREE_DATA_ASSIGN_ACTION";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_ASSIGN, "btn_assign_query"});
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tvLeft.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7_SELECT_LIST);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        List<Long> assignDataIds = this.getAssignDataIds();
        QFilter filter = new QFilter("id", "in", assignDataIds);
        BillList billList = (BillList)this.getControl(BILLLIST_AP);
        billList.setBillFormId(entityNumber);
        billList.getFilterParameter().getQFilters().add(filter);
        BillList billList2 = (BillList)this.getControl(BILLLISTAP2);
        billList2.setBillFormId(entityNumber);
        billList2.getFilterParameter().getQFilters().add(filter);
        if (BaseDataCommonService.isTreeType((String)entityNumber)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BILLLISTAP2});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BILLLISTAP});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BILLLISTAP2});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BILLLISTAP});
        billList.addCreateListColumnsListener(beforeCreateListColumnsArgs -> {
            if (BaseDataCommonService.isOtherMasterIdType((String)entityNumber)) {
                beforeCreateListColumnsArgs.getListColumn("name").setVisible(0);
                beforeCreateListColumnsArgs.getListColumn("number").setVisible(0);
            } else {
                beforeCreateListColumnsArgs.getListColumn("masterid.name").setVisible(0);
                beforeCreateListColumnsArgs.getListColumn("masterid.number").setVisible(0);
            }
        });
    }

    public void afterBindData(EventObject e) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        BillList billList = BaseDataCommonService.isTreeType((String)entityNumber) ? (BillList)this.getControl(BILLLISTAP2) : (BillList)this.getControl(BILLLISTAP);
        HashMap<String, Boolean> treeParams = new HashMap<String, Boolean>(1);
        treeParams.put("cpn", Boolean.FALSE);
        this.getView().updateControlMetadata(TREEVIEW, treeParams);
        billList.selectAllRows();
        billList.refreshData();
        billList.getView().sendFormAction(billList.getView());
    }

    public void afterCreateNewData(EventObject evt) {
        List<Long> assignDataIds;
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        if (null == ctrlView) {
            return;
        }
        List<TreeNode> orgList = this.getAllOrg(ctrlView);
        if (!CollectionUtils.isEmpty(orgList)) {
            this.treeNodes = orgList;
            this.getView().getPageCache().putBigObject(ALLORGLIST_KEY, SerializationUtils.toJsonString(orgList));
        }
        if (null == this.useOrgId) {
            if (this.getView().getFormShowParameter().getCustomParam(USEORGID) instanceof Integer) {
                this.useOrgId = ((Integer)this.getView().getFormShowParameter().getCustomParam(USEORGID)).longValue();
            } else if (this.getView().getFormShowParameter().getCustomParam(USEORGID) instanceof Long) {
                this.useOrgId = (Long)this.getView().getFormShowParameter().getCustomParam(USEORGID);
            }
        }
        if (CollectionUtils.isEmpty(assignDataIds = this.getAssignDataIds())) {
            logger.warn("AssignPlugin: assignDataIds is empty");
            return;
        }
        DynamicObject data = QueryServiceHelper.queryOne((String)entityNumber, (String)"id, createorg, org, ctrlstrategy", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)assignDataIds.get(0))});
        String ctrlType = null != data ? data.getString(CTRLSTRATEGY) : "1";
        this.getPageCache().put(this.getView().getPageId() + _CTRLSTRATEGY, ctrlType);
        Long viewId = (Long)ctrlView.getPkValue();
        if ("2".equals(ctrlType)) {
            this.initCUFreeAssignTree(viewId);
            return;
        }
        try {
            this.initCUAssignTree(this.useOrgId, viewId);
        }
        catch (Exception e) {
            logger.error("\u9010\u7ea7\u5206\u914d\u521d\u59cb\u5316\u7ec4\u7ec7\u6811\u5f02\u5e38", (Throwable)e);
        }
    }

    private List<Long> getAssignDataIds() {
        if (null != this.initDataIds) {
            return this.initDataIds;
        }
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        this.initDataIds = (List)this.getView().getFormShowParameter().getCustomParam("ids");
        if (BaseDataCommonService.isTreeType((String)entityNumber)) {
            this.initDataIds = this.assignAutoDatas(this.initDataIds);
        }
        return this.initDataIds;
    }

    private List<TreeNode> getAllOrg(DynamicObject ctrlView) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(ctrlView.getLong("id"));
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (null == rootNode) {
            return Collections.emptyList();
        }
        param.setId(Long.parseLong(rootNode.getId()));
        List allChildOrgNodeList = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid from t_org_structure where fisctrlunit = '1' and fviewid = ?;", new Object[]{ctrlView.getPkValue()});
        Set allCtrlUnitOrgIds = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, rs -> {
            HashSet<String> result = new HashSet<String>(16);
            while (rs.next()) {
                result.add(rs.getString("forgid"));
            }
            return result;
        });
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        ArrayList<TreeNode> rootNodeChildList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        if (allCtrlUnitOrgIds.contains(rootNode.getId())) {
            rootNode.setChildren(rootNodeChildList);
            nodeList.add(rootNode);
        }
        if (CollectionUtils.isEmpty((Collection)allChildOrgNodeList)) {
            return nodeList;
        }
        ArrayList<TreeNode> cuOrgChildNodeList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        for (TreeNode node : allChildOrgNodeList) {
            if (!allCtrlUnitOrgIds.contains(node.getId())) continue;
            List children = node.getChildren();
            if (!CollectionUtils.isEmpty((Collection)children)) {
                ArrayList<TreeNode> tempChildOrgList = new ArrayList<TreeNode>(children.size());
                for (TreeNode childrenNode : children) {
                    if (!allCtrlUnitOrgIds.contains(childrenNode.getId())) continue;
                    tempChildOrgList.add(childrenNode);
                }
                if (!tempChildOrgList.isEmpty()) {
                    node.setChildren(tempChildOrgList);
                } else {
                    node.setChildren(null);
                }
            }
            if (node.getParentid().equals(rootNode.getId())) {
                rootNodeChildList.add(node);
            }
            nodeList.add(node);
            cuOrgChildNodeList.add(node);
        }
        this.getChildNode(cuOrgChildNodeList, nodeList, allCtrlUnitOrgIds);
        return nodeList;
    }

    private void getChildNode(List<TreeNode> orgChildrenTreeData, List<TreeNode> allOrgs, Set<String> allCtrlUintOrgIds) {
        for (TreeNode node : orgChildrenTreeData) {
            List childNode = node.getChildren();
            if (null == childNode || childNode.isEmpty()) continue;
            ArrayList<TreeNode> tempChildOrgs = new ArrayList<TreeNode>(node.getChildren().size());
            for (TreeNode childrenNode : node.getChildren()) {
                if (!allCtrlUintOrgIds.contains(childrenNode.getId())) continue;
                allOrgs.add(childrenNode);
                tempChildOrgs.add(childrenNode);
            }
            if (!tempChildOrgs.isEmpty()) {
                node.setChildren(tempChildOrgs);
            } else {
                node.setChildren(null);
            }
            this.getChildNode(childNode, allOrgs, allCtrlUintOrgIds);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equalsIgnoreCase(BTN_ASSIGN)) {
            String opName;
            Map paramsMap = this.getView().getFormShowParameter().getCustomParams();
            String appId = this.getView().getFormShowParameter().getAppId();
            String entityNumber = (String)paramsMap.get(ENTITY_NUMBER);
            List ids = (List)paramsMap.get("ids");
            long createOrg = Long.parseLong(paramsMap.get(USEORGID).toString());
            boolean hasFuncPerm = PermissionValidatorHelper.checkFuncPerm("DIM_ORG", createOrg, appId, entityNumber, "80513208000000ac", opName = ResManager.loadKDString((String)"\u5206\u914d", (String)"AssignPlugin_12", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), this.getView());
            if (!hasFuncPerm) {
                evt.setCancel(true);
                return;
            }
            Map<String, Object> map = PermissionValidatorHelper.checkDataRule(appId, entityNumber, "80513208000000ac", (Long)createOrg, opName, ids);
            List messages = (List)map.get("messages");
            if (!messages.isEmpty()) {
                FormShowParameter parameter = PermissionValidatorHelper.buildFormShowParameter(messages);
                this.getView().showForm(parameter);
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        if (control.getKey().equals(BTN_ASSIGN)) {
            boolean isTreeType = BaseDataCommonService.isTreeType((String)entity);
            BillList billList = isTreeType ? (BillList)this.getControl(BILLLISTAP2) : (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection col = billList.getSelectedRows();
            if (col.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6570\u636e\u3002", (String)"AssignPlugin_0", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
            List checkedNodes = treeView.getTreeState().getCheckedNodes();
            if (checkedNodes.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"AssignPlugin_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.executeAssign(entity, col, checkedNodes, isTreeType);
        } else if (control.getKey().equals("btn_assign_query")) {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put(ASIGNEDDATAS, this.getPageCache().get(this.getView().getPageId() + ASIGNEDDATAS));
            params.put(USEORGID, this.getView().getFormShowParameter().getCustomParam(USEORGID));
            params.put(ENTITY_NUMBER, entity);
            CloseCallBack assignQueryCallBack = new CloseCallBack((IFormPlugin)this, ASSIGN_QUERY_CALLBACK);
            params.put("assign_query", Boolean.TRUE.toString());
            this.showForm("bd_assign_query_by_data", params, assignQueryCallBack, ShowType.Modal);
        }
    }

    private void executeAssign(String entity, ListSelectedRowCollection selectRows, List<Map<String, Object>> checkedOrgNodes, boolean isTreeType) {
        boolean isMultiCustomData;
        HashMap<Long, String> idNumMap = new HashMap<Long, String>(selectRows.size());
        for (ListSelectedRow row : selectRows) {
            Long dataId = Long.valueOf(String.valueOf(row.getPrimaryKeyValue()));
            idNumMap.put(dataId, row.getNumber());
        }
        List<Long> dataIds = new ArrayList<Long>(idNumMap.keySet());
        if (!isTreeType) {
            this.executeAssign(entity, idNumMap, dataIds);
            return;
        }
        TreeBaseDataAssignPreValidator validator = new TreeBaseDataAssignPreValidator(this.getView(), entity, "assign", this.useOrgId);
        if (!validator.integrityValidate(dataIds, Collections.emptyList())) {
            return;
        }
        dataIds = this.assignAutoDatas(dataIds);
        if (!TreeBaseDataCommonService.isAssignUnDetail((String)entity)) {
            this.executeAssign(entity, idNumMap, dataIds);
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(checkedOrgNodes.size());
        for (Map<String, Object> orgNode : checkedOrgNodes) {
            Object id = orgNode.getOrDefault("id", 0L);
            orgIds.add(Long.valueOf(id.toString()));
        }
        Long useOrgId = Long.valueOf(this.getView().getFormShowParameter().getCustomParam(USEORGID).toString());
        Map customOrgDataInfo = BaseDataCustomService.getCustomOrgDataInfo((String)entity, orgIds, dataIds, (Long)useOrgId);
        if (CollectionUtils.isEmpty((Map)customOrgDataInfo)) {
            this.executeAssign(entity, idNumMap, dataIds);
            return;
        }
        this.getPageCache().putBigObject(CACHE_ASSIGN_ID, SerializationUtils.toJsonString(dataIds));
        boolean bl = isMultiCustomData = customOrgDataInfo.size() > 1;
        if (!isMultiCustomData) {
            isMultiCustomData = ((List)customOrgDataInfo.values().iterator().next()).size() > 1;
        }
        Map<Long, String> orgNameMap = this.selectOrgName(orgIds);
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(CALL_BACK_ACTION, (IFormPlugin)this);
        if (isMultiCustomData) {
            ArrayList details = new ArrayList(10);
            String msg = ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u5728\u7ec4\u7ec7\u201c%2$s\u201d\u4e2d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\u3002", (String)"AssignPlugin_19", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
            for (Map.Entry entry : customOrgDataInfo.entrySet()) {
                String dataNum = (String)idNumMap.get(entry.getKey());
                ((List)entry.getValue()).forEach(e -> details.add(String.format(msg, dataNum, orgNameMap.get(e))));
            }
            String title = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u88ab\u5206\u914d\u6570\u636e\u7684\u7236\u7ea7\u8d44\u6599\u5728\u7ec4\u7ec7\u4e2d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u5206\u914d\u540e\u4e3a\u4e86\u786e\u4fdd\u53ef\u89c1\u8303\u56f4\u5185\u6570\u636e\u5c42\u7ea7\u7684\u6b63\u786e\u6027\uff0c\u88ab\u5206\u914d\u6570\u636e\u4f1a\u505a\u81ea\u52a8\u4e2a\u6027\u5316\u5904\u7406\u3002", (String)"AssignPlugin_20", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
            String detail = String.join((CharSequence)"\r\n", details);
            this.getView().showConfirm(title, detail, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener);
        } else {
            Map.Entry entry = customOrgDataInfo.entrySet().iterator().next();
            Long dataId = (Long)entry.getKey();
            Long orgId = (Long)((List)entry.getValue()).get(0);
            String msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u5728\u7ec4\u7ec7\u201c%2$s\u201d\u4e2d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u5206\u914d\u540e\u5c06\u4f1a\u81ea\u52a8\u4fee\u590d\u8d44\u6599\u5c42\u7ea7\uff0c\u70b9\u51fb\u786e\u5b9a\u7ee7\u7eed\u5206\u914d\uff0c\u53d6\u6d88\u4e0d\u5206\u914d\u3002", (String)"AssignPlugin_18", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), idNumMap.get(dataId), orgNameMap.get(orgId));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, callBackListener);
        }
    }

    private Map<Long, String> selectOrgName(Collection<Long> orgIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", orgIds)};
        HashMap<Long, String> orgName = new HashMap<Long, String>(orgIds.size());
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "bos_org", "id, name", filters);){
            ds.forEach(e -> orgName.put(e.getLong("id"), e.getString("name")));
        }
        return orgName;
    }

    private void executeAssign(String entity, Map<Long, String> idNumMap, List<Long> dataIds) {
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        List checkedNodes = treeView.getTreeState().getCheckedNodes();
        String ctrlStrategy = this.getPageCache().get(this.getView().getPageId() + _CTRLSTRATEGY);
        if ("1".equals(ctrlStrategy)) {
            this.CUAssign(entity, dataIds, idNumMap, checkedNodes);
            return;
        }
        this.assign(entity, dataIds, idNumMap, checkedNodes);
    }

    private void CUAssign(String entity, List<Long> dataIds, Map<Long, String> idNumMap, List<Map<String, Object>> checkedNodes) {
        Map<String, Object> node;
        Long useOrgId = Long.valueOf(this.getView().getFormShowParameter().getCustomParam(USEORGID).toString());
        if (1 == checkedNodes.size() && useOrgId.equals(Long.valueOf((node = checkedNodes.get(0)).get("id").toString()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0b\u7ea7\u7ec4\u7ec7\u8fdb\u884c\u5206\u914d\u3002", (String)"AssignPlugin_15", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(checkedNodes.size());
        for (Map<String, Object> node2 : checkedNodes) {
            orgIds.add(Long.valueOf((String)node2.get("id")));
        }
        if (BaseDataCommonService.isTreeType((String)entity)) {
            this.sortTreeIds(dataIds, entity);
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
        AssignService assignService = new AssignService(entity, false);
        BaseDataResponse response = assignService.assign(useOrgId, appId, new HashSet<Long>(dataIds), orgIds, false);
        if (response.isSuccess() && CollectionUtils.isEmpty((Map)response.getResult())) {
            this.getPageCache().put(this.getView().getPageId() + ASIGNEDDATAS, SerializationUtils.toJsonString(dataIds));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AssignPlugin_2", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            Map checkAssignRes = response.getResult();
            BaseDataAssignServiceHelper.noticeAfterAssignError(checkAssignRes, idNumMap, this.getView());
        }
    }

    private void sortTreeIds(List<Long> dataIDs, String entity) {
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])dataIDs.toArray(), (String)entity);
        ArrayList<Integer> levels = new ArrayList<Integer>();
        Integer level = 0;
        HashMap levelIdMap = new HashMap(8);
        for (DynamicObject obj : objectDynamicObjectMap.values()) {
            level = obj.getInt("level");
            if (!levels.contains(level)) {
                levels.add(level);
            }
            List dataIds = levelIdMap.containsKey(level) ? (List)levelIdMap.get(level) : new ArrayList();
            dataIds.add((Long)obj.getPkValue());
            levelIdMap.put(level, dataIds);
        }
        Collections.sort(levels);
        dataIDs.clear();
        for (Integer i : levels) {
            dataIDs.addAll((Collection)levelIdMap.get(i));
        }
    }

    private void assign(String entity, List<Long> dataIds, Map<Long, String> idNumMap, List<Map<String, Object>> checkedOrgNodes) {
        HashSet<Long> orgIds = new HashSet<Long>(checkedOrgNodes.size());
        for (Map<String, Object> orgNode : checkedOrgNodes) {
            Object id = orgNode.getOrDefault("id", 0L);
            orgIds.add(Long.valueOf(id.toString()));
        }
        Long useOrgId = Long.valueOf(this.getView().getFormShowParameter().getCustomParam(USEORGID).toString());
        orgIds.remove(useOrgId);
        if (orgIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5c06\u81ea\u5df1\u521b\u5efa\u7684\u6570\u636e\u5206\u914d\u7ed9\u81ea\u5df1\u3002", (String)"AssignPlugin_3", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> dataIdsTemp = new ArrayList<Long>(dataIds.size());
        dataIdsTemp.addAll(dataIds);
        String appId = this.getView().getFormShowParameter().getAppId();
        AssignService assignService = new AssignService(entity, false);
        BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
        BaseDataResponse response = assignService.assign(useOrgId, appId, new HashSet(dataIdsTemp), orgIds, false);
        if (response.isSuccess() && CollectionUtils.isEmpty((Map)response.getResult())) {
            this.getPageCache().put(this.getView().getPageId() + ASIGNEDDATAS, SerializationUtils.toJsonString(dataIds));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AssignPlugin_2", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            Map checkAssignRes = response.getResult();
            BaseDataAssignServiceHelper.noticeAfterAssignError(checkAssignRes, idNumMap, this.getView());
        }
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    private void initCUAssignTree(Long srcOrgId, Long orgViewId) {
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        treeView.deleteAllNodes();
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(orgViewId.longValue());
        param.setId(srcOrgId.longValue());
        TreeNode node = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        node.setData((Object)1);
        node.setParentid("");
        treeView.addNode(node);
        treeView.queryTreeNodeChildren("", String.valueOf(srcOrgId));
        treeView.expand(String.valueOf(srcOrgId));
    }

    private void initCUFreeAssignTree(Long orgViewId) {
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.deleteAllNodes();
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(orgViewId.longValue());
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (rootNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u5355\u5143\u6839\u7ec4\u7ec7\u5931\u8d25\u3002", (String)"AssignPlugin_10", (String)"bos-org-formplugin", (Object[])new Object[0]));
        }
        tvLeft.addNode(rootNode);
        tvLeft.queryTreeNodeChildren("", rootNode.getId());
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        List<TreeNode> nodeList = this.getAllNodeList();
        if (CollectionUtils.isEmpty(nodeList)) {
            return;
        }
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        String currentNodeId = treeNodeEvent.getNodeId().toString();
        for (TreeNode node : nodeList) {
            String nodeId = node.getId();
            if (!currentNodeId.equals(nodeId)) continue;
            tvLeft.addNodes(node.getChildren());
            break;
        }
    }

    private List<TreeNode> getAllNodeList() {
        if (this.treeNodes != null) {
            return this.treeNodes;
        }
        String allOrgStr = this.getView().getPageCache().getBigObject(ALLORGLIST_KEY);
        this.treeNodes = null == allOrgStr ? Collections.emptyList() : SerializationUtils.fromJsonStringToList((String)allOrgStr, TreeNode.class);
        return this.treeNodes;
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        BillList billList;
        List searchFields = searchEnterEvent.getSearchFields();
        QFilter idFilter = new QFilter("id", "in", this.getAssignDataIds());
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        boolean isTreeType = BaseDataCommonService.isTreeType((String)entity);
        BillList billList2 = billList = isTreeType ? (BillList)this.getControl(BILLLISTAP2) : (BillList)this.getControl(BILLLISTAP);
        if (searchFields == null) {
            billList.setFilter(idFilter);
        } else {
            List filedList = (List)((Map)searchFields.get(0)).get("fieldName");
            List text = (List)((Map)searchFields.get(0)).get("value");
            String filelistStr = SerializationUtils.toJsonString((Object)filedList);
            this.getPageCache().put("filedList", filelistStr);
            this.getPageCache().put("searchfiled", (String)text.get(0));
            QFilter orFilter = new QFilter((String)filedList.get(0), "like", (Object)("%" + (String)text.get(0) + "%"));
            for (int i = 1; i < filedList.size(); ++i) {
                QFilter filter = new QFilter((String)filedList.get(i), "like", (Object)("%" + (String)text.get(0) + "%"));
                orFilter = QFilter.or((QFilter)orFilter, (QFilter)filter);
            }
            billList.setFilter(idFilter.and(orFilter));
        }
        billList.refresh();
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        List<TreeNode> nodeList = this.getAllNodeList();
        if (CollectionUtils.isEmpty(nodeList)) {
            return;
        }
        String ctrlStrategy = this.getPageCache().get(this.getView().getPageId() + _CTRLSTRATEGY);
        boolean isIncludeChild = (Boolean)this.getModel().getValue("chkincludechild");
        String checkedNodeId = event.getNodeId().toString();
        if (event.getChecked().booleanValue()) {
            this.nodeCheck(ctrlStrategy, isIncludeChild, checkedNodeId, nodeList);
            return;
        }
        TreeNode checkedNode = BaseDataAssignServiceHelper.getTreeNode(checkedNodeId, nodeList);
        if (null == checkedNode) {
            return;
        }
        ArrayList<TreeNode> unCheckNodes = new ArrayList<TreeNode>();
        unCheckNodes.add(checkedNode);
        if (!"2".equals(ctrlStrategy) || isIncludeChild) {
            BaseDataAssignServiceHelper.getChildrenNodeList(checkedNode, unCheckNodes);
        }
        ArrayList uncheckNodeIds = new ArrayList(unCheckNodes.size());
        unCheckNodes.forEach(node -> uncheckNodeIds.add(node.getId()));
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.uncheckNodes(uncheckNodeIds);
        this.updateF7SelectedList(tvLeft.getTreeState().getSelectedNodes(), nodeList.get(0), ctrlStrategy);
    }

    private void nodeCheck(String ctrlStrategy, boolean isIncludeChild, String checkedNodeId, List<TreeNode> nodeList) {
        if (CollectionUtils.isEmpty(nodeList)) {
            return;
        }
        TreeNode checkedNode = BaseDataAssignServiceHelper.getTreeNode(checkedNodeId, nodeList);
        if (null == checkedNode) {
            return;
        }
        ArrayList<TreeNode> needCheckNodes = new ArrayList<TreeNode>(10);
        needCheckNodes.add(checkedNode);
        if (isIncludeChild) {
            BaseDataAssignServiceHelper.getChildrenNodeList(checkedNode, needCheckNodes);
        }
        if ("1".equals(ctrlStrategy)) {
            this.queryParentNodesByOrgIds(needCheckNodes, nodeList, checkedNode.getParentid());
        }
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.checkNodes(needCheckNodes);
        List selectedNodes = tvLeft.getTreeState().getSelectedNodes();
        this.updateF7SelectedList(selectedNodes, nodeList.get(0), ctrlStrategy);
    }

    private void queryParentNodesByOrgIds(List<TreeNode> allNodes, List<TreeNode> nodeList, String parentId) {
        if (StringUtils.isBlank((CharSequence)parentId) || CollectionUtils.isEmpty(nodeList)) {
            return;
        }
        for (TreeNode node : nodeList) {
            if (!parentId.equals(node.getId())) continue;
            allNodes.add(node);
            String currentNodePid = node.getParentid();
            this.queryParentNodesByOrgIds(allNodes, nodeList, currentNodePid);
            break;
        }
    }

    private List<Long> assignAutoDatas(List<Long> ids) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        Long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam(USEORGID).toString());
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(entityNumber);
        List dataIds = TreeBaseDataCommonService.isAssignUnDetail((String)entityNumber) ? service.getIntegrityNodeIds(new HashSet<Long>(ids), orgId) : service.getIntegrityTreeNodeIds(ids, orgId);
        return CollectionUtils.isEmpty((Collection)dataIds) ? ids : dataIds;
    }

    public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
        Object id = f7SelectedListRemoveEvent.getParam();
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        if (Objects.isNull(id)) {
            List checkedNodeIds = tvLeft.getTreeState().getCheckedNodeIds();
            tvLeft.uncheckNodes(checkedNodeIds);
        } else {
            tvLeft.treeNodeCheck("", (String)id, Boolean.FALSE);
        }
    }

    private void updateF7SelectedList(List<Map<String, Object>> selectedNodes, TreeNode rootNode, String ctrlStrategy) {
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7_SELECT_LIST);
        ArrayList<ValueTextItem> items = new ArrayList<ValueTextItem>(selectedNodes.size());
        String userOrgId = this.getView().getFormShowParameter().getCustomParam(USEORGID).toString();
        if ("2".equals(ctrlStrategy)) {
            for (Map<String, Object> selectedNode : selectedNodes) {
                String id = String.valueOf(selectedNode.get("id"));
                if (userOrgId.equals(id)) continue;
                ValueTextItem valueTextItem = new ValueTextItem(id, String.valueOf(selectedNode.get("text")));
                items.add(valueTextItem);
            }
        } else {
            TreeNode userOrgNode = rootNode.getTreeNode(userOrgId);
            ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
            BaseDataAssignServiceHelper.getChildrenNodeList(userOrgNode, childNodes);
            Set childIdList = childNodes.stream().map(TreeNode::getId).collect(Collectors.toSet());
            for (Map<String, Object> selectedNode : selectedNodes) {
                String id = String.valueOf(selectedNode.get("id"));
                if (!childIdList.contains(id)) continue;
                ValueTextItem valueTextItem = new ValueTextItem(id, String.valueOf(selectedNode.get("text")));
                items.add(valueTextItem);
            }
        }
        f7SelectedList.addItems(items);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (CALL_BACK_ACTION.equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
            String value = this.getPageCache().getBigObject(CACHE_ASSIGN_ID);
            if (StringUtils.isBlank((CharSequence)value)) {
                return;
            }
            List values = SerializationUtils.fromJsonStringToList((String)value, Long.class);
            List<Long> assignDataIds = values.stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
            boolean isTreeType = BaseDataCommonService.isTreeType((String)entity);
            BillList billList = isTreeType ? (BillList)this.getControl(BILLLISTAP2) : (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectRows = billList.getSelectedRows();
            HashMap<Long, String> idNumMap = new HashMap<Long, String>(selectRows.size());
            for (ListSelectedRow row : selectRows) {
                Long dataId = Long.valueOf(String.valueOf(row.getPrimaryKeyValue()));
                idNumMap.put(dataId, row.getNumber());
            }
            this.executeAssign(entity, idNumMap, assignDataIds);
        }
    }
}

