/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedata.service.BaseDataQueryService;
import kd.bos.bd.ctsy.utils.CtsyDBUtils;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.AssignQueryService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.CancelAssignResult;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.bdctrl.helper.BaseDataCommonServiceHelper;
import kd.bos.form.plugin.bdctrl.validator.BaseDataCancelAssignPreValidator;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.query.impl.CountQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class AssignQueryListPlugin
extends AbstractListPlugin
implements SearchEnterListener,
SetFilterListener {
    private static final Log LOGGER = LogFactory.getLog(AssignQueryListPlugin.class);
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String ENTITY_ASSIGN_ORG = "bd_assign_org";
    private static final String FIELD_ASSIGN_ORG_NAME = "assignorgname";
    private static final String BTN_CANCEL_ASSIGN = "btn_assign_cancel";
    private static final String PROP_BASE_DATA = "basedata";
    private static final String PROP_BD_MATERIEL = "materiel";
    private static final String KEY_SELECT_DATA_ID = "select_bd_ids";
    private static final String KEY_ASSIGN_ORG_ID = "assign_org_ids";
    private static final String KEY_BD_ASSIGN_MAP = "assign_org_map";
    private static final String KEY_BD_SEARCH_FIELDS = "search_field";
    private static final String KEY_BD_SEARCH_VALUES = "search_value";
    private static final String CALL_BACK_CANCEL_ASSIGN_NAME = "call_back_cancel_assign_on_query";
    private static final String PARAM_USE_ORG_ID = "useOrgId";
    private static final String PARAM_QUERY_TYPE = "assign_query";
    private static final String PARAM_BD_ENTITY = "entityNumber";
    private static final String PARAM_BD_APP_ID = "appId";
    private static final String PARAM_ASSIGNED_DATA_ID = "asignedDatas";
    private static final String REG_IS_ASSIGN = "1";
    private Boolean newModel = null;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_CANCEL_ASSIGN});
        BasedataEdit bd = (BasedataEdit)this.getControl(PROP_BD_MATERIEL);
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BD_ENTITY);
        if (BaseDataCommonServiceHelper.isMaterialInfo(entity) && bd != null) {
            bd.addBasedataEditListener(evt -> {
                DynamicObject data = (DynamicObject)evt.getDataEntity();
                if (null == data) {
                    return;
                }
                DynamicObject material = data.getDynamicObject("masterid");
                if (null != material) {
                    evt.setDisplayProp(material.getString("name"));
                    evt.setEditSearchProp(material.getString("number"));
                }
            });
        }
    }

    public void registerListener(EventObject e) {
        String entity;
        String key;
        BasedataEdit bd;
        BillList billList;
        super.registerListener(e);
        Search search = (Search)this.getControl("search");
        if (null != search) {
            search.addEnterListener((SearchEnterListener)this);
        }
        if (null != (billList = (BillList)this.getControl("billlistap"))) {
            billList.addSetFilterListener((SetFilterListener)this);
            billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new AssignQueryListDataProvider()));
        }
        if ((bd = (BasedataEdit)this.getControl(key = BaseDataCommonServiceHelper.isMaterialInfo(entity = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BD_ENTITY)) ? PROP_BD_MATERIEL : PROP_BASE_DATA)) != null) {
            IPageCache pageCache = this.getPageCache();
            bd.addBeforeF7SelectListener(event -> {
                Object orgParam = this.getView().getFormShowParameter().getCustomParam(PARAM_USE_ORG_ID);
                ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
                if (null != orgParam && null != parameter) {
                    parameter.setUseOrgId(Long.parseLong(orgParam.toString()));
                }
                String cacheValue = pageCache.getBigObject(KEY_SELECT_DATA_ID);
                List dataIds = SerializationUtils.fromJsonStringToList((String)cacheValue, Long.class);
                event.addCustomQFilter(new QFilter("id", "in", (Object)dataIds));
            });
        }
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        MainEntityType mainType;
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BD_ENTITY);
        if (StringUtils.isEmpty((Object)entity)) {
            return;
        }
        MainEntityType baseType = EntityMetadataCache.getDataEntityType((String)entity);
        try {
            mainType = (MainEntityType)args.getOriginalEntityType().clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("\u514b\u9686\u5b9e\u4f53\u5f02\u5e38", (Throwable)e);
            return;
        }
        this.setEntityType(baseType, mainType, PROP_BASE_DATA);
        this.setEntityType(baseType, mainType, PROP_BD_MATERIEL);
        args.setNewEntityType(mainType);
    }

    private void setEntityType(MainEntityType baseType, MainEntityType mainType, String key) {
        BasedataProp baseProp = (BasedataProp)mainType.findProperty(key);
        baseProp.setComplexType((IDataEntityType)baseType);
        baseProp.setBaseEntityId(baseType.getName());
        DynamicSimpleProperty refIdProp = (DynamicSimpleProperty)mainType.findProperty(baseProp.getRefIdProp().getName());
        mainType.getProperties().remove((Object)refIdProp);
        refIdProp = baseProp.createRefIDProp();
        refIdProp.setPrimaryKey(false);
        if (StringUtils.isEmpty((Object)baseProp.getAlias())) {
            refIdProp.setDbIgnore(true);
        } else {
            refIdProp.setAlias(baseProp.getAlias());
            refIdProp.setTableGroup(baseProp.getTableGroup());
        }
        refIdProp.setName(baseProp.getName() + "_id");
        mainType.addProperty((DynamicProperty)refIdProp);
        baseProp.setRefIdPropName(baseProp.getName() + "_id");
        baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
    }

    public void afterCreateNewData(EventObject e) {
        Object orgParam = this.getView().getFormShowParameter().getCustomParam(PARAM_USE_ORG_ID);
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BD_ENTITY);
        if (StringUtils.isEmpty((Object)orgParam) || null == entity) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        boolean isMaterialInfo = BaseDataCommonServiceHelper.isMaterialInfo(entity);
        this.getView().setVisible(Boolean.valueOf(isMaterialInfo), new String[]{PROP_BD_MATERIEL});
        this.getView().setVisible(Boolean.valueOf(!isMaterialInfo), new String[]{PROP_BASE_DATA});
        String key = isMaterialInfo ? PROP_BD_MATERIEL : PROP_BASE_DATA;
        BasedataEdit bd = (BasedataEdit)this.getControl(key);
        if (null == billList || bd == null) {
            return;
        }
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new AssignQueryListDataProvider()));
        Long currentOrgId = Long.valueOf(orgParam.toString());
        BasedataProp basedataProp = (BasedataProp)bd.getProperty();
        basedataProp.setBaseEntityId(entity);
        basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entity));
        this.setBaseDataCaption(entity, bd);
        List<Long> dataIds = this.getEnableSelectDataIds(entity, currentOrgId);
        this.getPageCache().putBigObject(KEY_SELECT_DATA_ID, SerializationUtils.toJsonString(dataIds));
        if (CollectionUtils.isEmpty(dataIds)) {
            return;
        }
        Long dataId = dataIds.get(0);
        this.getModel().setValue(key, (Object)dataId);
        this.setFormPageBaseDataInfo(dataId, entity, key);
        if (this.isNewModel(entity)) {
            Set<Long> orgIds = this.initAssignOrgIdsOnNewModel(dataId, entity, currentOrgId);
            this.initBaseDataOrgInfo(entity, dataId, currentOrgId, orgIds, key);
        } else {
            this.intiBdAssignOrgAndAssignRel(entity, dataId, currentOrgId, key);
        }
        billList.clearSelection();
    }

    private List<Long> getEnableSelectDataIds(String entity, Long currentOrgId) {
        boolean isFromAssignPage = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam(PARAM_QUERY_TYPE));
        List dataIds = Collections.emptyList();
        if (isFromAssignPage) {
            String cacheDataId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_ASSIGNED_DATA_ID);
            if (!StringUtils.isEmpty((Object)cacheDataId)) {
                dataIds = SerializationUtils.fromJsonStringToList((String)cacheDataId, Long.class);
            }
        } else {
            List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
            dataIds = new ArrayList(ids.size());
            for (Object id : ids) {
                dataIds.add(Long.valueOf(id.toString()));
            }
        }
        if (CollectionUtils.isEmpty(dataIds)) {
            String appId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BD_APP_ID);
            dataIds = new BaseDataQueryService().getBaseDataIdsFromDb(entity, currentOrgId, appId);
        }
        return dataIds;
    }

    private void setBaseDataCaption(String entity, BasedataEdit bd) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)entity);
        LocaleString caption = formConfig.getCaption();
        if (null == caption) {
            return;
        }
        LocaleString value = new LocaleString(caption.getLocaleValue());
        bd.setCaption(value);
    }

    private void setFormPageBaseDataInfo(Long dataId, String entity, String key) {
        DynamicObject baseData = (DynamicObject)this.getModel().getValue(key);
        if (null == baseData) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)dataId)};
            baseData = QueryServiceHelper.queryOne((String)entity, (String)"name, createorg, masterid", (QFilter[])filters);
        }
        if (null == baseData) {
            this.getModel().setValue("name", null);
            this.getModel().setValue("createorg", null);
            return;
        }
        if (BaseDataCommonServiceHelper.isMaterialInfo(entity)) {
            DynamicObject material = baseData.getDynamicObject("masterid");
            if (null == material) {
                this.getModel().setValue("name", null);
            } else {
                this.getModel().setValue("name", (Object)material.getString("name"));
            }
        } else {
            this.getModel().setValue("name", (Object)baseData.getString("name"));
        }
        DynamicObject org = baseData.getDynamicObject("createorg");
        if (null == org) {
            this.getModel().setValue("createorg", null);
            return;
        }
        this.getModel().setValue("createorg", (Object)org.getString("name"));
    }

    private void initBaseDataOrgInfo(String entity, Long dataId, Long useOrgId, Set<Long> orgIds, String key) {
        DynamicObject baseData = (DynamicObject)this.getModel().getValue(key);
        if (null == baseData) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)dataId)};
            baseData = QueryServiceHelper.queryOne((String)entity, (String)"ctrlstrategy", (QFilter[])filters);
        }
        IPageCache pageCache = this.getPageCache();
        pageCache.removeBigObject(KEY_BD_ASSIGN_MAP);
        if (null == baseData) {
            return;
        }
        String ctrlStrategy = baseData.getString("ctrlstrategy");
        if ("2".equals(ctrlStrategy)) {
            this.initFreeDataAssignOrgInfo(useOrgId, orgIds);
            return;
        }
        if (REG_IS_ASSIGN.equals(ctrlStrategy)) {
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
            if (null == ctrlView) {
                return;
            }
            Map<Long, String> assignOrgMap = this.getDirectSuperiorOrg((Long)ctrlView.getPkValue(), orgIds);
            pageCache.putBigObject(KEY_BD_ASSIGN_MAP, SerializationUtils.toJsonString(assignOrgMap));
        }
    }

    private Map<Long, String> getDirectSuperiorOrg(Long viewId, Collection<Long> orgIds) {
        QFilter viewFilter = new QFilter("view", "=", (Object)viewId);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        String selectFields = "org,parent";
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        Map parentMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)parentMap)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> orgParentMap = new HashMap<Long, String>(parentMap.size());
        for (DynamicObject parent : parentMap.values()) {
            DynamicObject orgObj = parent.getDynamicObject("org");
            if (orgObj == null) continue;
            Long orgId = orgObj.getLong("id");
            DynamicObject parentOrgObj = parent.getDynamicObject("parent");
            if (parentOrgObj == null) continue;
            orgParentMap.put(orgId, parentOrgObj.getString("name"));
        }
        return orgParentMap;
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        IPageCache pageCache = this.getPageCache();
        String orgCache = pageCache.getBigObject(KEY_ASSIGN_ORG_ID);
        if (StringUtils.isEmpty((Object)orgCache)) {
            filters.add(new QFilter("id", "in", Collections.emptyList()));
        } else {
            List dataIds = SerializationUtils.fromJsonStringToList((String)orgCache, Long.class);
            filters.add(new QFilter("id", "in", (Object)dataIds));
        }
        QFilter searchFilter = this.getSearchFilter();
        if (null != searchFilter) {
            filters.add(searchFilter);
        }
    }

    private QFilter getSearchFilter() {
        IPageCache pageCache = this.getPageCache();
        String searchFieldCache = pageCache.getBigObject(KEY_BD_SEARCH_FIELDS);
        String searchValueCache = pageCache.getBigObject(KEY_BD_SEARCH_VALUES);
        if (StringUtils.isEmpty((Object)searchFieldCache) || StringUtils.isEmpty((Object)searchValueCache)) {
            return null;
        }
        QFilter searchFilter = null;
        List fieldNames = SerializationUtils.fromJsonStringToList((String)searchFieldCache, String.class);
        List values = SerializationUtils.fromJsonStringToList((String)searchValueCache, String.class);
        for (Object fieldName : fieldNames) {
            if (null == searchFilter) {
                searchFilter = this.getSearchFilter(values, fieldName.toString());
                continue;
            }
            searchFilter = searchFilter.or(this.getSearchFilter(values, fieldName.toString()));
        }
        return searchFilter;
    }

    private QFilter getSearchFilter(List<?> values, String field) {
        if (CollectionUtils.isEmpty(values)) {
            return null;
        }
        QFilter result = null;
        for (Object value : values) {
            if (StringUtils.isEmpty(value)) continue;
            QFilter filter = new QFilter(field, "like", (Object)("%" + value + "%"));
            if (null == result) {
                result = filter;
                continue;
            }
            result = result.or(filter);
        }
        return result;
    }

    public void search(SearchEnterEvent event) {
        BillList billList = (BillList)this.getControl("billlistap");
        if (null == billList) {
            return;
        }
        List fieldNames = event.getFieldNames();
        String text = event.getText();
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.removeBigObject(KEY_BD_SEARCH_FIELDS);
        pageCache.removeBigObject(KEY_BD_SEARCH_VALUES);
        if (CollectionUtils.isEmpty((Collection)fieldNames) || null == text) {
            billList.clearSelection();
            billList.refresh();
            return;
        }
        if (StringUtils.isEmpty((Object)(text = text.trim()))) {
            billList.clearSelection();
            billList.refresh();
            return;
        }
        List values = Arrays.stream(text.split(" ")).collect(Collectors.toList());
        pageCache.putBigObject(KEY_BD_SEARCH_FIELDS, SerializationUtils.toJsonString((Object)fieldNames));
        pageCache.putBigObject(KEY_BD_SEARCH_VALUES, SerializationUtils.toJsonString(values));
        billList.clearSelection();
        billList.refresh();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        if (PROP_BASE_DATA.equals(property.getName()) || PROP_BD_MATERIEL.equals(property.getName())) {
            String key;
            ChangeData change = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)change.getNewValue();
            Long dataId = null;
            if (null != newValue) {
                dataId = (Long)newValue.getPkValue();
            }
            if (null == dataId) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_CANCEL_ASSIGN});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_CANCEL_ASSIGN});
            }
            Object orgParam = this.getView().getFormShowParameter().getCustomParam(PARAM_USE_ORG_ID);
            Long useOrgId = Long.valueOf(orgParam.toString());
            String entity = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BD_ENTITY);
            String string = key = BaseDataCommonServiceHelper.isMaterialInfo(entity) ? PROP_BD_MATERIEL : PROP_BASE_DATA;
            if (this.isNewModel(entity)) {
                Set<Long> orgIds = this.initAssignOrgIdsOnNewModel(dataId, entity, useOrgId);
                this.initBaseDataOrgInfo(entity, dataId, useOrgId, orgIds, key);
            } else {
                this.intiBdAssignOrgAndAssignRel(entity, dataId, useOrgId, key);
            }
            this.setFormPageBaseDataInfo(dataId, entity, key);
            BillList billList = (BillList)this.getControl("billlistap");
            billList.getEntryState().setCurrentPageIndex(Integer.valueOf(1));
            billList.clearSelection();
            billList.refresh();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (!BTN_CANCEL_ASSIGN.equals(control.getKey())) {
            return;
        }
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BD_ENTITY);
        if (CtsyDBUtils.ctsyBaseDataUseOnly((String)entity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u542f\u4e86\u8de8\u79df\u6237\u4e3b\u6570\u636e\u57df\u7ba1\u63a7\uff0c\u5f53\u524d\u64cd\u4f5c\u4e0d\u652f\u6301\uff0c\u8bf7\u5230\u96c6\u56e2\u79df\u6237\u6267\u884c\u3002", (String)"AssignQueryListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        String key = BaseDataCommonServiceHelper.isMaterialInfo(entity) ? PROP_BD_MATERIEL : PROP_BASE_DATA;
        DynamicObject baseData = (DynamicObject)this.getModel().getValue(key);
        this.executeCancelAssign(baseData, entity);
    }

    private void executeCancelAssign(DynamicObject baseData, String entity) {
        try {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            HashSet<Long> dataIds = new HashSet<Long>(16);
            Long dataId = baseData.getLong("id");
            dataIds.add(dataId);
            HashSet<Long> orgIds = new HashSet<Long>(selectedRows.size());
            for (ListSelectedRow row : selectedRows) {
                Long orgId = Long.valueOf(row.getPrimaryKeyValue().toString());
                orgIds.add(orgId);
            }
            Object orgParam = this.getView().getFormShowParameter().getCustomParam(PARAM_USE_ORG_ID);
            Long useOrgId = Long.valueOf(orgParam.toString());
            BaseDataCancelAssignPreValidator validate = new BaseDataCancelAssignPreValidator(this.getView(), entity, null);
            if (!validate.preValidate(entity, useOrgId, dataIds, orgIds)) {
                return;
            }
            BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
            List results = BaseDataServiceHelper.cancelAssign((String)entity, dataIds, orgIds);
            if (this.hasCancelSuccess(results)) {
                this.getView().addClientCallBack(CALL_BACK_CANCEL_ASSIGN_NAME);
            }
            results.removeIf(CancelAssignResult::isSuccess);
            if (results.isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AssignQueryListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            this.showCancelErrorNotice(results);
        }
        catch (Exception e) {
            LOGGER.error("\u53d6\u6d88\u5206\u914d\u662f\u5931\u8d25", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"AssignQueryListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (CALL_BACK_CANCEL_ASSIGN_NAME.equals(e.getName())) {
            String entity = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BD_ENTITY);
            String key = BaseDataCommonServiceHelper.isMaterialInfo(entity) ? PROP_BD_MATERIEL : PROP_BASE_DATA;
            DynamicObject baseData = (DynamicObject)this.getModel().getValue(key);
            boolean isNewModel = BaseDataCommonService.isNewModel((String)entity);
            this.refresh(isNewModel, entity, (Long)baseData.getPkValue());
        }
    }

    private void showCancelErrorNotice(List<CancelAssignResult> results) {
        if (results.size() == 1) {
            this.getView().showErrorNotification(results.get(0).getErrorMsg());
        } else {
            StringBuilder errorMsgSbd = new StringBuilder();
            results.forEach(result -> errorMsgSbd.append(result.getErrorMsg()).append("\r\n"));
            this.getView().showMessage(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"AssignQueryListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), errorMsgSbd.toString(), MessageTypes.Default);
        }
    }

    private boolean hasCancelSuccess(List<CancelAssignResult> results) {
        for (CancelAssignResult result : results) {
            if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)result.getOrgIds())) continue;
            return true;
        }
        return false;
    }

    private void refresh(boolean newModel, String entity, Long dataId) {
        Object orgParam = this.getView().getFormShowParameter().getCustomParam(PARAM_USE_ORG_ID);
        Long useOrgId = Long.valueOf(orgParam.toString());
        if (newModel) {
            this.initAssignOrgIdsOnNewModel(dataId, entity, useOrgId);
        } else {
            String key = BaseDataCommonServiceHelper.isMaterialInfo(entity) ? PROP_BD_MATERIEL : PROP_BASE_DATA;
            this.intiBdAssignOrgAndAssignRel(entity, dataId, useOrgId, key);
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new AssignQueryListDataProvider()));
        billList.clearSelection();
        billList.refresh();
    }

    private Set<Long> initAssignOrgIdsOnNewModel(Long dataId, String entity, Long currentOrgId) {
        try {
            DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)dataId, (String)entity);
            AssignQueryService service = new AssignQueryService();
            Map assignData = service.assignQueryByData(entity, Collections.singletonList(dataId), currentOrgId, baseData.getString("ctrlstrategy"));
            Set<Long> orgIds = assignData.keySet();
            this.getPageCache().putBigObject(KEY_ASSIGN_ORG_ID, SerializationUtils.toJsonString(orgIds));
            return orgIds;
        }
        catch (Exception ex) {
            LOGGER.error("\u67e5\u8be2\u5206\u914d\u60c5\u51b5\u5f02\u5e38", (Throwable)ex);
            this.getPageCache().putBigObject(KEY_ASSIGN_ORG_ID, SerializationUtils.toJsonString(Collections.emptySet()));
            return Collections.emptySet();
        }
    }

    private void intiBdAssignOrgAndAssignRel(String entity, Long dataId, Long currentOrgId, String key) {
        DynamicObject baseData = (DynamicObject)this.getModel().getValue(key);
        if (null == baseData) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)dataId)};
            baseData = QueryServiceHelper.queryOne((String)entity, (String)"ctrlstrategy", (QFilter[])filters);
        }
        if (null == baseData) {
            this.getPageCache().putBigObject(KEY_ASSIGN_ORG_ID, SerializationUtils.toJsonString(Collections.emptySet()));
            this.getPageCache().putBigObject(KEY_BD_ASSIGN_MAP, SerializationUtils.toJsonString(Collections.emptyMap()));
            return;
        }
        String ctrlStrategy = baseData.getString("ctrlstrategy");
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        HashSet cuOrgIds = new HashSet(16);
        if (null != ctrlView && REG_IS_ASSIGN.equals(ctrlStrategy)) {
            AssignQueryService service = new AssignQueryService();
            cuOrgIds.addAll(service.getAllCuSubordinateOrgIds((Long)ctrlView.getPkValue(), currentOrgId));
        }
        HashMap<Long, Long> assignRelMap = new HashMap<Long, Long>(16);
        IDataEntityType dt = ORM.create().getDataEntityType(entity);
        String selectSql = String.format("select fuseorgid,fassignorgid,fisassign from %susereg where fdataid  = %s;", dt.getAlias(), dataId);
        Set orgIds = (Set)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)selectSql, rs -> {
            HashSet<Long> result = new HashSet<Long>(16);
            while (rs.next()) {
                Long useOrgId = rs.getLong("fuseorgid");
                String assign = rs.getString("fisassign");
                if ("2".equals(ctrlStrategy) && REG_IS_ASSIGN.equals(assign)) {
                    result.add(useOrgId);
                    continue;
                }
                if (!REG_IS_ASSIGN.equals(ctrlStrategy) || !cuOrgIds.contains(useOrgId)) continue;
                result.add(useOrgId);
                assignRelMap.put(useOrgId, rs.getLong("fassignorgid"));
            }
            return result;
        });
        this.getPageCache().putBigObject(KEY_ASSIGN_ORG_ID, SerializationUtils.toJsonString((Object)orgIds));
        if (orgIds.isEmpty()) {
            this.getPageCache().putBigObject(KEY_BD_ASSIGN_MAP, SerializationUtils.toJsonString(Collections.emptyMap()));
            return;
        }
        if ("2".equals(ctrlStrategy)) {
            this.initFreeDataAssignOrgInfo(currentOrgId, orgIds);
        } else if (REG_IS_ASSIGN.equals(ctrlStrategy)) {
            this.initCuAssignDataAssignOrgInfo(entity, assignRelMap);
        }
    }

    private void initCuAssignDataAssignOrgInfo(String entity, Map<Long, Long> assignRelMap) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", assignRelMap.values())};
        Map dynamicObjMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_ASSIGN_ORG, (String)"name", (QFilter[])filters);
        HashMap orgId2NameMap = new HashMap(dynamicObjMap.size());
        dynamicObjMap.forEach((orgId, org) -> orgId2NameMap.put((Long)orgId, org.getString("name")));
        ArrayList<Long> needQueryParentOrgIds = new ArrayList<Long>(assignRelMap.size());
        HashMap<Long, String> result = new HashMap<Long, String>(assignRelMap.size());
        for (Map.Entry<Long, Long> entry : assignRelMap.entrySet()) {
            String orgName = (String)orgId2NameMap.get(entry.getValue());
            if (null != orgName) {
                result.put(entry.getKey(), orgName);
                continue;
            }
            needQueryParentOrgIds.add(entry.getKey());
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        if (!needQueryParentOrgIds.isEmpty() && null != ctrlView) {
            result.putAll(this.getDirectSuperiorOrg((Long)ctrlView.getPkValue(), needQueryParentOrgIds));
        }
        this.getView().getPageCache().putBigObject(KEY_BD_ASSIGN_MAP, SerializationUtils.toJsonString(result));
    }

    private void initFreeDataAssignOrgInfo(Long currentOrgId, Set<Long> orgIds) {
        if (orgIds.isEmpty()) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)currentOrgId)};
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_ASSIGN_ORG, (String)"name", (QFilter[])filters);
        HashMap assignOrgMap = new HashMap(16);
        if (null == org) {
            this.getPageCache().putBigObject(KEY_BD_ASSIGN_MAP, SerializationUtils.toJsonString(assignOrgMap));
            return;
        }
        String orgName = org.getString("name");
        orgIds.forEach(orgId -> assignOrgMap.put(orgId, orgName));
        this.getPageCache().putBigObject(KEY_BD_ASSIGN_MAP, SerializationUtils.toJsonString(assignOrgMap));
    }

    private boolean isNewModel(String entity) {
        if (null == this.newModel) {
            this.newModel = BaseDataCommonService.isNewModel((String)entity);
        }
        return this.newModel;
    }

    class AssignQueryListDataProvider
    extends ListDataProvider {
        AssignQueryListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            return super.getData(start, limit);
        }

        public int getRealCount() {
            QueryBuilder queryBuilder = this.getQueryBuilder();
            QFilter searchFilter = AssignQueryListPlugin.this.getSearchFilter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(Arrays.asList(queryBuilder.getFilters()));
            if (null != searchFilter) {
                filters.add(searchFilter);
                queryBuilder.setFilters(filters.toArray(new QFilter[0]));
            }
            return CountQuery.getCount((QueryBuilder)queryBuilder);
        }
    }
}

