/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.bd.service.AssignQueryService;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.bd.validator.BaseDataCancelAssignValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.bdctrl.helper.BaseDataCommonServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import org.roaringbitmap.RoaringBitmap;

public class AssignQueryPlugin
extends AbstractFormPlugin {
    public static final String BASEDATAUSEREGSUFFIX = "UseReg";
    public static final String BASEDATAEXCSUFFIX = "Exc";
    public static final String BASEDATAUSERANGESUFFIX = "_U";
    public static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    public static final String UNASSIGN_PERM = "80513209000000ac";
    public static final String BOS_BD_FORMPLUGIN = "bos-bd-formplugin";
    public static final String ENTRYENTITY = "entryentity";
    public static final String NUMBER = "number";
    public static final String DATAID = "dataid";
    public static final String USEORGID = "useorgid";
    public static final String MASTERID = "masterid";
    public static final String CREATEORG = "createorg";
    public static final String ORGID = "org.id";
    private static final String ORGPARENTID = "parent.id";
    public static final String ENTITY_NUMBER = "entityNumber";
    private static final String NAME = "name";
    private static final String ISTREETYPEBASEDATA = "isTreeTypeBaseData";
    private static final Log log = LogFactory.getLog(AssignQueryPlugin.class);
    private static final int ENRTYSIZE = 10000;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnunassign"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btnunassign")) {
            String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
            if (BaseDataCommonService.isNewModel((String)entity)) {
                this.cancelAssignOnNewModel(entity);
            } else {
                this.cancelAssign();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelAssign() {
        int n = 0;
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        String useOrgId = this.getView().getFormShowParameter().getCustomParam("useOrgId").toString();
        String dataTableName = ORM.create().getDataEntityType(entity).getAlias();
        String dataTableUseName = dataTableName + BASEDATAUSEREGSUFFIX;
        String appId = this.getView().getFormShowParameter().getAppId();
        if (PermissionServiceHelper.checkPermission((Long)Long.parseLong(RequestContext.get().getUserId()), (Long)Long.parseLong(useOrgId), (String)appId, (String)entity, (String)UNASSIGN_PERM) == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u53d6\u6d88\u5206\u914d\u6743\u9650\u3002", (String)"AssignQueryPlugin_0", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        EntryGrid billList = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] col = billList.getSelectRows();
        if (col.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53d6\u6d88\u5206\u914d\u7684\u6570\u636e\u3002", (String)"AssignQueryPlugin_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String baseDataTableName = ORM.create().getDataEntityType(entity).getAlias();
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        HashSet<Long> orgs = new HashSet<Long>(16);
        HashMap<String, Set<Long>> dataids = new HashMap<String, Set<Long>>(16);
        HashMap<String, Object> datas = new HashMap<String, Object>(16);
        HashMap<String, Object> useOrgs = new HashMap<String, Object>(16);
        ArrayList<Long[]> unAssignDatas = new ArrayList<Long[]>(col.length);
        this.fillData(col, unAssignDatas, dataids, datas, orgs, useOrgs, billList);
        List<Long[]> checkResult = this.bizUnassignVerify(dataids, unAssignDatas, entity);
        HashSet dataIds = new HashSet(dataids.size());
        dataids.keySet().stream().forEach(dataid -> dataIds.add(Long.valueOf(dataid)));
        Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)entity, (String)masteridPropName, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds)});
        HashSet<Long> masteridSet = new HashSet<Long>(dataids.size());
        for (Object dynamicObject : dynamicObjects.values()) {
            if (dynamicObject == null) continue;
            Long masterId = 0L;
            if (dynamicObject.get(masteridPropName) instanceof DynamicObject) {
                DynamicObject masterObj = dynamicObject.getDynamicObject(masteridPropName);
                masterId = (Long)masterObj.getPkValue();
            } else if (dynamicObject.get(masteridPropName) instanceof Long) {
                masterId = (Long)dynamicObject.get(masteridPropName);
            }
            masteridSet.add(masterId);
        }
        dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)entity, (String)(masteridPropName + ",createorg,ctrlstrategy"), (QFilter[])new QFilter[]{new QFilter(masteridPropName, "in", masteridSet)});
        HashMap<Long, List<Long>> masteridMap = new HashMap<Long, List<Long>>(dataids.size());
        for (DynamicObject dynamicObject : dynamicObjects.values()) {
            if (dynamicObject == null) continue;
            Long masterId = 0L;
            if (dynamicObject.get(masteridPropName) instanceof DynamicObject) {
                DynamicObject masterObj = dynamicObject.getDynamicObject(masteridPropName);
                masterId = (Long)masterObj.getPkValue();
            } else if (dynamicObject.get(masteridPropName) instanceof Long) {
                masterId = (Long)dynamicObject.get(masteridPropName);
            }
            List ids = masteridMap.containsKey(masterId) ? (List)masteridMap.get(masterId) : new ArrayList();
            ids.add((Long)dynamicObject.getPkValue());
            masteridMap.put(masterId, ids);
        }
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entity);
        if (null == ctrlview) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u672a\u914d\u7f6e\u7ec4\u7ec7\u89c6\u56fe", (String)"AssignQueryPlugin_14", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String message = "";
        int personalDataCount = 0;
        String personalDataNum = "";
        String personalDataOrg = "";
        String dbRouteKey = ORM.create().getDataEntityType(entity).getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        Map<Long, List<Long>> directSubOrgIdsMap = this.getDirectSubOrgIdsMap(dataids, ctrlview);
        Map<Long, List<Long>> dataUseRegMap = this.getDataUseRegMap(dataids, directSubOrgIdsMap, dbRoute, dataTableUseName, dataTableName);
        Map<Long, List<Long>> isNotCuDataUseRegMap = this.getIsNotCuDataUseRegMap(dataids, directSubOrgIdsMap, dbRoute, dataTableUseName, dataTableName, useOrgId);
        Iterator iterator = dataids.entrySet().iterator();
        block4: while (true) {
            if (!iterator.hasNext()) {
                if (params.size() > 0) {
                    ThreadPool pool = BaseDataThreadPoolUtils.getBdCommonThreadPool();
                    Future deleteUseReg = pool.submit(() -> {
                        this.deleteUseReg(dataTableUseName, dbRoute, params);
                        return Boolean.TRUE;
                    });
                    Future deleteExc = pool.submit(() -> {
                        this.deleteExc(baseDataTableName, dbRoute, params);
                        return Boolean.TRUE;
                    });
                    Future deleteUseRange = pool.submit(() -> {
                        this.deleteUseRange(baseDataTableName, dbRoute, params);
                        return Boolean.TRUE;
                    });
                    try {
                        if (((Boolean)deleteUseReg.get()).booleanValue() && ((Boolean)deleteExc.get()).booleanValue() && !((Boolean)deleteUseRange.get()).booleanValue()) {
                            // empty if block
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
                    String entityID = ORM.create().getDataEntityType(entity).getName();
                    String[] keys = new String[orgs.size()];
                    Iterator iter = orgs.iterator();
                    int i = 0;
                    while (iter.hasNext()) {
                        keys[i] = entityID + ((Long)iter.next()).toString();
                        ++i;
                    }
                    BaseDataCtrlCacheMrg.clearCache((String)type, (String[])keys);
                }
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.reflesh();
                if (personalDataCount > 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5728\u7ec4\u7ec7\u201c%2$s\u201d\u4e2d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u8bf7\u5148\u5220\u9664\u4e2a\u6027\u5316\u6570\u636e\u518d\u53d6\u6d88\u5206\u914d\u3002", (String)"AssignQueryPlugin_10", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), personalDataNum, personalDataOrg));
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)message)) {
                    if (checkResult.size() > 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u7b49%2$s\u6761\u6570\u636e\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"AssignQueryPlugin_3", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), datas.get(String.valueOf(checkResult.get(0)[0])), checkResult.size()));
                        return;
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AssignQueryPlugin_4", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (checkResult.size() > 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u7b49%2$s\u6761\u6570\u636e\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"AssignQueryPlugin_3", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), datas.get(String.valueOf(checkResult.get(0)[0])), checkResult.size()));
                    return;
                }
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u53d6\u6d88\u5206\u914d\u5931\u8d25\u6570\u636e\u3002", (String)"AssignQueryPlugin_5", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), n), message, MessageTypes.Default);
                return;
            }
            Map.Entry entry = iterator.next();
            String dataId = (String)entry.getKey();
            Long masterId = 0L;
            Set dataOrgs = (Set)entry.getValue();
            Iterator iterator2 = dataOrgs.iterator();
            while (true) {
                List<Object[]> tempParams;
                List<Long> directSubOrgIds;
                if (!iterator2.hasNext()) continue block4;
                Long orgId = (Long)iterator2.next();
                Object[] param = new Object[2];
                if (!BaseDataServiceHelper.isNoneCustomEntity((String)entity).booleanValue()) {
                    DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(Long.valueOf(dataId));
                    if (dynamicObject != null) {
                        if (dynamicObject.get(masteridPropName) instanceof DynamicObject) {
                            DynamicObject masterObj = dynamicObject.getDynamicObject(masteridPropName);
                            masterId = (Long)masterObj.getPkValue();
                        } else if (dynamicObject.get(masteridPropName) instanceof Long) {
                            masterId = (Long)dynamicObject.get(masteridPropName);
                        }
                    }
                    boolean isExist = false;
                    List ids = (List)masteridMap.get(masterId);
                    Long createorgId = null;
                    Iterator iterator3 = ids.iterator();
                    while (iterator3.hasNext()) {
                        Long id = (Long)iterator3.next();
                        DynamicObject curObj = (DynamicObject)dynamicObjects.get(id);
                        createorgId = curObj.getLong("createorg.id");
                        ArrayList currentOrg = new ArrayList(1);
                        currentOrg.addAll(dataOrgs);
                        if ("1".equals(curObj.get("ctrlstrategy"))) {
                            List subOrgs;
                            if (masterId.equals(id) || !(subOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(ctrlview.getPkValue().toString()), currentOrg, (boolean)true)).contains(createorgId)) continue;
                            isExist = true;
                            String createOrgName = String.valueOf(curObj.get("createorg.name"));
                            personalDataNum = String.valueOf(curObj.get(NUMBER));
                            personalDataOrg = createOrgName;
                            break;
                        }
                        if (masterId.equals(id) || !orgId.equals(createorgId)) continue;
                        isExist = true;
                        personalDataNum = String.valueOf(datas.get(dataId));
                        personalDataOrg = String.valueOf(useOrgs.get(String.valueOf(orgId)));
                    }
                    if (isExist) {
                        ++personalDataCount;
                        continue;
                    }
                }
                if (CollectionUtils.isEmpty(directSubOrgIds = directSubOrgIdsMap.get(orgId))) {
                    param[0] = Long.valueOf(dataId);
                    param[1] = orgId;
                    params.add(param);
                    continue;
                }
                List<Long> subOrgHaveNoCancel = this.getSubOrgHaveNoCancel(dataOrgs, Long.valueOf(dataId), directSubOrgIdsMap, dataUseRegMap, orgId);
                if (subOrgHaveNoCancel.size() > 0) {
                    message = String.format(ResManager.loadKDString((String)"%1$s%2$s\uff1a\u53d6\u6d88\u5206\u914d\u5931\u8d25\uff0c\u8bf7\u5148\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u53d6\u6d88\u5206\u914d\u3002\r\n", (String)"AssignQueryPlugin_13", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), message, datas.get(dataId));
                    ++n;
                    continue;
                }
                param[0] = Long.valueOf(dataId);
                param[1] = orgId;
                params.add(param);
                List<Long> isNotCuOrgIds = this.getIsNotCuOrgIds(Long.valueOf(dataId), directSubOrgIds, isNotCuDataUseRegMap);
                for (Long isNotCuOrgId : isNotCuOrgIds) {
                    if (dataOrgs.contains(isNotCuOrgId)) continue;
                    param = new Object[]{Long.valueOf(dataId), isNotCuOrgId};
                    params.add(param);
                }
                if (Long.valueOf(dataId).equals(masterId) || CollectionUtils.isEmpty(tempParams = this.getUseRegByMasterId(orgId, masterId, masteridMap))) continue;
                params.addAll(tempParams);
            }
            break;
        }
    }

    private List<Object[]> getUseRegByMasterId(Long orgId, Long masterId, Map<Long, List<Long>> masteridMap) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        List<Long> dataIds = masteridMap.get(masterId);
        if (!CollectionUtils.isEmpty(dataIds)) {
            for (Long dataId : dataIds) {
                Object[] param = new Object[]{dataId, orgId};
                params.add(param);
            }
        }
        return params;
    }

    private void deleteUseRange(String baseDataTableName, DBRoute dbRoute, List<Object[]> params) {
        try {
            String bsaeDataUseRangeTableName = baseDataTableName + BASEDATAUSERANGESUFFIX;
            String deleteUseRangeSql = "delete from " + bsaeDataUseRangeTableName + " where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql, params);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void deleteExc(String baseDataTableName, DBRoute dbRoute, List<Object[]> params) {
        try {
            String bsaeDataExcTableName = baseDataTableName + BASEDATAEXCSUFFIX;
            String deleteExcSql = "delete from " + bsaeDataExcTableName + " where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)dbRoute, (String)deleteExcSql, params);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void deleteUseReg(String dataTableUseName, DBRoute dbRoute, List<Object[]> params) {
        try {
            String deleteUseRegSql = "delete from " + dataTableUseName + " where fdataid = ? and fuseorgid = ?";
            DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql, params);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private Map<Long, List<Long>> getIsNotCuDataUseRegMap(Map<String, Set<Long>> dataids, Map<Long, List<Long>> directSubOrgIdsMap, DBRoute dbRoute, String dataTableUseName, String dataTableName, final String createOrgId) {
        StringBuilder dataIdStr = new StringBuilder();
        final HashSet directSubOrgIds = new HashSet(16);
        for (Map.Entry<String, Set<Long>> entry : dataids.entrySet()) {
            String dataId = entry.getKey();
            dataIdStr.append(dataId).append(',');
            Set<Long> dataOrgs = entry.getValue();
            for (Long orgId : dataOrgs) {
                directSubOrgIds.addAll(directSubOrgIdsMap.get(orgId));
            }
        }
        if (directSubOrgIds.size() == 0) {
            return new HashMap<Long, List<Long>>(1);
        }
        StringBuilder orgIdStr = new StringBuilder();
        for (Long id : directSubOrgIds) {
            orgIdStr.append(id).append(',');
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" SELECT  mu.fdataid,mu.fuseorgid uoid");
        stringBuilder.append(" from  ").append(dataTableUseName).append(" mu ");
        stringBuilder.append(" INNER JOIN  ").append(dataTableName).append(" m on m.fid = mu.fdataid ");
        stringBuilder.append(" where mu.fdataid in ( ").append(dataIdStr.substring(0, dataIdStr.length() - 1));
        stringBuilder.append(" ) and mu.fuseorgid in (").append(orgIdStr.substring(0, orgIdStr.length() - 1));
        stringBuilder.append(") and mu.FisAssign = '0' ");
        Map dataUseRegMap = (Map)DB.query((DBRoute)dbRoute, (String)stringBuilder.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<Long, List<Long>>>(){

            public Map<Long, List<Long>> handle(ResultSet rs) throws SQLException {
                HashMap<Long, List<Long>> dataUseRegMap = new HashMap<Long, List<Long>>(directSubOrgIds.size());
                while (rs.next()) {
                    Long dataId = rs.getLong(1);
                    Long useOrgId = rs.getLong(2);
                    ArrayList<Long> orgIdList = (ArrayList<Long>)dataUseRegMap.get(dataId);
                    if (null == orgIdList) {
                        orgIdList = new ArrayList<Long>(16);
                    }
                    if (!createOrgId.equals(String.valueOf(useOrgId))) {
                        orgIdList.add(useOrgId);
                    }
                    dataUseRegMap.put(dataId, orgIdList);
                }
                return dataUseRegMap;
            }
        });
        return dataUseRegMap;
    }

    private List<Long> getIsNotCuOrgIds(Long dataId, List<Long> directSubOrgIds, Map<Long, List<Long>> isNotCuDataUseRegMap) {
        ArrayList<Long> isNotCuOrgIds = new ArrayList<Long>(16);
        List<Long> useOrgIds = isNotCuDataUseRegMap.get(dataId);
        if (null != useOrgIds && useOrgIds.size() > 0) {
            for (Long useOrgId : useOrgIds) {
                if (!directSubOrgIds.contains(useOrgId)) continue;
                isNotCuOrgIds.add(useOrgId);
            }
        }
        return isNotCuOrgIds;
    }

    private Map<Long, List<Long>> getDataUseRegMap(Map<String, Set<Long>> dataids, Map<Long, List<Long>> directSubOrgIdsMap, DBRoute dbRoute, String dataTableUseName, String dataTableName) {
        StringBuilder dataIdStr = new StringBuilder();
        final HashSet<Long> directSubOrgIds = new HashSet<Long>(16);
        for (Map.Entry<String, Set<Long>> entry : dataids.entrySet()) {
            String dataId = entry.getKey();
            dataIdStr.append(dataId).append(',');
            Set<Long> dataOrgs = entry.getValue();
            directSubOrgIds.addAll(dataOrgs);
            for (Long orgId : dataOrgs) {
                directSubOrgIds.addAll((Collection)directSubOrgIdsMap.get(orgId));
            }
        }
        if (directSubOrgIds.size() == 0) {
            return new HashMap<Long, List<Long>>(1);
        }
        StringBuilder orgIdStr = new StringBuilder();
        for (Long id : directSubOrgIds) {
            orgIdStr.append(id).append(',');
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" SELECT  mu.fdataid,mu.fuseorgid uoid");
        stringBuilder.append("  from ").append(dataTableUseName).append(" mu ");
        stringBuilder.append("  INNER JOIN ").append(dataTableName).append(" m on m.fid = mu.fdataid ");
        stringBuilder.append(" where mu.fdataid in ( ").append(dataIdStr.substring(0, dataIdStr.length() - 1));
        stringBuilder.append(" ) and mu.fuseorgid in (");
        stringBuilder.append(orgIdStr.substring(0, orgIdStr.length() - 1));
        stringBuilder.append(") and mu.FisAssign = '1' and mu.fctrlstrategy = '1' ");
        Map dataUseRegMap = (Map)DB.query((DBRoute)dbRoute, (String)stringBuilder.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<Long, List<Long>>>(){

            public Map<Long, List<Long>> handle(ResultSet rs) throws SQLException {
                HashMap<Long, List<Long>> dataUseRegMap = new HashMap<Long, List<Long>>(directSubOrgIds.size());
                while (rs.next()) {
                    Long dataId = rs.getLong(1);
                    Long useOrgId = rs.getLong(2);
                    ArrayList<Long> orgIdList = (ArrayList<Long>)dataUseRegMap.get(dataId);
                    if (null == orgIdList) {
                        orgIdList = new ArrayList<Long>(16);
                    }
                    orgIdList.add(useOrgId);
                    dataUseRegMap.put(dataId, orgIdList);
                }
                return dataUseRegMap;
            }
        });
        return dataUseRegMap;
    }

    private List<Long> getSubOrgHaveNoCancel(Set<Long> dataOrgs, Long dataId, Map<Long, List<Long>> directSubOrgIdsMap, Map<Long, List<Long>> dataUseRegMap, Long currentSelectOrgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        List<Long> useOrgList = dataUseRegMap.get(dataId);
        Set<Long> directAndInDirectSubOrgs = this.getDirectAndInDirectSubOrgs(directSubOrgIdsMap, currentSelectOrgId);
        if (null != useOrgList && useOrgList.size() > 0) {
            for (Long useOrgId : useOrgList) {
                if (!directAndInDirectSubOrgs.contains(useOrgId) || dataOrgs.contains(useOrgId)) continue;
                orgIds.add(useOrgId);
            }
        }
        return orgIds;
    }

    private Set<Long> getDirectAndInDirectSubOrgs(Map<Long, List<Long>> directSubOrgIdsMap, Long currentSelectOrgId) {
        HashSet<Long> directAndInDirectSubOrgs = new HashSet<Long>(directSubOrgIdsMap.size());
        List<Long> directSubOrgIds = directSubOrgIdsMap.get(currentSelectOrgId);
        directAndInDirectSubOrgs.addAll(directSubOrgIds);
        for (Long inDirectSubOrgId : directSubOrgIds) {
            List<Long> inDirectSubOrgIds = directSubOrgIdsMap.get(inDirectSubOrgId);
            if (CollectionUtils.isEmpty(inDirectSubOrgIds)) continue;
            directAndInDirectSubOrgs.addAll(this.getDirectAndInDirectSubOrgs(directSubOrgIdsMap, inDirectSubOrgId));
        }
        return directAndInDirectSubOrgs;
    }

    private Map<Long, List<Long>> getDirectSubOrgIdsMap(Map<String, Set<Long>> dataids, DynamicObject ctrlview) {
        ORM ormOV = ORM.create();
        HashMap<Long, List<Long>> directSubOrgIdsMap = new HashMap<Long, List<Long>>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (Map.Entry<String, Set<Long>> entry : dataids.entrySet()) {
            Set<Long> dataOrgs = entry.getValue();
            orgIds.addAll(dataOrgs);
            for (Long orgId : orgIds) {
                directSubOrgIdsMap.put(orgId, new ArrayList(16));
            }
        }
        QFilter f1 = new QFilter("view.id", "=", ctrlview.getPkValue());
        QFilter f2 = new QFilter(ORGPARENTID, "in", orgIds);
        DataSet ds = ormOV.queryDataSet(AssignQueryPlugin.class.getName(), ENTITYID_ORG_STRUCTURE, "org.id,parent.id", new QFilter[]{f1, f2});
        Object object = null;
        try {
            for (Row row : ds) {
                Long orgId = row.getLong(ORGID);
                Long orgParentId = row.getLong(ORGPARENTID);
                if (null == orgId || null == orgParentId) continue;
                List tempList = (List)directSubOrgIdsMap.get(orgParentId);
                tempList.add(orgId);
                directSubOrgIdsMap.put(orgParentId, tempList);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return directSubOrgIdsMap;
    }

    private void fillData(int[] col, List<Long[]> unAssignDatas, Map<String, Set<Long>> dataids, Map<String, Object> datas, Set<Long> orgs, Map<String, Object> useOrgs, EntryGrid billList) {
        IDataModel model = this.getModel();
        for (int i : col) {
            Long[] unAssignData = new Long[2];
            Object number = model.getValue(NUMBER, i);
            Object useOrg = model.getValue("useorg", i);
            Object dataid = model.getValue(DATAID, i);
            Object orgId = model.getValue(USEORGID, i);
            unAssignData[0] = (Long)dataid;
            unAssignData[1] = (Long)orgId;
            unAssignDatas.add(unAssignData);
            if (dataid == null) continue;
            if (!dataids.containsKey(dataid.toString())) {
                dataids.put(dataid.toString(), new HashSet());
                datas.put(dataid.toString(), number);
            }
            if (orgId == null) continue;
            orgs.add(Long.valueOf(orgId.toString()));
            Set<Long> dataOrgs = dataids.get(String.valueOf(dataid));
            if (null == dataOrgs) {
                dataOrgs = new HashSet<Long>();
            }
            if (dataOrgs.contains(Long.valueOf(orgId.toString()))) continue;
            dataOrgs.add(Long.valueOf(orgId.toString()));
            useOrgs.put(orgId.toString(), useOrg);
            dataids.put(dataid.toString(), dataOrgs);
        }
    }

    private List<Long[]> bizUnassignVerify(Map<String, Set<Long>> dataids, List<Long[]> unAssignDatas, String entity) {
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entity);
        List<Object> checkResult = new ArrayList<Long[]>();
        if (baseDataCtrlPlugin != null) {
            checkResult = baseDataCtrlPlugin.unAssignCheck(unAssignDatas);
            Long curDataId = 0L;
            for (int i = 0; i < checkResult.size(); ++i) {
                curDataId = ((Long[])checkResult.get(i))[0];
                if (!dataids.containsKey(curDataId.toString())) continue;
                Set<Long> dataOrgs = dataids.get(curDataId.toString());
                dataOrgs.remove(((Long[])checkResult.get(i))[1]);
            }
        }
        return checkResult;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        IDataEntityType dataEntityType = ORM.create().getDataEntityType(entityNumber);
        BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntityType;
        DynamicProperty property = basedataEntityType.getProperty("fullname");
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        String fieldName = null;
        if (null != property) {
            this.getPageCache().put(this.getView().getPageId() + ISTREETYPEBASEDATA, "1");
            fieldName = ResManager.loadKDString((String)"\u957f\u540d\u79f0", (String)"AssignQueryPlugin_7", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
        } else {
            fieldName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"AssignQueryPlugin_8", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
        }
        entryGrid.setColumnProperty(NAME, "header", (Object)new LocaleString(fieldName));
        this.reflesh();
    }

    private void reflesh() {
        DynamicObject ctrlview;
        BasedataEntityType basedataEntityType;
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        if (BaseDataCommonService.isNewModel((String)entity)) {
            this.assignQueryInNewModel();
            return;
        }
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
        String dataTableName = ORM.create().getDataEntityType(entity).getAlias();
        String dataTableUseName = dataTableName + BASEDATAUSEREGSUFFIX;
        String useOrgId = this.getView().getFormShowParameter().getCustomParam("useOrgId").toString();
        final DynamicObject data = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)entity, (String)("id, org, createorg," + masteridPropName + ",ctrlstrategy"));
        boolean isMaterialInfo = false;
        IDataEntityType dataEntityType = data.getDataEntityType();
        if (dataEntityType instanceof BasedataEntityType && 2 == (basedataEntityType = (BasedataEntityType)dataEntityType).getMasteridType()) {
            isMaterialInfo = true;
        }
        if (null == (ctrlview = BaseDataServiceHelper.getCtrlview((String)entity))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u672a\u914d\u7f6e\u7ec4\u7ec7\u89c6\u56fe", (String)"AssignQueryPlugin_14", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Long viewId = Long.valueOf(ctrlview.getPkValue().toString());
        ArrayList<Long> paramList = new ArrayList<Long>(1);
        paramList.add(Long.valueOf(useOrgId));
        List assignOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, paramList, (boolean)true);
        ArrayList cuAssignParmList = new ArrayList(ids.size());
        StringBuilder assignOrgSbd = new StringBuilder();
        for (Object id : assignOrgIds) {
            assignOrgSbd.append('?').append(',');
            cuAssignParmList.add(id);
        }
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        SqlBuilder sqlsbd = new SqlBuilder();
        sqlsbd.append("SELECT top ", new Object[0]).append("10000", new Object[0]);
        sqlsbd.append(" mu.fdataid fdataid, mu.fcreateorgid coid, mu.fuseorgid uoid, mu.fadminorgid aoid ", new Object[0]);
        sqlsbd.append(" from ", new Object[0]).append(dataTableUseName, new Object[0]).append(" mu ", new Object[0]);
        sqlsbd.append(" where ", new Object[0]);
        sqlsbd.appendIn("mu.fdataid", ids);
        String ctrlstategy = data.getString("ctrlstrategy");
        if ("2".equals(ctrlstategy)) {
            sqlsbd.append(" and mu.fassignorgid = ", new Object[0]);
            sqlsbd.append(useOrgId, new Object[0]);
        } else {
            sqlsbd.appendIn(" and mu.fassignorgid", cuAssignParmList);
            sqlsbd.appendIn(" and mu.fuseorgid", cuAssignParmList);
        }
        sqlsbd.append(" and mu.fisassign ='1'", new Object[0]);
        String dbRouteKey = ORM.create().getDataEntityType(entity).getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        final HashSet oidSet = new HashSet();
        List result = (List)DB.query((DBRoute)dbRoute, (SqlBuilder)sqlsbd, (ResultSetHandler)new ResultSetHandler<List<Map<String, String>>>(){

            public List<Map<String, String>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(10);
                Long createOrg = 0L;
                if (data.get(AssignQueryPlugin.CREATEORG) instanceof DynamicObject) {
                    DynamicObject createorg = data.getDynamicObject(AssignQueryPlugin.CREATEORG);
                    createOrg = (Long)createorg.getPkValue();
                } else if (data.get(AssignQueryPlugin.CREATEORG) instanceof Long) {
                    createOrg = (Long)data.get(AssignQueryPlugin.CREATEORG);
                }
                while (rs.next()) {
                    if (rs.getLong("uoid") == createOrg.longValue()) continue;
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    oidSet.add(rs.getString("coid"));
                    oidSet.add(rs.getString("aoid"));
                    oidSet.add(rs.getString("uoid"));
                    map.put("createorgid", rs.getString("coid"));
                    map.put("adminorgid", rs.getString("aoid"));
                    map.put(AssignQueryPlugin.USEORGID, rs.getString("uoid"));
                    map.put(AssignQueryPlugin.DATAID, rs.getString("fdataid"));
                    list.add(map);
                }
                return list;
            }
        });
        String selectProperties = null;
        selectProperties = this.isTreeTypeData() ? "id,number,fullname" : "id,number,name";
        ArrayList<Long> dataIds = new ArrayList<Long>(10000);
        for (Map map : result) {
            dataIds.add(Long.valueOf((String)map.get(DATAID)));
        }
        QFilter filter = new QFilter("id", "in", dataIds);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)entity, (String)selectProperties, (QFilter[])filters, (String)"number asc");
        HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(10000);
        HashSet<Object> materialInfoIdSet = new HashSet<Object>(datas.length);
        HashMap<Object, String> idMapper = new HashMap<Object, String>();
        HashMap<Object, String> numberMap = new HashMap<Object, String>(16);
        for (DynamicObject obj : datas) {
            String dataid = obj.get("id").toString();
            dataMap.put(dataid, obj);
            if (!isMaterialInfo) continue;
            String number = "";
            String masterid = "";
            if (null != obj.get(MASTERID)) {
                number = ((DynamicObject)obj.get(MASTERID)).getString(NUMBER);
                masterid = ((DynamicObject)obj.get(MASTERID)).getPkValue().toString();
            }
            numberMap.put(dataid, number);
            idMapper.put(dataid, masterid);
            materialInfoIdSet.add(masterid);
        }
        Map<String, String> nameMap = null;
        if (isMaterialInfo) {
            nameMap = BaseDataCommonServiceHelper.getMaterialInfoNameNumber(dataTableName, materialInfoIdSet, data);
        }
        Map orgNameMap = new HashMap(16);
        Map orgNameCNMap = new HashMap(16);
        if (oidSet.size() > 0) {
            StringBuilder orgIdsSet = new StringBuilder();
            for (String orgid : oidSet) {
                if (orgIdsSet.length() > 0) {
                    orgIdsSet.append(',');
                }
                orgIdsSet.append(orgid);
            }
            String orgNameSql = "select fid, fname from t_org_org_l where flocaleid = '" + lang + "' and fid in (" + orgIdsSet + ")";
            orgNameMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)orgNameSql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    String orgId = null;
                    String orgName = null;
                    while (rs.next()) {
                        orgId = rs.getString("fid");
                        orgName = rs.getString("fname");
                        map.put(orgId, orgName);
                    }
                    return map;
                }
            });
            if (lang.equals("en_US")) {
                orgNameSql = "select fid, fname from t_org_org_l where flocaleid = 'zh_CN' and fid in (" + orgIdsSet + ")";
                orgNameCNMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)orgNameSql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                    public Map<String, String> handle(ResultSet rs) throws SQLException {
                        HashMap<String, String> map = new HashMap<String, String>(16);
                        String orgId = null;
                        String orgName = null;
                        while (rs.next()) {
                            orgId = rs.getString("fid");
                            orgName = rs.getString("fname");
                            map.put(orgId, orgName);
                        }
                        return map;
                    }
                });
            }
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            model.batchCreateNewEntryRow(ENTRYENTITY, result.size());
            DynamicObjectCollection doc = model.getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < result.size(); ++i) {
                Map map = (Map)result.get(i);
                String dataid = (String)map.get(DATAID);
                Object name = null;
                Object number = null;
                if (isMaterialInfo) {
                    name = nameMap.get(idMapper.get(dataid));
                    number = numberMap.get(dataid);
                } else {
                    name = this.isTreeTypeData() ? ((DynamicObject)dataMap.get(dataid)).get("fullname") : ((DynamicObject)dataMap.get(dataid)).get(NAME);
                    number = ((DynamicObject)dataMap.get(dataid)).get(NUMBER);
                }
                ((DynamicObject)doc.get(i)).set(NAME, name);
                ((DynamicObject)doc.get(i)).set(NUMBER, number);
                String adminOrgName = null == orgNameMap.get(map.get("adminorgid")) ? (String)orgNameCNMap.get(map.get("adminorgid")) : (String)orgNameMap.get(map.get("adminorgid"));
                String useOrgName = null == orgNameMap.get(map.get(USEORGID)) ? (String)orgNameCNMap.get(map.get(USEORGID)) : (String)orgNameMap.get(map.get(USEORGID));
                String createOrgName = null == orgNameMap.get(map.get("createorgid")) ? (String)orgNameCNMap.get(map.get("createorgid")) : (String)orgNameMap.get(map.get("createorgid"));
                String useorgid = (String)map.get(USEORGID);
                ((DynamicObject)doc.get(i)).set(CREATEORG, (Object)createOrgName);
                ((DynamicObject)doc.get(i)).set("adminorg", (Object)adminOrgName);
                ((DynamicObject)doc.get(i)).set("useorg", (Object)useOrgName);
                ((DynamicObject)doc.get(i)).set(USEORGID, (Object)useorgid);
                ((DynamicObject)doc.get(i)).set(DATAID, (Object)dataid);
            }
            this.getModel().updateEntryCache(doc);
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private boolean isTreeTypeData() {
        String isTreetypeBaseData = this.getPageCache().get(this.getView().getPageId() + ISTREETYPEBASEDATA);
        return "1".equals(isTreetypeBaseData);
    }

    private void assignQueryInNewModel() {
        Object useOrgId = this.getView().getFormShowParameter().getCustomParam("useOrgId");
        Object ctrlStrategy = this.getView().getFormShowParameter().getCustomParam("ctrlstrategy");
        if (null == useOrgId || null == ctrlStrategy) {
            return;
        }
        try {
            List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
            String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
            AssignQueryService queryService = new AssignQueryService();
            Map bitmap = queryService.assignQueryByData(entity, ctrlStrategy.toString(), ids, Long.valueOf(useOrgId.toString()));
            if (bitmap.isEmpty()) {
                this.getModel().deleteEntryData(ENTRYENTITY);
                return;
            }
            boolean isTreeType = this.isTreeTypeData();
            String selectProperties = isTreeType ? "id,number,fullname,createorg,org,bitindex" : "id,number,name,createorg,org,bitindex";
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
            DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)entity, (String)selectProperties, (QFilter[])filters, (String)"number asc");
            HashSet<Long> orgIds = new HashSet<Long>(bitmap.keySet());
            boolean isMaterialInfo = BaseDataCommonServiceHelper.isMaterialInfo(entity);
            Locale locale = RequestContext.get().getLang().getLocale();
            String lang = locale.getLanguage() + "_" + locale.getCountry();
            HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(16);
            HashMap<String, String> materialInfoNumber = new HashMap<String, String>(16);
            HashMap<String, String> materialInfoName = new HashMap<String, String>(16);
            for (DynamicObject baseData : dataArr) {
                String index = baseData.getString("bitindex");
                dataMap.put(index, baseData);
                orgIds.add(this.getOrgIdFromDynamicObject(CREATEORG, baseData));
                orgIds.add(this.getOrgIdFromDynamicObject("org", baseData));
                if (!isMaterialInfo) continue;
                DynamicObject mainData = baseData.getDynamicObject(MASTERID);
                String number = mainData.getString(NUMBER);
                String dataId = baseData.getString("id");
                materialInfoNumber.put(dataId, number);
                String name = mainData.getLocaleString(NAME).getLocaleValue_zh_CN();
                String enName = mainData.getLocaleString(NAME).getLocaleValue_en();
                if ("en_US".equals(lang) && StringUtils.isNotBlank((CharSequence)enName)) {
                    materialInfoName.put(dataId, enName);
                    continue;
                }
                materialInfoName.put(dataId, name);
            }
            Map<String, String> orgNameMap = this.getOrgNameMap(orgIds);
            IDataModel model = this.getModel();
            model.deleteEntryData(ENTRYENTITY);
            EntryProp entryProp = (EntryProp)model.getDataEntityType().getProperty(ENTRYENTITY);
            EntryType entryType = (EntryType)entryProp.getItemType();
            DynamicObjectCollection doc = model.getEntryEntity(ENTRYENTITY);
            for (Map.Entry entry : bitmap.entrySet()) {
                int[] indexes;
                Long orgId = (Long)entry.getKey();
                for (int index : indexes = ((RoaringBitmap)entry.getValue()).toArray()) {
                    DynamicObject baseData = (DynamicObject)dataMap.get(String.valueOf(index));
                    if (null == baseData) continue;
                    String dataId = baseData.getString("id");
                    DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entryType);
                    if (isMaterialInfo) {
                        dynamicObject.set(NAME, materialInfoName.get(dataId));
                        dynamicObject.set(NUMBER, materialInfoNumber.get(dataId));
                    } else {
                        if (isTreeType) {
                            dynamicObject.set(NAME, baseData.get("fullname"));
                        } else {
                            dynamicObject.set(NAME, baseData.get(NAME));
                        }
                        dynamicObject.set(NUMBER, baseData.get(NUMBER));
                    }
                    dynamicObject.set(DATAID, (Object)dataId);
                    dynamicObject.set(USEORGID, (Object)orgId);
                    long createOrgId = this.getOrgIdFromDynamicObject(CREATEORG, baseData);
                    dynamicObject.set(CREATEORG, (Object)orgNameMap.get(Long.toString(createOrgId)));
                    long adminOrgId = this.getOrgIdFromDynamicObject("org", baseData);
                    dynamicObject.set("adminorg", (Object)orgNameMap.get(Long.toString(adminOrgId)));
                    dynamicObject.set("useorg", (Object)orgNameMap.get(orgId.toString()));
                    doc.add((Object)dynamicObject);
                }
                if (doc.size() <= 15000) continue;
                break;
            }
            this.getModel().updateEntryCache(doc);
            this.getView().updateView(ENTRYENTITY);
        }
        catch (Exception e) {
            log.error("\u6309\u6570\u636e\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
        }
    }

    private Long getOrgIdFromDynamicObject(String property, DynamicObject data) {
        Object object = data.get(property);
        if (object instanceof DynamicObject) {
            return (Long)((DynamicObject)object).getPkValue();
        }
        return Long.valueOf(object.toString());
    }

    private Map<String, String> getOrgNameMap(Set<Long> orgIds) {
        int i = 0;
        ArrayList<String> placeholders = new ArrayList<String>(orgIds.size());
        Object[] params = new Object[orgIds.size()];
        for (Long orgId : orgIds) {
            params[i] = orgId;
            placeholders.add("?");
            ++i;
        }
        String idCondition = String.join((CharSequence)String.valueOf(','), placeholders);
        Locale locale = RequestContext.get().getLang().getLocale();
        String lang = locale.getLanguage() + "_" + locale.getCountry();
        Map<String, String> orgName = this.getDataName("t_org_org_l", lang, idCondition, params);
        if ("en_US".equals(lang)) {
            Map<String, String> cnName = this.getDataName("t_org_org_l", "zh_CN", idCondition, params);
            for (Map.Entry<String, String> entry : cnName.entrySet()) {
                String orgId = entry.getKey();
                if (orgName.containsKey(orgId)) continue;
                orgName.put(orgId, entry.getValue());
            }
        }
        return orgName;
    }

    private Map<String, String> getDataName(String table, String lang, String idCondition, Object[] params) {
        String sql = String.format("select fid, fname from %s where flocaleid = '%s' and fid in (%s)", table, lang, idCondition);
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            while (rs.next()) {
                String id = rs.getString("fid");
                String name = rs.getString("fname");
                map.put(id, name);
            }
            return map;
        });
    }

    private void cancelAssignOnNewModel(String entity) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        if (null == ctrlView) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u672a\u914d\u7f6e\u7ec4\u7ec7\u89c6\u56fe", (String)"AssignQueryPlugin_14", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        BaseDataCancelAssignValidator validator = new BaseDataCancelAssignValidator(this.getView(), entity);
        try {
            boolean validate = validator.validate(entity);
            if (!validate) {
                return;
            }
            Map cancelData = validator.getCancelData();
            BaseDataAssignService service = new BaseDataAssignService(entity);
            Object useOrgId = this.getView().getFormShowParameter().getCustomParam("useOrgId");
            service.setOpOrgId(Long.valueOf(useOrgId.toString()));
            service.setAppId(this.getView().getFormShowParameter().getAppId());
            service.cancelAssign(cancelData);
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u5206\u914d\u662f\u5931\u8d25", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"AssignQueryPlugin_15", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.reflesh();
        Map dataNumberMap = validator.getDataNumberMap();
        Map customData = validator.getCustomData();
        if (!CollectionUtils.isEmpty((Map)customData)) {
            this.showCustomTipNotification(validator, dataNumberMap, customData);
            return;
        }
        Map assignData = validator.getAssignData();
        List checkResult = validator.getBusinessCheckResult();
        if (CollectionUtils.isEmpty((Map)assignData)) {
            if (CollectionUtils.isEmpty((Collection)checkResult)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AssignQueryPlugin_4", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u7b49%2$s\u6761\u6570\u636e\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"AssignQueryPlugin_3", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), dataNumberMap.get(((Long[])checkResult.get(0))[0]), checkResult.size()));
            }
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)checkResult)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u7b49%2$s\u6761\u6570\u636e\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"AssignQueryPlugin_3", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), dataNumberMap.get(((Long[])checkResult.get(0))[0]), checkResult.size()));
            return;
        }
        StringJoiner joiner = new StringJoiner("");
        int failCount = 0;
        for (Map.Entry entry : assignData.entrySet()) {
            Long dataId = (Long)entry.getKey();
            Set orgIds = (Set)entry.getValue();
            failCount += orgIds.size();
            joiner.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53d6\u6d88\u5206\u914d\u5931\u8d25\uff0c\u8bf7\u5148\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u53d6\u6d88\u5206\u914d\u3002\r\n", (String)"AssignQueryPlugin_9", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), dataNumberMap.get(dataId)));
        }
        this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u53d6\u6d88\u5206\u914d\u5931\u8d25\u6570\u636e\u3002", (String)"AssignQueryPlugin_5", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), failCount), joiner.toString(), MessageTypes.Default);
    }

    private void showCustomTipNotification(BaseDataCancelAssignValidator validator, Map<Long, String> dataNumberMap, Map<Long, Set<Long>> customData) {
        StringJoiner joiner = new StringJoiner("");
        for (Map.Entry<Long, Set<Long>> entry : customData.entrySet()) {
            String personalDataNum = dataNumberMap.get(entry.getKey());
            Set<Long> values = entry.getValue();
            for (Long value : values) {
                String personalDataOrg = (String)validator.getOrgNameMap().get(value);
                String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5728\u7ec4\u7ec7\u201c%2$s\u201d\u6216\u8005\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u4e2d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u8bf7\u5148\u5220\u9664\u4e2a\u6027\u5316\u6570\u636e\u518d\u53d6\u6d88\u5206\u914d\u3002\r\n", (String)"AssignQueryPlugin_11", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), personalDataNum, personalDataOrg);
                joiner.add(msg);
            }
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e", (String)"AssignQueryPlugin_12", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), joiner.toString(), MessageTypes.Default);
    }
}

