/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bd.ctsy.utils.CtsyDBUtils;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.AssignQueryService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.basedata.CancelAssignResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.bdctrl.helper.BaseDataAssignServiceHelper;
import kd.bos.form.plugin.bdctrl.helper.BaseDataCommonServiceHelper;
import kd.bos.form.plugin.bdctrl.validator.BaseDataCancelAssignPreValidator;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AssignQueryPluginNew
extends AbstractListPlugin
implements TreeNodeQueryListener,
SearchEnterListener,
EntryGridBindDataListener,
TreeNodeCheckListener {
    public static final String TREEVIEW = "treeviewap";
    public static final String BASEDATAUSEREGSUFFIX = "UseReg";
    public static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    public static final String BASEDATAEXCSUFFIX = "Exc";
    public static final String BASEDATAUSERANGESUFFIX = "_U";
    private static final String ASIGNEDDATAS = "asignedDatas";
    private static final String ASIGNEDORGS = "asignedOrgs";
    private static final String CURRENTQUERYRES = "currentQueryResult";
    private static final String ORGNAME = "orgname";
    private static final String NAME = "name";
    private static final String KEY_FULL_NAME = "fullname";
    private static final String ISTREETYPEBASEDATA = "isTreeTypeBaseData";
    public static final String UNASSIGN_PERM = "80513209000000ac";
    public static final String ENTITY_NUMBER = "entityNumber";
    public static final String FILEDLIST = "filedList";
    public static final String SEARCHFILED = "searchfiled";
    public static final String BOS_BD_FORMPLUGIN = "bos-bd-formplugin";
    public static final String ENTRYENTITY = "entryentity";
    public static final String NUMBER = "number";
    public static final String DATAID = "dataid";
    public static final String USEORGID = "useorgid";
    public static final String MASTERID = "masterid";
    public static final String ORGID = "org.id";
    public static final String INNER_JOIN = " INNER JOIN ";
    private static final Log log = LogFactory.getLog(AssignQueryPluginNew.class);
    private static final String ALLORGLIST_KEY = "allOrgListKey";

    public void initialize() {
        super.initialize();
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.addClickListeners(new String[]{"btn_query", "btn_assign_cancel"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        EntryGrid billList = (EntryGrid)this.getControl(ENTRYENTITY);
        billList.addDataBindListener((EntryGridBindDataListener)this);
        tvLeft.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    private List<TreeNode> getAllOrg(DynamicObject ctrlView) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(String.valueOf(ctrlView.get(NUMBER)));
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        param.setIncludeDisable(true);
        param.setIncludeFreeze(true);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        List allChildOrgNodeList = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        if (null == rootNode) {
            return Collections.emptyList();
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid from t_org_structure where fisctrlunit = '1' and fviewid = ?;", new Object[]{ctrlView.getPkValue()});
        Set allCtrlUintOrgIds = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, rs -> {
            HashSet<String> result = new HashSet<String>(16);
            while (rs.next()) {
                result.add(rs.getString("forgid"));
            }
            return result;
        });
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        ArrayList<TreeNode> rootNodeChildList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        if (allCtrlUintOrgIds.contains(rootNode.getId())) {
            rootNode.setChildren(rootNodeChildList);
            nodeList.add(rootNode);
        }
        if (CollectionUtils.isEmpty((Collection)allChildOrgNodeList)) {
            return nodeList;
        }
        ArrayList<TreeNode> cuOrgChildNodeList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        for (TreeNode node : allChildOrgNodeList) {
            if (!allCtrlUintOrgIds.contains(node.getId())) continue;
            List children = node.getChildren();
            if (!CollectionUtils.isEmpty((Collection)children)) {
                ArrayList<TreeNode> tempChildOrgList = new ArrayList<TreeNode>(children.size());
                for (TreeNode childrenNode : children) {
                    if (!allCtrlUintOrgIds.contains(childrenNode.getId())) continue;
                    tempChildOrgList.add(childrenNode);
                }
                if (tempChildOrgList.size() > 0) {
                    node.setChildren(tempChildOrgList);
                } else {
                    node.setChildren(null);
                }
            }
            if (node.getParentid().equals(rootNode.getId())) {
                rootNodeChildList.add(node);
            }
            nodeList.add(node);
            cuOrgChildNodeList.add(node);
        }
        this.getChildNode(cuOrgChildNodeList, nodeList, allCtrlUintOrgIds);
        return nodeList;
    }

    private void getChildNode(List<TreeNode> orgChildrenTreeData, List<TreeNode> allOrgs, Set<String> allCtrlUintOrgIds) {
        for (TreeNode node : orgChildrenTreeData) {
            List childNodes = node.getChildren();
            if (CollectionUtils.isEmpty((Collection)childNodes)) continue;
            ArrayList<TreeNode> tempChildOrgs = new ArrayList<TreeNode>(childNodes.size());
            for (TreeNode childrenNode : childNodes) {
                if (!allCtrlUintOrgIds.contains(childrenNode.getId())) continue;
                allOrgs.add(childrenNode);
                tempChildOrgs.add(childrenNode);
            }
            if (tempChildOrgs.size() > 0) {
                node.setChildren(tempChildOrgs);
            } else {
                node.setChildren(null);
            }
            this.getChildNode(childNodes, allOrgs, allCtrlUintOrgIds);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btn_query")) {
            String filedlistStr = this.getPageCache().get(FILEDLIST);
            String filedValueStr = this.getPageCache().get(SEARCHFILED);
            ArrayList<String> filedList = null;
            ArrayList<String> filedValueList = null;
            filedList = StringUtils.isNotBlank((CharSequence)filedlistStr) ? (ArrayList<String>)SerializationUtils.fromJsonString((String)filedlistStr, List.class) : new ArrayList<String>(1);
            filedValueList = StringUtils.isNotBlank((CharSequence)filedValueStr) ? (ArrayList<String>)SerializationUtils.fromJsonString((String)filedValueStr, List.class) : new ArrayList<String>(1);
            this.refresh(filedList, filedValueList);
        } else if (control.getKey().equals("btn_assign_cancel")) {
            String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
            if (CtsyDBUtils.ctsyBaseDataUseOnly((String)entity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u542f\u4e86\u8de8\u79df\u6237\u4e3b\u6570\u636e\u57df\u7ba1\u63a7\uff0c\u5f53\u524d\u64cd\u4f5c\u4e0d\u652f\u6301\uff0c\u8bf7\u5230\u96c6\u56e2\u79df\u6237\u6267\u884c\u3002", (String)"AssignQueryPluginNew_19", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
            if (BaseDataCommonService.isNewModel((String)entity)) {
                this.cancelAssignOnNewModel(entity);
            } else {
                this.cancelAssign();
            }
        }
    }

    private void cancelAssign() {
        HashSet<Long> dataIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        ArrayList<String> selectedKey = new ArrayList<String>(10);
        this.fillData(dataIds, orgIds, selectedKey);
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        BaseDataCancelAssignPreValidator validate = new BaseDataCancelAssignPreValidator(this.getView(), entity, null);
        String useOrgId = this.getView().getFormShowParameter().getCustomParam("useOrgId").toString();
        if (!validate.preValidate(entity, Long.parseLong(useOrgId), dataIds, orgIds)) {
            return;
        }
        List results = BaseDataServiceHelper.cancelAssign((String)entity, dataIds, orgIds);
        boolean allFail = true;
        ArrayList<String> failedKey = new ArrayList<String>();
        for (CancelAssignResult result : results) {
            boolean isSuccess = result.isSuccess();
            if (isSuccess) {
                allFail = false;
                continue;
            }
            List failOrgIds = result.getOrgIds();
            Long failDataId = result.getDataId();
            for (Long failOrgId : failOrgIds) {
                failedKey.add(String.valueOf(failDataId) + String.valueOf(failOrgId));
            }
        }
        results.removeIf(CancelAssignResult::isSuccess);
        if (results.isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AssignQueryPluginNew_17", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            this.showCancelErrorNotice(results);
        }
        if (allFail) {
            return;
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        String currentQueryStr = this.getPageCache().get(CURRENTQUERYRES);
        Map currentQueryRes = (Map)SerializationUtils.fromJsonString((String)currentQueryStr, Map.class);
        String orgNameStr = this.getPageCache().get(ORGNAME);
        Map orgNameMap = (Map)SerializationUtils.fromJsonString((String)orgNameStr, Map.class);
        selectedKey.removeAll(failedKey);
        selectedKey.forEach(currentQueryRes::remove);
        String jsonString = SerializationUtils.toJsonString((Object)currentQueryRes);
        this.getPageCache().put(CURRENTQUERYRES, jsonString);
        Map<String, String[]> nameNumberMap = this.getBdNameNumberMap(entity, currentQueryRes);
        this.makeBillList(currentQueryRes, orgNameMap, nameNumberMap, null, null);
    }

    private void showCancelErrorNotice(List<CancelAssignResult> results) {
        if (results.size() == 1) {
            this.getView().showErrorNotification(results.get(0).getErrorMsg());
        } else {
            StringBuilder errorMsgSbd = new StringBuilder();
            results.forEach(result -> errorMsgSbd.append(result.getErrorMsg()).append("\r\n"));
            this.getView().showMessage(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"AssignQueryPluginNew_16", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), errorMsgSbd.toString(), MessageTypes.Default);
        }
    }

    private void fillData(Set<Long> dataIds, Set<Long> orgIds, List<String> selectedKey) {
        int[] col;
        EntryGrid billList = (EntryGrid)this.getControl(ENTRYENTITY);
        DynamicObject[] objs = billList.getEntryData().getDataEntitys();
        for (int i : col = billList.getSelectRows()) {
            Object dataid = objs[i].get(DATAID);
            Object orgId = objs[i].get(USEORGID);
            selectedKey.add(dataid + String.valueOf(orgId));
            if (dataid != null) {
                dataIds.add(Long.valueOf(dataid.toString()));
            }
            if (orgId == null) continue;
            orgIds.add(Long.valueOf(orgId.toString()));
        }
    }

    public void afterCreateNewData(EventObject e) {
        String fieldName;
        HashMap<String, Boolean> treeParams = new HashMap<String, Boolean>();
        treeParams.put("cpn", Boolean.FALSE);
        this.getView().updateControlMetadata(TREEVIEW, treeParams);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        if (null == ctrlView) {
            return;
        }
        List<TreeNode> orgList = this.getAllOrg(ctrlView);
        if (!CollectionUtils.isEmpty(orgList)) {
            this.getView().getPageCache().putBigObject(ALLORGLIST_KEY, SerializationUtils.toJsonString(orgList));
        }
        IDataEntityType dataEntityType = ORM.create().getDataEntityType(entityNumber);
        BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntityType;
        DynamicProperty property = basedataEntityType.getProperty(KEY_FULL_NAME);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (null != property) {
            this.getPageCache().put(this.getView().getPageId() + ISTREETYPEBASEDATA, "1");
            fieldName = ResManager.loadKDString((String)"\u957f\u540d\u79f0", (String)"AssignQueryPluginNew_10", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
        } else {
            fieldName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"AssignQueryPluginNew_11", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
        }
        entryGrid.setColumnProperty(NAME, "header", (Object)new LocaleString(fieldName));
        this.initCUAssignTree((Long)ctrlView.getPkValue());
        String asignDatasStr = (String)this.getView().getFormShowParameter().getCustomParam(ASIGNEDDATAS);
        String useOrgIdsStrs = (String)this.getView().getFormShowParameter().getCustomParam(ASIGNEDORGS);
        if (StringUtils.isNotEmpty((CharSequence)asignDatasStr) && StringUtils.isNotEmpty((CharSequence)useOrgIdsStrs)) {
            List asignDataIds = (List)SerializationUtils.fromJsonString((String)asignDatasStr, List.class);
            HashSet<Long> useOrgIds = new HashSet<Long>(SerializationUtils.fromJsonStringToList((String)useOrgIdsStrs, Long.class));
            this.queryBillListByMerialIds(asignDataIds, useOrgIds);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        String allOrgStr = this.getView().getPageCache().getBigObject(ALLORGLIST_KEY);
        if (null == allOrgStr) {
            return;
        }
        String currentNodeId = treeNodeEvent.getNodeId().toString();
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        List allNodeList = SerializationUtils.fromJsonStringToList((String)allOrgStr, TreeNode.class);
        for (TreeNode node : allNodeList) {
            String nodeId = node.getId();
            if (!currentNodeId.equals(nodeId)) continue;
            tvLeft.addNodes(node.getChildren());
            break;
        }
    }

    private void initCUAssignTree(Long orgViewId) {
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.deleteAllNodes();
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(orgViewId.longValue());
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (rootNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u5355\u5143\u6839\u7ec4\u7ec7\u5931\u8d25", (String)"AssignQueryPluginNew_12", (String)"bos-org-formplugin", (Object[])new Object[0]));
        }
        tvLeft.addNode(rootNode);
        tvLeft.queryTreeNodeChildren("", rootNode.getId());
    }

    private void refresh(List<String> filedList, List<String> filedValueList) {
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        if (BaseDataCommonService.isNewModel((String)entity)) {
            try {
                String filedValue = CollectionUtils.isEmpty(filedValueList) ? null : filedValueList.get(0);
                this.refreshOnNewModel(filedList, filedValue);
            }
            catch (Exception e) {
                log.error("\u6309\u7ec4\u7ec7\u4f4d\u56fe\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            }
            return;
        }
        SqlBuilder sqlBuilder = this.makeSQLBySearchText(entity);
        HashSet<Long> oidSet = new HashSet<Long>();
        Map<String, Map<String, String>> result = this.queryDB(sqlBuilder, entity, oidSet);
        Map<String, String[]> nameNumberMap = this.getBdNameNumberMap(entity, result);
        Map<String, String> orgNameMap = this.getOrgNameByOrgId(oidSet);
        this.makeBillList(result, orgNameMap, nameNumberMap, filedList, filedValueList);
    }

    private Map<String, String[]> getBdNameNumberMap(String entity, Map<String, Map<String, String>> result) {
        BasedataEntityType basedataEntityType;
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        HashMap<String, String[]> nameNumberMap = new HashMap<String, String[]>(16);
        Set<String> dataIdUseOrgs = result.keySet();
        if (CollectionUtils.isEmpty(dataIdUseOrgs)) {
            return nameNumberMap;
        }
        ArrayList<Long> dataIds = new ArrayList<Long>(10000);
        for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
            Map<String, String> map = entry.getValue();
            dataIds.add(Long.valueOf(map.get(DATAID)));
        }
        boolean isMaterialInfo = false;
        DynamicObject data = BusinessDataServiceHelper.loadSingle(dataIds.get(0), (String)entity, (String)"id, org, createorg,masterid");
        IDataEntityType dataEntityType = data.getDataEntityType();
        String dataTableName = dataEntityType.getAlias();
        if (dataEntityType instanceof BasedataEntityType && 2 == (basedataEntityType = (BasedataEntityType)dataEntityType).getMasteridType()) {
            isMaterialInfo = true;
        }
        boolean isTreeType = BaseDataCommonService.isTreeType((String)entity);
        String selectProperties = null;
        selectProperties = isTreeType ? "id,number,fullname" : (isMaterialInfo ? "id,number,masterid," + masteridPropName : "id,number,name");
        QFilter filter = new QFilter("id", "in", dataIds);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)entity, (String)selectProperties, (QFilter[])filters, (String)"number asc");
        HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(10000);
        HashSet<Object> materialInfoIdSet = new HashSet<Object>(datas.length);
        HashMap<String, String> idMapper = new HashMap<String, String>();
        HashMap<String, String> numberMap = new HashMap<String, String>(16);
        for (DynamicObject obj : datas) {
            DynamicObject materialInfo;
            Object material;
            String dataid = obj.get("id").toString();
            dataMap.put(dataid, obj);
            if (!isMaterialInfo || null == (material = obj.get(MASTERID))) continue;
            String number = "";
            if (material instanceof DynamicObject) {
                number = ((DynamicObject)material).getString(NUMBER);
            } else if (material instanceof Long && (materialInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)material, (String)"bd_material")) != null) {
                number = materialInfo.getString(NUMBER);
            }
            numberMap.put(dataid, number);
            String materialId = String.valueOf(((DynamicObject)material).getPkValue());
            idMapper.put(dataid, materialId);
            materialInfoIdSet.add(materialId);
        }
        Map<String, String> nameMap = null;
        if (isMaterialInfo) {
            nameMap = BaseDataCommonServiceHelper.getMaterialInfoNameNumber(dataTableName, materialInfoIdSet, data);
        }
        for (Long id : dataIds) {
            String dataId = id.toString();
            Object name = "";
            Object number = "";
            if (isMaterialInfo) {
                name = nameMap.get(idMapper.get(dataId));
                number = numberMap.get(dataId);
            } else {
                DynamicObject obj = (DynamicObject)dataMap.get(dataId);
                if (null != obj) {
                    name = isTreeType ? obj.get(KEY_FULL_NAME) : obj.get(NAME);
                    number = obj.get(NUMBER);
                }
            }
            if (number == null) {
                number = "";
            }
            if (null == name) {
                name = "";
            }
            nameNumberMap.put(dataId, new String[]{name.toString(), (String)number});
        }
        return nameNumberMap;
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        List searchFields = searchEnterEvent.getSearchFields();
        if (searchFields == null) {
            this.getPageCache().put(FILEDLIST, null);
            this.getPageCache().put(SEARCHFILED, null);
            ArrayList<String> filedList = new ArrayList<String>(1);
            ArrayList<String> filedValueList = new ArrayList<String>(1);
            this.refresh(filedList, filedValueList);
        } else {
            List filedList = (List)((Map)searchFields.get(0)).get("fieldName");
            List text = (List)((Map)searchFields.get(0)).get("value");
            String filelistStr = SerializationUtils.toJsonString((Object)filedList);
            String textStr = SerializationUtils.toJsonString((Object)text);
            this.getPageCache().put(FILEDLIST, filelistStr);
            this.getPageCache().put(SEARCHFILED, textStr);
            this.refresh(filedList, text);
        }
    }

    private SqlBuilder makeSQLBySearchText(String entity) {
        IDataEntityType dataEntityType = ORM.create().getDataEntityType(entity);
        String dataTableName = dataEntityType.getAlias();
        String useOrgId = this.getView().getFormShowParameter().getCustomParam("useOrgId").toString();
        String dataTableUseName = dataTableName + BASEDATAUSEREGSUFFIX;
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        List orgIDs = treeView.getTreeState().getCheckedNodeIds();
        ArrayList<Long> params = new ArrayList<Long>(orgIDs.size());
        for (String id : orgIDs) {
            params.add(Long.valueOf(id));
        }
        if (orgIDs.isEmpty()) {
            params.add(0L);
        }
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("select  mu.fdataid fdataid, mu.fcreateorgid coid, mu.fuseorgid uoid, mu.fadminorgid aoid  ", new Object[0]);
        sbd.append("   from ", new Object[0]).append(dataTableUseName, new Object[0]).append(" mu where ", new Object[0]);
        sbd.appendIn("mu.fuseorgid", params);
        sbd.append(" and mu.fassignorgid = ", new Object[0]).append(useOrgId, new Object[0]);
        return sbd;
    }

    private Map<String, Map<String, String>> queryDB(SqlBuilder sql, String entity, final Set<Long> oidSet) {
        String dbRouteKey = ORM.create().getDataEntityType(entity).getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        Map result = null;
        try {
            result = (Map)DB.query((DBRoute)dbRoute, (SqlBuilder)sql, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, String>>>(){

                public Map<String, Map<String, String>> handle(ResultSet rs) throws SQLException {
                    HashMap<String, Map<String, String>> dataMap = new HashMap<String, Map<String, String>>(16);
                    while (rs.next()) {
                        if (dataMap.size() > 100000) {
                            log.warn("\u5206\u914d\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u8fc7\u5927\uff0c\u8bf7\u51cf\u5c11\u67e5\u8be2\u7ec4\u7ec7\u7684\u6570\u91cf\uff0c\u6216\u8005\u4f7f\u7528\u5206\u914d\u67e5\u8be2\u6309\u6570\u636e");
                            throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5206\u914d\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u8fc7\u5927\uff0c\u8bf7\u51cf\u5c11\u67e5\u8be2\u7ec4\u7ec7\u7684\u6570\u91cf\uff0c\u6216\u8005\u4f7f\u7528\u5206\u914d\u67e5\u8be2\u6309\u6570\u636e\u3002", (String)"AssignQueryPluginNew_18", (String)AssignQueryPluginNew.BOS_BD_FORMPLUGIN, (Object[])new Object[0])), new Object[0]);
                        }
                        HashMap<String, String> map = new HashMap<String, String>(16);
                        Long useOrgId = rs.getLong("uoid");
                        Long createOrgId = rs.getLong("coid");
                        Long adminOrgId = rs.getLong("aoid");
                        String dataId = rs.getString("fdataid");
                        if (useOrgId.equals(createOrgId)) continue;
                        oidSet.add(createOrgId);
                        oidSet.add(adminOrgId);
                        oidSet.add(useOrgId);
                        map.put("createorgid", String.valueOf(createOrgId));
                        map.put("adminorgid", String.valueOf(adminOrgId));
                        map.put(AssignQueryPluginNew.USEORGID, String.valueOf(useOrgId));
                        map.put(AssignQueryPluginNew.DATAID, dataId);
                        dataMap.put(dataId + useOrgId, map);
                    }
                    return dataMap;
                }
            });
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u914d\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u8fc7\u5927\uff0c\u8bf7\u51cf\u5c11\u67e5\u8be2\u7ec4\u7ec7\u7684\u6570\u91cf\uff0c\u6216\u8005\u4f7f\u7528\u5206\u914d\u67e5\u8be2\u6309\u6570\u636e\u3002", (String)"AssignQueryPluginNew_18", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            return new HashMap<String, Map<String, String>>();
        }
        String jsonString = SerializationUtils.toJsonString((Object)result);
        this.getPageCache().put(CURRENTQUERYRES, jsonString);
        return result;
    }

    private Map<String, String> getOrgNameByOrgId(Set<Long> oidSet) {
        HashMap<String, String> orgNameMap = new HashMap<String, String>(oidSet.size());
        if (!CollectionUtils.isEmpty(oidSet)) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", oidSet)};
            Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)NAME, (QFilter[])filters);
            for (Map.Entry entry : dynamicObjects.entrySet()) {
                orgNameMap.put(Objects.toString(entry.getKey(), ""), ((DynamicObject)entry.getValue()).getString(NAME));
            }
        }
        String jsonString = SerializationUtils.toJsonString(orgNameMap);
        this.getPageCache().put(ORGNAME, jsonString);
        return orgNameMap;
    }

    private void makeBillList(Map<String, Map<String, String>> result, Map<String, String> orgNameMap, Map<String, String[]> nameNumberMap, List<String> filedList, List<String> filedValueList) {
        String dataId;
        Map map2;
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        Map<Object, Object> newResult = new HashMap(result.size());
        if (result.size() > 0) {
            Iterator<Map.Entry<String, Map<String, String>>> iterator = result.entrySet().iterator();
            if (CollectionUtils.isEmpty(filedList)) {
                newResult = result;
            } else {
                ArrayList<Long> dataIds = new ArrayList<Long>(result.size());
                result.values().forEach(map -> dataIds.add(Long.valueOf((String)map.get(DATAID))));
                List<Long> matchDataIds = this.getDataIdsBySearchKey(dataIds, filedList, filedValueList);
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    map2 = (Map)entry.getValue();
                    dataId = (String)map2.get(DATAID);
                    if (!matchDataIds.contains(Long.valueOf(dataId))) continue;
                    newResult.put(entry.getKey(), map2);
                }
            }
        }
        if (newResult.size() > 0) {
            int index = 0;
            model.batchCreateNewEntryRow(ENTRYENTITY, newResult.size());
            DynamicObjectCollection doc = model.getEntryEntity(ENTRYENTITY);
            for (Map.Entry<Object, Object> entry : newResult.entrySet()) {
                map2 = (Map)entry.getValue();
                dataId = (String)map2.get(DATAID);
                String[] nameNumber = nameNumberMap.get(dataId);
                String bdName = nameNumber[0];
                String bdNumber = nameNumber[1];
                ((DynamicObject)doc.get(index)).set(NAME, (Object)bdName);
                ((DynamicObject)doc.get(index)).set(NUMBER, (Object)bdNumber);
                ((DynamicObject)doc.get(index)).set("createorg", (Object)orgNameMap.get(map2.get("createorgid")));
                ((DynamicObject)doc.get(index)).set("adminorg", (Object)orgNameMap.get(map2.get("adminorgid")));
                ((DynamicObject)doc.get(index)).set("useorg", (Object)orgNameMap.get(map2.get(USEORGID)));
                ((DynamicObject)doc.get(index)).set(USEORGID, map2.get(USEORGID));
                ((DynamicObject)doc.get(index)).set(DATAID, (Object)dataId);
                ++index;
            }
            this.getModel().updateEntryCache(doc);
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private List<Long> getDataIdsBySearchKey(List<Long> ids, List<String> filedList, List<String> filedValueList) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        boolean isOtherMasterIdType = BaseDataCommonService.isOtherMasterIdType((String)entityNumber);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter qfilter = null;
        for (int i = 0; i < filedList.size(); ++i) {
            for (String filedValue : filedValueList) {
                String key;
                String string = key = isOtherMasterIdType ? "masterid." + filedList.get(i) : filedList.get(i);
                if (null == qfilter) {
                    qfilter = new QFilter(key, "like", (Object)("%" + filedValue + "%"));
                    continue;
                }
                qfilter.or(new QFilter(key, "like", (Object)("%" + filedValue + "%")));
            }
        }
        idFilter.and(qfilter);
        qFilterList.add(idFilter);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)entityNumber, (String)"id,number", (QFilter[])qFilterList.toArray(new QFilter[0]));
        if (objects.length > 0) {
            ArrayList<Long> dataIds = new ArrayList<Long>(objects.length);
            Arrays.stream(objects).forEach(object -> dataIds.add(object.getLong("id")));
            return dataIds;
        }
        return new ArrayList<Long>(1);
    }

    public void queryBillListByMerialIds(List<Long> asignDataIds, Set<Long> orgIds) {
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        if (BaseDataCommonService.isNewModel((String)entity)) {
            this.queryBillListByMaterialIdsOnNewModel(asignDataIds, orgIds, entity);
            return;
        }
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        SqlBuilder sqlBuilder = this.makeSQL(entity, lang, asignDataIds, orgIds);
        HashSet<Long> oidSet = new HashSet<Long>();
        Map<String, Map<String, String>> result = this.queryDB(sqlBuilder, entity, oidSet);
        Map<String, String> orgNameMap = this.getOrgNameByOrgId(oidSet);
        Map<String, String[]> nameNumberMap = this.getBdNameNumberMap(entity, result);
        this.makeBillList(result, orgNameMap, nameNumberMap, null, null);
    }

    private SqlBuilder makeSQL(String entity, String lang, List<Long> asignDataIds, Set<Long> useOrgIds) {
        String dataTableName = ORM.create().getDataEntityType(entity).getAlias();
        String dataTableUseName = dataTableName + BASEDATAUSEREGSUFFIX;
        SqlBuilder sbd = new SqlBuilder();
        sbd.append(" SELECT mu.fdataid fdataid,mu.fcreateorgid coid, mu.fuseorgid uoid, mu.fadminorgid aoid", new Object[0]);
        sbd.append(" from ", new Object[0]).append(dataTableUseName, new Object[0]).append(" mu ", new Object[0]);
        sbd.append(" where ", new Object[0]);
        ArrayList<Long> useOrgIdParm = new ArrayList<Long>(useOrgIds.size());
        useOrgIdParm.addAll(useOrgIds);
        ArrayList<Long> dataIdParm = new ArrayList<Long>(useOrgIds.size());
        dataIdParm.addAll(asignDataIds);
        sbd.appendIn("mu.fuseorgid", useOrgIdParm);
        sbd.append(" and ", new Object[0]);
        sbd.appendIn("mu.fdataid", dataIdParm);
        return sbd;
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        e.getStartIndex();
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        String allOrgStr = this.getView().getPageCache().getBigObject(ALLORGLIST_KEY);
        if (StringUtils.isEmpty((CharSequence)allOrgStr)) {
            return;
        }
        List nodeList = SerializationUtils.fromJsonStringToList((String)allOrgStr, TreeNode.class);
        String checkedNodeId = event.getNodeId().toString();
        TreeNode node = BaseDataAssignServiceHelper.getTreeNode(checkedNodeId, nodeList);
        if (null == node) {
            return;
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        nodes.add(node);
        if (((Boolean)this.getModel().getValue("chkincludechild")).booleanValue()) {
            BaseDataAssignServiceHelper.getChildrenNodeList(node, nodes);
        }
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        if (event.getChecked().booleanValue()) {
            tvLeft.checkNodes(nodes);
            return;
        }
        ArrayList uncheckNodeIds = new ArrayList(nodes.size());
        nodes.forEach(unCheckNode -> uncheckNodeIds.add(unCheckNode.getId()));
        tvLeft.uncheckNodes(uncheckNodeIds);
    }

    private void refreshOnNewModel(List<String> filedList, String filedValue) throws Exception {
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        Long useOrgId = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("useOrgId").toString());
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        List orgIds = treeView.getTreeState().getCheckedNodeIds();
        HashSet selectOrgIds = new HashSet(orgIds.size());
        orgIds.forEach(orgId -> selectOrgIds.add(Long.valueOf(orgId)));
        Future future = BaseDataThreadPoolUtils.getBdCommonThreadPool().submit(() -> this.getOrgNameByOrgId(selectOrgIds), RequestContext.get());
        AssignQueryService service = new AssignQueryService(entity);
        QFilter searchFilter = this.getSearchFilter(filedList, filedValue, entity);
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
        Map assignDataMap = service.assignQueryByOrg(useOrgId, selectOrgIds, searchFilter, 15000, dataMap::putAll);
        if (assignDataMap.isEmpty()) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            return;
        }
        Map orgNameMap = (Map)future.get();
        this.refreshOnNewModel(assignDataMap, dataMap, orgNameMap);
    }

    private void refreshOnNewModel(Map<Long, Set<Long>> assignDataMap, Map<Long, DynamicObject> dataMap, Map<String, String> orgNameMap) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        int rowSize = this.getEntryRowSize(assignDataMap, dataMap);
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, rowSize);
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRYENTITY);
        this.packData(assignDataMap, dataMap, orgNameMap, doc, rowSize);
        this.getModel().updateEntryCache(doc);
        this.getView().updateView(ENTRYENTITY);
    }

    private void packData(Map<Long, Set<Long>> assignDataMap, Map<Long, DynamicObject> dataMap, Map<String, String> orgNameMap, DynamicObjectCollection doc, int rowSize) {
        String entity = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        Locale locale = RequestContext.get().getLang().getLocale();
        String lang = locale.getLanguage() + "_" + locale.getCountry();
        boolean isMaterialInfo = BaseDataCommonServiceHelper.isMaterialInfo(entity);
        boolean isTreeType = BaseDataCommonService.isTreeType((String)entity);
        int index = 0;
        for (Map.Entry<Long, Set<Long>> entry : assignDataMap.entrySet()) {
            for (Long dataId : entry.getValue()) {
                DynamicObject baseData = dataMap.get(dataId);
                if (null == baseData) continue;
                String createOrgName = baseData.getString("createorg.name");
                orgNameMap.put(baseData.getString("createorg.id"), createOrgName);
                DynamicObject dynamicObject = (DynamicObject)doc.get(index);
                if (isMaterialInfo) {
                    DynamicObject mainData = baseData.getDynamicObject(MASTERID);
                    ILocaleString name = mainData.getLocaleString(NAME);
                    String enName = name.getLocaleValue_en();
                    if ("en_US".equals(lang) && StringUtils.isNotBlank((CharSequence)enName)) {
                        dynamicObject.set(NAME, (Object)enName);
                    } else {
                        dynamicObject.set(NAME, (Object)name.getLocaleValue_zh_CN());
                    }
                    dynamicObject.set(NUMBER, (Object)mainData.getString(NUMBER));
                } else {
                    if (isTreeType) {
                        dynamicObject.set(NAME, (Object)baseData.getString(KEY_FULL_NAME));
                    } else {
                        dynamicObject.set(NAME, (Object)baseData.getString(NAME));
                    }
                    dynamicObject.set(NUMBER, (Object)baseData.getString(NUMBER));
                }
                dynamicObject.set("createorg", (Object)createOrgName);
                long adminOrgId = this.getOrgIdFromDynamicObject("org", baseData);
                dynamicObject.set("adminorg", (Object)orgNameMap.get(Long.toString(adminOrgId)));
                Long useOrg = entry.getKey();
                dynamicObject.set("useorg", (Object)orgNameMap.get(useOrg.toString()));
                dynamicObject.set(USEORGID, (Object)useOrg);
                dynamicObject.set(DATAID, (Object)dataId);
                if (++index < rowSize) continue;
                return;
            }
        }
    }

    private int getEntryRowSize(Map<Long, Set<Long>> assignDataMap, Map<Long, DynamicObject> dataMap) {
        int size = 0;
        for (Set<Long> value : assignDataMap.values()) {
            for (Long dataId : value) {
                if (dataMap.containsKey(dataId)) {
                    ++size;
                }
                if (size < 15000) continue;
                return size;
            }
        }
        return size;
    }

    private Long getOrgIdFromDynamicObject(String property, DynamicObject data) {
        Object object = data.get(property);
        if (null == object) {
            return 0L;
        }
        if (object instanceof DynamicObject) {
            return (Long)((DynamicObject)object).getPkValue();
        }
        return Long.valueOf(object.toString());
    }

    private QFilter getSearchFilter(List<String> filedList, String filedValue, String entity) {
        boolean isTreeType = BaseDataCommonService.isTreeType((String)entity);
        if (CollectionUtils.isEmpty(filedList) || null == filedValue) {
            return null;
        }
        QFilter searchFilter = null;
        String value = "%" + filedValue + "%";
        for (String field : filedList) {
            if (isTreeType && NAME.equals(field)) {
                if (null == searchFilter) {
                    searchFilter = new QFilter(KEY_FULL_NAME, "like", (Object)value);
                    continue;
                }
                searchFilter.or(new QFilter(KEY_FULL_NAME, "like", (Object)value));
                continue;
            }
            if (null == searchFilter) {
                searchFilter = new QFilter(field, "like", (Object)value);
                continue;
            }
            searchFilter.or(new QFilter(field, "like", (Object)value));
        }
        return searchFilter;
    }

    private void queryBillListByMaterialIdsOnNewModel(List<Long> assignDataIds, Set<Long> orgIds, String entity) {
        HashSet<Long> dataId = new HashSet<Long>(assignDataIds);
        Long useOrgId = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("useOrgId").toString());
        orgIds.remove(useOrgId);
        if (CollectionUtils.isEmpty(assignDataIds) || CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        try {
            Future future = BaseDataThreadPoolUtils.getBdCommonThreadPool().submit(() -> this.getOrgNameByOrgId(orgIds), RequestContext.get());
            AssignQueryService service = new AssignQueryService(entity);
            Map assignData = service.assignQuery(entity, dataId, orgIds);
            HashSet dataIds = new HashSet(16);
            assignData.values().forEach(dataIds::addAll);
            boolean isTreeType = BaseDataCommonService.isTreeType((String)entity);
            String selectProperties = isTreeType ? "id,number,fullname,createorg.id, createorg.name,org" : "id,number,name,createorg.id, createorg.name,org";
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
            DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)entity, (String)selectProperties, (QFilter[])filters, (String)"number asc");
            HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject data : dataArr) {
                dataMap.put(data.getLong("id"), data);
            }
            this.refreshOnNewModel(assignData, dataMap, (Map)future.get());
        }
        catch (Exception e) {
            log.error("\u4ece\u4f4d\u56fe\u4fe1\u606f\u4e2d\u83b7\u53d6\u5df2\u5206\u914d\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    private void cancelAssignOnNewModel(String entity) {
        try {
            String useOrgId;
            EntryGrid billList = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            DynamicObject[] objs = billList.getEntryData().getDataEntitys();
            int[] selectRows = billList.getSelectRows();
            HashSet<Long> dataIds = new HashSet<Long>(selectRows.length);
            HashSet<Long> orgIds = new HashSet<Long>(selectRows.length);
            for (int i : selectRows) {
                Long dataId = objs[i].getLong(DATAID);
                Long useOrgId2 = objs[i].getLong(USEORGID);
                dataIds.add(dataId);
                orgIds.add(useOrgId2);
            }
            BaseDataCancelAssignPreValidator validate = new BaseDataCancelAssignPreValidator(this.getView(), entity, null);
            if (!validate.preValidate(entity, Long.parseLong(useOrgId = this.getView().getFormShowParameter().getCustomParam("useOrgId").toString()), dataIds, orgIds)) {
                return;
            }
            List results = BaseDataServiceHelper.cancelAssign((String)entity, dataIds, orgIds);
            this.refreshBillListAfterCancelAssign(results);
            results.removeIf(CancelAssignResult::isSuccess);
            if (results.isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AssignQueryPluginNew_17", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                this.showCancelErrorNotice(results);
            }
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u5206\u914d\u662f\u5931\u8d25", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"AssignQueryPluginNew_16", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void refreshBillListAfterCancelAssign(List<CancelAssignResult> results) {
        Map<Long, Set<Long>> cancelData = this.getCancelData(results);
        EntryGrid billList = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        DynamicObject[] objs = billList.getEntryData().getDataEntitys();
        Set selectRows = Arrays.stream(billList.getSelectRows()).boxed().collect(Collectors.toSet());
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        DynamicObjectCollection doc = model.getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject obj = objs[i];
            if (!selectRows.contains(i)) {
                doc.add((Object)obj);
                continue;
            }
            Long orgId = obj.getLong(USEORGID);
            Long dataId = obj.getLong(DATAID);
            Set<Long> dataIds = cancelData.get(orgId);
            if (!CollectionUtils.isEmpty(dataIds) && dataIds.contains(dataId)) continue;
            doc.add((Object)obj);
        }
        model.updateEntryCache(doc);
        this.getView().updateView(ENTRYENTITY);
    }

    public Map<Long, Set<Long>> getCancelData(List<CancelAssignResult> results) {
        HashMap<Long, Set<Long>> cancelData = new HashMap<Long, Set<Long>>(16);
        for (CancelAssignResult result : results) {
            if (!result.isSuccess()) continue;
            List orgIds = result.getOrgIds();
            Long dataId = result.getDataId();
            Iterator it = orgIds.iterator();
            while (it.hasNext()) {
                cancelData.computeIfAbsent((Long)it.next(), (Function<Long, Set<Long>>)((Function<Long, Set>)k -> new HashSet(16))).add(dataId);
                it.remove();
            }
        }
        return cancelData;
    }
}

