/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.bdctrl.helper.BaseDataCommonServiceHelper;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class AssignTreeQueryPlugin
extends AbstractTreeListPlugin {
    private static final String TREEVIEW = "treeviewap";
    private static final String CHECKEDNODES = "checkedNodes";
    private static final String ISCTRlUNIT = "1";
    private static final String SEARCHTEXTKEY = "searchTextKey";
    private static final String SELECTED_NODEKEY = "selected_nodeKey";

    public void registerListener(EventObject e) {
        Search searchTree = (Search)this.getControl("searchap_tree");
        searchTree.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        if (!StringUtils.isBlank((CharSequence)searchText)) {
            String checkedNodesStr = this.getPageCache().getBigObject(this.getView().getPageId() + CHECKEDNODES);
            if (StringUtils.isNotEmpty((CharSequence)checkedNodesStr)) {
                ArrayList<String> nodeIds = new ArrayList<String>(8);
                List nodes = SerializationUtils.fromJsonStringToList((String)checkedNodesStr, TreeNode.class);
                for (TreeNode node : nodes) {
                    nodeIds.add(node.getId());
                }
                treeView.uncheckNodes(nodeIds);
            }
            this.checkTreeNodes(searchText, treeView);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u67e5\u8be2\u5173\u952e\u5b57\u3002", (String)"AssignTreeQueryPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkTreeNodes(String searchText, TreeView treeView) {
        List<TreeNode> treeNodes;
        String oldSearchText = this.getPageCache().getBigObject(this.getView().getPageId() + SEARCHTEXTKEY);
        if (StringUtils.isNotEmpty((CharSequence)oldSearchText) && searchText.equals(oldSearchText)) {
            treeNodes = this.searchTreeNode(searchText);
            String oldSelectedNodeId = this.getPageCache().getBigObject(this.getView().getPageId() + SELECTED_NODEKEY);
            if (null != oldSelectedNodeId) {
                this.switchCheckNode(treeView, treeNodes, oldSelectedNodeId);
                return;
            }
        }
        if (CollectionUtils.isEmpty(treeNodes = this.searchTreeNode(searchText))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"AssignTreeQueryPlugin_1", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode node = treeNodes.get(0);
        ArrayList<TreeNode> parentNodes = new ArrayList<TreeNode>(treeNodes.size() * 2);
        this.getParentNode(node, parentNodes);
        for (int i = parentNodes.size() - 1; i > -1; --i) {
            TreeNode parentNode = (TreeNode)parentNodes.get(i);
            treeView.queryTreeNodeChildren(parentNode.getParentid(), parentNode.getId());
            treeView.expand(parentNode.getId());
            treeView.focusNode(parentNode);
        }
        treeView.focusNode(node);
        treeView.checkNode(node);
        ArrayList<TreeNode> tempList = new ArrayList<TreeNode>(1);
        tempList.add(treeNodes.get(0));
        this.getPageCache().putBigObject(this.getView().getPageId() + CHECKEDNODES, SerializationUtils.toJsonString(tempList));
        this.getPageCache().putBigObject(this.getView().getPageId() + SELECTED_NODEKEY, treeNodes.get(0).getId());
        this.getPageCache().putBigObject(this.getView().getPageId() + SEARCHTEXTKEY, searchText);
    }

    private void switchCheckNode(TreeView treeView, List<TreeNode> treeNodes, String oldSelectedNodeId) {
        for (int i = 0; i < treeNodes.size(); ++i) {
            TreeNode node = treeNodes.get(i);
            String orgId = node.getId();
            if (!orgId.equals(oldSelectedNodeId)) continue;
            int index = i + 1 >= treeNodes.size() ? 0 : i + 1;
            TreeNode nextNode = treeNodes.get(index);
            String nextNodeId = nextNode.getId();
            ArrayList<TreeNode> parentNodes = new ArrayList<TreeNode>(treeNodes.size() * 2);
            this.getParentNode(nextNode, parentNodes);
            for (int j = parentNodes.size() - 1; j > -1; --j) {
                TreeNode parentNode = (TreeNode)parentNodes.get(j);
                treeView.queryTreeNodeChildren("", parentNode.getId());
                treeView.expand(parentNode.getId());
            }
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(1);
            nodes.add(nextNode);
            this.getPageCache().putBigObject(this.getView().getPageId() + CHECKEDNODES, SerializationUtils.toJsonString(nodes));
            treeView.focusNode(nextNode);
            treeView.checkNode(nextNode);
            this.getPageCache().putBigObject(this.getView().getPageId() + SELECTED_NODEKEY, nextNodeId);
            return;
        }
    }

    private List<TreeNode> searchTreeNode(String searchText) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        String sql = "SELECT o.fid,o.fname,t.fparentid,t.fviewid from t_org_structure t left join T_ORG_ORG o on t.forgid=o.fid where t.FVIEWID = ? and o.fstatus = 'C' and o.fenable = '1' and (o.fname like ? or o.fnumber like ?) and t.fisctrlunit = ? order by o.fid asc";
        Object[] params = new SqlParameter[]{new SqlParameter(":fviewid", 12, (Object)((Long)ctrlView.getPkValue())), new SqlParameter(":fname", 12, (Object)("%" + searchText + "%")), new SqlParameter(":fnumber", 12, (Object)("%" + searchText + "%")), new SqlParameter(":fisctrlunit", 12, (Object)ISCTRlUNIT)};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
            while (rs.next()) {
                TreeNode treeNode = new TreeNode(rs.getString(3), rs.getString(1), rs.getString(2));
                treeNodes.add(treeNode);
            }
            return treeNodes;
        });
    }

    private void getParentNode(TreeNode treeNode, List<TreeNode> parentNodes) {
        String parentId = treeNode.getParentid();
        if (StringUtils.isNotEmpty((CharSequence)parentId)) {
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
            TreeNode parentNode = BaseDataCommonServiceHelper.queryNodeByOrgId(Long.valueOf(parentId), entityNumber);
            if (null != parentNode) {
                parentNodes.add(parentNode);
                this.getParentNode(parentNode, parentNodes);
            }
        }
    }
}

