/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataCustomService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.validator.BaseDataAssignValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.bdctrl.helper.BaseDataAssignServiceHelper;
import kd.bos.form.plugin.bdctrl.helper.PermissionValidatorHelper;
import kd.bos.list.BillList;
import kd.bos.list.ListCache;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AssignWithOrgListPlugin
extends AbstractListPlugin {
    private static final String BD_ASSIGN = "btnok";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String USEORGID = "useOrgId";
    private static final String CONFIRM_ASSIGN = "confirmAssign";
    private static final String CALL_BACK_ACTION = "TREE_DATA_ASSIGN_ACTION";
    private static final String PARAM_ASSIGN_DATA = "assign_data";
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private Long useOrg;
    private Set<Long> dataIds;
    private String appId;
    private String entityId;
    private Map<Long, String> idNumMap;

    public void initialize() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        this.entityId = (String)fsp.getCustomParam(ENTITY_NUMBER);
        Object tempData = fsp.getCustomParam(PARAM_ASSIGN_DATA);
        tempData = Optional.ofNullable(tempData).orElseGet(Collections::emptyMap);
        Set tempSet = (Set)SerializationUtils.fromJsonString((String)tempData.toString(), Set.class);
        this.dataIds = tempSet.stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toSet());
        this.appId = fsp.getAppId();
        this.useOrg = Long.valueOf(fsp.getCustomParam(USEORGID).toString());
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BD_ASSIGN});
    }

    public void afterCreateNewData(EventObject e) {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (null != filterContainer) {
            String title = ResManager.loadKDString((String)"\u57fa\u7840\u6570\u636e\u5206\u914d", (String)"AssignWithOrgListPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            ListCache listCache = new ListCache(this.getPageCache(), "filtercontainerap");
            listCache.setFilterContainerTitle(new LocaleString(title));
            filterContainer.setTitle(new LocaleString(title));
            this.getView().updateView("filtercontainerap");
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty("filtercontainerap", "tips", null);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        if (!CollectionUtils.isEmpty((Collection)columns)) {
            columns.forEach(e -> e.setHyperlink(false));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String opName = ResManager.loadKDString((String)"\u5206\u914d", (String)"AssignWithOrgListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        Map<String, Object> map = PermissionValidatorHelper.checkDataRule(this.appId, this.entityId, "80513208000000ac", this.useOrg, opName, new ArrayList<Long>(this.dataIds));
        List messages = (List)map.get("messages");
        if (!messages.isEmpty()) {
            FormShowParameter parameter = PermissionValidatorHelper.buildFormShowParameter(messages);
            this.getView().showForm(parameter);
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (!BD_ASSIGN.equals(control.getKey())) {
            return;
        }
        BillList billListAp = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"AssignWithOrgListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        if (BaseDataCommonService.isTreeType((String)this.entityId)) {
            String msg = TreeBaseDataCommonService.isAssignUnDetail((String)this.entityId) ? ResManager.loadKDString((String)"\u6811\u5f62\u57fa\u7840\u8d44\u6599\u5206\u914d\u65f6\u4f1a\u5c06\u4e0a\u7ea7\u8d44\u6599\u4e00\u540c\u5206\u914d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AssignWithOrgListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6811\u5f62\u57fa\u7840\u8d44\u6599\u5206\u914d\u53f6\u5b50\u8282\u70b9\u65f6\u4f1a\u5c06\u4e0a\u7ea7\u8d44\u6599\u4e00\u540c\u5206\u914d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AssignWithOrgListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_ASSIGN, (IFormPlugin)this));
            return;
        }
        HashSet orgIds = new HashSet(selectedRows.size());
        selectedRows.forEach(r -> orgIds.add(Long.valueOf(r.getPrimaryKeyValue().toString())));
        BaseDataResponse response = new AssignService(this.entityId).assign(this.useOrg, this.appId, this.dataIds, orgIds, true);
        this.notification(response);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (CONFIRM_ASSIGN.equals(callBackId) && MessageBoxResult.Yes == result) {
            BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
            this.executeAssign();
        } else if (CALL_BACK_ACTION.equals(callBackId) && MessageBoxResult.Yes == result) {
            BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
            BillList billListAp = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
            HashSet orgIds = new HashSet(selectedRows.size());
            selectedRows.forEach(r -> orgIds.add(Long.valueOf(r.getPrimaryKeyValue().toString())));
            BaseDataResponse response = new AssignService(this.entityId).assign(this.useOrg, this.appId, this.dataIds, orgIds, false);
            this.notification(response);
        }
    }

    private void executeAssign() {
        BillList billListAp = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
        HashSet<Long> orgIds = new HashSet<Long>(selectedRows.size());
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long orgId = Long.valueOf(row.getPrimaryKeyValue().toString());
            orgIds.add(orgId);
            orgNameMap.put(orgId, row.getName());
        }
        if (!TreeBaseDataCommonService.isAssignUnDetail((String)this.entityId)) {
            BaseDataResponse response = new AssignService(this.entityId).assign(this.useOrg, this.appId, this.dataIds, orgIds, true);
            this.notification(response);
            return;
        }
        BaseDataAssignValidator validator = new BaseDataAssignValidator(this.entityId, this.useOrg, this.appId, this.dataIds, orgIds);
        BaseDataResponse response = validator.assignValidate();
        if (!response.isSuccess()) {
            this.errorNotification(response);
            return;
        }
        int originalSize = orgIds.size();
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entityId);
        Map superiors = OrgUnitServiceHelper.getAllSuperiorOrgs((String)ctrlView.getString("number"), new ArrayList(orgIds));
        for (Map.Entry entry : superiors.entrySet()) {
            Long supper;
            List suppers = (List)entry.getValue();
            for (int i = suppers.size() - 1; i >= 0 && !this.useOrg.equals(supper = (Long)suppers.get(i)); --i) {
                orgIds.add(supper);
            }
        }
        List nodeIds = new TreeBaseDataCommonService(this.entityId).getIntegrityNodeIds(new HashSet<Long>(this.dataIds), this.useOrg);
        Map customOrgDataInfo = BaseDataCustomService.getCustomOrgDataInfo((String)this.entityId, orgIds, (Collection)nodeIds, (Long)this.useOrg);
        if (CollectionUtils.isEmpty((Map)customOrgDataInfo)) {
            response = new AssignService(this.entityId).assign(this.useOrg, this.appId, this.dataIds, orgIds, false);
            this.notification(response);
            return;
        }
        if (orgIds.size() > originalSize) {
            try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "bos_org", "id, name", new QFilter[]{new QFilter("id", "in", orgIds)});){
                ds.forEach(e -> orgNameMap.put(e.getLong("id"), e.getString("name")));
            }
        }
        this.autoIndividualConfirm(customOrgDataInfo, orgNameMap, nodeIds);
    }

    private void autoIndividualConfirm(Map<Long, List<Long>> customOrgDataInfo, Map<Long, String> orgNameMap, List<Long> nodeIds) {
        boolean isMultiCustomData;
        boolean bl = isMultiCustomData = customOrgDataInfo.size() > 1;
        if (!isMultiCustomData) {
            isMultiCustomData = customOrgDataInfo.values().iterator().next().size() > 1;
        }
        this.idNumMap = new HashMap<Long, String>(nodeIds.size());
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), this.entityId, "id, number", new QFilter[]{new QFilter("id", "in", nodeIds)});){
            ds.forEach(e -> this.idNumMap.put(e.getLong("id"), e.getString("number")));
        }
        if (isMultiCustomData) {
            ArrayList details = new ArrayList(10);
            String msg = ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u5728\u7ec4\u7ec7\u201c%2$s\u201d\u4e2d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\u3002", (String)"AssignWithOrgListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            for (Map.Entry<Long, List<Long>> entry : customOrgDataInfo.entrySet()) {
                String dataNum = this.idNumMap.get(entry.getKey());
                entry.getValue().forEach(e -> details.add(String.format(msg, dataNum, orgNameMap.get(e))));
            }
            String title = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u88ab\u5206\u914d\u6570\u636e\u7684\u7236\u7ea7\u8d44\u6599\u5728\u7ec4\u7ec7\u4e2d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u5206\u914d\u540e\u4e3a\u4e86\u786e\u4fdd\u53ef\u89c1\u8303\u56f4\u5185\u6570\u636e\u5c42\u7ea7\u7684\u6b63\u786e\u6027\uff0c\u88ab\u5206\u914d\u6570\u636e\u4f1a\u505a\u81ea\u52a8\u4e2a\u6027\u5316\u5904\u7406\u3002", (String)"AssignWithOrgListPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            String detail = String.join((CharSequence)"\r\n", details);
            this.getView().showConfirm(title, detail, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALL_BACK_ACTION, (IFormPlugin)this));
        } else {
            Map.Entry<Long, List<Long>> entry = customOrgDataInfo.entrySet().iterator().next();
            Long dataId = entry.getKey();
            Long orgId = entry.getValue().get(0);
            String msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u5728\u7ec4\u7ec7\u201c%2$s\u201d\u4e2d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u5206\u914d\u540e\u5c06\u4f1a\u81ea\u52a8\u4fee\u590d\u8d44\u6599\u5c42\u7ea7\uff0c\u70b9\u51fb\u786e\u5b9a\u7ee7\u7eed\u5206\u914d\uff0c\u53d6\u6d88\u4e0d\u5206\u914d\u3002", (String)"AssignWithOrgListPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.idNumMap.get(dataId), orgNameMap.get(orgId));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALL_BACK_ACTION, (IFormPlugin)this));
        }
    }

    private void notification(BaseDataResponse response) {
        if (response.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"AssignWithOrgListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else {
            this.errorNotification(response);
        }
    }

    private void errorNotification(BaseDataResponse response) {
        String errorMsg = response.getErrorMsg();
        if (StringUtils.isEmpty((Object)errorMsg)) {
            if (null == this.idNumMap) {
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", this.dataIds)};
                this.idNumMap = new HashMap<Long, String>(this.dataIds.size());
                try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), this.entityId, "id, number", filters);){
                    ds.forEach(e -> this.idNumMap.put(e.getLong("id"), e.getString("number")));
                }
            }
            Map result = response.getResult();
            BaseDataAssignServiceHelper.noticeAfterAssignError(result, this.idNumMap, this.getView());
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002%s", (String)"AssignWithOrgListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), errorMsg));
        }
    }
}

