/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bd.pojo.CtrlStrategyEnum;
import kd.bos.bd.service.AutoAssignService;
import kd.bos.bd.validator.AutoAssignValidator;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.bdctrl.BaseDataListPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.jetbrains.annotations.NotNull;

public class AutoAssignFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
EntryGridBindDataListener,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(AutoAssignFormPlugin.class);
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String USE_ORG_ID = "useOrgId";
    private static final String USE_ORG = "useorg";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String DEFAULT_NUMBER = "Auto-000001";
    private static final String DEFAULT_NUMBER_PREFIX = "Auto-";
    private static final String ASSIGN_ORG_ID = "assignOrgId";
    private static final String ITEM_BATCH_ADD = "batchadd";
    private static final String ADD_ROW = "addrow";
    private static final String DEL_ROW = "delrow";
    private static final String PLAN_DETAIL = "plandetail";
    private static final String FILTER_CONDITION = "filterCondition";
    private static final String FILTER_SELECT = "filterselect";
    private static final String FILTER_SELECT_ORG = "useorgfilter";
    private static final String PREVIEW = "preview";
    private static final String ORG_PREVIEW = "orgpreview";
    private static final String ORG_FILTER_SCHEME = "orgfilterscheme";
    private static final String ORG_FILTER_SCHEME_ID = "orgfilterscheme.id";
    private static final String RETURN_CALLBACK_ID = "returnFilterConditionId";
    private static final String RETURN_ORG_CALLBACK_ID = "returnOrgFilterSchemeId";
    private static final String ENTITY_ID = "entityId";
    private static final String APP_ID = "appId";
    private static final String BAR_ASSIGN = "bar_assign";
    private static final String BAR_SAVE = "bar_save";
    private static final String ENTITY_FILTER_CONDITION = "bd_filtercondition";
    private static final String ENTITY_ORG_FILTER_SCHEME = "bd_org_filterscheme";
    private static final String ENTITY_ORG = "bos_org";
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    private static final String QUERY_PERM = "47150e89000000ac";
    private static final String ENTITY_ORG_STRUCTURE = "bos_org_structure";
    private static final String VIEW_ID = "view.id";
    private static final String FIELD_ORG = "org";
    private static final String FIELD_ORG_ID = "org.id";
    private static final String FIELD_IS_CTRL_UNIT = "isCtrlUnit";
    private static final String REMARK = "remark";
    private static final String IS_CONCLUDE = "isconclude";
    private static final String BILL_STATUS = "bill_status";
    private static final String TASK_CLOSE_CALL_BACK = "taskCloseCallBack";
    private static final String AUTO_ASSIGN_PLAN_ID = "autoAssignPlanId";
    private static final String ORG_ENTITY = "bos_org";
    private static final String ADD_SUBSCRIBE_CONFIRM = "add_subscribe_confirm";
    private static final String ENTITY = "entity";
    private static final String OPERATION = "operation";
    private static final String DOT = ".";
    private static final String SAVE = "save";
    private static final String AUDIT = "audit";
    private static final String EVT_EVENT = "evt_event";
    private static final String EVT_SUBSCRIPTION = "evt_subscription";
    private static final Long SERVICE_EXECUTE_PLUGIN = 904236026388547584L;
    private static final String EXECUTE_PLUGIN_NUMBER = "executePlugin";
    private static final String EVENT = "event";
    private static final String OPERATE_NUMBER = "opernumber";
    private static final String BASE_DATA_ID = "fbasedataid";
    private static final String STATUS = "status";
    private static final String TRUE_VALUE = "1";
    private static final String FALSE_VALUE = "0";
    private static final String ROW_INDEX = "rowIndex";
    private static final String EVT_EVENT_MODIFY_PERM_ITERM = "4715a0df000000ac";
    private static final String EVT_SUBSCRIPTION_PERM_ITERM = "0=KX5+QVF5+R";
    private static final String ORG_VIEW_NUMBER = "orgViewSchemeNumber";
    private static final String FBASEDATAID_ID = "fbasedataid_id";
    private static final String PK_ID = "pkid";
    private static final String CLEAN_USE_ORG_CONFIRM = "clean_use_org_confirm";
    private static final String BAR_VIEW_RESULT = "bar_viewresult";
    private static final String NEW_ENTRY = "newentry";
    private static final String PROP_NAME = "name";
    private static final String CACHE_CLICK_INDEX = "clickIndex";
    private static final String PARAM_CTRL_STRATEGY = "ctrlStrtgy";
    private static final String PARAM_ORG_VIEW_NUMBER = "orgViewSchemeNumber";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap", "tbmain", ITEM_BATCH_ADD, BAR_ASSIGN});
        this.addClickListeners(new String[]{FILTER_SELECT, FILTER_SELECT_ORG, PREVIEW, ORG_PREVIEW});
        EntryGrid planDetail = (EntryGrid)this.getView().getControl(PLAN_DETAIL);
        planDetail.addHyperClickListener((HyperLinkClickListener)this);
        planDetail.addDataBindListener((EntryGridBindDataListener)this);
        BasedataEdit assignOrg = (BasedataEdit)this.getView().getControl(ASSIGN_ORG_ID);
        BasedataEdit useOrg = (BasedataEdit)this.getView().getControl(USE_ORG);
        assignOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        useOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        EntryGrid planDetail;
        DynamicObject[] rowDataArr;
        super.beforeBindData(e);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(APP_ID);
        this.getModel().setValue(ENTITY_ID, (Object)entityId);
        this.getModel().setValue(APP_ID, (Object)appId);
        if (StringUtils.isEmpty((CharSequence)String.valueOf(this.getModel().getValue("number")))) {
            String number = this.getAutoIncrementNumber(entityId);
            this.getModel().setValue("number", (Object)number);
        }
        if ((rowDataArr = (planDetail = (EntryGrid)this.getView().getControl(PLAN_DETAIL)).getEntryData().getDataEntitys()).length == 0) {
            return;
        }
        ArrayList<Long> filterConditionIds = new ArrayList<Long>(rowDataArr.length);
        for (DynamicObject rowData : rowDataArr) {
            filterConditionIds.add(rowData.getLong(FILTER_CONDITION));
        }
        DynamicObjectCollection filterConditions = QueryServiceHelper.query((String)ENTITY_FILTER_CONDITION, (String)AutoAssignFormPlugin.getSelectField("id", PROP_NAME), (QFilter[])new QFilter[]{new QFilter("id", "in", filterConditionIds)});
        HashMap filterConditionNameMap = new HashMap(rowDataArr.length);
        filterConditions.forEach(filterCondition -> filterConditionNameMap.put(filterCondition.getLong("id"), filterCondition.getString(PROP_NAME)));
        DynamicObjectCollection doc = this.getModel().getEntryEntity(PLAN_DETAIL);
        for (int i = 0; i < rowDataArr.length; ++i) {
            String selectCondition = (String)filterConditionNameMap.get(rowDataArr[i].getLong(FILTER_CONDITION));
            if (null != selectCondition) {
                ((DynamicObject)doc.get(i)).set(FILTER_SELECT, (Object)selectCondition);
            } else {
                ((DynamicObject)doc.get(i)).set(FILTER_SELECT, (Object)AutoAssignFormPlugin.getSelectPlanMsg());
            }
            if (null != rowDataArr[i].get(ORG_FILTER_SCHEME)) {
                DynamicObject orgFilterScheme = ((DynamicObject)doc.get(i)).getDynamicObject(ORG_FILTER_SCHEME);
                ((DynamicObject)doc.get(i)).set(FILTER_SELECT_ORG, (Object)orgFilterScheme.getString(PROP_NAME));
            } else {
                ((DynamicObject)doc.get(i)).set(FILTER_SELECT_ORG, (Object)AutoAssignFormPlugin.getSelectPlanMsg());
            }
            ((DynamicObject)doc.get(i)).set(PREVIEW, (Object)AutoAssignFormPlugin.getPreviewMsg());
            ((DynamicObject)doc.get(i)).set(ORG_PREVIEW, (Object)AutoAssignFormPlugin.getPreviewMsg());
        }
    }

    private String getAutoIncrementNumber(String entityId) {
        String newNumStr;
        int oldNum;
        String sql = "select top 1 fNumber from t_bd_autoAssign where fEntityId = ? and fNumber like 'Auto-%' order by fNumber desc;";
        String number = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{entityId}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getString(1);
            }
            return null;
        });
        if (StringUtils.isEmpty((CharSequence)number)) {
            return DEFAULT_NUMBER;
        }
        try {
            oldNum = Integer.parseInt(number.substring(DEFAULT_NUMBER_PREFIX.length()));
        }
        catch (NumberFormatException e) {
            LOGGER.error(ResManager.loadKDString((String)"AutoAssignFormPlugin\uff0c\u7f16\u7801\u4e0d\u662f\u6574\u578b\uff0c\u91cd\u65b0\u83b7\u53d6", (String)"AutoAssignFormPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), (Throwable)e);
            oldNum = AutoAssignFormPlugin.getOldNum(entityId);
        }
        catch (StringIndexOutOfBoundsException e) {
            LOGGER.error("AutoAssignFormPlugin.getAutoIncrementNumber:number is StringIndexOutOfBounds, try get again.", (Throwable)e);
            oldNum = AutoAssignFormPlugin.getOldNum(entityId);
        }
        if (String.valueOf(++oldNum).length() < 6) {
            int zeroNum = 6 - String.valueOf(oldNum).length();
            StringBuilder sbd = new StringBuilder();
            for (int i = 0; i < zeroNum; ++i) {
                sbd.append('0');
            }
            newNumStr = sbd.append(oldNum).toString();
        } else {
            newNumStr = String.valueOf(oldNum);
        }
        return DEFAULT_NUMBER_PREFIX + newNumStr;
    }

    private static int getOldNum(String entityId) {
        int oldNum = 0;
        String sql = "select fNumber from t_bd_autoAssign where fEntityId = ? and fNumber like 'Auto-%' order by fNumber desc;";
        List numberList = (List)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{entityId}, resultSet -> {
            ArrayList<String> tempNumberList = new ArrayList<String>(10);
            while (resultSet.next()) {
                tempNumberList.add(resultSet.getString(1));
            }
            return tempNumberList;
        });
        if (CollectionUtils.isEmpty((Collection)numberList)) {
            return oldNum;
        }
        for (String number : numberList) {
            try {
                oldNum = Integer.parseInt(number.substring(DEFAULT_NUMBER_PREFIX.length()));
                break;
            }
            catch (NumberFormatException e) {
                LOGGER.error(ResManager.loadKDString((String)"AutoAssignFormPlugin.getOldNum\uff0c\u7f16\u7801\u4e0d\u662f\u6574\u578b\uff0c\u91cd\u65b0\u83b7\u53d6", (String)"AutoAssignFormPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), (Throwable)e);
            }
            catch (StringIndexOutOfBoundsException e) {
                LOGGER.error("AutoAssignFormPlugin.getOldNum:number is StringIndexOutOfBounds, get last one.", (Throwable)e);
            }
        }
        return oldNum;
    }

    private Long getUseOrgId() {
        Long useOrgId = null;
        Object orgId = this.getView().getFormShowParameter().getCustomParam(USE_ORG_ID);
        if (orgId instanceof Integer || orgId instanceof Long) {
            useOrgId = Long.valueOf(orgId.toString());
        }
        return useOrgId;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        EntryGrid planDetail = (EntryGrid)this.getView().getControl(PLAN_DETAIL);
        switch (key) {
            case "addrow": {
                int maxRow = 20;
                if (planDetail.getEntryData().getEndIndex() < maxRow) break;
                evt.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6dfb\u52a0%s\u884c\u6570\u636e\u3002", (String)"AutoAssignFormPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), maxRow));
                break;
            }
            case "batchadd": {
                int[] selectRows = planDetail.getSelectRows();
                if (selectRows.length == 0) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"AutoAssignFormPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                if (selectRows.length <= 1) break;
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5176\u4e2d\u4e00\u884c\u3002", (String)"AutoAssignFormPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                break;
            }
            case "bar_assign": {
                if (FALSE_VALUE.equals(this.getModel().getValue(ENABLE))) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u518d\u5206\u914d\u3002", (String)"AutoAssignFormPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                Long autoAssignPlanId = (Long)this.getModel().getDataEntity().getPkValue();
                boolean isAssignDataBeyondMaxNum = new AutoAssignValidator().isAssignDataBeyondMaxNum(entityId, autoAssignPlanId);
                if (!isAssignDataBeyondMaxNum) break;
                this.getView().showErrorNotification(AutoAssignValidator.getErrorMsgOfBeyondMaxAssignNum());
                evt.setCancel(true);
                break;
            }
            case "bar_save": {
                this.beforeSave(evt, entityId);
                break;
            }
        }
    }

    private void beforeSave(BeforeItemClickEvent evt, String entityId) {
        if (TRUE_VALUE.equals(this.getModel().getValue(ENABLE))) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7981\u7528\u518d\u4fee\u6539\u3002", (String)"AutoAssignFormPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        if (!this.hasPerm()) {
            evt.setCancel(true);
            return;
        }
        DynamicObjectCollection eventDoc = this.getDefineEvent();
        DynamicObjectCollection subscribeDoc = this.getSubscribeEvent(eventDoc);
        if (eventDoc.size() != 2 || subscribeDoc.size() != 2) {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityId);
            String title = met.getDisplayName().getLocaleValue();
            String noticeMsg = String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u914d\u9700\u8981\u751f\u6210\u201d%s\u201c\u7684\u4fdd\u5b58\u3001\u5ba1\u6838\u5b9a\u4e49\u4e8b\u4ef6\u548c\u8ba2\u9605\u4e8b\u4ef6\u3002\u662f\u5426\u81ea\u52a8\u751f\u6210\uff1f", (String)"AutoAssignFormPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), title);
            this.getView().showConfirm(noticeMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ADD_SUBSCRIBE_CONFIRM, (IFormPlugin)this));
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (ADD_SUBSCRIBE_CONFIRM.equals(callBackId) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            boolean isDefineEventSave = true;
            boolean isSubscribeEventSave = true;
            DynamicObjectCollection eventDoc = this.getDefineEvent();
            DynamicObjectCollection subscribeDoc = this.getSubscribeEvent(eventDoc);
            if (eventDoc.size() != 2) {
                isDefineEventSave = this.saveDefineEvent(eventDoc);
            }
            if (subscribeDoc.size() != 2) {
                isSubscribeEventSave = this.saveSubscribeEvent(subscribeDoc);
            }
            if (isDefineEventSave && isSubscribeEventSave) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002\u60a8\u53ef\u4ee5\u5728\u201c\u6d41\u7a0b\u670d\u52a1\u4e91-\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3-\u4e8b\u4ef6\u5b9a\u4e49|\u4e8b\u4ef6\u8ba2\u9605\u201d\u67e5\u770b\u3002", (String)"AutoAssignFormPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
                DynamicObject data = this.getModel().getDataEntity();
                DynamicObjectCollection planDetailCol = this.getModel().getEntryEntity(PLAN_DETAIL);
                data.set(PLAN_DETAIL, (Object)planDetailCol);
                DynamicObject[] dataList = new DynamicObject[]{data};
                OperationResult result = OperationServiceHelper.executeOperate((String)SAVE, (String)entityId, (DynamicObject[])dataList, (OperateOption)OperateOption.create());
                if (!result.isSuccess()) {
                    StringJoiner stringJoiner = new StringJoiner("\r\n");
                    result.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).forEach(stringJoiner::add);
                    this.getView().showMessage(stringJoiner.toString());
                }
            }
            return;
        }
        if (CLEAN_USE_ORG_CONFIRM.equals(callBackId) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            DynamicObjectCollection doc = this.getModel().getEntryEntity(PLAN_DETAIL);
            if (doc.isEmpty()) {
                return;
            }
            for (DynamicObject detail : doc) {
                detail.set(ORG_FILTER_SCHEME, null);
                detail.set(FILTER_SELECT_ORG, (Object)AutoAssignFormPlugin.getSelectPlanMsg());
                detail.set(USE_ORG, null);
            }
            this.getModel().updateEntryCache(doc);
            this.getView().updateView(PLAN_DETAIL);
            this.getView().sendFormAction(this.getView());
        }
        if (CLEAN_USE_ORG_CONFIRM.equals(callBackId) && event.getResult().equals((Object)MessageBoxResult.Cancel)) {
            Object ctrlStrategy = this.getModel().getValue("ctrlstrategy");
            Optional.ofNullable(ctrlStrategy).ifPresent(this::repealSetCtrlStrategy);
        }
    }

    private void repealSetCtrlStrategy(Object newCtrlStrategy) {
        if (CtrlStrategyEnum.CU_ASSIGN.getCtrlStrategy().equals(newCtrlStrategy)) {
            this.getPageCache().put(CLEAN_USE_ORG_CONFIRM, TRUE_VALUE);
            this.getModel().setValue("ctrlstrategy", (Object)CtrlStrategyEnum.FREE_ASSIGN.getCtrlStrategy());
        }
        if (CtrlStrategyEnum.FREE_ASSIGN.getCtrlStrategy().equals(newCtrlStrategy)) {
            this.getPageCache().put(CLEAN_USE_ORG_CONFIRM, TRUE_VALUE);
            this.getModel().setValue("ctrlstrategy", (Object)CtrlStrategyEnum.CU_ASSIGN.getCtrlStrategy());
        }
    }

    private boolean saveDefineEvent(DynamicObjectCollection eventDoc) {
        DynamicObject[] defineEvents;
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityId);
        String entityName = met.getDisplayName().getLocaleValue();
        if (eventDoc.isEmpty()) {
            defineEvents = new DynamicObject[2];
            DynamicObject saveEvent = this.getDefineEvent(entityId, entityName, SAVE, AutoAssignFormPlugin.getSaveMsg());
            DynamicObject auditEvent = this.getDefineEvent(entityId, entityName, AUDIT, AutoAssignFormPlugin.getAuditMsg());
            defineEvents[0] = saveEvent;
            defineEvents[1] = auditEvent;
        } else if (eventDoc.size() == 1) {
            defineEvents = new DynamicObject[1];
            String operation = ((DynamicObject)eventDoc.get(0)).getString(OPERATE_NUMBER);
            DynamicObject event = AUDIT.equals(operation) ? this.getDefineEvent(entityId, entityName, SAVE, AutoAssignFormPlugin.getSaveMsg()) : this.getDefineEvent(entityId, entityName, AUDIT, AutoAssignFormPlugin.getAuditMsg());
            defineEvents[0] = event;
        } else {
            return true;
        }
        long userId = RequestContext.get().getCurrUserId();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)EVT_EVENT);
        String appNumber = mainEntityType.getBizAppNumber();
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        if (!PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)EVT_EVENT, (String)EVT_EVENT_MODIFY_PERM_ITERM)) {
            String caption = FormMetadataCache.getFormConfig((String)EVT_EVENT).getCaption().getLocaleValue();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AutoAssignFormPlugin_20", (String)SYSTEM_TYPE, (Object[])new Object[0]), caption));
            return false;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)SAVE, (String)EVT_EVENT, (DynamicObject[])defineEvents, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            List errorInfoList = operationResult.getAllErrorOrValidateInfo();
            StringJoiner sj = new StringJoiner("\r\n");
            for (IOperateInfo errorInfo : errorInfoList) {
                sj.add(errorInfo.getMessage());
            }
            this.getView().showMessage(sj.toString());
            return false;
        }
        return true;
    }

    @NotNull
    private DynamicObject getDefineEvent(String entityId, String entityName, String operateKey, String operateName) {
        DynamicObject defineEvent = BusinessDataServiceHelper.newDynamicObject((String)EVT_EVENT);
        defineEvent.set("number", (Object)(entityId + DOT + operateKey));
        defineEvent.set(PROP_NAME, (Object)(entityName + DOT + operateName));
        defineEvent.set(OPERATION, (Object)operateName);
        defineEvent.set("type", (Object)"cosmic");
        defineEvent.set(ENTITY, (Object)entityId);
        QFilter qFilter = new QFilter("number", "=", (Object)entityId);
        DynamicObject app = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"bizappid", (QFilter[])new QFilter[]{qFilter});
        if (app != null) {
            defineEvent.set("source", app.get("bizappid"));
        }
        defineEvent.set(OPERATE_NUMBER, (Object)operateKey);
        defineEvent.set("scene", (Object)"operate");
        defineEvent.set(STATUS, (Object)TRUE_VALUE);
        defineEvent.set("ispreinsdata", (Object)FALSE_VALUE);
        defineEvent.set("ismodified", (Object)TRUE_VALUE);
        defineEvent.set("numberview", (Object)(entityId + DOT + operateKey));
        defineEvent.set("passoperparam", (Object)TRUE_VALUE);
        defineEvent.set("creater", (Object)RequestContext.get().getCurrUserId());
        return defineEvent;
    }

    private boolean saveSubscribeEvent(DynamicObjectCollection subscribeDoc) {
        DynamicObject[] subscribeEvents;
        DynamicObjectCollection defineEventDoc = this.getDefineEvent();
        if (defineEventDoc.size() != 2) {
            return false;
        }
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityId);
        String entityName = met.getDisplayName().getLocaleValue();
        if (subscribeDoc.isEmpty()) {
            DynamicObject auditDefineEvent;
            DynamicObject saveDefineEvent;
            subscribeEvents = new DynamicObject[2];
            if (SAVE.equals(((DynamicObject)defineEventDoc.get(0)).getString(OPERATE_NUMBER))) {
                saveDefineEvent = (DynamicObject)defineEventDoc.get(0);
                auditDefineEvent = (DynamicObject)defineEventDoc.get(1);
            } else {
                saveDefineEvent = (DynamicObject)defineEventDoc.get(1);
                auditDefineEvent = (DynamicObject)defineEventDoc.get(0);
            }
            DynamicObject saveEvent = this.getSubscribeEvent(entityId, entityName, saveDefineEvent.getLong("id"), SAVE, AutoAssignFormPlugin.getSaveMsg());
            DynamicObject auditEvent = this.getSubscribeEvent(entityId, entityName, auditDefineEvent.getLong("id"), AUDIT, AutoAssignFormPlugin.getAuditMsg());
            subscribeEvents[0] = saveEvent;
            subscribeEvents[1] = auditEvent;
        } else if (subscribeDoc.size() == 1) {
            DynamicObject event;
            subscribeEvents = new DynamicObject[1];
            Long subscribeEventId = ((DynamicObject)subscribeDoc.get(0)).getLong(EVENT);
            boolean isSaveSubscribeEvent = AutoAssignFormPlugin.isSaveSubscribeEvent(defineEventDoc, subscribeEventId);
            Long defineEventId = ((DynamicObject)defineEventDoc.get(0)).getLong("id");
            Long eventId = subscribeEventId.equals(defineEventId) ? ((DynamicObject)defineEventDoc.get(1)).getLong("id") : defineEventId.longValue();
            String operateNumber = isSaveSubscribeEvent ? AUDIT : SAVE;
            String operateName = isSaveSubscribeEvent ? AutoAssignFormPlugin.getAuditMsg() : AutoAssignFormPlugin.getSaveMsg();
            subscribeEvents[0] = event = this.getSubscribeEvent(entityId, entityName, eventId, operateNumber, operateName);
        } else {
            return true;
        }
        long userId = RequestContext.get().getCurrUserId();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)EVT_SUBSCRIPTION);
        String appNumber = mainEntityType.getBizAppNumber();
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        if (!PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)EVT_SUBSCRIPTION, (String)EVT_SUBSCRIPTION_PERM_ITERM)) {
            String caption = FormMetadataCache.getFormConfig((String)EVT_SUBSCRIPTION).getCaption().getLocaleValue();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u4fdd\u5b58\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AutoAssignFormPlugin_21", (String)SYSTEM_TYPE, (Object[])new Object[0]), caption));
            return false;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)SAVE, (String)EVT_SUBSCRIPTION, (DynamicObject[])subscribeEvents, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            List errorInfoList = operationResult.getAllErrorOrValidateInfo();
            StringJoiner sj = new StringJoiner("\r\n");
            for (IOperateInfo errorInfo : errorInfoList) {
                sj.add(errorInfo.getMessage());
            }
            this.getView().showMessage(sj.toString());
            return false;
        }
        return true;
    }

    private static boolean isSaveSubscribeEvent(DynamicObjectCollection defineEventDoc, Long subscribeEventId) {
        boolean isSave = false;
        for (DynamicObject defineEvent : defineEventDoc) {
            Long defineEventId = defineEvent.getLong("id");
            if (!defineEventId.equals(subscribeEventId)) continue;
            isSave = SAVE.equals(defineEvent.getString(OPERATE_NUMBER));
        }
        return isSave;
    }

    private DynamicObject getSubscribeEvent(String entityId, String entityName, Long defineEvent, String operateNumber, String operateName) {
        DynamicObject subscribeEvent = BusinessDataServiceHelper.newDynamicObject((String)EVT_SUBSCRIPTION);
        subscribeEvent.set("number", (Object)(entityId + DOT + operateNumber + DOT + "autoassign" + DOT + EXECUTE_PLUGIN_NUMBER));
        subscribeEvent.set(PROP_NAME, (Object)String.format(ResManager.loadKDString((String)"%1$s.%2$s.\u6267\u884c\u63d2\u4ef6", (String)"AutoAssignFormPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), entityName, operateName));
        subscribeEvent.set(EVENT, (Object)defineEvent);
        subscribeEvent.set("service", (Object)SERVICE_EXECUTE_PLUGIN);
        subscribeEvent.set("isconcurrent", (Object)TRUE_VALUE);
        subscribeEvent.set(STATUS, (Object)TRUE_VALUE);
        subscribeEvent.set("errorstrategy", (Object)"retry");
        subscribeEvent.set("sequence", (Object)0);
        subscribeEvent.set("eventnumber", (Object)(entityId + DOT + operateNumber));
        subscribeEvent.set("servicenumber", (Object)EXECUTE_PLUGIN_NUMBER);
        subscribeEvent.set("creater", (Object)RequestContext.get().getCurrUserId());
        subscribeEvent.set("ispreinsdata", (Object)FALSE_VALUE);
        subscribeEvent.set("ismodified", (Object)TRUE_VALUE);
        subscribeEvent.set("serviceconfig", (Object)"{\"scriptid\":\"\",\"type\":\"class\",\"value\":\"{\\\"appid\\\":\\\"\\\",\\\"class\\\":\\\"kd.bos.bd.subscribe.BaseDataAutoAssignPlugin\\\",\\\"operateparamsconf\\\":\\\"\\\"}\"}");
        return subscribeEvent;
    }

    private DynamicObjectCollection getDefineEvent() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        QFilter[] qFilters = new QFilter[]{new QFilter(ENTITY, "=", (Object)entityId), new QFilter(OPERATE_NUMBER, "in", Arrays.asList(SAVE, AUDIT))};
        return QueryServiceHelper.query((String)EVT_EVENT, (String)"id,number,entity,opernumber", (QFilter[])qFilters);
    }

    private DynamicObjectCollection getSubscribeEvent(DynamicObjectCollection eventDoc) {
        if (eventDoc.isEmpty()) {
            return new DynamicObjectCollection();
        }
        ArrayList<Long> defineEventIds = new ArrayList<Long>(eventDoc.size());
        for (DynamicObject defineEvent : eventDoc) {
            defineEventIds.add(defineEvent.getLong("id"));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(EVENT, "in", defineEventIds), new QFilter("serviceconfig", "like", (Object)"%kd.bos.bd.subscribe.BaseDataAutoAssignPlugin%")};
        return QueryServiceHelper.query((String)EVT_SUBSCRIPTION, (String)"id,number,event", (QFilter[])qFilters);
    }

    private boolean hasPerm() {
        Long autoAssignPlanId = (Long)this.getModel().getDataEntity().getPkValue();
        AutoAssignService service = new AutoAssignService();
        ArrayList<Long> autoAssignPlanIds = new ArrayList<Long>(1);
        autoAssignPlanIds.add(autoAssignPlanId);
        Map planDetailMap = service.getPlanDetailMap(autoAssignPlanIds);
        if (!CollectionUtils.isEmpty((Map)planDetailMap)) {
            Collection planDetails = planDetailMap.values();
            ArrayList assignOrgIds = new ArrayList(planDetailMap.size());
            for (List autoAssignPlanDetails : planDetails) {
                autoAssignPlanDetails.forEach(autoAssignPlanDetail -> assignOrgIds.add(autoAssignPlanDetail.getAssignOrgId()));
            }
            List<QFilter> qFilters = this.getBaseDataViewPermOrgFilters();
            DynamicObjectCollection orgList = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
            HashSet orgIds = new HashSet(orgList.size());
            orgList.forEach(org -> orgIds.add(org.getLong("id")));
            QFilter[] assignOrgFilters = new QFilter[]{new QFilter("id", "in", assignOrgIds)};
            DynamicObjectCollection assignOrgList = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])assignOrgFilters);
            HashMap<Long, String> assignOrgNameMap = new HashMap<Long, String>(assignOrgList.size());
            for (DynamicObject assignOrg : assignOrgList) {
                assignOrgNameMap.put(assignOrg.getLong("id"), assignOrg.getString(PROP_NAME));
            }
            for (Long assignOrgId : assignOrgIds) {
                if (orgIds.contains(assignOrgId) || assignOrgId.equals(0L)) continue;
                String orgName = (String)assignOrgNameMap.get(assignOrgId);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5f53\u524d\u65b9\u6848\u3002", (String)"AutoAssignFormPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]), orgName));
                return false;
            }
        }
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "batchadd": {
                EntryGrid planDetail = (EntryGrid)this.getView().getControl(PLAN_DETAIL);
                int[] selectRows = planDetail.getSelectRows();
                if (selectRows.length != 1) break;
                this.batchAddRow(planDetail, selectRows);
                break;
            }
            case "bar_assign": {
                String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
                Long filterConditionId = (Long)this.getModel().getDataEntity().getPkValue();
                this.sendAutoAssignTask(entityId, filterConditionId);
                break;
            }
            case "bar_viewresult": {
                this.viewAssignResult();
                break;
            }
        }
    }

    private void viewAssignResult() {
        AutoAssignService autoAssignService = new AutoAssignService();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        Long autoAssignPlanId = (Long)this.getModel().getDataEntity().getPkValue();
        ArrayList<Long> autoAssignPlanIdList = new ArrayList<Long>(10);
        autoAssignPlanIdList.add(autoAssignPlanId);
        Map planDetailMap = autoAssignService.getPlanDetailMap(autoAssignPlanIdList);
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bd_autoassign_result", (boolean)false);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setLookUp(true);
        parameter.setCustomParam(ENTITY_ID, (Object)entityId);
        parameter.setCustomParam(PLAN_DETAIL, new ArrayList(planDetailMap.keySet()));
        parameter.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u5206\u914d\u7ed3\u679c", (String)"AutoAssignFormPlugin_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        parameter.addCustPlugin("kd.bos.form.plugin.bdctrl.FilterConditionListPlugin");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void batchAddRow(EntryGrid planDetail, int[] selectRows) {
        DynamicObject[] rowDataArr = planDetail.getEntryData().getDataEntitys();
        int selectRowIndex = selectRows[0];
        DynamicObject rowData = rowDataArr[selectRowIndex];
        DynamicObject assignOrg = rowData.getDynamicObject(ASSIGN_ORG_ID);
        MulBasedataDynamicObjectCollection useOrgCol = (MulBasedataDynamicObjectCollection)rowData.get(USE_ORG);
        MulBasedataDynamicObjectCollection useOrgList = new MulBasedataDynamicObjectCollection();
        for (DynamicObject tempOrg : useOrgCol) {
            Object tempOrgId = tempOrg.get(BASE_DATA_ID);
            if (null == tempOrgId) continue;
            useOrgList.add(tempOrg);
        }
        String isConclude = rowData.getString(IS_CONCLUDE);
        String filterCondition = rowData.getString(FILTER_CONDITION);
        String filterSelect = rowData.getString(FILTER_SELECT);
        String useOrgFilter = rowData.getString(FILTER_SELECT_ORG);
        DynamicObject orgFilterScheme = rowData.getDynamicObject(ORG_FILTER_SCHEME);
        String remark = rowData.getString(REMARK);
        DynamicObjectCollection doc = this.getModel().getEntryEntity(PLAN_DETAIL);
        this.getModel().deleteEntryData(PLAN_DETAIL);
        this.getModel().batchCreateNewEntryRow(PLAN_DETAIL, rowDataArr.length);
        CloneUtils cloneUtils = new CloneUtils(true, true);
        int useOrgListSize = this.getUseOrgListSize(rowDataArr, selectRowIndex, useOrgList.size());
        long[] useOrgPKIds = DB.genGlobalLongIds((int)useOrgListSize);
        long[] ids = DB.genGlobalLongIds((int)rowDataArr.length);
        int j = 0;
        for (int i = 0; i < rowDataArr.length; ++i) {
            ((DynamicObject)doc.get(i)).set("id", (Object)ids[i]);
            if (i < selectRowIndex) {
                ((DynamicObject)doc.get(i)).set(ASSIGN_ORG_ID, rowDataArr[i].get(ASSIGN_ORG_ID));
                MulBasedataDynamicObjectCollection useOrgOldCol = (MulBasedataDynamicObjectCollection)rowDataArr[i].get(USE_ORG);
                MulBasedataDynamicObjectCollection tempUseOrg = new MulBasedataDynamicObjectCollection();
                for (DynamicObject useOrg : useOrgOldCol) {
                    DynamicObject tempOrg = (DynamicObject)cloneUtils.clone((IDataEntityBase)useOrg);
                    tempOrg.set(PK_ID, (Object)useOrgPKIds[j]);
                    tempOrg.set(BASE_DATA_ID, tempOrg.get(BASE_DATA_ID));
                    tempOrg.set(FBASEDATAID_ID, tempOrg.get(FBASEDATAID_ID));
                    tempUseOrg.add(tempOrg);
                    ++j;
                }
                ((DynamicObject)doc.get(i)).set(USE_ORG, (Object)tempUseOrg);
                ((DynamicObject)doc.get(i)).set(IS_CONCLUDE, rowDataArr[i].get(IS_CONCLUDE));
                ((DynamicObject)doc.get(i)).set(FILTER_CONDITION, rowDataArr[i].get(FILTER_CONDITION));
                ((DynamicObject)doc.get(i)).set(FILTER_SELECT, rowDataArr[i].get(FILTER_SELECT));
                ((DynamicObject)doc.get(i)).set(ORG_FILTER_SCHEME, rowDataArr[i].get(ORG_FILTER_SCHEME));
                ((DynamicObject)doc.get(i)).set(FILTER_SELECT_ORG, rowDataArr[i].get(FILTER_SELECT_ORG));
                ((DynamicObject)doc.get(i)).set(PREVIEW, (Object)AutoAssignFormPlugin.getPreviewMsg());
                ((DynamicObject)doc.get(i)).set(ORG_PREVIEW, (Object)AutoAssignFormPlugin.getPreviewMsg());
                ((DynamicObject)doc.get(i)).set(REMARK, rowDataArr[i].get(REMARK));
                continue;
            }
            ((DynamicObject)doc.get(i)).set(ASSIGN_ORG_ID, (Object)assignOrg);
            MulBasedataDynamicObjectCollection tempUseOrg = new MulBasedataDynamicObjectCollection();
            for (DynamicObject useOrg : useOrgList) {
                DynamicObject tempOrg = (DynamicObject)cloneUtils.clone((IDataEntityBase)useOrg);
                tempOrg.set(PK_ID, (Object)useOrgPKIds[j]);
                tempOrg.set(BASE_DATA_ID, tempOrg.get(BASE_DATA_ID));
                tempOrg.set(FBASEDATAID_ID, tempOrg.get(FBASEDATAID_ID));
                ++j;
                tempUseOrg.add(tempOrg);
            }
            ((DynamicObject)doc.get(i)).set(USE_ORG, (Object)tempUseOrg);
            ((DynamicObject)doc.get(i)).set(IS_CONCLUDE, (Object)isConclude);
            ((DynamicObject)doc.get(i)).set(FILTER_CONDITION, (Object)filterCondition);
            ((DynamicObject)doc.get(i)).set(FILTER_SELECT, (Object)filterSelect);
            ((DynamicObject)doc.get(i)).set(ORG_FILTER_SCHEME, (Object)orgFilterScheme);
            ((DynamicObject)doc.get(i)).set(FILTER_SELECT_ORG, (Object)useOrgFilter);
            ((DynamicObject)doc.get(i)).set(PREVIEW, (Object)AutoAssignFormPlugin.getPreviewMsg());
            ((DynamicObject)doc.get(i)).set(ORG_PREVIEW, (Object)AutoAssignFormPlugin.getPreviewMsg());
            ((DynamicObject)doc.get(i)).set(REMARK, (Object)remark);
        }
        this.getModel().updateEntryCache(doc);
        this.getView().updateView(PLAN_DETAIL);
        this.getView().sendFormAction(this.getView());
    }

    private int getUseOrgListSize(DynamicObject[] rowDataArr, int selectRowIndex, int selectRowUseOrgSize) {
        int size = 0;
        for (int i = 0; i < rowDataArr.length; ++i) {
            if (i > selectRowIndex) {
                size += selectRowUseOrgSize;
                continue;
            }
            MulBasedataDynamicObjectCollection useOrgOldCol = (MulBasedataDynamicObjectCollection)rowDataArr[i].get(USE_ORG);
            size += useOrgOldCol.size();
        }
        return size == 0 ? 1 : size;
    }

    private void sendAutoAssignTask(String entityId, Long autoAssignPlanId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName("autoAssign job");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.bos.bd.task.AutoAssignJobTask");
        jobInfo.setRunByLang(Lang.get());
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(ENTITY_ID, entityId);
        params.put(AUTO_ASSIGN_PLAN_ID, new Object[]{autoAssignPlanId});
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TASK_CLOSE_CALL_BACK);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"AutoAssignFormPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.bos.bd.task.AutoAssignTaskClick");
        jobFormInfo.setParentPageId(this.getView().getPageId());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int clickIndex = evt.getRowIndex();
        EntryGrid planDetail = (EntryGrid)evt.getSource();
        DynamicObject[] rowDataArr = planDetail.getEntryData().getDataEntitys();
        DynamicObject rowData = rowDataArr[clickIndex];
        Long filterCondition = rowData.getLong(FILTER_CONDITION);
        DynamicObject orgFilterScheme = rowData.getDynamicObject(ORG_FILTER_SCHEME);
        Long assignOrgId = this.getAssignOrgId(rowData);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        if (FILTER_SELECT.equalsIgnoreCase(evt.getFieldName())) {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityId);
            String title = met.getDisplayName().getLocaleValue();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bd_filtercondition_set");
            parameter.setCustomParam(USE_ORG_ID, (Object)this.getUseOrgId());
            parameter.setCustomParam(ROW_INDEX, (Object)clickIndex);
            parameter.setCustomParam(FILTER_CONDITION, (Object)filterCondition);
            parameter.setCustomParam(ENTITY_NUMBER, (Object)entityId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(String.format(ResManager.loadKDString((String)"\u5206\u914d\u8fc7\u6ee4\u65b9\u6848(%s)", (String)"AutoAssignFormPlugin_16", (String)SYSTEM_TYPE, (Object[])new Object[0]), title));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RETURN_CALLBACK_ID));
            Object enable = this.getModel().getValue(ENABLE);
            if (TRUE_VALUE.equals(enable)) {
                parameter.setCustomParam(BILL_STATUS, (Object)"view");
            }
            this.getView().showForm(parameter);
        } else if (PREVIEW.equalsIgnoreCase(evt.getFieldName())) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)entityId, (boolean)true);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setLookUp(true);
            if (filterCondition == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"AutoAssignFormPlugin_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            List<QFilter> qFilters = this.getConditionQFilters(entityId, filterCondition, assignOrgId);
            parameter.getListFilterParameter().setQFilters(qFilters);
            parameter.setMultiSelect(false);
            parameter.addCustPlugin("kd.bos.form.plugin.bdctrl.FilterConditionListPlugin");
            parameter.setUseOrgId(assignOrgId.longValue());
            this.getView().showForm((FormShowParameter)parameter);
        } else if (FILTER_SELECT_ORG.equals(evt.getFieldName())) {
            if (0L == assignOrgId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u914d\u7ec4\u7ec7\u3002", (String)"AutoAssignFormPlugin_24", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityId);
            String title = met.getDisplayName().getLocaleValue();
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setBillStatus(BillOperationStatus.EDIT);
            parameter.setFormId(ENTITY_ORG_FILTER_SCHEME);
            parameter.setCustomParam(ASSIGN_ORG_ID, (Object)assignOrgId);
            parameter.setCustomParam(ENTITY_NUMBER, (Object)entityId);
            parameter.setCustomParam(ORG_FILTER_SCHEME, (Object)(null == orgFilterScheme ? "-1" : orgFilterScheme.getPkValue().toString()));
            Object ctrlStrtgy = this.getModel().getValue("ctrlstrategy");
            parameter.setCustomParam(PARAM_CTRL_STRATEGY, ctrlStrtgy);
            this.getPageCache().put(CACHE_CLICK_INDEX, String.valueOf(clickIndex));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCaption(String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\uff08%s\uff09", (String)"AutoAssignFormPlugin_23", (String)SYSTEM_TYPE, (Object[])new Object[0]), title));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RETURN_ORG_CALLBACK_ID));
            Object enable = this.getModel().getValue(ENABLE);
            if (TRUE_VALUE.equals(enable)) {
                parameter.setCustomParam(BILL_STATUS, (Object)"view");
            }
            this.getView().showForm((FormShowParameter)parameter);
        } else if (ORG_PREVIEW.equals(evt.getFieldName())) {
            if (null == orgFilterScheme) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"AutoAssignFormPlugin_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)false);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setLookUp(true);
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
            if (null == ctrlView) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u57fa\u7840\u8d44\u6599\u63a7\u5236\u89c6\u56fe\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u914d\u7f6e\u3002", (String)"AutoAssignFormPlugin_25", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            String viewNumber = ctrlView.getString("number");
            parameter.setCustomParam("orgViewSchemeNumber", (Object)viewNumber);
            ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
            if (null == listFilterParameter) {
                listFilterParameter = new ListFilterParameter();
            }
            boolean includeSub = rowData.getBoolean(IS_CONCLUDE);
            listFilterParameter.setQFilters(this.getUseOrgQFilters(entityId, orgFilterScheme, assignOrgId, includeSub));
            parameter.setListFilterParameter(listFilterParameter);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private Long getAssignOrgId(DynamicObject rowData) {
        long assignOrgId = rowData.get(ASSIGN_ORG_ID) instanceof DynamicObject ? ((DynamicObject)rowData.get(ASSIGN_ORG_ID)).getLong("id") : (rowData.get(ASSIGN_ORG_ID) instanceof Long ? Long.parseLong(rowData.get(ASSIGN_ORG_ID).toString()) : 0L);
        return assignOrgId;
    }

    private List<QFilter> getConditionQFilters(String entityId, Long filterCondition, Long assignOrgId) {
        Object ctrlStrategy;
        QFilter useRangeQFilter;
        FilterCondition condition;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        String selectProperties = "id, name, filterCondition";
        DynamicObject filterConditionObj = QueryServiceHelper.queryOne((String)ENTITY_FILTER_CONDITION, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)filterCondition)});
        String filterStr = null;
        if (filterConditionObj != null) {
            filterStr = filterConditionObj.getString(FILTER_CONDITION);
        }
        FilterCondition filterCondition2 = condition = StringUtils.isEmpty(filterStr) ? null : (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        if (condition != null) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityId);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
            filterBuilder.buildFilter();
            qFilters.add(filterBuilder.getQFilter());
        }
        if (0L != assignOrgId && null != (useRangeQFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)assignOrgId))) {
            qFilters.add(useRangeQFilter);
        }
        if (null != (ctrlStrategy = this.getModel().getValue("ctrlstrategy"))) {
            qFilters.add(new QFilter("ctrlstrategy", "=", ctrlStrategy));
            if (ctrlStrategy.equals("2")) {
                String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
                qFilters.add(new QFilter("createorg", "=", (Object)assignOrgId));
                qFilters.add(QFilter.of((String)("id = " + masterIdPropName), (Object[])new Object[0]));
            }
        }
        qFilters.add(new QFilter(STATUS, "=", (Object)"C"));
        return qFilters;
    }

    private List<QFilter> getUseOrgQFilters(String entityId, DynamicObject orgFilterScheme, Long assignOrgId, boolean includeSub) {
        DynamicObject ctrlView;
        String filterConditionStr;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        DynamicObjectCollection orgEntry = orgFilterScheme.getDynamicObjectCollection("entryentity");
        List selectedOrgIds = orgEntry.stream().map(v -> v.getLong("selectedorg.id")).collect(Collectors.toList());
        QFilter schemeFilter = null;
        if (!CollectionUtils.isEmpty(selectedOrgIds)) {
            schemeFilter = new QFilter("id", "in", selectedOrgIds);
        }
        if (StringUtils.isNotBlank((CharSequence)(filterConditionStr = orgFilterScheme.getString("filtercondition")))) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"bos_org");
            FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter filter = filterBuilder.getQFilter();
            if (null != filter) {
                QFilter qFilter = schemeFilter = schemeFilter == null ? filter : schemeFilter.or(filter);
            }
        }
        if (null == (ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId))) {
            qFilters.add(new QFilter(TRUE_VALUE, "=", (Object)0));
            return qFilters;
        }
        Long viewId = (Long)ctrlView.getPkValue();
        if (null != schemeFilter) {
            DynamicObjectCollection schemeOrgs;
            if (includeSub && !CollectionUtils.isEmpty((Collection)(schemeOrgs = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{schemeFilter})))) {
                List schemeOrgIds = schemeOrgs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                List includeSubOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, schemeOrgIds, (boolean)true);
                schemeFilter = new QFilter("id", "in", (Object)includeSubOrgIds);
            }
        } else {
            qFilters.add(new QFilter(TRUE_VALUE, "=", (Object)0));
            return qFilters;
        }
        qFilters.add(schemeFilter);
        qFilters.add(new QFilter(ENABLE, "=", (Object)Boolean.TRUE));
        String ctrlStrategy = (String)this.getModel().getValue("ctrlstrategy");
        QFilter joinFilter = QFilter.of((String)"bos_org_structure.view = ?", (Object[])new Object[]{viewId}).and("bos_org_structure.isctrlunit", "=", (Object)Boolean.TRUE).and("bos_org_structure.isfreeze", "=", (Object)Boolean.FALSE);
        qFilters.add(QFilter.join((String)"id", (String)"bos_org_structure.org", (QFilter)joinFilter));
        if (TRUE_VALUE.equals(ctrlStrategy)) {
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, Collections.singletonList(assignOrgId), (boolean)false);
            qFilters.add(new QFilter("id", "in", (Object)subOrgIds));
        }
        return qFilters;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (RETURN_CALLBACK_ID.equals(closedCallBackEvent.getActionId())) {
            Object returnData2 = closedCallBackEvent.getReturnData();
            if (returnData2 instanceof FormShowParameter) {
                FormShowParameter formShowParameter = (FormShowParameter)returnData2;
                Long filterConditionId = (Long)formShowParameter.getCustomParam(FILTER_CONDITION);
                int rowIndex = (Integer)formShowParameter.getCustomParam(ROW_INDEX);
                String filterConditionName = this.getFilterConditionName(filterConditionId);
                DynamicObjectCollection doc = this.getModel().getEntryEntity(PLAN_DETAIL);
                ((DynamicObject)doc.get(rowIndex)).set(FILTER_SELECT, (Object)filterConditionName);
                ((DynamicObject)doc.get(rowIndex)).set(FILTER_CONDITION, (Object)filterConditionId);
                this.getModel().updateEntryCache(doc);
                this.getView().updateView(PLAN_DETAIL);
            }
            this.reloadFilterConditionName();
            return;
        }
        if (RETURN_ORG_CALLBACK_ID.equals(closedCallBackEvent.getActionId())) {
            returnData = closedCallBackEvent.getReturnData();
            String indexStr = this.getPageCache().get(CACHE_CLICK_INDEX);
            if (StringUtils.isEmpty((CharSequence)indexStr)) {
                this.reloadOrgFilterSchemeName();
                return;
            }
            int clickIndex = Integer.parseInt(indexStr);
            DynamicObjectCollection doc = this.getModel().getEntryEntity(PLAN_DETAIL);
            if (returnData instanceof DynamicObject && doc.size() > clickIndex) {
                DynamicObject orgFilterScheme = (DynamicObject)returnData;
                ((DynamicObject)doc.get(clickIndex)).set(ORG_FILTER_SCHEME, (Object)orgFilterScheme);
                this.getModel().updateEntryCache(doc);
                this.getView().updateView(PLAN_DETAIL);
            }
            this.reloadOrgFilterSchemeName();
        }
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)TASK_CLOSE_CALL_BACK) && null != (returnData = closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210\u3002", (String)"AutoAssignFormPlugin_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            IFormView iFormView = closedCallBackEvent.getView();
            if (null != iFormView) {
                iFormView.close();
            }
        }
    }

    private void reloadFilterConditionName() {
        DynamicObjectCollection planDetails = this.getModel().getEntryEntity(PLAN_DETAIL);
        if (!planDetails.isEmpty()) {
            List<Long> conditionIds = planDetails.stream().filter(planDetail -> 0L != planDetail.getLong(FILTER_CONDITION)).map(planDetail -> planDetail.getLong(FILTER_CONDITION)).collect(Collectors.toList());
            Map<Long, String> filterIdNameMap = this.getFilterIdNameMap(conditionIds);
            for (DynamicObject planDetail2 : planDetails) {
                if (0L == planDetail2.getLong(FILTER_CONDITION)) continue;
                String filterConditionName = filterIdNameMap.get(planDetail2.getLong(FILTER_CONDITION));
                planDetail2.set(FILTER_SELECT, (Object)filterConditionName);
            }
            this.getModel().updateEntryCache(planDetails);
            this.getView().updateView(PLAN_DETAIL);
        }
    }

    private void reloadOrgFilterSchemeName() {
        DynamicObjectCollection planDetails = this.getModel().getEntryEntity(PLAN_DETAIL);
        Iterator iterator = planDetails.iterator();
        while (iterator.hasNext()) {
            DynamicObject planDetail;
            DynamicObject orgFilterScheme = (planDetail = (DynamicObject)iterator.next()).getDynamicObject(ORG_FILTER_SCHEME);
            planDetail.set(FILTER_SELECT_ORG, (Object)(null == orgFilterScheme ? AutoAssignFormPlugin.getSelectPlanMsg() : orgFilterScheme.getString(PROP_NAME)));
        }
        this.getModel().updateEntryCache(planDetails);
        this.getView().updateView(PLAN_DETAIL);
    }

    private Map<Long, String> getFilterIdNameMap(List<Long> conditionIds) {
        DynamicObjectCollection filterConditions = QueryServiceHelper.query((String)ENTITY_FILTER_CONDITION, (String)AutoAssignFormPlugin.getSelectField("id", PROP_NAME), (QFilter[])new QFilter[]{new QFilter("id", "in", conditionIds)});
        return filterConditions.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getString(PROP_NAME)));
    }

    private String getFilterConditionName(Object filterConditionId) {
        DynamicObjectCollection filterCondition = QueryServiceHelper.query((String)ENTITY_FILTER_CONDITION, (String)AutoAssignFormPlugin.getSelectField("id", PROP_NAME), (QFilter[])new QFilter[]{new QFilter("id", "=", filterConditionId)});
        return filterCondition.isEmpty() ? null : String.valueOf(((DynamicObject)filterCondition.get(0)).get(PROP_NAME));
    }

    private String getAppId() {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)"bd_autoassign");
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appId = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appId = met.getAppId();
            }
        }
        return appId;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.getValue() == status.getValue() || FALSE_VALUE.equals(this.getModel().getValue(ENABLE))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{ADD_ROW, DEL_ROW, ITEM_BATCH_ADD, FILTER_SELECT});
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_ASSIGN});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{ADD_ROW, DEL_ROW, ITEM_BATCH_ADD, FILTER_SELECT});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_ASSIGN});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (DISABLE.equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{ADD_ROW, DEL_ROW, ITEM_BATCH_ADD, FILTER_SELECT});
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_ASSIGN});
            return;
        }
        if (ENABLE.equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ADD_ROW, DEL_ROW, ITEM_BATCH_ADD, FILTER_SELECT});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_ASSIGN});
        }
        if (NEW_ENTRY.equals(args.getOperateKey())) {
            DynamicObjectCollection doc = this.getModel().getEntryEntity(PLAN_DETAIL);
            if (doc.isEmpty()) {
                return;
            }
            int lastRow = doc.size() - 1;
            ((DynamicObject)doc.get(lastRow)).set(FILTER_SELECT, (Object)AutoAssignFormPlugin.getSelectPlanMsg());
            ((DynamicObject)doc.get(lastRow)).set(FILTER_SELECT_ORG, (Object)AutoAssignFormPlugin.getSelectPlanMsg());
            ((DynamicObject)doc.get(lastRow)).set(PREVIEW, (Object)AutoAssignFormPlugin.getPreviewMsg());
            ((DynamicObject)doc.get(lastRow)).set(ORG_PREVIEW, (Object)AutoAssignFormPlugin.getPreviewMsg());
            this.getModel().updateEntryCache(doc);
            this.getView().updateView(PLAN_DETAIL);
            this.getView().sendFormAction(this.getView());
        }
    }

    private static String getSelectPlanMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8fc7\u6ee4\u65b9\u6848", (String)"AutoAssignFormPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String property = event.getProperty().getName();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        if (ASSIGN_ORG_ID.equalsIgnoreCase(property)) {
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
            String orgViewNumber = null == ctrlView ? "16" : ctrlView.getString("number");
            event.getFormShowParameter().setCustomParam("orgViewSchemeNumber", (Object)orgViewNumber);
            List<QFilter> qFilters = this.getBaseDataViewPermOrgFilters();
            event.setCustomQFilters(qFilters);
            return;
        }
        if (USE_ORG.equalsIgnoreCase(property)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            AutoAssignService autoAssignService = new AutoAssignService();
            String ctrlStrategy = (String)this.getModel().getValue("ctrlstrategy");
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
            String orgViewNumber = null == ctrlView ? "16" : ctrlView.getString("number");
            event.getFormShowParameter().setCustomParam("orgViewSchemeNumber", (Object)orgViewNumber);
            long viewId = null == ctrlView ? 16L : ctrlView.getLong("id");
            int row = event.getRow();
            EntryGrid planDetail = (EntryGrid)this.getControl(PLAN_DETAIL);
            DynamicObject[] rowDataArr = planDetail.getEntryData().getDataEntitys();
            DynamicObject rowData = rowDataArr[row];
            DynamicObject assignOrg = (DynamicObject)rowData.get(ASSIGN_ORG_ID);
            if (TRUE_VALUE.equals(ctrlStrategy)) {
                if (null == assignOrg) {
                    return;
                }
                Long assignOrgId = assignOrg.getLong("id");
                List<Long> assignOrgIds = Collections.singletonList(assignOrgId);
                List subordinateOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, assignOrgIds, (boolean)false);
                List cuOrgIds = autoAssignService.getCuOrgIds(Long.valueOf(viewId), subordinateOrgIds);
                qFilters.add(new QFilter("id", "in", (Object)cuOrgIds));
            } else {
                long assignOrgId = Optional.ofNullable(assignOrg).orElseGet(() -> BusinessDataServiceHelper.newDynamicObject((String)"bos_org")).getLong("id");
                QFilter orgIdFilter = this.getOrgIdFilter(entityId, null);
                qFilters.add(new QFilter("id", "!=", (Object)assignOrgId));
                qFilters.add(orgIdFilter);
            }
            event.setCustomQFilters(qFilters);
        }
    }

    private List<QFilter> getBaseDataViewPermOrgFilters() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        String appId = this.getAppId();
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"", (boolean)false, (String)appId, (String)entityId, (String)QUERY_PERM);
        if (null == hasPermOrgResult) {
            qFilters.add(new QFilter(TRUE_VALUE, "!=", (Object)1));
            return qFilters;
        }
        QFilter orgIdFilter = this.getOrgIdFilter(entityId, hasPermOrgResult);
        qFilters.add(orgIdFilter);
        return qFilters;
    }

    private QFilter getOrgIdFilter(String entityId, HasPermOrgResult result) {
        Set<Long> viewOrgIds = AutoAssignFormPlugin.getViewOrgIds(entityId, result);
        return new QFilter("id", "in", viewOrgIds);
    }

    @NotNull
    private static Set<Long> getViewOrgIds(String entityId, HasPermOrgResult result) {
        QFilter[] qFilters;
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        long view = null == ctrlView ? 16L : ctrlView.getLong("id");
        QFilter viewFilter = new QFilter(VIEW_ID, "=", (Object)view);
        QFilter isCtrlUnitFilter = new QFilter(FIELD_IS_CTRL_UNIT, "=", (Object)Boolean.TRUE);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)Boolean.TRUE);
        if (null == result || result.hasAllOrgPerm()) {
            qFilters = new QFilter[]{viewFilter, isCtrlUnitFilter, enableFilter};
        } else {
            QFilter idsFilter = new QFilter(FIELD_ORG, "in", (Object)result.getHasPermOrgs());
            qFilters = new QFilter[]{viewFilter, isCtrlUnitFilter, enableFilter, idsFilter};
        }
        HashSet<Long> viewOrgIds = new HashSet<Long>(16);
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(BaseDataListPlugin.class.getName(), ENTITY_ORG_STRUCTURE, FIELD_ORG_ID, qFilters, "");){
            for (Row row : ds) {
                Long orgId = row.getLong(FIELD_ORG_ID);
                if (orgId == null) continue;
                viewOrgIds.add(orgId);
            }
        }
        return viewOrgIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeDataArr = e.getChangeSet();
        if ("ctrlstrategy".equals(property.getName()) && null != changeDataArr && changeDataArr.length > 0) {
            ChangeData change = Arrays.stream(changeDataArr).filter(changeData -> !changeData.getOldValue().equals(changeData.getNewValue())).findAny().orElse(null);
            DynamicObjectCollection doc = this.getModel().getEntryEntity(PLAN_DETAIL);
            if (null != change && !doc.isEmpty()) {
                String repealSetCtrlStrategy = this.getView().getPageCache().get(CLEAN_USE_ORG_CONFIRM);
                if (null != repealSetCtrlStrategy) {
                    this.getView().getPageCache().remove(CLEAN_USE_ORG_CONFIRM);
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5206\u914d\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u7a7a\u5206\u5f55\u4e0a\u7684\u4f7f\u7528\u7ec4\u7ec7\u4fe1\u606f\u3002\r\n\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"AutoAssignFormPlugin_22", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CLEAN_USE_ORG_CONFIRM, (IFormPlugin)this));
            }
        } else if (ASSIGN_ORG_ID.equalsIgnoreCase(property.getName())) {
            this.assignOrgPropChange(e);
        }
    }

    private void assignOrgPropChange(PropertyChangedArgs e) {
        ChangeData[] changeDataArr = e.getChangeSet();
        if (null == changeDataArr || changeDataArr.length == 0) {
            return;
        }
        for (ChangeData changeData : changeDataArr) {
            long newOrgId;
            int rowIndex = changeData.getRowIndex();
            DynamicObject oldOrg = (DynamicObject)changeData.getOldValue();
            DynamicObject newOrg = (DynamicObject)changeData.getNewValue();
            long oldOrgId = Optional.ofNullable(oldOrg).orElseGet(() -> BusinessDataServiceHelper.newDynamicObject((String)"bos_org")).getLong("id");
            if (oldOrgId == (newOrgId = Optional.ofNullable(newOrg).orElseGet(() -> BusinessDataServiceHelper.newDynamicObject((String)"bos_org")).getLong("id"))) continue;
            DynamicObjectCollection doc = this.getModel().getEntryEntity(PLAN_DETAIL);
            if (doc.isEmpty()) {
                return;
            }
            ((DynamicObject)doc.get(rowIndex)).set(USE_ORG, null);
            ((DynamicObject)doc.get(rowIndex)).set(ORG_FILTER_SCHEME, null);
            ((DynamicObject)doc.get(rowIndex)).set(FILTER_SELECT_ORG, (Object)AutoAssignFormPlugin.getSelectPlanMsg());
            for (DynamicObject entry : doc) {
                if ("".equals(entry.get(FILTER_SELECT))) {
                    entry.set(FILTER_SELECT, (Object)AutoAssignFormPlugin.getSelectPlanMsg());
                }
                if ("".equals(entry.get(FILTER_SELECT_ORG))) {
                    entry.set(FILTER_SELECT_ORG, (Object)AutoAssignFormPlugin.getSelectPlanMsg());
                }
                if ("".equals(entry.get(PREVIEW))) {
                    entry.set(PREVIEW, (Object)AutoAssignFormPlugin.getPreviewMsg());
                }
                if (!"".equals(entry.get(ORG_PREVIEW))) continue;
                entry.set(ORG_PREVIEW, (Object)AutoAssignFormPlugin.getPreviewMsg());
            }
            this.getModel().updateEntryCache(doc);
            this.getView().updateView(PLAN_DETAIL);
            this.getView().sendFormAction(this.getView());
        }
    }

    private static String getSelectField(String ... props) {
        StringJoiner stringJoiner = new StringJoiner(",");
        Stream.of(props).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }

    private static String getPreviewMsg() {
        return ResManager.loadKDString((String)"\u9884\u89c8", (String)"AutoAssignFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    private static String getAuditMsg() {
        return ResManager.loadKDString((String)"\u5ba1\u6838", (String)"AutoAssignFormPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    private static String getSaveMsg() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AutoAssignFormPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }
}

