/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.service.AutoAssignService;
import kd.bos.bd.validator.AutoAssignValidator;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.bdctrl.BaseDataListPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class AutoAssignListPlugin
extends AbstractListPlugin {
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String BAR_ASSIGN = "bar_assign";
    private static final String USE_ORG_ID = "useOrgId";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String ENTITY_ID = "entityId";
    private static final String APP_ID = "appId";
    private static final String CUSTOM_FILTER = "customfilter";
    private static final String FIELD_NAME = "FieldName";
    private static final String BILL_LIST = "billListAp";
    private static final String ORG_ID = "org.id";
    private static final String TBL_ASSIGN = "tbl_assign";
    private static final String ENABLE = "enable";
    private static final String STRUCTURE_ENABLE = "structure.viewenable";
    private static final String TASK_CLOSE_CALL_BACK = "taskCloseCallBack";
    private static final String AUTO_ASSIGN_PLAN_ID = "autoAssignPlanId";
    private static final String PLAN_DETAIL = "plandetail";
    private CommonFilterColumn filterColumn;
    private static final String VALUE = "Value";
    private static final String STRUCTURE_VIEW_ID = "structure.view.id";
    private static final String STRUCTURE_IS_CTRL_UNIT = "structure.isctrlunit";
    private static final String ORG_ENTITY = "bos_org";
    private List<Map<String, String>> allOrgList = new ArrayList<Map<String, String>>(10);
    private static final String ORG_VIEW_NUMBER = "orgViewSchemeNumber";

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFilterList = (List)filterValues.get(CUSTOM_FILTER);
        if (customFilterList == null) {
            return;
        }
        Iterator iterator = customFilterList.iterator();
        while (iterator.hasNext()) {
            Map customFilter = (Map)iterator.next();
            List fieldNames = (List)customFilter.get(FIELD_NAME);
            if (fieldNames == null || fieldNames.isEmpty()) continue;
            String customFilterSer = SerializationUtils.toJsonString((Object)customFilterList);
            this.getPageCache().putBigObject(CUSTOM_FILTER, customFilterSer);
            if (!ORG_ID.equals(fieldNames.get(0))) continue;
            iterator.remove();
            if (this.filterColumn == null) {
                return;
            }
            List value = (List)customFilter.get(VALUE);
            if (value.size() == 1) {
                this.filterColumn.setDefaultValue(value.get(0).toString());
                continue;
            }
            this.filterColumn.setDefaultValues(value);
        }
        super.filterContainerSearchClick(args);
    }

    public void setFilter(SetFilterEvent e) {
        List orgIdList;
        super.setFilter(e);
        String customFilterSer = this.getPageCache().getBigObject(CUSTOM_FILTER);
        if (null != customFilterSer) {
            List customFilterList = (List)SerializationUtils.fromJsonString((String)customFilterSer, ArrayList.class);
            this.addCustomerFilter(e, customFilterList);
        }
        if (!CollectionUtils.isEmpty(orgIdList = e.getQFilters().stream().filter(qFilter -> ORG_ID.equals(qFilter.getProperty())).map(QFilter::getValue).collect(Collectors.toList())) && orgIdList.get(0) instanceof List) {
            List orgFilterIds = (List)orgIdList.get(0);
            QFilter autoAssignFilter = this.getAutoAssignFilter(orgFilterIds);
            e.getQFilters().add(autoAssignFilter);
            List orgIds = orgFilterIds.stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
            ((AbstractListView)this.getView()).setSelectedMainOrgIds(orgIds);
        }
        e.getQFilters().removeIf(filter -> filter.getProperty().equals(ORG_ID));
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        e.addCustomQFilter(new QFilter(ENTITY_ID, "=", (Object)entityId));
    }

    private void addCustomerFilter(SetFilterEvent e, List<Map<String, List<Object>>> customFilterList) {
        for (Map<String, List<Object>> customFilter : customFilterList) {
            List<Object> fieldNames = customFilter.get(FIELD_NAME);
            if (CollectionUtils.isEmpty(fieldNames) || !ORG_ID.equals(fieldNames.get(0))) continue;
            List<Object> orgFilterIds = customFilter.get(VALUE);
            if (orgFilterIds.size() == 1 && StringUtils.isEmpty((CharSequence)orgFilterIds.get(0).toString()) || CollectionUtils.isEmpty(orgFilterIds)) break;
            QFilter autoAssignFilter = this.getAutoAssignFilter(orgFilterIds);
            e.getQFilters().add(autoAssignFilter);
            List orgIds = orgFilterIds.stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
            ((AbstractListView)this.getView()).setSelectedMainOrgIds(orgIds);
        }
    }

    private QFilter getAutoAssignFilter(List<Object> orgFilterIds) {
        ArrayList orgIds = new ArrayList(orgFilterIds.size());
        orgFilterIds.forEach(orgId -> orgIds.add(Long.valueOf(orgId.toString())));
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid from t_bd_autoAssign_assignOrg where ", new Object[0]);
        sqlBuilder.appendIn("fAssignOrgId", new ArrayList(orgIds));
        List autoAssignIds = (List)DB.query((DBRoute)DBRoute.base, (SqlBuilder)sqlBuilder, resultSet -> {
            ArrayList<Long> ids = new ArrayList<Long>(10);
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            return ids;
        });
        return new QFilter("id", "in", (Object)autoAssignIds);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if (CollectionUtils.isEmpty(this.allOrgList)) {
            this.allOrgList = this.getAllOrgList();
        }
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterCol : filterColumnList) {
            if (!ORG_ID.equals(filterCol.getFieldName())) continue;
            CommonFilterColumn orgColumn = (CommonFilterColumn)filterCol;
            orgColumn.setEntityField(false);
            List<ComboItem> combos = this.getComboItems();
            orgColumn.setComboItems(combos);
            this.filterColumn = orgColumn;
        }
    }

    private List<ComboItem> getComboItems() {
        if (null == this.allOrgList) {
            return new ArrayList<ComboItem>(1);
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(this.allOrgList.size());
        for (Map<String, String> orgMap : this.allOrgList) {
            if (orgMap == null) continue;
            String orgId = orgMap.get("id");
            String name = orgMap.get("name");
            combos.add(new ComboItem(new LocaleString(name), orgId));
        }
        return combos;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey().toLowerCase();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        HashSet<String> itemKeys = new HashSet<String>(Collections.singletonList(TBL_ASSIGN));
        if (itemKeys.contains(itemKey) && rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AutoAssignListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (TBL_ASSIGN.equals(itemKey)) {
            Object[] autoAssignPlanPks = rows.getPrimaryKeyValues();
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
            ArrayList autoAssignPlanIds = new ArrayList(autoAssignPlanPks.length);
            Arrays.stream(autoAssignPlanPks).forEach(autoAssignPlanPk -> autoAssignPlanIds.add(Long.valueOf(autoAssignPlanPk.toString())));
            DynamicObjectCollection autoAssignPlans = new AutoAssignService().getAutoAssignPlanById(autoAssignPlanIds);
            for (DynamicObject autoAssignPlan : autoAssignPlans) {
                if (null == autoAssignPlan || !Boolean.FALSE.equals(autoAssignPlan.getBoolean(ENABLE))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u518d\u6267\u884c\u7acb\u5373\u5206\u914d\u3002", (String)"AutoAssignListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            boolean isAssignDataBeyondMaxNum = new AutoAssignValidator().isAssignDataBeyondMaxNum(entityId, autoAssignPlanIds);
            if (isAssignDataBeyondMaxNum) {
                this.getView().showErrorNotification(AutoAssignValidator.getErrorMsgOfBeyondMaxAssignNum());
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey().toLowerCase();
        if (TBL_ASSIGN.equals(itemKey)) {
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            ListSelectedRowCollection rows = billList.getSelectedRows();
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
            this.sendAutoAssignTask(entityId, rows.getPrimaryKeyValues());
            return;
        }
        if ("tbl_viewresult".equals(itemKey)) {
            this.viewAssignResult();
        }
    }

    private void viewAssignResult() {
        AutoAssignService autoAssignService = new AutoAssignService();
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bd_autoassign_result", (boolean)false);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        ArrayList autoAssignPlanIdList = new ArrayList(rows.size());
        if (!rows.isEmpty()) {
            Arrays.stream(rows.getPrimaryKeyValues()).forEach(planId -> autoAssignPlanIdList.add(Long.valueOf(planId.toString())));
            Map planDetailMap = autoAssignService.getPlanDetailMap(autoAssignPlanIdList);
            parameter.setCustomParam(PLAN_DETAIL, new ArrayList(planDetailMap.keySet()));
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setLookUp(true);
        parameter.setCustomParam(ENTITY_ID, (Object)entityId);
        parameter.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u5206\u914d\u7ed3\u679c", (String)"AutoAssignFormPlugin_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        parameter.addCustPlugin("kd.bos.form.plugin.bdctrl.FilterConditionListPlugin");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        Long useOrgID = this.getUseOrgId();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(APP_ID);
        param.setCustomParam(USE_ORG_ID, (Object)useOrgID);
        param.setCustomParam(ENTITY_NUMBER, (Object)entityId);
        param.setCustomParam(APP_ID, (Object)appId);
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityId);
        String title = met.getDisplayName().getLocaleValue();
        param.setCaption(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u914d\u7ba1\u7406(%s)", (String)"AutoAssignListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), title));
    }

    private Long getUseOrgId() {
        Long useOrgId = null;
        Object orgId = this.getView().getFormShowParameter().getCustomParam(USE_ORG_ID);
        if (orgId instanceof Integer || orgId instanceof Long) {
            useOrgId = Long.valueOf(orgId.toString());
        }
        return useOrgId;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BAR_ASSIGN});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)TASK_CLOSE_CALL_BACK) && null != (returnData = closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210\u3002", (String)"AutoAssignListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            IFormView iFormView = closedCallBackEvent.getView();
            if (null != iFormView) {
                iFormView.close();
            }
        }
    }

    private void sendAutoAssignTask(String entityId, Object[] autoAssignPlanIds) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName("autoAssign job");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.bos.bd.task.AutoAssignJobTask");
        jobInfo.setRunByLang(Lang.get());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ENTITY_ID, entityId);
        params.put(AUTO_ASSIGN_PLAN_ID, autoAssignPlanIds);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TASK_CLOSE_CALL_BACK);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"AutoAssignListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.bos.bd.task.AutoAssignTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private List<Map<String, String>> getAllOrgList() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        long view = null == ctrlView ? 16L : ctrlView.getLong("id");
        ORM ormOV = ORM.create();
        ArrayList<Map<String, String>> orgListMap = new ArrayList<Map<String, String>>(5000);
        QFilter viewFilter = new QFilter(STRUCTURE_VIEW_ID, "=", (Object)view);
        QFilter enableFilter = new QFilter(STRUCTURE_ENABLE, "=", (Object)Boolean.TRUE);
        QFilter ctrlUnitFilter = new QFilter(STRUCTURE_IS_CTRL_UNIT, "=", (Object)Boolean.TRUE);
        QFilter[] qFilters = new QFilter[]{viewFilter, enableFilter, ctrlUnitFilter};
        try (DataSet ds = ormOV.queryDataSet(BaseDataListPlugin.class.getName(), ORG_ENTITY, "id,name", qFilters);){
            for (Row row : ds) {
                String orgId = row.getString("id");
                String orgName = row.getString("name");
                HashMap<String, String> orgMap = new HashMap<String, String>(3);
                orgMap.put("id", orgId);
                orgMap.put("name", orgName);
                orgListMap.add(orgMap);
            }
        }
        return orgListMap;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (!ORG_ID.equals(fieldName)) {
            return;
        }
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        if (null != ctrlView) {
            args.getCustomParams().put(ORG_VIEW_NUMBER, ctrlView.getString("number"));
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        if (CollectionUtils.isEmpty(this.allOrgList)) {
            this.allOrgList = this.getAllOrgList();
        }
        ArrayList orgIds = new ArrayList(this.allOrgList.size());
        this.allOrgList.forEach(map -> orgIds.add(Long.valueOf((String)map.get("id"))));
        filterList.add(new QFilter("id", "in", orgIds));
        List f7SelectFilters = args.getQfilters();
        if (f7SelectFilters == null) {
            args.setQfilters(filterList);
        } else {
            f7SelectFilters.addAll(filterList);
        }
    }
}

