/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class AutoAssignResultListPlugin
extends AbstractListPlugin {
    private static final String PLAN_DETAIL = "plandetail";
    private static final String ENTITY_ID = "entityId";
    private static final String PLAN_DETAIL_ID = "planDetailId";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List planDetailIds = (List)formShowParameter.getCustomParam(PLAN_DETAIL);
        String entityId = (String)formShowParameter.getCustomParam(ENTITY_ID);
        ArrayList<QFilter> customerFilters = new ArrayList<QFilter>(2);
        if (!CollectionUtils.isEmpty((Collection)planDetailIds)) {
            customerFilters.add(new QFilter(PLAN_DETAIL_ID, "in", (Object)planDetailIds));
        }
        if (null != entityId) {
            customerFilters.add(new QFilter(ENTITY_ID, "=", (Object)entityId));
        }
        if (!customerFilters.isEmpty()) {
            e.setCustomQFilters(customerFilters);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("viewdetail".equals(operateKey)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String entityId = (String)formShowParameter.getCustomParam(ENTITY_ID);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            Object[] ids = rows.getPrimaryKeyValues();
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
            DynamicObjectCollection assignResults = QueryServiceHelper.query((String)"bd_autoassign_result", (String)"id,plandetailid,entityid", (QFilter[])filters);
            List planDetails = assignResults.stream().map(assignResult -> assignResult.getLong(PLAN_DETAIL_ID)).collect(Collectors.toList());
            QFilter[] logFilters = new QFilter[]{new QFilter("operatsourceid", "in", planDetails)};
            DynamicObjectCollection logs = QueryServiceHelper.query((String)"bd_log", (String)"id", (QFilter[])logFilters, (String)"operattime desc", (int)1);
            if (!logs.isEmpty()) {
                BaseShowParameter baseShowParameter = new BaseShowParameter();
                baseShowParameter.setFormId("bd_log");
                baseShowParameter.setPkId((Object)((DynamicObject)logs.get(0)).getLong("id"));
                baseShowParameter.setStatus(OperationStatus.EDIT);
                baseShowParameter.setCustomParam(ENTITY_ID, (Object)entityId);
                ShowType viewShowType = FormMetadataCache.getFormConfig((String)entityId).getViewShowType();
                baseShowParameter.getOpenStyle().setShowType(viewShowType);
                this.getView().showForm((FormShowParameter)baseShowParameter);
            }
        }
    }
}

