/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class BaseDataBitQueryPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(BaseDataBitQueryPlugin.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"query"});
        this.addClickListeners(new String[]{"btnclearcache"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("query".equals(control.getKey())) {
            this.queryBit();
        } else if ("btnclearcache".equals(control.getKey())) {
            Object entity = this.getModel().getValue("entity");
            Object object = this.getModel().getValue("org");
            if (null == object || null == entity) {
                return;
            }
            DynamicObject org = (DynamicObject)object;
            Long orgId = (Long)org.getPkValue();
            BaseDataUseRelUpdateEngine.removeRelBitCache((String)entity.toString(), (Long)orgId);
            this.getView().showSuccessNotification("clear bit cache success.");
        }
    }

    private void queryBit() {
        Object object = this.getModel().getValue("org");
        Object entity = this.getModel().getValue("entity");
        IDataModel model = this.getModel();
        if (null == object || null == entity) {
            model.deleteEntryData("entry");
            return;
        }
        DynamicObject org = (DynamicObject)object;
        Long orgId = (Long)org.getPkValue();
        List indexes = null;
        try {
            indexes = BaseDataUseRelQueryEngine.getUseBaseDataIndexByOrgId((Long)orgId, (String)entity.toString());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4f4d\u56fe\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)indexes)) {
            model.deleteEntryData("entry");
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("bitindex", "in", (Object)indexes)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entity.toString(), (String)"number,name,bitindex,createorg", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            model.deleteEntryData("entry");
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : collection) {
            Object createOrg = dynamicObject.get("createorg");
            if (createOrg instanceof DynamicObject) {
                orgIds.add((Long)((DynamicObject)createOrg).getPkValue());
                continue;
            }
            orgIds.add(Long.valueOf(createOrg.toString()));
        }
        Map<Long, String> orgName = this.getOrgName(orgIds);
        model.deleteEntryData("entry");
        EntryProp entryProp = (EntryProp)model.getDataEntityType().getProperty("entry");
        EntryType entryType = (EntryType)entryProp.getItemType();
        DynamicObjectCollection doc = model.getEntryEntity("entry");
        for (DynamicObject baseData : collection) {
            Long createOrgId;
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entryType);
            dynamicObject.set("number", baseData.get("number"));
            dynamicObject.set("bit", baseData.get("bitindex"));
            dynamicObject.set("name", baseData.get("name"));
            Object createOrg = baseData.get("createorg");
            dynamicObject.set("createorg", createOrg);
            if (createOrg instanceof DynamicObject) {
                createOrgId = (Long)((DynamicObject)createOrg).getPkValue();
                dynamicObject.set("orgid", (Object)createOrgId);
                dynamicObject.set("createorgname", (Object)orgName.get(createOrgId));
            } else {
                createOrgId = Long.valueOf(createOrg.toString());
                dynamicObject.set("orgid", (Object)createOrgId);
                dynamicObject.set("createorgname", (Object)orgName.get(createOrgId));
            }
            doc.add((Object)dynamicObject);
        }
        this.getModel().updateEntryCache(doc);
        this.getView().updateView("entry");
    }

    private Map<Long, String> getOrgName(List<Long> orgIds) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_org", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)});
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        for (DynamicObject org : collection) {
            Long orgId = org.getLong("id");
            String name = org.getString("name");
            map.put(orgId, name);
        }
        return map;
    }
}

