/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BaseDataDeleteValidator
extends AbstractValidator {
    public static final String baseDataUseRegSuffix = "UseReg";
    public static final String MASTERID = "masterid";
    private static final String IS_MULTI_USEORG = "isMultiUseOrg";
    private static final Log log = LogFactory.getLog(BaseDataDeleteValidator.class);

    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("createOrg");
        String entityId = this.entityKey;
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        set.add(masteridPropName);
        return set;
    }

    public void validate() {
        String useOrgIDStr = null;
        try {
            useOrgIDStr = this.getOption().getVariableValue("createOrg");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Long useOrgID = 0L;
        boolean isMultiUseOrg = this.getOption().containsVariable(IS_MULTI_USEORG);
        if (!isMultiUseOrg) {
            if (StringUtils.isEmpty((CharSequence)useOrgIDStr)) {
                return;
            }
            useOrgID = Long.valueOf(useOrgIDStr);
        }
        DynamicObject baseData = null;
        DynamicObject createorg = null;
        String baseDataTableName = null;
        HashSet<Long> masterIdSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> dataIdSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> personalChkRes = new HashSet<Long>(8);
        HashSet<Long> assignChkRes = new HashSet<Long>(8);
        Long masterId = 0L;
        Long dataId = 0L;
        String masteridPropName = null;
        String entityID = null;
        for (ExtendedDataEntity dynamicObject : this.dataEntities) {
            if (baseDataTableName == null) {
                baseData = dynamicObject.getDataEntity();
                baseDataTableName = baseData.getDataEntityType().getAlias();
            }
            baseData = dynamicObject.getDataEntity();
            entityID = dynamicObject.getDataEntity().getDataEntityType().getName();
            if (null == masteridPropName) {
                masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityID);
            }
            dataId = (Long)baseData.getPkValue();
            if (baseData.get(masteridPropName) instanceof DynamicObject) {
                DynamicObject masterObj = baseData.getDynamicObject(masteridPropName);
                masterId = (Long)masterObj.getPkValue();
            } else if (baseData.get(masteridPropName) instanceof Long) {
                masterId = (Long)baseData.get(masteridPropName);
            }
            if (masterId.equals(dataId)) {
                masterIdSet.add(masterId);
            }
            dataIdSet.add(dataId);
        }
        if (!"t_bd_material".equalsIgnoreCase(baseDataTableName)) {
            this.personalDataCheck(baseData, masterIdSet, personalChkRes, masteridPropName);
        }
        this.assignCheck(baseData, dataIdSet, assignChkRes, baseDataTableName);
        for (ExtendedDataEntity dynamicObject : this.dataEntities) {
            baseData = dynamicObject.getDataEntity();
            createorg = baseData.getDynamicObject("createorg");
            if (createorg == null) continue;
            if (!isMultiUseOrg && !useOrgID.equals(createorg.getPkValue())) {
                this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BaseDataDeleteValidator_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (assignChkRes.contains(baseData.getPkValue())) {
                this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u88ab\u5206\u914d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BaseDataDeleteValidator_2", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            }
            if (!personalChkRes.contains(baseData.getPkValue())) continue;
            this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BaseDataDeleteValidator_1", (String)"bos-bd-formplugin", (Object[])new Object[0]));
        }
    }

    private void personalDataCheck(DynamicObject baseData, Set<Long> masterIdSet, Set<Long> personalChkRes, String masteridPropName) {
        Map map = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)baseData.getDynamicObjectType(), (QFilter[])new QFilter[]{new QFilter(masteridPropName, "in", masterIdSet), new QFilter(masteridPropName, "!=", (Object)"id", true)});
        Long masterId = 0L;
        for (DynamicObject obj : map.values()) {
            if (obj.get(masteridPropName) instanceof DynamicObject) {
                DynamicObject masterObj = obj.getDynamicObject(masteridPropName);
                masterId = (Long)masterObj.getPkValue();
            } else if (obj.get(masteridPropName) instanceof Long) {
                masterId = (Long)obj.get(masteridPropName);
            }
            personalChkRes.add(masterId);
        }
    }

    private void assignCheck(DynamicObject baseData, Set<Long> dataIdSet, Set<Long> assignChkRes, String baseDataTableName) {
        if (baseDataTableName == null) {
            baseDataTableName = baseData.getDataEntityType().getAlias();
        }
        String dataTableUseName = baseDataTableName + baseDataUseRegSuffix;
        String dbRouteKey = baseData.getDataEntityType().getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT  mu.fdataid");
        sb.append(" from ").append(dataTableUseName).append(" mu ");
        sb.append(" where mu.fdataid in (");
        for (int i = 0; i < dataIdSet.size(); ++i) {
            sb.append(" ?");
            if (i == dataIdSet.size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        sb.append(" and mu.FisAssign = '1' ");
        Set result = (Set)DB.query((DBRoute)dbRoute, (String)sb.toString(), (Object[])dataIdSet.toArray(), rs -> {
            HashSet<Long> set = new HashSet<Long>(8);
            while (rs.next()) {
                set.add(rs.getLong(1));
            }
            return set;
        });
        assignChkRes.addAll(result);
    }
}

