/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.plugin.bdctrl.BaseDataDisableValidator;
import kd.bos.form.plugin.bdctrl.validator.BaseDataPermValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BaseDataDisablePlugin
extends AbstractOperationServicePlugIn {
    private static final String DISABLER = "disabler";
    private static final String DISABLEDATE = "disabledate";

    public void onPreparePropertys(PreparePropertysEventArgs preparepropertyseventargs) {
        preparepropertyseventargs.getFieldKeys().add(DISABLER);
        preparepropertyseventargs.getFieldKeys().add(DISABLEDATE);
        preparepropertyseventargs.getFieldKeys().add("createorg");
        preparepropertyseventargs.getFieldKeys().add("longnumber");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (objs == null || objs.length == 0) {
            return;
        }
        String entity = objs[0].getDataEntityType().getName();
        if (!BaseDataCommonService.isTreeType((String)entity)) {
            BaseDataServiceHelper.handleDisable((String)entity, (DynamicObject[])objs);
            return;
        }
        ArrayList<Long> dataIds = new ArrayList<Long>(objs.length);
        for (DynamicObject data : objs) {
            dataIds.add((Long)data.getPkValue());
        }
        BasedataEntityType dt = (BasedataEntityType)objs[0].getDynamicObjectType();
        Map fields = dt.getAllFields();
        List<String> selectFields = CollectionUtils.isEmpty((Map)fields) ? Collections.singletonList("id") : new ArrayList(fields.keySet());
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(entity);
        List childNodes = service.getChildNodesByParentIds(dataIds, null, selectFields, false);
        ArrayList<DynamicObject> disableDataList = new ArrayList<DynamicObject>(Arrays.asList(objs));
        disableDataList.addAll(childNodes);
        BaseDataServiceHelper.handleDisable((String)entity, (DynamicObject[])disableDataList.toArray(new DynamicObject[0]));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String entityKey = this.billEntityType.getName();
        BaseDataDisableValidator validator = new BaseDataDisableValidator();
        BaseDataPermValidator permValidator = new BaseDataPermValidator();
        permValidator.setEntityKey(entityKey);
        validator.setEntityKey(entityKey);
        e.addValidator((AbstractValidator)permValidator);
        e.addValidator((AbstractValidator)validator);
    }
}

