/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataCustomService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BaseDataFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BaseDataFormPlugin.class);
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String CREATEORG = "createorg";
    public static final String BOS_BD_FORMPLUGIN = "bos-bd-formplugin";
    public static final String USEORGID = "useorgId";
    public static final String ISPERSONALIZEDATA = "isPersonalizeData";
    private static final String PARENT = "parent";
    private static final String NUMBER = "number";
    private static final String USE_ORG = "useOrg";
    private static final String BASE_DATA_SAVE = "base_date_save";
    private static final String MULTI_ORG = "multi_org";
    private static final String IS_MULTI_USEORG = "isMultiUseOrg";
    boolean isSingleOrgManageMode = false;
    private static final String TREE_TYPE = "treetype";
    private static final String SUBMIT = "submit";

    public void initialize() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        this.isSingleOrgManageMode = licenseService.isSingleOrgManageMode();
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        this.setCtrlStrategyAsParent();
    }

    private void setCtrlStrategyAsParent() {
        String entity = this.getModel().getDataEntityType().getName();
        if (BaseDataCommonService.isTreeType((String)this.getModel().getDataEntityType().getName())) {
            DynamicObject obj;
            String ctrlStrategy;
            Long parentId = 0L;
            try {
                parentId = (Long)this.getModel().getDataEntity().get("parent.id");
            }
            catch (Exception ex) {
                parentId = 0L;
            }
            if (parentId != null && parentId != 0L && StringUtils.isNotEmpty((CharSequence)(ctrlStrategy = (obj = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)entity)).getString(CTRLSTRATEGY)))) {
                this.getModel().setValue(CTRLSTRATEGY, (Object)ctrlStrategy);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setCtrlStrategyAsParent();
        Object param = this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (Boolean.parseBoolean(String.valueOf(param))) {
            this.getModel().setValue("bitindex", null);
            this.getModel().setValue("sourcedata", null);
            this.getModel().setValue("srcindex", null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCreateOrgFilter();
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if ("new".equalsIgnoreCase(operate.getType()) || operate.getType().equals("copy")) {
            this.beforeDoOperationNew(args);
        } else if (operate.getType().equals("delete")) {
            this.beforeDoOperationDelete(args);
        } else if ("save".equalsIgnoreCase(operate.getType()) || SUBMIT.equalsIgnoreCase(operate.getType())) {
            String createOrgId;
            this.restoreBitIndexOnCopyOperation();
            if (SUBMIT.equalsIgnoreCase(operate.getType())) {
                operate.getOption().setVariableValue("new_submit", Boolean.TRUE.toString());
            }
            if ("save".equalsIgnoreCase(operate.getType())) {
                operate.getOption().setVariableValue(BASE_DATA_SAVE, Boolean.TRUE.toString());
            }
            Object isPersonalizeData = this.getView().getFormShowParameter().getCustomParam(ISPERSONALIZEDATA);
            String useOrgID = (String)this.getView().getFormShowParameter().getCustomParam(USEORGID);
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue(CREATEORG);
            if (null == useOrgID && null != this.getModel().getValue(USE_ORG)) {
                useOrgID = ((DynamicObject)this.getModel().getValue(USE_ORG)).getPkValue().toString();
            }
            if (!(null == createOrg || !StringUtils.isNotEmpty((CharSequence)useOrgID) || (createOrgId = String.valueOf(createOrg.getPkValue())).equals(useOrgID) || null != isPersonalizeData && ((Boolean)isPersonalizeData).booleanValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"BaseDataFormPlugin_2", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                args.cancel = true;
                args.setCancelMessage(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"BaseDataFormPlugin_2", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            operate.getOption().setVariableValue("useOrgID", useOrgID);
            if (null != isPersonalizeData && ((Boolean)isPersonalizeData).booleanValue()) {
                operate.getOption().setVariableValue(ISPERSONALIZEDATA, "1");
            } else {
                operate.getOption().setVariableValue(ISPERSONALIZEDATA, "0");
            }
        }
        super.beforeDoOperation(args);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operationKey = evt.getOperationKey().toLowerCase();
        String useOrgID = (String)this.getView().getFormShowParameter().getCustomParam(USEORGID);
        DynamicObject createorg = (DynamicObject)this.getModel().getValue(CREATEORG);
        if (null == createorg) {
            return;
        }
        if (null == useOrgID && null != this.getModel().getValue(USE_ORG)) {
            useOrgID = ((DynamicObject)this.getModel().getValue(USE_ORG)).getPkValue().toString();
        }
        if (null == useOrgID) {
            return;
        }
        String createorgId = String.valueOf(createorg.getPkValue());
        switch (operationKey) {
            case "unaudit": {
                if (createorgId.equals(useOrgID)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"BaseDataUnAuditValidator_2", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "audit": {
                if (createorgId.equals(useOrgID)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u4e0e\u521b\u5efa\u7ec4\u7ec7\u76f8\u540c\u624d\u80fd\u5ba1\u6838\u3002", (String)"BaseDataFormPlugin_11", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "disable": {
                if (createorgId.equals(useOrgID)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u7981\u7528\u5931\u8d25\u3002", (String)"BaseDataDisableValidator_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "enable": {
                if (createorgId.equals(useOrgID)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u542f\u7528\u5931\u8d25\u3002", (String)"BaseDataEnableValidator_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    private void restoreBitIndexOnCopyOperation() {
        Object param = this.getView().getFormShowParameter().getCustomParam("iscopy");
        boolean isCopy = false;
        if (param instanceof Boolean) {
            isCopy = (Boolean)param;
        }
        IPageCache pageCache = this.getPageCache();
        String wasSave = pageCache.get("bd_was_save");
        if (isCopy && !Boolean.parseBoolean(wasSave)) {
            pageCache.put("bd_was_save", Boolean.TRUE.toString());
            this.getModel().setValue("bitindex", null);
            this.getModel().setValue("sourcedata", null);
            this.getModel().setValue("srcindex", null);
        }
    }

    private void beforeDoOperationNew(BeforeDoOperationEventArgs args) {
        String entity = this.getModel().getDataEntityType().getName();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entity);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        Long useOrgId = this.getView().getFormShowParameter().getCustomParam(USEORGID) == null ? 0L : Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(USEORGID));
        List createOrgs = BaseDataServiceHelper.getCreateOrgList((String)entity, (String)appid);
        if (createOrgs.isEmpty()) {
            args.cancel = true;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6709\u6743\u521b\u5efa%s\u7684\u7ec4\u7ec7\u5355\u5143\uff0c\u8bf7\u68c0\u67e5\u529f\u80fd\u6743\u9650\u6216\u8005\u63a7\u5236\u89c4\u5219\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"BaseDataFormPlugin_10", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), met.getDisplayName()));
        } else {
            if (useOrgId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f7f\u7528\u7ec4\u7ec7\u3002", (String)"BaseDataFormPlugin_3", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                args.cancel = true;
                return;
            }
            if (!createOrgs.contains(useOrgId) && createOrgs.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u521b\u5efa\u57fa\u7840\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u201c\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u201d\u63a7\u5236\u89c4\u5219\u5904\u6dfb\u52a0\u4e3a\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"BaseDataFormPlugin_4", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                args.cancel = true;
            }
        }
    }

    private String getAppIdByEntity(String entityId) {
        String appId = null;
        String appNumber = this.getView().getFormShowParameter().getAppId();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityId);
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appId = met.getAppId();
            }
        }
        return appId;
    }

    private void beforeDoOperationDelete(BeforeDoOperationEventArgs args) {
        DynamicObject createOrgObj = (DynamicObject)this.getModel().getValue(CREATEORG);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (createOrgObj == null || StringUtils.isBlank((CharSequence)parentPageId)) {
            return;
        }
        String createOrg = createOrgObj.getPkValue().toString();
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(parentPageId);
        if (null != pageCache) {
            List multiOrgs;
            String multiOrgStr = pageCache.getBigObject(MULTI_ORG);
            if (StringUtils.isNotBlank((CharSequence)multiOrgStr) && !CollectionUtils.isEmpty((Collection)(multiOrgs = SerializationUtils.fromJsonStringToList((String)multiOrgStr, Long.class))) && multiOrgs.size() > 1) {
                FormOperate operate = (FormOperate)args.getSource();
                operate.getOption().setVariableValue(IS_MULTI_USEORG, "true");
                return;
            }
            String createOrgCache = pageCache.get("createOrg");
            if (null != createOrgCache && !"0".equals(createOrgCache) && !createOrg.equals(createOrgCache)) {
                args.cancel = true;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u7f16\u7801%s\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BaseDataFormPlugin_6", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), this.getModel().getValue(NUMBER)));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && (operate.getType().equals("addnew") || operate.getType().equals("save"))) {
            this.getModel().setDataChanged(false);
        }
        if (operate.getType().equals("save")) {
            String dataId = "0";
            try {
                dataId = operate.getOption().getVariableValue("dataId");
            }
            catch (Exception ignored) {
                log.error(ignored.getMessage(), (Throwable)ignored);
            }
            if (!"0".equals(dataId)) {
                String entity = this.getModel().getDataEntity().getDataEntityType().toString();
                DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingle((Object)dataId, (String)entity);
                ((BillModel)this.getModel()).push((Object)dynamicObject1);
                this.getView().updateView();
            }
        }
    }

    private void setCreateOrgFilter() {
        BasedataEdit bde = (BasedataEdit)this.getControl(CREATEORG);
        String entity = this.getModel().getDataEntity().getDataEntityType().toString();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entity);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        List orgList = BaseDataServiceHelper.getCreateOrgList((String)entity, appid);
        if (bde != null) {
            bde.setQFilter(new QFilter("id", "in", (Object)orgList));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty pro = e.getProperty();
        if (CREATEORG.equalsIgnoreCase(pro.getName())) {
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue(CREATEORG);
            if (createOrg == null) {
                this.getModel().setValue(CTRLSTRATEGY, null);
                return;
            }
            String entityName = this.getModel().getDataEntity().getDataEntityType().toString();
            String ctrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)entityName, (String)String.valueOf(createOrg.getPkValue()));
            if (ctrlStrgy != null && ctrlStrgy.length() > 0) {
                this.setCtrlStrgy(ctrlStrgy);
            }
        }
        if (PARENT.equalsIgnoreCase(pro.getName())) {
            ChangeData changeData = e.getChangeSet()[0];
            Long parentId = (Long)changeData.getDataEntity().get("parent.id");
            if (parentId != null) {
                this.checkAddData(parentId);
                this.setCtrlStrategyAsParent();
            } else {
                DynamicObject createOrg = (DynamicObject)this.getModel().getValue(CREATEORG);
                if (null == createOrg || null == createOrg.getPkValue()) {
                    return;
                }
                String entityName = this.getModel().getDataEntity().getDataEntityType().toString();
                String ctrlStrategy = BaseDataServiceHelper.getBdCtrlStrgy((String)entityName, (String)String.valueOf(createOrg.getPkValue()));
                if (StringUtils.isNotBlank((CharSequence)ctrlStrategy)) {
                    String[] ctrlStrategyArr;
                    for (String ctr : ctrlStrategyArr = ctrlStrategy.split(",")) {
                        if (!StringUtils.isNotEmpty((CharSequence)ctr)) continue;
                        this.getModel().setValue(CTRLSTRATEGY, (Object)ctr);
                    }
                }
            }
        }
    }

    private void setCtrlStrgy(String ctrlStrgy) {
        String[] ctrlStrgys = ctrlStrgy.split(",");
        if (ctrlStrgys.length > 1) {
            for (String ctr : ctrlStrgys) {
                if (!StringUtils.isNotEmpty((CharSequence)ctr)) continue;
                this.getModel().setValue(CTRLSTRATEGY, (Object)ctr);
                return;
            }
        } else {
            this.getModel().setValue(CTRLSTRATEGY, (Object)ctrlStrgy);
        }
    }

    private void checkAddData(Long parentId) {
        String entity = this.getModel().getDataEntityType().getName();
        if (!BaseDataCommonService.isTreeType((String)entity)) {
            return;
        }
        if (parentId != 0L) {
            boolean isCurrentOrg;
            BaseDataCustomService service;
            Map customOrgInfo;
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)entity);
            String number = obj.getString(NUMBER);
            long useOrgId = 0L;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam(USEORGID)))) {
                useOrgId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(USEORGID));
            }
            if (!(TreeBaseDataCommonService.isAssignUnDetail((String)entity) || CollectionUtils.isEmpty((Map)(customOrgInfo = (service = new BaseDataCustomService(entity)).getCustomOrgInfo(obj, Long.valueOf(useOrgId)))) || BaseDataBusinessServiceUtils.isEnableVersion((String)entity))) {
                String orgName = (String)new ArrayList(customOrgInfo.values()).get(0);
                String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5728\u7ec4\u7ec7\uff1a\u201c%2$s\u201d\u5b58\u5728\u4e0b\u7ea7\u8d44\u6599\u6216\u4e2a\u6027\u5316\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\u4e0b\u7ea7\u8d44\u6599\u3002", (String)"BaseDataFormPlugin_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), number, orgName);
                throw new KDBizException(errorMsg);
            }
            String strategy = obj.getString(CTRLSTRATEGY);
            if (StringUtils.isNotBlank((CharSequence)strategy) && ("5".equals(strategy) || "6".equals(strategy)) && !(isCurrentOrg = this.checkCreateOrgIsCurrentOrg(parentId))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5171\u4eab\u201d \u578b\u7b56\u7565\u4e0b\uff0c\u6240\u6709\u5c42\u7ea7\u7684\u521b\u5efa\u7ec4\u7ec7\u5fc5\u987b\u76f8\u540c\u3002", (String)"BaseDataTreeListPlugin_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    private boolean checkCreateOrgIsCurrentOrg(Long parentId) {
        String entity = this.getModel().getDataEntityType().getName();
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        String selectFields = "id, createOrg," + masterIdPropName + ",number";
        QFilter[] qfArr = new QFilter[]{new QFilter("id", "in", (Object)parentId)};
        DynamicObject[] dyCol = BusinessDataServiceHelper.load((String)entity, (String)selectFields, (QFilter[])qfArr);
        String useOrgID = (String)this.getView().getFormShowParameter().getCustomParam(USEORGID);
        if (null == useOrgID && null != this.getModel().getValue(USE_ORG)) {
            useOrgID = ((DynamicObject)this.getModel().getValue(USE_ORG)).getPkValue().toString();
        }
        for (DynamicObject dynamicObject : dyCol) {
            Long createOrgId = 0L;
            if (dyCol[0].get(CREATEORG) instanceof DynamicObject) {
                createOrgId = (Long)dynamicObject.getDynamicObject(CREATEORG).getPkValue();
            } else if (dyCol[0].get(CREATEORG) instanceof Long) {
                createOrgId = (Long)dynamicObject.get(CREATEORG);
            }
            if (createOrgId.equals(Long.parseLong(useOrgID))) continue;
            return false;
        }
        return true;
    }
}

