/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.provider.BaseDataListProvider;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.BasedataProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.events.MobFilterSortInitArgs;
import kd.bos.form.events.MobFilterSortSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.bdctrl.BaseDataListPlugin;
import kd.bos.license.api.ILicenseService;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BaseDataMobListPlugin
extends AbstractMobListPlugin {
    boolean isSingleOrgManageMode = false;
    private static final int ORG_MANAGE_MODE_SINGLE = 1;
    private static final String USEORG_FILEDNAME = "useorg.name";
    private static final String USEORG_FILEID = "useorg.id";
    private static final String PRO_CREATEORG = "createOrg";
    private static final String VERIFYORG = "verifyOrg";
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String USEORG = "useorg";
    private static final String VIEWID = "view.id";
    private static final String ISCTRLUNIT = "isctrlunit";
    private static final String CUSTOM_FILTER = "customfilter";
    private static final String FIELDNAME = "FieldName";
    private static final String VALUE = "Value";
    private static final String ORGVIEWSCHEMENUMBER = "orgViewSchemeNumber";
    private static final String QUERY_PERM = "47150e89000000ac";
    private static final String ORG_ENTITY = "bos_org";
    private static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    private DynamicObjectCollection allUseOrg = null;
    private Map<String, List<Map<String, List<Object>>>> filterValues = null;
    private List<Map<String, List<Object>>> customfilter = null;
    private QFilter qfilter;
    private static final String ORG_ID = "org.id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void initialize() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        this.isSingleOrgManageMode = licenseService.isSingleOrgManageMode();
        if (this.isSingleOrgManageMode) {
            Long orgId = RequestContext.get().getOrgId();
            this.getPageCache().put(PRO_CREATEORG, String.valueOf(orgId));
            this.getPageCache().put(VERIFYORG, String.valueOf(orgId));
        }
    }

    public void mobFilterSortBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if (USEORG_FILEID.equals(args.getFieldName())) {
            QFilter extendOrgQfilter;
            long userId = RequestContext.get().getCurrUserId();
            String appid = this.getAppId();
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)this.getEntityNumber(), (String)QUERY_PERM);
            if (result == null) {
                return;
            }
            QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            String entityType = ((AbstractListView)this.getView()).getEntityTypeId();
            DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
            ArrayList<Long> viewOrgIds = new ArrayList<Long>();
            String view = "";
            if (null == ctrlview) {
                view = "16";
            } else {
                view = ctrlview.getString("id");
                args.getCustomParams().put(ORGVIEWSCHEMENUMBER, ctrlview.getString("number"));
            }
            QFilter f2 = new QFilter(VIEWID, "=", (Object)Long.valueOf(view));
            QFilter f3 = new QFilter(ISCTRLUNIT, "=", (Object)Boolean.TRUE);
            QFilter[] qfilters = null;
            qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3} : new QFilter[]{f2, f3, idsFilter};
            ORM ormOv = ORM.create();
            try (DataSet ds = ormOv.queryDataSet(BaseDataListPlugin.class.getName(), ENTITYID_ORG_STRUCTURE, ORG_ID, qfilters);){
                for (Row row : ds) {
                    if (row.getLong(ORG_ID) == null || viewOrgIds.contains(row.getLong(ORG_ID))) continue;
                    viewOrgIds.add(row.getLong(ORG_ID));
                }
            }
            idsFilter = new QFilter("id", "in", viewOrgIds);
            filterList.add(idsFilter);
            IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entityType);
            if (baseDataCtrlPlugin != null && (extendOrgQfilter = baseDataCtrlPlugin.getExtendOrgQFilter()) != null) {
                filterList.add(extendOrgQfilter);
                args.getQfilters().add(extendOrgQfilter);
            }
            args.addCustomQFilter(idsFilter);
        }
        super.mobFilterSortBeforeF7Select(args);
    }

    public void mobFilterSortSearchClick(MobFilterSortSearchClickArgs args) {
        this.filterValues = args.getSearchClickEvent().getFilterValues();
        List<Map<String, List<Object>>> customFiterList = this.filterValues.get(CUSTOM_FILTER);
        if (customFiterList == null) {
            return;
        }
        String customfilterSer = SerializationUtils.toJsonString(customFiterList);
        this.getPageCache().remove(CUSTOM_FILTER);
        this.getPageCache().put(CUSTOM_FILTER, customfilterSer);
        String orgId = null;
        Iterator<Map<String, List<Object>>> iterator = customFiterList.iterator();
        while (iterator.hasNext()) {
            List<Object> orgIds;
            Map<String, List<Object>> customFiter = iterator.next();
            List<Object> fieldNames = customFiter.get(FIELDNAME);
            if (fieldNames == null || fieldNames.size() == 0 || !USEORG_FILEDNAME.equals(fieldNames.get(0)) && !USEORG_FILEID.equals(fieldNames.get(0)) || (orgIds = customFiter.get(VALUE)) == null || orgIds.size() == 0) continue;
            orgId = String.valueOf(orgIds.get(0));
            iterator.remove();
            this.getPageCache().put(PRO_CREATEORG, String.valueOf(orgId));
            this.getPageCache().put(VERIFYORG, String.valueOf(orgId));
            break;
        }
        super.mobFilterSortSearchClick(args);
    }

    public void setFilter(SetFilterEvent e) {
        if (this.isSingleOrgManageMode) {
            return;
        }
        String customFilterSer = this.getPageCache().get(CUSTOM_FILTER);
        if (customFilterSer == null) {
            return;
        }
        boolean isNewModel = BaseDataCommonService.isNewModel((String)this.getEntityNumber());
        boolean isBaseDataListProvider = this.isBaseDataListProvider(e);
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        this.customfilter = (List)SerializationUtils.fromJsonString((String)customFilterSer, ArrayList.class);
        for (Map<String, List<Object>> customFilter : this.customfilter) {
            Object orgId;
            boolean includeUseOrgId;
            List<Object> fieldNames = customFilter.get(FIELDNAME);
            if (CollectionUtils.isEmpty(fieldNames)) continue;
            boolean bl = includeUseOrgId = USEORG_FILEDNAME.equals(fieldNames.get(0)) || USEORG_FILEID.equals(fieldNames.get(0));
            if (!isNewModel && includeUseOrgId) {
                this.setFilterAppend(customFilter, orgIds);
                break;
            }
            if (!isBaseDataListProvider && isNewModel && includeUseOrgId) {
                this.setFilterAppend(customFilter, orgIds);
                break;
            }
            if (!isNewModel || !includeUseOrgId) continue;
            this.setFilterAppend(customFilter, orgIds);
            List<Object> orgFilterIds = customFilter.get(VALUE);
            if (CollectionUtils.isEmpty(orgFilterIds) || !StringUtils.isNotBlank((Object)(orgId = orgFilterIds.get(0)))) break;
            this.setProviderOrgId(Long.valueOf(orgId.toString()));
            break;
        }
        List filters = e.getQFilters();
        filters.removeIf(filter -> filter.getProperty().equals(USEORG_FILEID));
        if (this.qfilter != null) {
            filters.add(this.qfilter);
            e.setQFilters(filters);
        }
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        QFilter dataPermissionFilter = ((PermissionService)ServiceFactory.getService(PermissionService.class)).getDataRuleWithoutDim(userId, appId, this.getEntityNumber(), QUERY_PERM, orgIds);
        if (dataPermissionFilter != null) {
            filters.add(dataPermissionFilter);
        }
        super.setFilter(e);
    }

    private boolean isBaseDataListProvider(SetFilterEvent e) {
        BillList billList = (BillList)e.getSource();
        if (null == billList) {
            return false;
        }
        IListModel listModel = billList.getListModel();
        if (null == listModel) {
            return false;
        }
        IListDataProvider provider = listModel.getProvider();
        return provider instanceof BaseDataListProvider;
    }

    private void setFilterAppend(Map<String, List<Object>> customFiter, List<Long> orgIds) {
        List<Object> orgFilterIds = customFiter.get(VALUE);
        if (orgFilterIds == null || orgFilterIds.size() == 0 || orgFilterIds.get(0) == null || StringUtils.isBlank((Object)orgFilterIds.get(0))) {
            this.qfilter = new QFilter("id", "=", (Object)-1L);
        } else if (orgFilterIds.get(0) != null && orgFilterIds.get(0) instanceof Long) {
            this.qfilter = BaseDataServiceHelper.getBaseDataFilter((String)this.getEntityNumber(), (Long)((Long)orgFilterIds.get(0)));
            orgIds.add((Long)orgFilterIds.get(0));
        } else if (orgFilterIds.get(0) != null && orgFilterIds.get(0) instanceof String) {
            this.qfilter = BaseDataServiceHelper.getBaseDataFilter((String)this.getEntityNumber(), (Long)Long.valueOf((String)orgFilterIds.get(0)));
            orgIds.add(Long.valueOf((String)orgFilterIds.get(0)));
        }
    }

    public void mobFilterSortInit(MobFilterSortInitArgs args) {
        super.mobFilterSortInit(args);
        if (this.isSingleOrgManageMode) {
            return;
        }
        List filterColumnList = args.getMobFilterSortInitEvent().getFilterColumns();
        LocaleString orgPropertyName = this.getBizOrgName();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String entityType = ((AbstractListView)this.getView()).getEntityTypeId();
        FilterColumn orgColumn = args.getMobFilterSortInitEvent().getFilterColumn(USEORG_FILEDNAME);
        if (orgColumn == null) {
            orgColumn = new CommonFilterColumn();
            orgColumn.setCaption(orgPropertyName);
            orgColumn.setFieldName(USEORG_FILEDNAME);
            ((CommonFilterColumn)orgColumn).setMustInput(true);
            orgColumn.setEntityField(true);
        }
        if (filterColumnList.contains(orgColumn)) {
            return;
        }
        if (this.allUseOrg == null) {
            this.allUseOrg = this.getAllUseOrg(entityType);
        }
        String defaultOrg = this.getDefaultUseOrg(this.allUseOrg);
        orgColumn.setType("enum");
        String createOrg = this.getPageCache().get(PRO_CREATEORG);
        if (StringUtils.isBlank((CharSequence)createOrg)) {
            orgColumn.setDefaultValue(defaultOrg);
        } else {
            orgColumn.setDefaultValue(createOrg);
        }
        args.getMobFilterSortInitEvent().addFilterColumn(orgColumn);
        if (this.filterValues == null) {
            this.filterValues = new HashMap<String, List<Map<String, List<Object>>>>();
            this.filterValues.put("fastfilter", new ArrayList());
            this.filterValues.put(CUSTOM_FILTER, new ArrayList());
            for (FilterColumn filterColumn : filterColumnList) {
                HashMap<String, List> customFiter = new HashMap<String, List>();
                ArrayList<String> fieldName = new ArrayList<String>();
                fieldName.add(filterColumn.getFieldName());
                customFiter.put(FIELDNAME, fieldName);
                if (USEORG_FILEDNAME.equals(filterColumn.getFieldName())) {
                    ArrayList<String> value = new ArrayList<String>();
                    if (StringUtils.isBlank((CharSequence)createOrg)) {
                        value.add(defaultOrg);
                        this.getPageCache().put(PRO_CREATEORG, defaultOrg);
                        this.getPageCache().put(VERIFYORG, defaultOrg);
                    } else {
                        value.add(createOrg);
                        this.getPageCache().put(PRO_CREATEORG, createOrg);
                        this.getPageCache().put(VERIFYORG, createOrg);
                    }
                    customFiter.put(VALUE, value);
                } else if (filterColumn.getDefaultValues() != null && filterColumn.getDefaultValues().size() > 0) {
                    customFiter.put(VALUE, filterColumn.getDefaultValues());
                }
                if (customFiter.get(VALUE) == null) continue;
                this.filterValues.get(CUSTOM_FILTER).add(customFiter);
            }
            this.customfilter = this.filterValues.get(CUSTOM_FILTER);
            String customfilterSer = SerializationUtils.toJsonString(this.customfilter);
            this.getPageCache().put(CUSTOM_FILTER, customfilterSer);
        }
    }

    private LocaleString getBizOrgName() {
        LocaleString orgPropertyName = null;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"BaseDataMobListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String entityType = ((AbstractListView)this.getView()).getEntityTypeId();
        if (!StringUtils.isEmpty((CharSequence)(entityType = FormMetadataCache.getFormConfig((String)entityType).getEntityTypeId()))) {
            BasedataProp orgProp = null;
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityType);
            orgProp = (BasedataProp)dt.getProperties().get((Object)USEORG);
            if (orgProp != null) {
                orgPropertyName = orgProp.getDisplayName();
            }
        }
        if (orgPropertyName == null) {
            orgPropertyName = new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"BaseDataMobListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return orgPropertyName;
    }

    private DynamicObjectCollection getAllUseOrg(String entityType) {
        long userId = RequestContext.get().getCurrUserId();
        String appid = this.getAppId();
        String entityNumber = this.getEntityNumber();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityNumber, (String)QUERY_PERM);
        if (result == null) {
            return new DynamicObjectCollection();
        }
        return this.getAllUseOrg(entityType, entityNumber, result);
    }

    private DynamicObjectCollection getAllUseOrg(String entityType, String entityNumber, HasPermOrgResult result) {
        String orgFuncPro;
        String useOrgFunc = BaseDataServiceHelper.getUseOrgFunc((String)entityNumber);
        QFilter[] filters = null;
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty((CharSequence)useOrgFunc) && StringUtils.isNotEmpty((CharSequence)(orgFuncPro = OrgServiceHelper.getOrgBizPro((String)useOrgFunc)))) {
            QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)Boolean.TRUE);
            filterList.add(orgFuncFilter);
        }
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        ArrayList<Long> viewOrgIds = new ArrayList<Long>();
        Long view = 0L;
        view = null == ctrlview ? Long.valueOf(16L) : Long.valueOf(ctrlview.getLong("id"));
        QFilter f2 = new QFilter(VIEWID, "=", (Object)view);
        QFilter f3 = new QFilter(ISCTRLUNIT, "=", (Object)Boolean.TRUE);
        QFilter f4 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] qfilters = null;
        qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3, f4} : new QFilter[]{f2, f3, f4, idsFilter};
        ORM ormOv = ORM.create();
        try (DataSet ds = ormOv.queryDataSet(BaseDataListPlugin.class.getName(), ENTITYID_ORG_STRUCTURE, ORG_ID, qfilters);){
            for (Row row : ds) {
                if (row.getLong(ORG_ID) == null || viewOrgIds.contains(row.getLong(ORG_ID))) continue;
                viewOrgIds.add(row.getLong(ORG_ID));
            }
        }
        idsFilter = new QFilter("id", "in", viewOrgIds);
        filterList.add(idsFilter);
        this.getAllUseOrgAppend(filterList, entityType);
        filters = filterList.toArray(new QFilter[0]);
        return QueryServiceHelper.query((String)ORG_ENTITY, (String)"id,name", (QFilter[])filters, (String)"id");
    }

    private void getAllUseOrgAppend(List<QFilter> filterList, String entityType) {
        QFilter extendOrgQfilter;
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entityType);
        if (baseDataCtrlPlugin != null && (extendOrgQfilter = baseDataCtrlPlugin.getExtendOrgQFilter()) != null) {
            filterList.add(extendOrgQfilter);
        }
    }

    private String getAppId() {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)this.getEntityNumber());
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        return appid;
    }

    private String getDefaultUseOrg(DynamicObjectCollection col) {
        String defaultUseOrg = null;
        if (!col.isEmpty()) {
            defaultUseOrg = String.valueOf(((DynamicObject)col.get(0)).get("id"));
        }
        long longinOrg = RequestContext.get().getOrgId();
        for (DynamicObject obj : col) {
            if (longinOrg != obj.getLong("id")) continue;
            defaultUseOrg = String.valueOf(longinOrg);
        }
        return defaultUseOrg;
    }

    private String getEntityNumber() {
        String entity = ((AbstractListView)this.getView()).getEntityTypeId();
        entity = FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
        return entity;
    }

    private DynamicObjectCollection getHasPermOrgCollection(String entity) {
        HasPermOrgResult result;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entity);
        String appId = null;
        String appNumber = this.getView().getFormShowParameter().getAppId();
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appId = met.getAppId();
            }
        }
        if ((result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entity, (String)QUERY_PERM)) == null) {
            return new DynamicObjectCollection();
        }
        return this.getAllUseOrg(entity, entity, result);
    }

    private void setProviderOrgId(Long orgId) {
        BillList billList = (BillList)this.getControl("billlistap");
        if (null == billList) {
            return;
        }
        IListModel listModel = billList.getListModel();
        if (null == listModel) {
            return;
        }
        IListDataProvider provider = listModel.getProvider();
        if (provider instanceof BaseDataListProvider) {
            BaseDataListProvider p = (BaseDataListProvider)provider;
            p.setOrgId(orgId);
        }
    }
}

