/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.mq.BaseDataOrgRelSolidifyConsumer;
import kd.bos.bd.pojo.ConsumeTypeEnum;
import kd.bos.bd.pojo.SolidifyProgressInfo;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;

public class BaseDataRelSolidifyMessageListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(BaseDataRelSolidifyMessageListPlugin.class);
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String BTN_CONSUME = "tblconsume";
    private static final String CALL_BACK_CONSUME_NAME = "call_back_msg_consume";
    private static final String CACHE_KEY_PROGRESS = "cache_progress";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BTN_CONSUME});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"BaseDataRelSolidifyMessageListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (!BTN_CONSUME.equals(itemKey)) {
            return;
        }
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"BaseDataRelSolidifyMessageListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        try {
            Map solidifyMsg = new BaseDataOrgRelSolidifyConsumer().getSolidifyMessage(rows.getPrimaryKeyValues());
            SolidifyProgressInfo info = new SolidifyProgressInfo(this.size(solidifyMsg));
            info.setSuccess(true);
            this.getPageCache().putBigObject(CACHE_KEY_PROGRESS, SerializationUtils.toJsonString((Object)info));
            this.showProgressLoading(0);
            this.getView().addClientCallBack(CALL_BACK_CONSUME_NAME, Integer.valueOf(500));
            this.batchConsume(solidifyMsg);
        }
        catch (Exception e) {
            LOGGER.error("\u79ef\u538b\u6d88\u606f\u6d88\u8d39\u5931\u8d25...", (Throwable)e);
            this.getView().hideLoading();
            this.getPageCache().removeBigObject(CACHE_KEY_PROGRESS);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79ef\u538b\u6d88\u606f\u5904\u7406\u5931\u8d25\u3002", (String)"BaseDataRelSolidifyMessageListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private int size(Map<String, Set<Long>> solidifyMsg) {
        int size = 0;
        for (Set<Long> value : solidifyMsg.values()) {
            size += value.size();
        }
        return size;
    }

    private void batchConsume(Map<String, Set<Long>> solidifyMsg) {
        Map<String, String> solidifyObj = this.getSolidifyObj(solidifyMsg.keySet());
        LocalDate christmas = LocalDate.of(2999, 12, 31);
        ZonedDateTime zonedDateTime = christmas.atStartOfDay(ZoneId.systemDefault());
        Date date = Date.from(zonedDateTime.toInstant());
        ThreadPool pool = BaseDataThreadPoolUtils.getBdCommonThreadPool();
        for (Map.Entry<String, Set<Long>> entry : solidifyMsg.entrySet()) {
            String entity = entry.getKey();
            String obj = solidifyObj.get(entity);
            Set<Long> useOrgIds = entry.getValue();
            for (Long orgId : useOrgIds) {
                pool.execute(() -> this.consume(entity, orgId, date, obj), RequestContext.get());
            }
        }
    }

    private void consume(String entity, Long orgId, Date opTime, String obj) {
        try {
            BaseDataOrgRelSolidifyConsumer consumer = new BaseDataOrgRelSolidifyConsumer();
            consumer.consume(entity, orgId, opTime, obj, ConsumeTypeEnum.MANUAL);
            this.updateProgressInfo(true);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u5b9e\u4f53\u3010%s\u3011\uff0c\u7ec4\u7ec7\u3010%s\u3011\uff0c\u56fa\u5316\u5bf9\u8c61\u3010%s\u3011\u6d88\u8d39\u5931\u8d25...", entity, orgId, obj), (Throwable)e);
            this.updateProgressInfo(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgressInfo(boolean success) {
        DLock lock = DLock.createReentrant((String)this.getView().getPageId());
        lock.lock();
        try {
            String value = this.getPageCache().getBigObject(CACHE_KEY_PROGRESS);
            if (StringUtils.isBlank((CharSequence)value)) {
                return;
            }
            SolidifyProgressInfo info = (SolidifyProgressInfo)SerializationUtils.fromJsonString((String)value, SolidifyProgressInfo.class);
            info.incr(1);
            this.showProgressLoading(info.getCurrPercentage());
            if (info.isSuccess()) {
                info.setSuccess(success);
            }
            this.getPageCache().putBigObject(CACHE_KEY_PROGRESS, SerializationUtils.toJsonString((Object)info));
        }
        finally {
            lock.unlock();
        }
    }

    private Map<String, String> getSolidifyObj(Collection<String> entities) {
        QFilter[] filters = new QFilter[]{new QFilter("basedataid", "in", entities)};
        String selectFields = "basedataid, solidifyobj";
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_bddefctrlstrtgy", (String)selectFields, (QFilter[])filters);
        HashMap<String, String> result = new HashMap<String, String>(entities.size());
        for (DynamicObject config : map.values()) {
            DynamicObject solidifyObj;
            DynamicObject baseData = config.getDynamicObject("basedataid");
            if (null == baseData || null == baseData.getPkValue() || null == (solidifyObj = config.getDynamicObject("solidifyobj")) || null == solidifyObj.getPkValue()) continue;
            result.put(baseData.getPkValue().toString(), solidifyObj.getPkValue().toString());
        }
        return result;
    }

    private void showProgressLoading(int currPercentage) {
        String msg = ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d...", (String)"BaseDataRelSolidifyMessageListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.getView().showProgressLoading(new LocaleString(msg), currPercentage);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (!CALL_BACK_CONSUME_NAME.equals(e.getName())) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String cache = pageCache.getBigObject(CACHE_KEY_PROGRESS);
        if (StringUtils.isBlank((CharSequence)cache)) {
            this.getView().addClientCallBack(CALL_BACK_CONSUME_NAME, Integer.valueOf(500));
            return;
        }
        SolidifyProgressInfo progressInfo = (SolidifyProgressInfo)SerializationUtils.fromJsonString((String)cache, SolidifyProgressInfo.class);
        this.showProgressLoading(progressInfo.getCurrPercentage());
        if (progressInfo.complete()) {
            this.getView().hideLoading();
            pageCache.removeBigObject(CACHE_KEY_PROGRESS);
            if (progressInfo.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d88\u606f\u6d88\u8d39\u5b8c\u6bd5\u3002", (String)"BaseDataRelSolidifyMessageListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5931\u8d25\u7684\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u5904\u7406\u3002", (String)"BaseDataRelSolidifyMessageListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        } else {
            this.getView().addClientCallBack(CALL_BACK_CONSUME_NAME, Integer.valueOf(500));
        }
    }
}

