/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.EventObject;
import kd.bos.bd.pojo.SolidifyProgressInfo;
import kd.bos.bd.service.BaseDataRelBitRestoreService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class BaseDataRelSolidifyProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String CON_PROGRESS = "progressbarap";
    private static final String BTN_OK = "btnok";
    private static final String BTN_BACK = "backgrouder";
    private static final String BTN_CANCEL = "btncancel";
    private static final int PERCENT_MAX = 100;

    public void registerListener(EventObject event) {
        ProgressBar bar = (ProgressBar)this.getView().getControl(CON_PROGRESS);
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BTN_OK, BTN_BACK, BTN_CANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK});
        ProgressBar progressBar = (ProgressBar)this.getControl(CON_PROGRESS);
        progressBar.start();
    }

    public void onProgress(ProgressEvent evt) {
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("param_entity");
        SolidifyProgressInfo info = BaseDataRelBitRestoreService.getSolidifyProgressInfo((String)entity);
        if (null == info) {
            if (BaseDataRelBitRestoreService.manualInterrupt((String)entity)) {
                this.updateTips(ResManager.loadKDString((String)"\u5df2\u4e2d\u65ad\u56fa\u5316\u4efb\u52a1\u3002", (String)"BaseDataRelSolidifyProgressPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BACK});
            } else {
                this.complete(evt);
            }
            return;
        }
        if (!info.isSuccess() && StringUtils.isNotBlank((CharSequence)info.getMessage())) {
            this.updateTips(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f4d\u56fe\u6570\u636e\u56fa\u5316\u5b58\u5728\u5f02\u5e38\u3010%1$s\u3011\u3002", (String)"BaseDataRelSolidifyProgressPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), info.getMessage()));
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BACK});
        } else if (info.complete()) {
            this.complete(evt);
        } else {
            evt.setProgress(info.getCurrPercentage());
        }
    }

    private void updateTips(String msg) {
        Label tip = (Label)this.getControl("labelap");
        tip.setText(msg);
    }

    private void complete(ProgressEvent evt) {
        evt.setProgress(100);
        ProgressBar progressBar = (ProgressBar)this.getControl(CON_PROGRESS);
        progressBar.stop();
        this.updateTips(ResManager.loadKDString((String)"\u56fa\u5316\u4efb\u52a1\u6267\u884c\u6210\u529f\u3002", (String)"BaseDataRelSolidifyProgressPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_OK});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCEL, BTN_BACK});
    }

    private boolean isComplete() {
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("param_entity");
        SolidifyProgressInfo info = BaseDataRelBitRestoreService.getSolidifyProgressInfo((String)entity);
        if (null == info) {
            return !BaseDataRelBitRestoreService.manualInterrupt((String)entity);
        }
        return info.getCurrent() == info.getTotal();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        this.getPageCache().putBigObject("op", key);
        switch (key) {
            case "btncancel": {
                this.confirm();
                break;
            }
            case "backgrouder": {
                this.getView().close();
                break;
            }
            case "btnok": {
                this.getView().returnDataToParent((Object)Boolean.TRUE);
                this.getView().close();
                break;
            }
        }
    }

    private void confirm() {
        String msg = ResManager.loadKDString((String)"\u786e\u5b9a\u505c\u6b62\u6267\u884c\u7ec4\u7ec7\u6570\u636e\u5173\u7cfb\u7684\u56fa\u5316\u8fd8\u539f\u64cd\u4f5c\u5417\uff1f", (String)"BaseDataRelSolidifyProgressPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_CANCEL, (IFormPlugin)this));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String op = this.getPageCache().getBigObject("op");
        if (!(BTN_BACK.equals(op) || BTN_OK.equals(op) || BTN_CANCEL.equals(op))) {
            if (this.isComplete()) {
                this.getView().returnDataToParent((Object)Boolean.TRUE);
            } else {
                e.setCancel(true);
                this.getPageCache().putBigObject("op", BTN_CANCEL);
                this.confirm();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if (BTN_CANCEL.equals(callBackId)) {
            if (e.getResult() == MessageBoxResult.Yes) {
                String entity = (String)this.getView().getFormShowParameter().getCustomParam("param_entity");
                BaseDataRelBitRestoreService.stop((String)entity);
                this.getView().close();
            } else {
                this.getPageCache().removeBigObject("op");
            }
        }
    }
}

