/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.basedata.common.BaseDataCtrlLog;
import kd.bos.basedata.service.BDCtrlLogServiceHelper;
import kd.bos.bd.common.BaseDataCommon;
import kd.bos.bd.ctsy.service.CtsyCommonService;
import kd.bos.bd.ctsy.service.CtsyIndividualizeService;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.plugin.bdctrl.BdCtrlStrtgyUtils;
import kd.bos.form.plugin.bdctrl.helper.BaseDataCommonServiceHelper;
import kd.bos.form.plugin.bdctrl.service.BaseDataNewDataCache;
import kd.bos.form.plugin.bdctrl.validator.BaseDataPermValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class BaseDataSavePlugin
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(BaseDataSavePlugin.class);
    private static final String USEORG = "useorg";
    private static final String FIELD_ORG_ID = "forgid";
    private static final String USEORGID = "useOrgID";
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private Set<Long> isUpdateDataSet = new HashSet<Long>(16);
    private static final String NAME_VERSION_ENTRY = "name$version";
    private static final String PRO_CREATEORG = "createOrg";
    private Map<String, Map<String, Boolean>> fieldRuleMap = new HashMap<String, Map<String, Boolean>>(16);

    public void onPreparePropertys(PreparePropertysEventArgs eventArgs) {
        eventArgs.getFieldKeys().add("ctrlstrategy");
        eventArgs.getFieldKeys().add("org");
        eventArgs.getFieldKeys().add("createorg");
        eventArgs.getFieldKeys().add(USEORG);
        eventArgs.getFieldKeys().add("srccreateorg");
        String entityId = this.billEntityType.getName();
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        eventArgs.getFieldKeys().add(masterIdPropName);
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            eventArgs.getFieldKeys().add("bitindex");
            eventArgs.getFieldKeys().add("srcindex");
            eventArgs.getFieldKeys().add("sourcedata");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String entityKey = this.billEntityType.getName();
        BaseDataValidator validator = new BaseDataValidator();
        validator.setEntityKey(entityKey);
        BaseDataPermValidator permValidator = new BaseDataPermValidator();
        permValidator.setEntityKey(entityKey);
        e.addValidator((AbstractValidator)permValidator);
        e.addValidator((AbstractValidator)validator);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List objs = e.getValidExtDataEntities();
        if (CollectionUtils.isEmpty((Collection)objs)) {
            return;
        }
        ExtendedDataEntity entity = (ExtendedDataEntity)objs.get(0);
        DynamicObject obj = entity.getDataEntity();
        String entityNumber = obj.getDataEntityType().getName();
        if (BaseDataBusinessServiceUtils.isEnableVersion((String)entityNumber)) {
            return;
        }
        this.getOption().setVariableValue("dataId", "0");
        String personalDataKey = "isPersonalizeData";
        if (this.getOption().getVariables().containsKey(personalDataKey)) {
            String isPersonalizeData = this.getOption().getVariableValue(personalDataKey);
            if ("1".equals(isPersonalizeData)) {
                this.handleModify(e, isPersonalizeData);
            } else if ("0".equals(isPersonalizeData)) {
                this.beforeExecuteOperationTransaction(objs, e);
            }
        } else {
            this.handleModify(e, "0");
        }
        this.beforeHandleDataSync(objs);
    }

    private void beforeExecuteOperationTransaction(List<ExtendedDataEntity> objs, BeforeOperationArgs e) {
        Iterator<ExtendedDataEntity> iter = objs.iterator();
        while (iter.hasNext()) {
            ExtendedDataEntity entity = iter.next();
            DynamicObject obj = entity.getDataEntity();
            Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)"createorg");
            String value = this.getOption().getVariableValue(USEORGID, "0");
            Long useOrgId = StringUtils.isEmpty((CharSequence)value) ? 0L : Long.parseLong(value);
            boolean fromDatabase = obj.getDataEntityState().getFromDatabase();
            if (fromDatabase && !useOrgId.equals(0L) && !useOrgId.equals(createOrgId)) {
                OperateErrorInfo info = new OperateErrorInfo();
                info.setLevel(ErrorLevel.Error);
                info.setMessage(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"BaseDataSavePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.operationResult.addErrorInfo(info);
                iter.remove();
                continue;
            }
            if (!fromDatabase && null == obj.get("srccreateorg")) {
                obj.set("srccreateorg", obj.get("createorg"));
            }
            BaseDataSavePlugin.handleCtsyIndividualize(e, iter, obj, createOrgId);
        }
    }

    private void beforeHandleDataSync(List<ExtendedDataEntity> objs) {
        if (CollectionUtils.isEmpty(objs)) {
            return;
        }
        String entityId = objs.get(0).getDataEntity().getDataEntityType().getName();
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        boolean isSyncData = BaseDataCommonService.isSyncData((String)entityId);
        HashMap<String, String> dataChangedProperties = new HashMap<String, String>(16);
        HashMap<String, String> dataChangedColProperties = new HashMap<String, String>(16);
        Object[] objIds = objs.stream().map(ExtendedDataEntity::getBillPkId).toArray();
        HashMap<Object, Object> oldObjs = new HashMap<Object, Object>(16);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityId);
        Object[] load = BusinessDataServiceHelper.load((Object[])objIds, (DynamicObjectType)type);
        BusinessDataReader.loadRefence((Object[])load, (IDataEntityType)type);
        for (Object data : load) {
            oldObjs.put(data.getPkValue(), data);
        }
        String useOrgIdOp = this.getOption().getVariableValue(USEORGID, "0");
        Long useOrgId = StringUtils.isEmpty((CharSequence)useOrgIdOp) ? 0L : Long.parseLong(useOrgIdOp);
        for (ExtendedDataEntity entity : objs) {
            String ctrlstrategy;
            boolean notAssignStrategy;
            DynamicObject obj = entity.getDataEntity();
            Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)"createorg");
            if (!obj.getDataEntityState().getFromDatabase()) continue;
            this.isUpdateDataSet.add((Long)obj.getPkValue());
            if (!useOrgId.equals(0L) && !useOrgId.equals(createOrgId) || (notAssignStrategy = !"1".equals(ctrlstrategy = obj.getString("ctrlstrategy")) && !"2".equals(ctrlstrategy)) || !obj.get("id").equals(obj.get(masterIdPropName))) continue;
            HashMap<String, Boolean> mapShare = new HashMap<String, Boolean>();
            HashMap<String, Boolean> mapUpdate = new HashMap<String, Boolean>();
            BdCtrlStrtgyUtils.getShareInfoFromBdCtrlStrtgy(entityId, createOrgId, mapShare, mapUpdate);
            if (!isSyncData) {
                boolean numberUpdate = mapUpdate.getOrDefault("number", false);
                mapUpdate.clear();
                mapUpdate.put("number", numberUpdate);
            }
            if (CollectionUtils.isEmpty(mapUpdate) || !mapUpdate.containsKey("number")) {
                mapUpdate.put("number", false);
            }
            HashSet<String> changedProperties = new HashSet<String>(16);
            HashSet<String> changedColProperties = new HashSet<String>(16);
            List dirtyProperties = obj.getDataEntityState().GetDirtyProperties();
            for (IDataEntityProperty property : dirtyProperties) {
                String name = property.getName();
                String alias = property.getAlias();
                if (StringUtils.isEmpty((CharSequence)alias)) continue;
                String tempName = name;
                if (name.endsWith("_id")) {
                    tempName = name.substring(0, name.lastIndexOf("_id"));
                }
                if (mapUpdate.get(tempName) == null || Boolean.TRUE.equals(mapUpdate.get(tempName))) continue;
                changedProperties.add(name);
            }
            DynamicObject oldObj = (DynamicObject)oldObjs.get(obj.getPkValue());
            for (ICollectionProperty colproperty : obj.getDataEntityType().getProperties().getCollectionProperties(false)) {
                DynamicObjectCollection entrys = new DynamicObjectCollection();
                if (colproperty.getValue((Object)obj) instanceof DynamicObjectCollection) {
                    entrys = (DynamicObjectCollection)colproperty.getValue((Object)obj);
                }
                DynamicObjectCollection oldEntrys = new DynamicObjectCollection();
                if (colproperty.getValue((Object)oldObj) instanceof DynamicObjectCollection) {
                    oldEntrys = (DynamicObjectCollection)colproperty.getValue((Object)oldObj);
                }
                if (entrys.size() != oldEntrys.size()) {
                    if (mapUpdate.get(colproperty.getName()) == null || Boolean.TRUE.equals(mapUpdate.get(colproperty.getName()))) continue;
                    changedColProperties.add(colproperty.getName());
                    continue;
                }
                for (DynamicObject item : entrys) {
                    List changeItemProperties = item.getDataEntityState().GetDirtyProperties();
                    for (IDataEntityProperty property : changeItemProperties) {
                        String alias = property.getAlias();
                        if (StringUtils.isEmpty((CharSequence)alias) || mapUpdate.get(colproperty.getName()) == null || Boolean.TRUE.equals(mapUpdate.get(colproperty.getName()))) continue;
                        changedColProperties.add(colproperty.getName());
                    }
                }
            }
            if (changedProperties.size() > 0) {
                dataChangedProperties.put(obj.getPkValue().toString(), JSONObject.toJSONString(changedProperties));
            }
            if (changedColProperties.size() <= 0) continue;
            dataChangedColProperties.put(obj.getPkValue().toString(), JSONObject.toJSONString(changedColProperties));
        }
        if (dataChangedProperties.size() > 0) {
            this.getOption().setVariableValue("changedProperties", JSONObject.toJSONString(dataChangedProperties));
        }
        if (dataChangedColProperties.size() > 0) {
            this.getOption().setVariableValue("changedColProperties", JSONObject.toJSONString(dataChangedColProperties));
        }
    }

    private void handleModify(BeforeOperationArgs e, String isPersonalizeData) {
        List objs = e.getValidExtDataEntities();
        if (objs == null) {
            return;
        }
        Iterator<ExtendedDataEntity> iter = objs.iterator();
        while (iter.hasNext()) {
            boolean fromDatabase;
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)iter.next();
            DynamicObject obj = dataEntity.getDataEntity();
            Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)USEORG);
            String ctrlStrategy = obj.getString("ctrlstrategy");
            boolean isAssignStrategy = "1".equals(ctrlStrategy) || "2".equals(ctrlStrategy);
            String entityNumber = obj.getDataEntityType().getName();
            if (!BaseDataBusinessServiceUtils.isEnableVersion((String)entityNumber) && isAssignStrategy && "1".equals(isPersonalizeData) && BaseDataCommonServiceHelper.havePersonaliedData(obj, String.valueOf(useOrgId))) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u4e2a\u6027\u5316\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"BaseDataSavePlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            Long adminOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)"org");
            Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)"createorg");
            if (adminOrgId == 0L || !adminOrgId.equals(createOrgId)) {
                obj.set("org_id", (Object)createOrgId);
            }
            if (StringUtils.isEmpty((CharSequence)obj.getString("ctrlstrategy"))) {
                this.setCtrlStrategy(createOrgId.toString(), obj);
            }
            if (fromDatabase = obj.getDataEntityState().getFromDatabase()) {
                this.executeIndividuation(e, obj, iter, createOrgId, useOrgId);
            } else {
                obj.set("srccreateorg", obj.get("createorg"));
            }
            BaseDataSavePlugin.handleCtsyIndividualize(e, iter, obj, createOrgId);
        }
    }

    private static void handleCtsyIndividualize(BeforeOperationArgs e, Iterator<ExtendedDataEntity> iter, DynamicObject obj, Long createOrgId) {
        boolean isSubTenant = CtsyCommonService.ifCurrentIsSubTenant();
        Long srcCreateOrgId = AbstractBaseDataService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)"srccreateorg");
        if (!obj.getDataEntityState().getFromDatabase() && null != srcCreateOrgId && !srcCreateOrgId.equals(0L) && !srcCreateOrgId.equals(createOrgId) && isSubTenant) {
            String entity = obj.getDataEntityType().getName();
            BaseDataResponse response = new CtsyIndividualizeService(entity, createOrgId).handleIndividualizeBeforeSave(obj);
            iter.remove();
            if (!response.isSuccess()) {
                Collection errorList;
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append(ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u5931\u8d25", (String)"BaseDataSavePlugin_18", (String)SYSTEM_TYPE, (Object[])new Object[0])).append('\uff0c').append(response.getErrorMsg());
                Map errorResult = response.getResult();
                if (!CollectionUtils.isEmpty((Map)errorResult) && !CollectionUtils.isEmpty(errorList = errorResult.values())) {
                    errorList.stream().filter(Objects::nonNull).map(Map::values).flatMap(Collection::stream).filter(Objects::nonNull).forEach(errorMsg::append);
                }
                e.setCancel(true);
                e.setCancelMessage(errorMsg.toString());
            }
        }
    }

    private void setCtrlStrategy(String createOrgId, DynamicObject obj) {
        String ctrlStrategy = BaseDataServiceHelper.getBdCtrlStrgy((String)obj.getDynamicObjectType().getName(), (String)createOrgId);
        if (StringUtils.isBlank((CharSequence)ctrlStrategy)) {
            return;
        }
        String[] strategyArr = ctrlStrategy.split(",");
        if (strategyArr.length == 1) {
            obj.set("ctrlstrategy", (Object)ctrlStrategy);
            return;
        }
        for (String ctr : strategyArr) {
            if (!StringUtils.isNotEmpty((CharSequence)ctr)) continue;
            obj.set("ctrlstrategy", (Object)ctr);
            break;
        }
    }

    private void executeIndividuation(BeforeOperationArgs e, DynamicObject data, Iterator<ExtendedDataEntity> iter, Long createOrgId, Long useOrgId) {
        boolean isEntryModify = data.getDataEntityState().getDataEntityDirty() || BaseDataSavePlugin.isEntryModify(data);
        String entityNumber = data.getDataEntityType().getName();
        if (isEntryModify && data.getPkValue() != null && (Long)data.getPkValue() != 0L && !useOrgId.equals(0L) && !createOrgId.equals(useOrgId)) {
            boolean shareStrategy;
            if (BaseDataServiceHelper.isNoneCustomEntity((String)entityNumber).booleanValue()) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e2a\u6027\u5316\u3002", (String)"BaseDataSavePlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            String ctrlStrategy = data.getString("ctrlstrategy");
            boolean enableVersion = BaseDataBusinessServiceUtils.isEnableVersion((String)entityNumber);
            boolean bl = shareStrategy = "5".equals(ctrlStrategy) || "6".equals(ctrlStrategy);
            if (!enableVersion && shareStrategy) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u201c\u5171\u4eab\u578b\u201d\u7b56\u7565\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"BaseDataSavePlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            if (!enableVersion && "7".equals(ctrlStrategy)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u201c\u79c1\u6709\u578b\u201d\u7b56\u7565\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"BaseDataSavePlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            if (BaseDataCommonService.isTreeType((String)entityNumber) && this.individuationValidateOnTreeType(e, data, useOrgId, entityNumber)) {
                return;
            }
            Object oldPk = data.getPkValue();
            boolean isModify = BaseDataServiceHelper.handleModify((DynamicObject)data);
            if (isModify) {
                new CtsyIndividualizeService(entityNumber, useOrgId).ctsyIndividualize(Collections.singleton(data.getLong("id")));
                this.getOption().setVariableValue("dataId", String.valueOf(data.getPkValue()));
                iter.remove();
                ArrayList<BaseDataCtrlLog> bdCtrlLogs = new ArrayList<BaseDataCtrlLog>(1);
                String opDescription = String.format(ResManager.loadKDString((String)"%s:\u4e2a\u6027\u5316\u6210\u529f\u3002", (String)"BaseDataSavePlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), data.getString("number"));
                String name = e.getDataEntities()[0].getDataEntityType().getName();
                BaseDataCtrlLog log = new BaseDataCtrlLog("basedata", name, "individuation", useOrgId, opDescription);
                log.setOpKey("individuation");
                log.setOpShowName(BaseDataCommon.getOpName((String)entityNumber, (String)"individuation"));
                log.setMultiLangDesc(new MultiLangEnumBridge("%s:\u4e2a\u6027\u5316\u6210\u529f\u3002", "BaseDataSavePlugin_6", SYSTEM_TYPE));
                log.setArgs(new String[]{data.getString("number")});
                log.setKeyWord(data.getString("number"));
                bdCtrlLogs.add(log);
                BDCtrlLogServiceHelper.saveLogBatch(bdCtrlLogs);
            }
            this.getOperationResult().addSuccessPkId(oldPk);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u4e0e\u521b\u5efa\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u521b\u5efa\u4e2a\u6027\u5316\u8bb0\u5f55\u3002", (String)"BaseDataSavePlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private boolean individuationValidateOnTreeType(BeforeOperationArgs e, DynamicObject data, Long useOrgId, String entity) {
        if (TreeBaseDataCommonService.isAssignUnDetail((String)entity)) {
            List<Long> dataIds = Collections.singletonList((Long)data.getPkValue());
            Collection coll = new TreeBaseDataCommonService(entity).getUnLastVisibleNodeByIds(useOrgId, dataIds, "number");
            if (!coll.isEmpty()) {
                String msg = ResManager.loadKDString((String)"%1$s\uff1a\u4e0d\u662f\u7ec4\u7ec7\u53ef\u89c1\u8303\u56f4\u7684\u672b\u7ea7\u8d44\u6599\uff0c\u4e0d\u80fd\u4e2a\u6027\u5316\u3002", (String)"BaseDataSavePlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                e.setCancelMessage(String.format(msg, ((DynamicObject)coll.iterator().next()).getString("number")));
                e.setCancel(true);
                return true;
            }
        } else if (!data.getBoolean("isleaf")) {
            String number = data.getString("number");
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5b58\u5728\u4e0b\u7ea7\u8d44\u6599\uff0c\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"BaseDataSavePlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
            return true;
        }
        return false;
    }

    private static boolean isEntryModify(DynamicObject obj) {
        List properties = obj.getDataEntityType().getProperties().getCollectionProperties(false);
        for (ICollectionProperty property : properties) {
            DynamicObjectCollection entries = (DynamicObjectCollection)property.getValueFast((Object)obj);
            for (DynamicObject item : entries) {
                if (!item.getDataEntityState().getDataEntityDirty()) continue;
                return true;
            }
        }
        return false;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (null == dataEntities || dataEntities.length == 0) {
            return;
        }
        String entityId = this.billEntityType.getName();
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        for (DynamicObject obj : dataEntities) {
            if ("masterid".equals(masterIdPropName)) continue;
            Long id = obj.getLong("id");
            if (0L != obj.getLong(masterIdPropName)) continue;
            obj.set(masterIdPropName, (Object)id);
        }
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            new BaseDataCommonService().generateBaseDataBitIndexAndSourceId(dataEntities, entityId);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String nameVersionChangedProperties;
        String changedColPropertiesStr;
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (objs == null || objs.length == 0) {
            return;
        }
        String entityId = objs[0].getDataEntityType().getName();
        BaseDataNewDataCache.afterNewData(objs, this.isUpdateDataSet);
        boolean isSyncData = BaseDataCommonService.isSyncData((String)entityId);
        Map dataChangedProperties = new HashMap(16);
        Map dataChangedColProperties = new HashMap(16);
        String changedPropertiesStr = this.getOption().getVariableValue("changedProperties", "");
        if (!StringUtils.isEmpty((CharSequence)changedPropertiesStr)) {
            dataChangedProperties = (Map)JSONObject.parse((String)changedPropertiesStr);
        }
        if (!StringUtils.isEmpty((CharSequence)(changedColPropertiesStr = this.getOption().getVariableValue("changedColProperties", "")))) {
            dataChangedColProperties = (Map)JSONObject.parse((String)changedColPropertiesStr);
        }
        Map nameVersionPropertiesMap = StringUtils.isEmpty((CharSequence)(nameVersionChangedProperties = this.getOption().getVariableValue("nameVersionChangedProperties", ""))) ? new HashMap(0) : (Map)SerializationUtils.fromJsonString((String)nameVersionChangedProperties, Map.class);
        for (DynamicObject obj : objs) {
            List<String> changedProperties = new ArrayList<String>(16);
            List<String> changedColProperties = new ArrayList<String>(16);
            String pkValue = obj.getPkValue().toString();
            if (!CollectionUtils.isEmpty(dataChangedProperties) && !StringUtils.isEmpty((CharSequence)(changedPropertiesStr = (String)dataChangedProperties.get(pkValue)))) {
                changedProperties = (List)JSONObject.parse((String)changedPropertiesStr);
            }
            if (!CollectionUtils.isEmpty(dataChangedColProperties) && !StringUtils.isEmpty((CharSequence)(changedColPropertiesStr = (String)dataChangedColProperties.get(pkValue)))) {
                changedColProperties = (List)JSONObject.parse((String)changedColPropertiesStr);
            }
            if (CollectionUtils.isEmpty(changedProperties) && CollectionUtils.isEmpty(changedColProperties)) {
                return;
            }
            this.synPorperties(obj, changedProperties, changedColProperties, nameVersionPropertiesMap);
        }
    }

    private void synPorperties(DynamicObject dataInfo, List<String> changedProperties, List<String> changedColProperties, Map<String, String> nameVersionPropertiesMap) {
        if (CollectionUtils.isEmpty(changedProperties) && CollectionUtils.isEmpty(changedColProperties)) {
            return;
        }
        String ctrlstrategy = dataInfo.getString("ctrlstrategy");
        if (!"1".equals(ctrlstrategy) && !"2".equals(ctrlstrategy)) {
            return;
        }
        String nameVersionProperty = nameVersionPropertiesMap.get(dataInfo.getPkValue().toString());
        if ("1".equals(ctrlstrategy)) {
            this.synAssignPorperties(dataInfo, changedProperties, changedColProperties, nameVersionProperty);
        } else {
            this.synFreeAssignPorperties(dataInfo, changedProperties, changedColProperties, nameVersionProperty);
        }
    }

    private void synAssignPorperties(DynamicObject dataInfo, List<String> changedProperties, List<String> changedColProperties, String nameVersionProperty) {
        IDataEntityType dt = dataInfo.getDataEntityType();
        String entityID = dt.getName();
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityID);
        if (null == ctrlview) {
            return;
        }
        Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dataInfo, (String)"createorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(createOrgId);
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityID);
        List subOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)((Long)ctrlview.getPkValue()), orgIds, (boolean)false);
        Long masterid = dataInfo.getLong(masteridPropName);
        QFilter masteridQFilter = new QFilter(masteridPropName, "=", (Object)masterid);
        QFilter createOrgQFilter = new QFilter("createorg", "in", (Object)subOrgs);
        DynamicObject[] subCustomDatas = BusinessDataServiceHelper.load((String)entityID, (String)"id", (QFilter[])new QFilter[]{masteridQFilter, createOrgQFilter});
        if (subCustomDatas == null || subCustomDatas.length == 0) {
            return;
        }
        this.synAssignPorperties(subCustomDatas, dataInfo, dt, changedProperties, changedColProperties, masteridPropName, nameVersionProperty);
    }

    private void synAssignPorperties(DynamicObject[] subCustomDatas, DynamicObject dataInfo, IDataEntityType dt, List<String> changedProperties, List<String> changedColProperties, String masteridPropName, String nameVersionProperty) {
        ArrayList<Object> subCustomDataPKs = new ArrayList<Object>(16);
        for (DynamicObject customDataInfo : subCustomDatas) {
            subCustomDataPKs.add(customDataInfo.getPkValue());
        }
        for (DynamicObject customDataInfo : subCustomDatas = (DynamicObject[])BusinessDataServiceHelper.load((Object[])subCustomDataPKs.toArray(), (IDataEntityType)dataInfo.getDataEntityType())) {
            IDataEntityProperty dpOldProp;
            if (customDataInfo.getPkValue().equals(customDataInfo.get(masteridPropName))) continue;
            boolean isOnlyDbProperty = true;
            for (ISimpleProperty sp : dt.getProperties().getSimpleProperties(isOnlyDbProperty)) {
                if (!changedProperties.contains(sp.getName())) continue;
                dpOldProp = null;
                RefObject tempRef_dpOldProp = new RefObject(dpOldProp);
                this.TryGetOldProperty((IDataEntityProperty)sp, dt, (RefObject<IDataEntityProperty>)tempRef_dpOldProp);
                dpOldProp = (IDataEntityProperty)tempRef_dpOldProp.argvalue;
                if (sp.getReadOnly() || dpOldProp == null) continue;
                sp.setValue((Object)customDataInfo, dpOldProp.getValue((Object)dataInfo));
                if (nameVersionProperty == null || !nameVersionProperty.equals(sp.getName())) continue;
                changedColProperties.add(NAME_VERSION_ENTRY);
            }
            for (ICollectionProperty colp : dt.getProperties().getCollectionProperties(isOnlyDbProperty)) {
                List colpNewListValue;
                if (!changedColProperties.contains(colp.getName())) continue;
                dpOldProp = null;
                RefObject tempRef_dpOldProp3 = new RefObject(dpOldProp);
                this.TryGetOldProperty((IDataEntityProperty)colp, dt, (RefObject<IDataEntityProperty>)tempRef_dpOldProp3);
                dpOldProp = (IDataEntityProperty)tempRef_dpOldProp3.argvalue;
                Object colpValue = dpOldProp.getValue((Object)dataInfo);
                if (colp == null || colpValue == null) continue;
                Iterable colpListValue = (Iterable)(colpValue instanceof Iterable ? colpValue : null);
                if (colpListValue == null) {
                    LOGGER.warn("\u54e6\uff0c\u771f\u4e0d\u5e78\uff0c\u96c6\u5408\u7684\u5c5e\u6027\u8fd4\u56de\u503c\u4e0d\u652f\u6301\u679a\u4e3e\u3002");
                    continue;
                }
                customDataInfo.getDataStorage().setLocalValue((IDataEntityProperty)colp, null);
                Object colpNewValue = colp.getValue((Object)customDataInfo);
                if (colpNewValue == null) {
                    if (!colp.getReadOnly()) {
                        colpNewValue = TypesContainer.createInstance((Class)colp.getPropertyType());
                        colp.setValue((Object)customDataInfo, colpNewValue);
                    } else {
                        LOGGER.warn("\u54e6\uff0c\u771f\u4e0d\u5e78\uff0c\u96c6\u5408\u7684\u5c5e\u6027\u8fd4\u56de\u503c\u4e3anull\u3002");
                        continue;
                    }
                }
                if ((colpNewListValue = (List)(colpNewValue instanceof List ? colpNewValue : null)) == null) {
                    LOGGER.warn("\u54e6\uff0c\u771f\u4e0d\u5e78\uff0c\u96c6\u5408\u7684\u5c5e\u6027\u8fd4\u56de\u503c\u4e0d\u652f\u6301IList\u3002");
                    continue;
                }
                colpNewListValue.clear();
                for (Object item : colpListValue) {
                    IDataEntityBase itemAsEntity = (IDataEntityBase)(item instanceof IDataEntityBase ? item : null);
                    IDataEntityType itemType = itemAsEntity == null ? colp.getItemType() : itemAsEntity.getDataEntityType();
                    CloneUtils cloneUtils = new CloneUtils(true, true);
                    colpNewListValue.add(cloneUtils.clone(itemType, item));
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])subCustomDatas);
    }

    private void synFreeAssignPorperties(DynamicObject dataInfo, List<String> changedProperties, List<String> changedColProperties, String nameVersionProperty) {
        Long masterid;
        IDataEntityType dt = dataInfo.getDataEntityType();
        String entityID = dt.getName();
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityID);
        Long id = (Long)dataInfo.getPkValue();
        if (!id.equals(masterid = Long.valueOf(dataInfo.getLong(masteridPropName)))) {
            return;
        }
        QFilter masteridQFilter = new QFilter(masteridPropName, "=", (Object)masterid);
        DynamicObject[] subCustomDatas = BusinessDataServiceHelper.load((String)entityID, (String)"id", (QFilter[])new QFilter[]{masteridQFilter});
        if (subCustomDatas == null || subCustomDatas.length == 0) {
            return;
        }
        this.synAssignPorperties(subCustomDatas, dataInfo, dt, changedProperties, changedColProperties, masteridPropName, nameVersionProperty);
    }

    private boolean TryGetOldProperty(IDataEntityProperty dp, IDataEntityType dtOldData, RefObject<IDataEntityProperty> dpOldProperty) {
        dpOldProperty.argvalue = null;
        if (dtOldData == null || dp == null) {
            return false;
        }
        return dtOldData.getProperties().tryGetValue(dp.getName(), dpOldProperty);
    }

    protected String checkFieldRule(ExtendedDataEntity dataEntity, DynamicObject obj, DynamicObject objFromDb) {
        Map<String, Boolean> mapUpdate;
        DynamicObject originalData;
        boolean notEquals;
        String entityId = obj.getDataEntityType().getName();
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        Long oriOrgId = 0L;
        Long masterId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)masterIdPropName);
        Object id = obj.get("id");
        Object mstId = obj.get(masterIdPropName);
        boolean bl = notEquals = id != null && mstId != null && !id.equals(masterId);
        if (notEquals && (originalData = BusinessDataServiceHelper.loadSingleFromCache((Object)masterId, (String)entityId)) != null && originalData.getDynamicObject(PRO_CREATEORG) != null) {
            oriOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)originalData, (String)PRO_CREATEORG);
        }
        if ((mapUpdate = this.fieldRuleMap.get(oriOrgId.toString())) == null) {
            HashMap<String, Boolean> mapShare = new HashMap<String, Boolean>(16);
            mapUpdate = new HashMap<String, Boolean>(16);
            BdCtrlStrtgyUtils.getShareInfoFromBdCtrlStrtgy(entityId, oriOrgId, mapShare, mapUpdate);
            if (!mapUpdate.isEmpty() && !mapUpdate.containsKey("number")) {
                mapUpdate.put("number", Boolean.FALSE);
            }
            this.fieldRuleMap.put(oriOrgId.toString(), mapUpdate);
        }
        if (mapUpdate.size() == 0) {
            HashMap<String, Boolean> unModifyMap = new HashMap<String, Boolean>(16);
            unModifyMap.put("number", Boolean.FALSE);
            return this.headUnModifyVerification(obj, objFromDb, unModifyMap);
        }
        return this.unModifyVerification(obj, objFromDb, mapUpdate);
    }

    private String unModifyVerification(DynamicObject obj, DynamicObject objFromDb, Map<String, Boolean> mapUpdate) {
        String message = this.headUnModifyVerification(obj, objFromDb, mapUpdate);
        if (null != message) {
            return message;
        }
        HashSet<String> changedColProperties = new HashSet<String>(16);
        block0: for (ICollectionProperty colproperty : obj.getDataEntityType().getProperties().getCollectionProperties(true)) {
            String propertyName;
            Boolean isUpdate;
            if (!(colproperty instanceof EntryProp) || Boolean.TRUE.equals(isUpdate = mapUpdate.get(propertyName = colproperty.getName()))) continue;
            DynamicObjectCollection entrys = (DynamicObjectCollection)obj.get(propertyName);
            DynamicObjectCollection entrysFromDB = null == objFromDb ? new DynamicObjectCollection() : (DynamicObjectCollection)objFromDb.get(propertyName);
            if (entrys.size() != entrysFromDB.size()) {
                String fldName = colproperty.getDisplayName() == null ? propertyName : colproperty.getDisplayName().toString();
                changedColProperties.add(fldName);
                continue;
            }
            for (DynamicObject item : entrys) {
                List changeItemProperties = item.getDataEntityState().GetDirtyProperties();
                if (changeItemProperties == null || changeItemProperties.size() == 0) continue;
                DynamicObject itemFromDB = null;
                for (DynamicObject tempObj : entrysFromDB) {
                    if (tempObj == null || !tempObj.getPkValue().equals(item.getPkValue())) continue;
                    itemFromDB = tempObj;
                    break;
                }
                if (itemFromDB == null) {
                    String fldName = colproperty.getDisplayName() == null ? propertyName : colproperty.getDisplayName().toString();
                    changedColProperties.add(fldName);
                    continue;
                }
                boolean isBreak = false;
                for (IDataEntityProperty property : changeItemProperties) {
                    String name = property.getName();
                    String alias = property.getAlias();
                    if (StringUtils.isEmpty((CharSequence)alias) || this.equals(item.get(name), itemFromDB.get(name))) continue;
                    String fldName = colproperty.getDisplayName() == null ? colproperty.getName() : colproperty.getDisplayName().toString();
                    changedColProperties.add(fldName);
                    isBreak = true;
                    break;
                }
                if (!isBreak) continue;
                continue block0;
            }
        }
        if (changedColProperties.size() > 0) {
            String fldNames = String.join((CharSequence)",", changedColProperties);
            return String.format(ResManager.loadKDString((String)"[%1$s]\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"BaseDataSavePlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), fldNames);
        }
        return null;
    }

    private String headUnModifyVerification(DynamicObject obj, DynamicObject objFromDb, Map<String, Boolean> mapUpdate) {
        HashSet<String> changedProperties = new HashSet<String>(16);
        List dirtyProperties = obj.getDataEntityState().GetDirtyProperties();
        for (IDataEntityProperty property : dirtyProperties) {
            Boolean isUpdate;
            String name = property.getName();
            String alias = property.getAlias();
            if (StringUtils.isEmpty((CharSequence)alias) || name.endsWith("_id") || !Boolean.FALSE.equals(isUpdate = mapUpdate.get(name)) || objFromDb == null || this.equals(obj.get(name), objFromDb.get(name))) continue;
            String fldName = property.getDisplayName() == null ? property.getName() : property.getDisplayName().toString();
            changedProperties.add(fldName);
        }
        if (changedProperties.size() > 0) {
            String fieldName = String.join((CharSequence)",", changedProperties);
            return String.format(ResManager.loadKDString((String)"[%1$s]\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"BaseDataSavePlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), fieldName);
        }
        return null;
    }

    private static boolean isEqualMap(Map mapa, Map mapb) {
        if (mapa.size() != mapb.size()) {
            return false;
        }
        for (Map.Entry entry : mapa.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(value == null ? mapb.get(key) != null || !mapb.containsKey(key) : !value.equals(mapb.get(key)))) continue;
            return false;
        }
        return true;
    }

    private boolean equals(Object obj1, Object obj2) {
        boolean isEqual = true;
        if (obj1 instanceof Map && obj2 instanceof Map) {
            Map map1 = (Map)obj1;
            Map map2 = (Map)obj2;
            return BaseDataSavePlugin.isEqualMap(map1, map2);
        }
        return obj1.equals(obj2);
    }

    class BaseDataValidator
    extends AbstractValidator {
        private static final String PRO_ID = "id";
        String masterIdPropName = "";
        Map<String, Map<String, Boolean>> fieldRuleMap = new HashMap<String, Map<String, Boolean>>(16);

        BaseDataValidator() {
        }

        public void validate() {
            if (null == this.dataEntities || this.dataEntities.length == 0) {
                return;
            }
            if (!BaseDataServiceHelper.checkBaseDataCtrl((String)this.entityKey).booleanValue()) {
                return;
            }
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entityKey);
            if (null == ctrlView) {
                return;
            }
            ArrayList<Object> dataIds = new ArrayList<Object>(this.dataEntities.length);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                dataIds.add(dataEntity.getDataEntity().get(PRO_ID));
            }
            Map dbDataMap = BusinessDataServiceHelper.loadFromCache((String)this.getEntityKey(), (QFilter[])new QFilter[]{new QFilter(PRO_ID, "in", dataIds)});
            String personalDataKey = "isPersonalizeData";
            if (this.getOption().getVariables().containsKey(personalDataKey)) {
                String isPersonalizeData = this.getOption().getVariableValue(personalDataKey);
                String orgField = "createorg";
                if ("1".equals(isPersonalizeData)) {
                    orgField = BaseDataSavePlugin.USEORG;
                }
                this.cuValidateOnPageOp(orgField, ctrlView);
                this.validateFieldCannotChanged(dbDataMap);
            } else {
                this.validateFieldCannotChanged(dbDataMap);
                this.cuValidateOnOtherSaveType(ctrlView, dbDataMap);
            }
        }

        private void validateFieldCannotChanged(Map<Object, DynamicObject> idDataMap) {
            String skipValidation = this.getOption().getVariableValue("bdCtrl_skipValidation", "0");
            if ("1".equals(skipValidation) || CollectionUtils.isEmpty(idDataMap)) {
                return;
            }
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                long oldCreateOrgId;
                DynamicObject obj = dataEntity.getDataEntity();
                String ctrlStrategy = obj.getString("ctrlstrategy");
                DynamicObject createOrg = obj.getDynamicObject("createorg");
                long createOrgId = null != createOrg ? createOrg.getLong(PRO_ID) : 0L;
                DynamicObject data = idDataMap.get(dataEntity.getDataEntity().get(PRO_ID));
                if (null != ctrlStrategy && null != data && !data.getString("ctrlstrategy").equals(ctrlStrategy)) {
                    String errorMsg = ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u4e0d\u5141\u8bb8\u76f4\u63a5\u4fee\u6539\uff0c\u8bf7\u901a\u8fc7\u201c\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u201d\u529f\u80fd\u53d8\u66f4\u3002", (String)"BaseDataSavePlugin_15", (String)BaseDataSavePlugin.SYSTEM_TYPE, (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, errorMsg);
                }
                long l = oldCreateOrgId = null != data && null != data.getDynamicObject("createorg") ? data.getDynamicObject("createorg").getLong(PRO_ID) : 0L;
                if (createOrgId == oldCreateOrgId || createOrgId == 0L || oldCreateOrgId == 0L) continue;
                String errorMsg = ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u4e0d\u5141\u8bb8\u76f4\u63a5\u4fee\u6539\uff0c\u8bf7\u901a\u8fc7\u201c\u7ba1\u7406\u6743\u8f6c\u8ba9\u201d\u529f\u80fd\u53d8\u66f4\u3002", (String)"BaseDataSavePlugin_16", (String)BaseDataSavePlugin.SYSTEM_TYPE, (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
            }
        }

        private void cuValidateOnOtherSaveType(DynamicObject ctrlView, Map<Object, DynamicObject> idDataMap) {
            this.masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)this.getEntityKey());
            ArrayList<Object> orgIds = new ArrayList<Object>(this.dataEntities.length);
            HashMap<ExtendedDataEntity, Long> baseDataMap = new HashMap<ExtendedDataEntity, Long>(this.dataEntities.length);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                String errorMsg;
                DynamicObject dbData;
                boolean isEntryModify;
                DynamicObject obj = dataEntity.getDataEntity();
                Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)BaseDataSavePlugin.USEORG);
                Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)"createorg");
                boolean bl = isEntryModify = obj.getDataEntityState().getDataEntityDirty() || BaseDataSavePlugin.isEntryModify(obj);
                if (isEntryModify && obj.getPkValue() != null && (Long)obj.getPkValue() != 0L && !useOrgId.equals(0L) && !createOrgId.equals(useOrgId)) {
                    orgIds.add(useOrgId);
                    baseDataMap.put(dataEntity, useOrgId);
                    dbData = idDataMap.get(obj.get(PRO_ID));
                    if (null == dbData || null == (errorMsg = BaseDataSavePlugin.this.checkFieldRule(dataEntity, obj, dbData))) continue;
                    this.addErrorMessage(dataEntity, errorMsg);
                    continue;
                }
                if (isEntryModify && !Objects.equals(obj.getPkValue(), obj.getLong(this.masterIdPropName)) && null != (dbData = idDataMap.get(obj.get(PRO_ID))) && null != (errorMsg = BaseDataSavePlugin.this.checkFieldRule(dataEntity, obj, dbData))) {
                    this.addErrorMessage(dataEntity, errorMsg);
                }
                orgIds.add(createOrgId);
                baseDataMap.put(dataEntity, createOrgId);
            }
            Set<Long> cuOrgIds = this.getCuOrgIds(ctrlView, orgIds);
            if (CollectionUtils.isEmpty(cuOrgIds)) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    this.addErrorMessage(dataEntity);
                }
                return;
            }
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                Long orgId = (Long)baseDataMap.get(dataEntity);
                if (null == orgId || cuOrgIds.contains(orgId)) continue;
                this.addErrorMessage(dataEntity);
            }
        }

        private void addErrorMessage(ExtendedDataEntity dataEntity) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u5931\u8d25\uff0c\u521b\u5efa\u7ec4\u7ec7\u4e0d\u662f\u7ec4\u7ec7\u89c6\u56fe\u4e0a\u7684\u7ba1\u63a7\u5355\u5143\u3002", (String)"BaseDataSavePlugin_8", (String)BaseDataSavePlugin.SYSTEM_TYPE, (Object[])new Object[0]));
        }

        private void cuValidateOnPageOp(String orgField, DynamicObject ctrlView) {
            HashMap<Long, Set> baseDataMap = new HashMap<Long, Set>(16);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                try {
                    DynamicObject baseData = dataEntity.getDataEntity();
                    Object org = baseData.get(orgField);
                    Long orgId = org instanceof DynamicObject ? (Long)((DynamicObject)org).getPkValue() : Long.valueOf(org.toString());
                    baseDataMap.computeIfAbsent(orgId, k -> new HashSet(16)).add(dataEntity);
                }
                catch (Exception e) {
                    LOGGER.error("\u83b7\u53d6\u6570\u636e\u521b\u5efa\u7ec4\u7ec7\u5931\u8d25...", (Throwable)e);
                }
            }
            if (baseDataMap.isEmpty()) {
                return;
            }
            Set<Long> orgIds = this.getCuOrgIds(ctrlView, new ArrayList<Object>(baseDataMap.keySet()));
            if (CollectionUtils.isEmpty(orgIds)) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    this.addErrorMessage(dataEntity);
                }
                return;
            }
            for (Map.Entry entry : baseDataMap.entrySet()) {
                if (orgIds.contains(entry.getKey())) continue;
                Set value = (Set)entry.getValue();
                value.forEach(this::addErrorMessage);
            }
        }

        private Set<Long> getCuOrgIds(DynamicObject ctrlView, List<Object> orgIds) {
            Long viewId = (Long)ctrlView.getPkValue();
            SqlBuilder builder = new SqlBuilder();
            builder.append("select forgid from t_org_structure where fviewid = ", new Object[0]).append(viewId.toString(), new Object[0]);
            builder.append(" and fisctrlunit = '1' and ", new Object[0]);
            builder.appendIn(BaseDataSavePlugin.FIELD_ORG_ID, orgIds);
            return (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, resultSet -> {
                HashSet<Long> result = new HashSet<Long>(16);
                while (resultSet.next()) {
                    result.add(resultSet.getLong(BaseDataSavePlugin.FIELD_ORG_ID));
                }
                return result;
            });
        }
    }
}

