/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.plugin.bdctrl.op.AbstractBaseDataOpServicePlugin;
import kd.bos.form.plugin.bdctrl.service.BaseDataNewDataCache;
import kd.bos.form.plugin.bdctrl.validator.BaseDataPermValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BaseDataSubmitPlugin
extends AbstractBaseDataOpServicePlugin {
    private static final Log LOGGER = LogFactory.getLog(BaseDataSubmitPlugin.class);
    private Set<Long> isUpdateDataSet = new HashSet<Long>(16);

    public void onPreparePropertys(PreparePropertysEventArgs eventArgs) {
        eventArgs.getFieldKeys().add("ctrlstrategy");
        eventArgs.getFieldKeys().add("org");
        eventArgs.getFieldKeys().add("createorg");
        eventArgs.getFieldKeys().add("useorg");
        eventArgs.getFieldKeys().add("srccreateorg");
        String entityId = this.billEntityType.getName();
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        eventArgs.getFieldKeys().add(masterIdPropName);
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            eventArgs.getFieldKeys().add("bitindex");
            eventArgs.getFieldKeys().add("srcindex");
            eventArgs.getFieldKeys().add("sourcedata");
        }
        if (BaseDataCommonService.isTreeType((String)entityId)) {
            eventArgs.getFieldKeys().add("parent");
            eventArgs.getFieldKeys().add("longnumber");
            eventArgs.getFieldKeys().add("isleaf");
            eventArgs.getFieldKeys().add("level");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String entityKey = this.billEntityType.getName();
        BaseDataPermValidator permValidator = new BaseDataPermValidator();
        permValidator.setEntityKey(entityKey);
        e.addValidator((AbstractValidator)permValidator);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List objs = e.getValidExtDataEntities();
        if (CollectionUtils.isEmpty((Collection)objs)) {
            return;
        }
        for (ExtendedDataEntity entity : objs) {
            boolean isNewData;
            DynamicObject obj = entity.getDataEntity();
            boolean bl = isNewData = !obj.getDataEntityState().getFromDatabase();
            if (isNewData && this.isTreeType()) {
                super.beforeExecuteOperationTransaction(e, entity);
            }
            if (isNewData) {
                this.isUpdateDataSet.add((Long)obj.getPkValue());
            }
            Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)"createorg");
            Long adminOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)"org");
            if (adminOrgId == 0L || !adminOrgId.equals(createOrgId)) {
                obj.set("org_id", (Object)createOrgId);
            }
            if (!isNewData || !this.isTreeType()) continue;
            this.setCtrlStrategy(obj);
        }
    }

    private void setCtrlStrategy(DynamicObject obj) {
        String objStrategy;
        Object value = obj.get("parent");
        if (null == value) {
            return;
        }
        DynamicObject parent = (DynamicObject)value;
        String parentStrategy = parent.getString("ctrlstrategy");
        if (!parentStrategy.equals(objStrategy = obj.getString("ctrlstrategy"))) {
            obj.set("ctrlstrategy", (Object)parentStrategy);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (null == dataEntities || dataEntities.length == 0) {
            return;
        }
        String entityId = dataEntities[0].getDataEntityType().getName();
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        for (DynamicObject obj : dataEntities) {
            if ("masterid".equals(masterIdPropName)) continue;
            Long id = obj.getLong("id");
            if (0L != obj.getLong(masterIdPropName)) continue;
            obj.set(masterIdPropName, (Object)id);
        }
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            new BaseDataCommonService().generateBaseDataBitIndexAndSourceId(dataEntities, entityId);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (objs == null) {
            this.triggerEventSubscribe();
            return;
        }
        BaseDataNewDataCache.afterNewData(objs, this.isUpdateDataSet);
        if (BaseDataCommonService.isNewModel((String)this.billEntityType.getName())) {
            Boolean isNewData = Boolean.valueOf(this.operateOption.getVariableValue("new_submit", String.valueOf(false)));
            if (!isNewData.booleanValue()) {
                this.triggerEventSubscribe();
                return;
            }
            try {
                new BaseDataCommonService().handleSubmitNewCtrlData(objs);
            }
            catch (Exception ex) {
                LOGGER.error("\u63d0\u4ea4\u6570\u636e\u65f6\uff0c\u5904\u7406\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38", (Object)e);
                for (DynamicObject obj : objs) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("", ErrorLevel.Error, obj.getPkValue());
                    errorInfo.setMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5904\u7406\u4f4d\u56fe\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\u3002", (String)"BaseDataSubmitPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
                    this.operationResult.addErrorInfo(errorInfo);
                }
            }
        } else {
            BaseDataServiceHelper.baseDataSubmitHandler((DynamicObject[])objs);
        }
        this.triggerEventSubscribe();
    }
}

