/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.List;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.validator.TreeBaseDataDeleteValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.impt.ApiServiceLocalCache;
import kd.bos.form.plugin.bdctrl.DeleteBaseDataTreeValidator;
import kd.bos.form.plugin.bdctrl.validator.BaseDataPermValidator;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BaseDataTreeDeletePlugin
extends AbstractOperationServicePlugIn {
    private Boolean newModel = null;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("longnumber");
        fieldKeys.add("parent");
        fieldKeys.add("enable");
        fieldKeys.add("createorg");
        fieldKeys.add("ctrlstrategy");
        if (this.isNewModel(this.billEntityType.getName())) {
            fieldKeys.add("sourcedata");
            fieldKeys.add("srcindex");
            fieldKeys.add("bitindex");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String entityKey = this.billEntityType.getName();
        BaseDataPermValidator permValidator = new BaseDataPermValidator();
        permValidator.setEntityKey(entityKey);
        e.addValidator((AbstractValidator)permValidator);
        if (this.isNewModel(entityKey)) {
            TreeBaseDataDeleteValidator v = new TreeBaseDataDeleteValidator();
            v.setEntityKey(entityKey);
            e.addValidator((AbstractValidator)v);
        } else {
            DeleteBaseDataTreeValidator validator = new DeleteBaseDataTreeValidator();
            e.addValidator((AbstractValidator)validator);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (objs == null || objs.length == 0) {
            return;
        }
        String entityKey = this.billEntityType.getName();
        if (this.isNewModel(entityKey)) {
            String useOrgIdStr = this.getOption().getVariableValue("createOrg", null);
            if (StringUtils.isEmpty((CharSequence)useOrgIdStr)) {
                return;
            }
            Long useOrgId = Long.valueOf(useOrgIdStr);
            new BaseDataCommonService().deleteData(objs, entityKey, useOrgId);
        } else {
            BaseDataServiceHelper.baseDataDeleteHandler((DynamicObject[])objs);
        }
        ApiServiceLocalCache.clearEntityCache((String)entityKey);
    }

    private boolean isNewModel(String entity) {
        if (null == this.newModel) {
            this.newModel = BaseDataCommonService.isNewModel((String)entity);
        }
        return this.newModel;
    }
}

