/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.bd.ctsy.utils.CtsyDBUtils;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataCustomService;
import kd.bos.bd.service.ChangeCtrlStrategyService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataTreeListPlugin
extends TemplateTreePlugin {
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String LONGNUMBER = "longnumber";
    private static final String PRO_CREATEORG = "createOrg";
    private static final String CREATEORG = "createorg";
    private static final String BAR_INDIVIDUATION = "bar_individuation";
    private static final String TBLDISABLE = "tbldisable";
    private static final String TBLNEW = "tblnew";
    private static final String TBLCOPY = "tblcopy";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String NEW = "new";
    private static final String COPY = "copy";
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final String NUMBER = "number";
    private static final String ISLEAF = "isleaf";
    private static final String ENABLE = "enable";
    private static final String MULTI_ORG = "multi_org";
    private static final String LEVEL = "level";

    public ListSelectedRowCollection deleteOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection sortListSelectedRowCollection = args.getListSelectedData();
        GroupProp props = this.getTreeListView().getTreeModel().getGroupProp();
        if (props instanceof ParentBasedataProp && !BaseDataBusinessServiceUtils.isEnableVersion((String)this.getEntityNumber())) {
            BasedataEntityType entityType = props.getEntityType();
            String primaryKey = entityType.getPrimaryKey().getName();
            String entityId = entityType.getName();
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            ArrayList<Long> parentIds = new ArrayList<Long>(listSelectedRowCollection.size());
            for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                parentIds.add((Long)listSelectedRow.getPrimaryKeyValue());
            }
            TreeBaseDataCommonService service = new TreeBaseDataCommonService(entityId);
            List childList = service.getChildNodesByParentIds(parentIds, null, Collections.singletonList(primaryKey), true);
            if (!CollectionUtils.isEmpty((Collection)childList)) {
                sortListSelectedRowCollection = new ListSelectedRowCollection();
                for (DynamicObject dynamicObject : childList) {
                    ListSelectedRow rows = new ListSelectedRow((Object)dynamicObject.getLong("id"));
                    if (sortListSelectedRowCollection.contains((Object)rows)) continue;
                    sortListSelectedRowCollection.add((Object)rows);
                }
            }
        }
        return sortListSelectedRowCollection;
    }

    public DynamicObjectCollection getChildrenDynamicObject(BeforeDoOperationEventArgs args, BasedataEntityType entityType) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        ArrayList<Long> parentIds = new ArrayList<Long>(listSelectedRowCollection.size());
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            parentIds.add((Long)listSelectedRow.getPrimaryKeyValue());
        }
        String primaryKey = entityType.getPrimaryKey().getName();
        String entityId = entityType.getName();
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(entityId);
        List childList = service.getChildNodesByParentIds(parentIds, null, Collections.singletonList(primaryKey), true);
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        dynamicObjects.addAll((Collection)childList);
        return dynamicObjects;
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        Long useOrg = StringUtils.isEmpty((CharSequence)this.getPageCache().get(PRO_CREATEORG)) ? 0L : Long.parseLong(this.getPageCache().get(PRO_CREATEORG));
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            useOrg = listShowParameter.getUseOrgId();
        }
        String multiOrgStr = this.getPageCache().getBigObject(MULTI_ORG);
        QFilter baseDataUseRangefilter = null;
        if (null != multiOrgStr) {
            boolean isRemoveDup = !BaseDataCommonService.isTreeType((String)this.getEntityNumber());
            List multiOrgs = (List)SerializationUtils.fromJsonString((String)multiOrgStr, ArrayList.class);
            ArrayList orgIds = new ArrayList(10);
            multiOrgs.forEach(org -> orgIds.add(Long.valueOf(org.toString())));
            baseDataUseRangefilter = BaseDataServiceHelper.getBaseDataFilter((String)this.getEntityNumber(), orgIds, (boolean)isRemoveDup);
        } else {
            baseDataUseRangefilter = BaseDataServiceHelper.getBaseDataFilter((String)this.getEntityNumber(), (Long)useOrg);
        }
        if (null != baseDataUseRangefilter) {
            ITreeModel treemodel = this.getTreeListView().getTreeModel();
            treemodel.getTreeFilter().add(baseDataUseRangefilter);
        }
    }

    private String getEntityNumber() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = listShowParameter.getBillFormId();
        entity = FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
        return entity;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Long parentId;
        String entityName;
        String opKey = evt.getOperationKey();
        if ("delete".equals(opKey) && CtsyDBUtils.ctsyBaseDataUseOnly((String)(entityName = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u542f\u4e86\u8de8\u79df\u6237\u4e3b\u6570\u636e\u57df\u7ba1\u63a7\uff0c\u5f53\u524d\u64cd\u4f5c\u4e0d\u652f\u6301\uff0c\u8bf7\u5230\u96c6\u56e2\u79df\u6237\u6267\u884c\u3002", (String)"BaseDataTreeListPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        super.beforeItemClick(evt);
        if (evt.isCancel()) {
            return;
        }
        String itemKey = evt.getItemKey();
        ITreeModel treeModel = this.getTreeModel();
        GroupProp prop = this.getTreeModel().getGroupProp();
        String entityId = prop.getBaseEntityId();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        try {
            parentId = Long.valueOf(currentNodeId);
        }
        catch (Exception e) {
            parentId = 0L;
        }
        if (TBLNEW.equals(itemKey.toLowerCase(Locale.ENGLISH)) || TBLCOPY.equals(itemKey.toLowerCase(Locale.ENGLISH))) {
            evt.setCancel(!this.checkAddDatas(parentId, entityId));
            return;
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (itemKey.toLowerCase(Locale.ENGLISH)) {
            case "bar_individuation": {
                evt.setCancel(!this.itemClickIndividuation(rows));
                break;
            }
            case "tbldisable": {
                evt.setCancel(!this.itemClickDisable(rows, evt));
                break;
            }
            case "bdctrlchange": {
                String appId = this.getView().getFormShowParameter().getAppId();
                Long orgId = Long.valueOf(this.getPageCache().get(PRO_CREATEORG));
                ArrayList<Long> ids = new ArrayList<Long>(rows.size());
                for (ListSelectedRow row : rows) {
                    ids.add((Long)row.getPrimaryKeyValue());
                }
                boolean changeable = this.ctrlChangeValidate(entityId, appId, orgId, ids, this.getView());
                if (changeable) break;
                evt.setCancel(true);
                return;
            }
        }
    }

    private boolean ctrlChangeValidate(String entityId, String appId, Long useOrgId, List<Long> ids, IFormView view) {
        ChangeCtrlStrategyService service = new ChangeCtrlStrategyService(entityId);
        BaseDataResponse response = service.validate(new HashSet<Long>(ids), "1", appId, useOrgId);
        if (!response.isSuccess()) {
            view.showTipNotification(response.getErrorMsg());
            return false;
        }
        return true;
    }

    private boolean itemClickDisable(ListSelectedRowCollection listSelectedRowCollection, BeforeItemClickEvent evt) {
        GroupProp prop = this.getTreeModel().getGroupProp();
        if (!(prop instanceof ParentBasedataProp)) {
            return true;
        }
        String propName = prop.getName();
        String entityName = prop.getEntityType().getName();
        String numberName = prop.getNumberProp();
        String listCaption = this.getView().getFormShowParameter().getCaption();
        if (listSelectedRowCollection != null && !listSelectedRowCollection.isEmpty()) {
            ORM orm = ORM.create();
            String selectField = "id," + prop.getEntityType().getNameProperty() + "," + propName + ".enable," + propName + "." + numberName + ",longnumber,enable";
            Object[] ids = new Object[listSelectedRowCollection.size()];
            Object[] numbers = new Object[listSelectedRowCollection.size()];
            for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
                ids[i] = listSelectedRowCollection.get(i).getPrimaryKeyValue();
                numbers[i] = listSelectedRowCollection.get(i).getNumber();
            }
            QFilter q = new QFilter("id", "in", (Object)ids);
            QFilter[] filters = new QFilter[]{q};
            DynamicObjectCollection dynamicObjectCollection = orm.query(prop.getBaseEntityId(), selectField, filters);
            Object[] longNumbers = new Object[dynamicObjectCollection.size()];
            int needProcessData = 0;
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject doj = (DynamicObject)dynamicObjectCollection.get(i);
                if ("0".equals(doj.get(ENABLE)) && evt.getItemKey().equals(TBLDISABLE)) continue;
                ++needProcessData;
                longNumbers[i] = doj.get(LONGNUMBER);
            }
            if (needProcessData > 0) {
                QFilter baseQfilter = new QFilter(LONGNUMBER, "like", (Object)(longNumbers[0] + ((ParentBasedataProp)prop).getLongNumberDLM() + "%"));
                for (int i = 1; i < longNumbers.length; ++i) {
                    QFilter tempQfilter = new QFilter(LONGNUMBER, "like", (Object)(longNumbers[i] + ((ParentBasedataProp)prop).getLongNumberDLM() + "%"));
                    baseQfilter.or(tempQfilter);
                }
                if (orm.exists(entityName, new QFilter[]{baseQfilter})) {
                    evt.setCancel(true);
                    if (evt.getItemKey().equals(TBLDISABLE)) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u63d0\u793a", (String)"StandardTreeListPlugin_8", (String)BOS_FORM_CORE, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u672c\u6b21\u7981\u7528\u5c06\u7981\u7528%1$s\u7684\u6240\u6709\u4e0b\u7ea7\u57fa\u7840\u8d44\u6599\uff0c\u5305\u542b\u4e0b\u7ea7\u7ec4\u7ec7\u521b\u5efa\u7684\u4e0b\u7ea7\u8d44\u6599\uff0c\u4ee5\u4e0b\u6570\u636e\uff1a%2$s,\u6709\u4e0b\u7ea7\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminDivisionTreePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), listCaption, Arrays.toString(numbers)), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("disablebyall", (IFormPlugin)this));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private boolean itemClickIndividuation(ListSelectedRowCollection rows) {
        if (rows.isEmpty()) {
            return true;
        }
        String entityName = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        if (TreeBaseDataCommonService.isAssignUnDetail((String)entityName)) {
            Long useOrgId = Long.parseLong(this.getPageCache().get(PRO_CREATEORG));
            ArrayList pks = new ArrayList(rows.size());
            rows.forEach(e -> pks.add(Long.valueOf(e.getPrimaryKeyValue().toString())));
            TreeBaseDataCommonService service = new TreeBaseDataCommonService(entityName);
            Collection unLastVisibleNodes = service.getUnLastVisibleNodeByIds(useOrgId, pks, NUMBER);
            if (unLastVisibleNodes.isEmpty()) {
                return true;
            }
            String msg = ResManager.loadKDString((String)"%1$s\uff1a\u4e0d\u662f\u7ec4\u7ec7\u53ef\u89c1\u8303\u56f4\u7684\u672b\u7ea7\u8d44\u6599\uff0c\u4e0d\u80fd\u4e2a\u6027\u5316\u3002", (String)"BaseDataTreeListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.showValidateTips(unLastVisibleNodes, msg);
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)rows.getPrimaryKeyValues()), new QFilter(ISLEAF, "=", (Object)Boolean.FALSE)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityName, (String)"isleaf, number", (QFilter[])filters);
        if (collection.isEmpty()) {
            return true;
        }
        String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5b58\u5728\u4e0b\u7ea7\u8d44\u6599\uff0c\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"BaseDataTreeListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.showValidateTips((Collection<DynamicObject>)collection, msg);
        return false;
    }

    private void showValidateTips(Collection<DynamicObject> collection, String msgFormat) {
        if (collection.size() == 1) {
            String number = collection.iterator().next().getString(NUMBER);
            this.getView().showTipNotification(String.format(msgFormat, number));
            return;
        }
        ArrayList messages = new ArrayList(collection.size());
        collection.forEach(e -> messages.add(String.format(msgFormat, e.getString(NUMBER))));
        String title = ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u6821\u9a8c\u5931\u8d25", (String)"BaseDataTreeListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.getView().showMessage(title, String.join((CharSequence)"\r\n", messages), MessageTypes.Default);
    }

    private boolean checkAddDatas(Long parentId, String entityNumber) {
        boolean isCurrentOrg;
        if (parentId == 0L) {
            return true;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)entityNumber);
        String number = obj.getString(NUMBER);
        if (!obj.getBoolean(ENABLE)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7%1$s\uff1a\u8be5\u6570\u636e\u88ab\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u518d\u65b0\u589e\u4e0b\u7ea7\u660e\u7ec6\u3002", (String)"BaseDataImportValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), number);
            this.getView().showTipNotification(errorMsg);
            return false;
        }
        String strategy = obj.getString(CTRLSTRATEGY);
        if (("5".equals(strategy) || "6".equals(strategy)) && !(isCurrentOrg = this.checkCreateOrgIsCurrentOrg(parentId))) {
            String errorMsg = ResManager.loadKDString((String)"\u201c\u5171\u4eab\u201d \u578b\u7b56\u7565\u4e0b\uff0c\u6240\u6709\u5c42\u7ea7\u7684\u521b\u5efa\u7ec4\u7ec7\u5fc5\u987b\u76f8\u540c\u3002", (String)"BaseDataTreeListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showTipNotification(errorMsg);
            return false;
        }
        if (TreeBaseDataCommonService.isAssignUnDetail((String)entityNumber) || BaseDataBusinessServiceUtils.isEnableVersion((String)entityNumber)) {
            return true;
        }
        BaseDataCustomService service = new BaseDataCustomService(entityNumber);
        Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)CREATEORG);
        Map customOrgInfo = service.getCustomOrgInfo(obj, createOrgId);
        if (!CollectionUtils.isEmpty((Map)customOrgInfo)) {
            ArrayList orgNames = new ArrayList(customOrgInfo.values());
            if (orgNames.size() == 1) {
                String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5728\u7ec4\u7ec7\uff1a\u201c%2$s\u201d\u5b58\u5728\u4e0b\u7ea7\u8d44\u6599\u6216\u4e2a\u6027\u5316\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\u4e0b\u7ea7\u8d44\u6599\u3002", (String)"BaseDataTreeListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, orgNames.get(0));
                this.getView().showTipNotification(errorMsg);
            } else {
                StringJoiner joiner = new StringJoiner("");
                for (String name : orgNames) {
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u5728\u7ec4\u7ec7\uff1a\u201c%2$s\u201d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\u4e0b\u7ea7\u8d44\u6599\u3002\r\n", (String)"BaseDataTreeListPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, name);
                    joiner.add(msg);
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25", (String)"BaseDataTreeListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), joiner.toString(), MessageTypes.Default);
            }
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (NEW.equalsIgnoreCase(operate.getType())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.clearSelection();
            billList.refresh();
        }
        GroupProp prop = this.getTreeModel().getGroupProp();
        String entityId = prop.getBaseEntityId();
        ITreeModel treeModel = this.getTreeModel();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        Long parentId = 0L;
        try {
            parentId = Long.valueOf(currentNodeId);
        }
        catch (Exception e) {
            parentId = 0L;
        }
        if ((NEW.equalsIgnoreCase(operate.getType()) || COPY.equalsIgnoreCase(operate.getType())) && !this.checkAddDatas(parentId, entityId)) {
            args.setCancel(true);
        }
    }

    private boolean checkCreateOrgIsCurrentOrg(Long id) {
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)this.getEntityNumber());
        String selectFields = "id, createOrg," + masteridPropName + ",number";
        QFilter[] qfArr = new QFilter[]{new QFilter("id", "in", (Object)id)};
        DynamicObject[] dyCol = BusinessDataServiceHelper.load((String)this.getEntityNumber(), (String)selectFields, (QFilter[])qfArr);
        long useOrgId = Long.parseLong(this.getPageCache().get(PRO_CREATEORG));
        for (int i = 0; i < dyCol.length; ++i) {
            Long createorg = 0L;
            if (dyCol[0].get(CREATEORG) instanceof DynamicObject) {
                createorg = (Long)dyCol[i].getDynamicObject(CREATEORG).getPkValue();
            } else if (dyCol[0].get(CREATEORG) instanceof Long) {
                createorg = (Long)dyCol[i].get(CREATEORG);
            }
            if (createorg == useOrgId) continue;
            return false;
        }
        return true;
    }
}

