/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.plugin.bdctrl.BaseDataAuditPlugin;
import kd.bos.form.plugin.bdctrl.BaseDataUnAuditValidator;
import kd.bos.form.plugin.bdctrl.validator.BaseDataPermValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BaseDataUnAuditPlugin
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(BaseDataAuditPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("ctrlstrategy");
        if (BaseDataCommonService.isNewModel((String)this.billEntityType.getName())) {
            e.getFieldKeys().add("bitindex");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String entityKey = this.billEntityType.getName();
        BaseDataPermValidator permValidator = new BaseDataPermValidator();
        permValidator.setEntityKey(entityKey);
        e.addValidator((AbstractValidator)permValidator);
        if (BaseDataCommonService.isNewModel((String)entityKey)) {
            kd.bos.bd.validator.BaseDataUnAuditValidator v = new kd.bos.bd.validator.BaseDataUnAuditValidator();
            v.setEntityKey(entityKey);
            e.addValidator((AbstractValidator)v);
        } else {
            BaseDataUnAuditValidator validator = new BaseDataUnAuditValidator();
            validator.setEntityKey(entityKey);
            e.addValidator((AbstractValidator)validator);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (objs == null) {
            return;
        }
        try {
            BaseDataServiceHelper.clearCache((DynamicObject[])objs);
        }
        catch (Exception exception) {
            this.addFailOperationResult(objs);
            logger.error("\u53cd\u5ba1\u6838\u66f4\u65b0\u4f4d\u56fe\u4fe1\u606f\u6216\u8005\u4f7f\u7528\u8303\u56f4\u8bb0\u5f55\u53d1\u751f\u5f02\u5e38...", (Object)e);
        }
    }

    private void addFailOperationResult(DynamicObject[] objs) {
        boolean isNewModel = BaseDataCommonService.isNewModel((String)this.billEntityType.getName());
        for (DynamicObject obj : objs) {
            OperateErrorInfo errorInfo = new OperateErrorInfo("", ErrorLevel.Error, obj.getPkValue());
            if (isNewModel) {
                errorInfo.setMessage(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u65f6\u66f4\u65b0\u4f4d\u56fe\u4fe1\u606f\u5931\u8d25\u3002", (String)"BaseDataUnAuditPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            } else {
                errorInfo.setMessage(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u65f6\u4fdd\u5b58\u4f7f\u7528\u8303\u56f4\u8bb0\u5f55\u5931\u8d25\u3002", (String)"BaseDataUnAuditPlugin_1", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            }
            this.operationResult.addErrorInfo(errorInfo);
        }
    }
}

