/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.ChangeCtrlStrategyService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataMutexUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.validate.DataMutexResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BdCtrlChangePlugin
extends AbstractFormPlugin {
    public static final String BASEDATAUSEREGSUFFIX = "UseReg";
    private static final String BASEDATAEXCSUFFIX = "Exc";
    public static final String BASEDATAUSERANGESUFFIX = "_U";
    public static final String CTRLSTRATEGY_CU_ASSIGN = "1";
    public static final String CTRLSTRATEGY_CU_FREE_ASSIGN = "2";
    public static final String CTRLSTRATEGY_OU_ASSIGN = "3";
    public static final String CTRLSTRATEGY_OU_FREE_ASSIGN = "4";
    public static final String CTRLSTRATEGY_GLOBAL_SHARE = "5";
    public static final String CTRLSTRATEGY_CU_SHARE = "6";
    public static final String CTRLSTRATEGY_PRIVATE = "7";
    public static final String CTRLSTRATEGY = "ctrlstrategy";
    public static final String TARGETBDCTRL = "targetbdctrl";
    public static final String CREATEORG = "createorg";
    public static final String USEORG = "useorg";
    private static final String CTRL_SAVE = "save";
    private static final String OP_MODIFY = "modify";
    private static final String KEY_MUTEX_LOCK_RET = "mutex_lock_Key";
    private static final String BOS_BD_FORMPLUGIN = "bos-bd-formplugin";
    private static final String MASTER_ID = "master_id";
    private static final String CREATEORG_ID = "createorg.id";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.getModel().setValue("oribdctrl", parameter.getCustomParam("bdctrl"));
        this.setCtrlStrategy();
        this.initComboItems();
        this.treeBaseDataInitComboItems();
        super.afterCreateNewData(e);
        List<Long> dataIds = this.getChangeStrategyDataIds();
        if (!dataIds.isEmpty()) {
            this.batchRequireMutex(new HashSet<Long>(dataIds));
        }
    }

    private List<Long> getChangeStrategyDataIds() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object param = parameter.getCustomParam("ids");
        if (null == param) {
            return Collections.emptyList();
        }
        List ids = SerializationUtils.fromJsonStringToList((String)param.toString(), Long.class);
        ArrayList<Long> dataIds = new ArrayList<Long>(ids.size());
        ids.forEach(id -> dataIds.add(Long.valueOf(id.toString())));
        return dataIds;
    }

    private Map<String, String> selectDataNumber(List<DataMutexResult> dataMutexResults, String entity) {
        String numberField = BaseDataCommonService.isOtherMasterIdType((String)entity) ? "masterid.number" : "number";
        ArrayList dataIds = new ArrayList(dataMutexResults.size());
        dataMutexResults.forEach(mutexResult -> dataIds.add(Long.valueOf(mutexResult.getId())));
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        HashMap<String, String> result = new HashMap<String, String>(dataIds.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)("id, " + numberField), (QFilter[])filters, (String)"");){
            ds.forEach(r -> result.put(r.getString("id"), r.getString(numberField)));
        }
        return result;
    }

    private void batchRequireMutex(Set<Long> ids) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityID");
        List dataMutexResults = BaseDataMutexUtils.batchRequireAndReturnFailMutex((String)entityId, ids, (String)OP_MODIFY);
        if (CollectionUtils.isEmpty((Collection)dataMutexResults)) {
            this.getView().getPageCache().put(KEY_MUTEX_LOCK_RET, Boolean.TRUE.toString());
            return;
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{CTRL_SAVE, TARGETBDCTRL});
        Map<String, String> param = this.selectDataNumber(dataMutexResults, entityId);
        String msg = ResManager.loadKDString((String)"%1$s\uff1a%2$s", (String)"BdCtrlChangePlugin_14", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
        if (dataMutexResults.size() == 1) {
            DataMutexResult mutexResult = (DataMutexResult)dataMutexResults.get(0);
            String dataId = mutexResult.getId();
            ids.remove(Long.valueOf(dataId));
            this.getView().showTipNotification(String.format(msg, param.get(dataId), mutexResult.getMessage()));
        } else {
            StringJoiner joiner = new StringJoiner("\r\n");
            for (DataMutexResult mutexResult : dataMutexResults) {
                String dataId = mutexResult.getId();
                joiner.add(String.format(msg, param.get(dataId), mutexResult.getMessage()));
                ids.remove(Long.valueOf(dataId));
            }
            String title = ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u88ab\u9501\u5b9a", (String)"BdCtrlChangePlugin_13", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showMessage(title, joiner.toString(), MessageTypes.Default);
        }
        if (!ids.isEmpty()) {
            BaseDataMutexUtils.batchRelease((String)entityId, (String)OP_MODIFY, ids);
        }
    }

    public void pageRelease(EventObject e) {
        String lockCache = this.getView().getPageCache().get(KEY_MUTEX_LOCK_RET);
        if (Boolean.parseBoolean(lockCache)) {
            List<Long> ids = this.getChangeStrategyDataIds();
            if (ids.isEmpty()) {
                return;
            }
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityID");
            BaseDataMutexUtils.batchRelease((String)entityId, (String)OP_MODIFY, ids);
        }
    }

    private List<Map<String, String>> getChildrenByParentIds(String entity, List<Long> pIds, String masterIdPropName) {
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(entity);
        List<String> fields = Arrays.asList("id", "number", "longnumber", "level", CTRLSTRATEGY, CREATEORG, masterIdPropName);
        List nodes = service.getChildNodesByParentIds(pIds, null, fields, true);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(nodes.size());
        for (DynamicObject node : nodes) {
            HashMap<String, String> map = new HashMap<String, String>(7);
            map.put("id", node.getString("id"));
            map.put(CTRLSTRATEGY, node.getString(CTRLSTRATEGY));
            Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)node, (String)CREATEORG);
            map.put(CREATEORG_ID, createOrgId.toString());
            Long masterId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)node, (String)masterIdPropName);
            map.put(MASTER_ID, masterId.toString());
            map.put("number", node.getString("number"));
            map.put("level", node.getString("level"));
            map.put("longnumber", node.getString("longnumber"));
            result.add(map);
        }
        return result;
    }

    private void treeBaseDataInitComboItems() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityID");
        if (!BaseDataCommonService.isTreeType((String)entityId)) {
            return;
        }
        List<Long> ids = this.getChangeStrategyDataIds();
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        String selectProperties = "id, ctrlstrategy, createOrg," + masteridPropName + ",number,level,longnumber";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)entityId, (String)selectProperties, (QFilter[])filters);
        HashSet<String> rootLongnumbers = new HashSet<String>(16);
        String longNumberDLM = BaseDataCommonService.getLongNumberDLM((String)entityId);
        for (DynamicObject dynamicObject : objs) {
            int level = dynamicObject.getInt("level");
            String longnumber = dynamicObject.getString("longnumber");
            String rootLongNumber = null;
            if (1 == level) {
                rootLongNumber = longnumber;
            } else if (longnumber.contains(longNumberDLM)) {
                rootLongNumber = longnumber.substring(0, longnumber.indexOf(longNumberDLM));
            }
            rootLongnumbers.add(rootLongNumber);
        }
        List<Map<String, String>> allObjs = this.getChildrenByParentIds(entityId, ids, masteridPropName);
        HashMap<String, List<Map<String, String>>> longNumberDataIdMap = new HashMap<String, List<Map<String, String>>>(16);
        for (Map<String, String> map : allObjs) {
            String longnumber = map.get("longnumber");
            String rootLongNumber = null;
            int level = Integer.parseInt(map.get("level"));
            if (1 == level) {
                rootLongNumber = longnumber;
            } else if (longnumber.contains(longNumberDLM)) {
                rootLongNumber = longnumber.substring(0, longnumber.indexOf(longNumberDLM));
            }
            ArrayList<Map<String, String>> dataIds = (ArrayList<Map<String, String>>)longNumberDataIdMap.get(rootLongNumber);
            if (null == dataIds) {
                dataIds = new ArrayList<Map<String, String>>(16);
            }
            dataIds.add(map);
            longNumberDataIdMap.put(rootLongNumber, dataIds);
        }
        HashSet<String> unModifiableRootLongNumbers = new HashSet<String>(allObjs.size());
        boolean bl = this.isTreeBaseDaCreateByTheSameOrg(allObjs, unModifiableRootLongNumbers, longNumberDataIdMap, longNumberDLM);
        boolean haveModifiable = false;
        HashSet modifiableRootLongNumbers = new HashSet(rootLongnumbers);
        modifiableRootLongNumbers.removeAll(unModifiableRootLongNumbers);
        if (!modifiableRootLongNumbers.isEmpty()) {
            haveModifiable = true;
        }
        boolean isGalaxyUltimate = OrgUnitServiceHelper.isGalaxyUltimate();
        if (!(bl || haveModifiable || isGalaxyUltimate)) {
            this.setCtrlStrategyCuAssign();
        }
        if (this.isHasIdentifyInCuShare(allObjs, masteridPropName) && !haveModifiable) {
            this.setCtrlStrategyCuAssign();
        }
    }

    private boolean isHasIdentifyInCuShare(List<Map<String, String>> allObjs, String masteridPropName) {
        for (Map<String, String> obj : allObjs) {
            Long dataId = Long.valueOf(obj.get("id"));
            String ctrlstrategy = obj.get(CTRLSTRATEGY);
            Long masterid = Long.valueOf(obj.get(MASTER_ID));
            if (!CTRLSTRATEGY_CU_SHARE.equals(ctrlstrategy) || dataId.equals(masterid)) continue;
            return true;
        }
        return false;
    }

    private void setCtrlStrategyCuAssign() {
        ComboEdit control = (ComboEdit)this.getControl(TARGETBDCTRL);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem ci = new ComboItem();
        ci.setValue(CTRLSTRATEGY_CU_ASSIGN);
        LocaleString caption = null;
        caption = this.getLocaleString(CTRLSTRATEGY_CU_ASSIGN, caption);
        ci.setCaption(caption);
        items.add(ci);
        control.setComboItems(items);
    }

    private boolean isTreeBaseDaCreateByTheSameOrg(List<Map<String, String>> allObjs, Set<String> unModifiableRootLongNumbers, Map<String, List<Map<String, String>>> longNumberDataIdMap, String longNumberDLM) {
        boolean isTreeBaseDaCreateByTheSameOrg = true;
        for (Map<String, String> obj : allObjs) {
            List<Map<String, String>> sameRootLongNumberNodes;
            String longnumber = obj.get("longnumber");
            int level = Integer.parseInt(obj.get("level"));
            String rootLongNumber = null;
            if (1 == level) {
                rootLongNumber = longnumber;
            } else if (longnumber.contains(longNumberDLM)) {
                rootLongNumber = longnumber.substring(0, longnumber.indexOf(longNumberDLM));
            }
            if (CollectionUtils.isEmpty(sameRootLongNumberNodes = longNumberDataIdMap.get(rootLongNumber))) continue;
            Long createOrgId = Long.valueOf(sameRootLongNumberNodes.get(0).get(CREATEORG_ID));
            for (Map<String, String> node : sameRootLongNumberNodes) {
                if (createOrgId.equals(Long.valueOf(node.get(CREATEORG_ID)))) continue;
                isTreeBaseDaCreateByTheSameOrg = false;
                unModifiableRootLongNumbers.add(rootLongNumber);
            }
        }
        return isTreeBaseDaCreateByTheSameOrg;
    }

    private void setCtrlStrategy() {
        String isTreeTypeData = (String)this.getView().getFormShowParameter().getCustomParam("isTreeTypeData");
        String oldBdCtrl = (String)this.getView().getFormShowParameter().getCustomParam("bdctrl");
        String entityID = String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("entityID"));
        MetadataReader reader = new MetadataReader();
        String formId = reader.loadIdByNumber(entityID, MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getItems();
        ComboField comboField = null;
        for (EntityItem item : items) {
            if (!CTRLSTRATEGY.equals(item.getKey()) || !(item instanceof ComboField)) continue;
            comboField = (ComboField)item;
            comboField.getItems();
        }
        if (null != comboField) {
            ComboEdit targetbdctrl = (ComboEdit)this.getControl(TARGETBDCTRL);
            ComboItem comboItem = new ComboItem();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(comboField.getItems().size());
            for (kd.bos.metadata.entity.commonfield.ComboItem item : comboField.getItems()) {
                boolean unLoadSomeCtrls;
                LocaleString localeString = item.getCaption();
                String imageKey = item.getImageKey();
                String value = item.getValue();
                boolean itemVisible = item.isItemVisible();
                comboItem = new ComboItem(imageKey, localeString, value, itemVisible);
                boolean isGalaxyUltimate = OrgUnitServiceHelper.isGalaxyUltimate();
                boolean bl = unLoadSomeCtrls = isGalaxyUltimate && (CTRLSTRATEGY_CU_ASSIGN.equals(value) || CTRLSTRATEGY_CU_SHARE.equals(value));
                if (CTRLSTRATEGY_CU_ASSIGN.equals(isTreeTypeData)) {
                    if (oldBdCtrl.equals(value) || CTRLSTRATEGY_CU_FREE_ASSIGN.equals(value) || CTRLSTRATEGY_PRIVATE.equals(value) || unLoadSomeCtrls) continue;
                    comboItems.add(comboItem);
                    continue;
                }
                if (oldBdCtrl.equals(value) || unLoadSomeCtrls) continue;
                comboItems.add(comboItem);
            }
            targetbdctrl.setComboItems(comboItems);
        }
    }

    private void initComboItems() {
        boolean unLoadSomeCtrls;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String bdctrl = customParams.get("bdctrl").toString();
        String entityID = customParams.get("entityID").toString();
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityID);
        List<Long> ids = this.getChangeStrategyDataIds();
        boolean isExist = QueryServiceHelper.exists((String)entityID, (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter(masteridPropName, "!=", (Object)"id", true)});
        if (!isExist) {
            return;
        }
        boolean isGalaxyUltimate = OrgUnitServiceHelper.isGalaxyUltimate();
        boolean bl = unLoadSomeCtrls = isGalaxyUltimate && (CTRLSTRATEGY_CU_ASSIGN.equals(bdctrl) || CTRLSTRATEGY_CU_SHARE.equals(bdctrl));
        if (CTRLSTRATEGY_CU_ASSIGN.equals(bdctrl)) {
            ComboEdit control = (ComboEdit)this.getControl(TARGETBDCTRL);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            ComboItem ci = new ComboItem();
            LocaleString caption = null;
            if (!unLoadSomeCtrls) {
                ci.setValue(CTRLSTRATEGY_CU_SHARE);
                caption = this.getLocaleString(CTRLSTRATEGY_CU_SHARE, caption);
                ci.setCaption(caption);
                items.add(ci);
            }
            ci = new ComboItem();
            ci.setValue(CTRLSTRATEGY_PRIVATE);
            caption = this.getLocaleString(CTRLSTRATEGY_PRIVATE, caption);
            ci.setCaption(caption);
            items.add(ci);
            control.setComboItems(items);
            return;
        }
        if (CTRLSTRATEGY_CU_SHARE.equals(bdctrl)) {
            ComboEdit control = (ComboEdit)this.getControl(TARGETBDCTRL);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            ComboItem ci = new ComboItem();
            ci.setValue(CTRLSTRATEGY_CU_ASSIGN);
            LocaleString caption = null;
            caption = this.getLocaleString(CTRLSTRATEGY_CU_ASSIGN, caption);
            ci.setCaption(caption);
            items.add(ci);
            if (!unLoadSomeCtrls) {
                ci = new ComboItem();
                ci.setValue(CTRLSTRATEGY_PRIVATE);
                caption = this.getLocaleString(CTRLSTRATEGY_PRIVATE, caption);
                ci.setCaption(caption);
                items.add(ci);
            }
            control.setComboItems(items);
            return;
        }
        if (CTRLSTRATEGY_PRIVATE.equals(bdctrl)) {
            if (isGalaxyUltimate) {
                return;
            }
            ComboEdit control = (ComboEdit)this.getControl(TARGETBDCTRL);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            ComboItem ci = new ComboItem();
            ci.setValue(CTRLSTRATEGY_CU_ASSIGN);
            LocaleString caption = null;
            caption = this.getLocaleString(CTRLSTRATEGY_CU_ASSIGN, caption);
            ci.setCaption(caption);
            items.add(ci);
            ci = new ComboItem();
            ci.setValue(CTRLSTRATEGY_CU_SHARE);
            caption = this.getLocaleString(CTRLSTRATEGY_CU_SHARE, caption);
            ci.setCaption(caption);
            items.add(ci);
            control.setComboItems(items);
            return;
        }
    }

    private LocaleString getLocaleString(String str, LocaleString caption) {
        switch (str) {
            case "1": {
                caption = new LocaleString(ResManager.loadKDString((String)"\u9010\u7ea7\u5206\u914d", (String)"BdCtrlChangePlugin_0", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "2": {
                caption = new LocaleString(ResManager.loadKDString((String)"\u81ea\u7531\u5206\u914d", (String)"BdCtrlChangePlugin_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "3": {
                caption = new LocaleString(ResManager.loadKDString((String)"\u6309\u7ec4\u7ec7\u9010\u7ea7\u5206\u914d", (String)"BdCtrlChangePlugin_2", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "4": {
                caption = new LocaleString(ResManager.loadKDString((String)"\u6309\u7ec4\u7ec7\u81ea\u7531\u5206\u914d", (String)"BdCtrlChangePlugin_3", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "5": {
                caption = new LocaleString(ResManager.loadKDString((String)"\u5168\u5c40\u5171\u4eab", (String)"BdCtrlChangePlugin_4", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "6": {
                caption = new LocaleString(ResManager.loadKDString((String)"\u7ba1\u63a7\u8303\u56f4\u5185\u5171\u4eab", (String)"BdCtrlChangePlugin_5", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "7": {
                caption = new LocaleString(ResManager.loadKDString((String)"\u79c1\u6709", (String)"BdCtrlChangePlugin_6", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
        }
        return caption;
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{CTRL_SAVE, TARGETBDCTRL});
        this.getView().setVisible(Boolean.FALSE, new String[]{"privatenotice"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"assignnotice"});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if (c.getKey().toLowerCase().startsWith(CTRL_SAVE)) {
            String useOrg = (String)this.getView().getFormShowParameter().getCustomParam(USEORG);
            List<Long> ids = this.getChangeStrategyDataIds();
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam("objecttype");
            String appId = (String)this.getView().getFormShowParameter().getCustomParam("appId");
            Object newBdCtrl = this.getModel().getValue(TARGETBDCTRL);
            if (newBdCtrl == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u65b0\u63a7\u5236\u7b56\u7565\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BdCtrlChangePlugin_7", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            Long userId = RequestContext.get().getCurrUserId();
            int permRes = PermissionServiceHelper.checkPermission((Long)userId, (Long)Long.valueOf(useOrg), (String)appId, (String)entityId, (String)"/IN0GIK354+3");
            if (0 == permRes) {
                String caption = FormMetadataCache.getFormConfig((String)entityId).getCaption().getLocaleValue();
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BdCtrlChangePlugin_11", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), caption));
                return;
            }
            BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.INTERFACE_OP);
            ChangeCtrlStrategyService service = new ChangeCtrlStrategyService(entityId);
            BaseDataResponse response = service.changeCtrlStrategy(new HashSet<Long>(ids), newBdCtrl.toString(), appId, Long.valueOf(useOrg), false);
            if (!response.isSuccess()) {
                this.getView().showErrorNotification(response.getErrorMsg());
                return;
            }
            String pageId = this.getView().getFormShowParameter().getParentPageId();
            IFormView viewNoPlugin = this.getView().getViewNoPlugin(pageId);
            if (null != viewNoPlugin) {
                viewNoPlugin.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"BdCtrlChangePlugin_8", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                this.getView().sendFormAction(viewNoPlugin);
            }
            this.getView().returnDataToParent((Object)Boolean.TRUE);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        String entityID = String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("entityID"));
        if (TARGETBDCTRL.equals(propName) && BaseDataCommonService.isTreeType((String)entityID)) {
            String newValue;
            switch (newValue = e.getChangeSet()[0].getNewValue().toString()) {
                case "7": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"privatenotice"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"assignnotice"});
                    break;
                }
                case "1": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"privatenotice"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"assignnotice"});
                    break;
                }
                default: {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"privatenotice"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"assignnotice"});
                }
            }
        }
        this.getView().updateView();
    }
}

