/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bd.service.CtrlStrategyConfigService;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BdCtrlStrategyListPlugin
extends AbstractListPlugin
implements UploadListener {
    private static final Log log = LogFactory.getLog(BdCtrlStrategyListPlugin.class);
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String KEY_IMP_JSON = "imp_json";
    private static final String KEY_EXP_SQL = "exp_sql";
    private static final String KEY_EXP_JSON = "exp_json";
    private static final String OP_DEL = "delete";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addUploadListener((UploadListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (OP_DEL.equalsIgnoreCase(operate.getType())) {
            if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
                String msg = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u624d\u53ef\u4ee5\u5220\u9664\u7ba1\u63a7\u7b56\u7565\u914d\u7f6e\u3002", (String)"BdCtrlStrategyListPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                args.setCancel(true);
                return;
            }
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            Object[] pks = rows.getPrimaryKeyValues();
            if (null == pks || pks.length == 0) {
                return;
            }
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)pks)};
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_bddefctrlstrtgy", (String)"basedataid", (QFilter[])filters);
            for (DynamicObject data : coll) {
                String entity = data.getString("basedataid");
                if (!this.hasBaseDataInfo(entity)) continue;
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean hasBaseDataInfo(String entity) {
        try {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
            if (StringUtils.isEmpty((Object)dt.getAlias())) {
                return false;
            }
            SqlBuilder builder = new SqlBuilder();
            builder.append("select top 1 fid from", new Object[0]).append(dt.getAlias(), new Object[0]);
            if (((Boolean)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, ResultSet::next)).booleanValue()) {
                String msg = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u7ba1\u63a7\u914d\u7f6e\u4e2d\uff0c\u5b58\u5728\u4e1a\u52a1\u8d44\u6599\u660e\u7ec6\uff0c\u4e0d\u53ef\u4ee5\u5220\u9664\u7ba1\u63a7\u7b56\u7565\u914d\u7f6e\u3002", (String)"BdCtrlStrategyListPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return true;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u660e\u7ec6\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey().toLowerCase();
        if (KEY_EXP_JSON.equals(itemKey) || KEY_EXP_SQL.equals(itemKey)) {
            if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"BdCtrlStrategyListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                evt.setCancel(true);
                return;
            }
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)rows)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"BdCtrlStrategyListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (KEY_EXP_JSON.equalsIgnoreCase(itemKey)) {
            this.exportStrategyConfigJson();
        } else if (KEY_EXP_SQL.equalsIgnoreCase(itemKey)) {
            this.exportStrategyConfigSql();
        }
    }

    private void exportStrategyConfigJson() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        CtrlStrategyConfigService service = new CtrlStrategyConfigService();
        Map exportMap = service.exportStrategyConfigOnMap(rows.getPrimaryKeyValues());
        String json = SerializationUtils.toJsonString((Object)exportMap);
        String jsonFileName = String.format("ctrl_strategy_config_%s.json", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        this.exportFile(json, jsonFileName);
    }

    private void exportStrategyConfigSql() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        String sql = new CtrlStrategyConfigService().exportStrategyConfigSql(rows.getPrimaryKeyValues());
        String sqlFileName = String.format("ctrl_strategy_config_%s.sql", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        this.exportFile(sql, sqlFileName);
    }

    private void exportFile(String content, String fileName) {
        try (ByteArrayInputStream ins = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)ins, 5000);
            this.getView().openUrl(url);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BdCtrlStrategyListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            log.error(msg, (Throwable)e);
            throw new KDBizException(msg);
        }
    }

    public void upload(UploadEvent evt) {
        if (!KEY_IMP_JSON.equalsIgnoreCase(evt.getCallbackKey())) {
            log.debug("\u975eimp_json\u6267\u884c\u4e0a\u4f20\u64cd\u4f5c\u3002");
            return;
        }
        Object[] urls = evt.getUrls();
        if (null == urls || urls.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6587\u4ef6\u8def\u5f84\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BdCtrlStrategyListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"BdCtrlStrategyListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        this.getView().getPageCache().put(KEY_IMP_JSON, (String)urls[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_IMP_JSON, (IFormPlugin)this);
        String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u64cd\u4f5c\u4e3a\u8986\u76d6\u5f0f\u5bfc\u5165\uff0c\u5982\u679c\u8d44\u6599\u5df2\u7ecf\u5b58\u5728\u7ba1\u63a7\u914d\u7f6e\uff0c\u90a3\u4e48\u65b0\u5bfc\u5165\u7684\u914d\u7f6e\u4f1a\u8986\u76d6\u539f\u914d\u7f6e\uff0c\u786e\u8ba4\u6267\u884c\u5bfc\u5165\u5417\uff1f", (String)"BdCtrlStrategyListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (KEY_IMP_JSON.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String url = this.getView().getPageCache().get(KEY_IMP_JSON);
            if (StringUtils.isEmpty((Object)url)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bfb\u53d6\u5bfc\u5165\u7684\u6587\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BdCtrlStrategyListPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            Map<String, String> config = this.readUploadFile(url);
            CtrlStrategyConfigService service = new CtrlStrategyConfigService();
            service.importStrategyConfig(config);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6210\u529f\u3002", (String)"BdCtrlStrategyListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, String> readUploadFile(String url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

